/*
 * Decompiled with CFR 0.152.
 */
package createkml;

import createkml.CreateKMLAboutBox;
import createkml.CreateKMLApp;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class CreateKMLView
extends FrameView {
    private JButton Browse1;
    private JButton Browse2;
    private JButton CancelBtn;
    private JButton ProcessBtn;
    private JTextField fileName;
    private JTextField inputName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JTextField outputName;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public CreateKMLView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateKMLView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateKMLView.this.busyIconIndex = (CreateKMLView.this.busyIconIndex + 1) % CreateKMLView.this.busyIcons.length;
                CreateKMLView.this.statusAnimationLabel.setIcon(CreateKMLView.this.busyIcons[CreateKMLView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!CreateKMLView.this.busyIconTimer.isRunning()) {
                        CreateKMLView.this.statusAnimationLabel.setIcon(CreateKMLView.this.busyIcons[0]);
                        CreateKMLView.this.busyIconIndex = 0;
                        CreateKMLView.this.busyIconTimer.start();
                    }
                    CreateKMLView.this.progressBar.setVisible(true);
                    CreateKMLView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    CreateKMLView.this.busyIconTimer.stop();
                    CreateKMLView.this.statusAnimationLabel.setIcon(CreateKMLView.this.idleIcon);
                    CreateKMLView.this.progressBar.setVisible(false);
                    CreateKMLView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    CreateKMLView.this.statusMessageLabel.setText(text == null ? "" : text);
                    CreateKMLView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    CreateKMLView.this.progressBar.setVisible(true);
                    CreateKMLView.this.progressBar.setIndeterminate(false);
                    CreateKMLView.this.progressBar.setValue(value);
                }
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CreateKMLApp();
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = CreateKMLApp.getApplication().getMainFrame();
            this.aboutBox = new CreateKMLAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        CreateKMLApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.inputName = new JTextField();
        this.outputName = new JTextField();
        this.fileName = new JTextField();
        this.Browse1 = new JButton();
        this.Browse2 = new JButton();
        this.ProcessBtn = new JButton();
        this.CancelBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(CreateKMLApp.class).getContext().getResourceMap(CreateKMLView.class);
        this.inputName.setText(resourceMap.getString("inputName.text", new Object[0]));
        this.inputName.setName("inputName");
        this.outputName.setText(resourceMap.getString("outputName.text", new Object[0]));
        this.outputName.setName("outputName");
        this.fileName.setText(resourceMap.getString("fileName.text", new Object[0]));
        this.fileName.setName("fileName");
        this.Browse1.setText(resourceMap.getString("Browse1.text", new Object[0]));
        this.Browse1.setName("Browse1");
        this.Browse1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateKMLView.this.Browse1ActionPerformed(evt);
            }
        });
        this.Browse2.setText(resourceMap.getString("Browse2.text", new Object[0]));
        this.Browse2.setName("Browse2");
        this.Browse2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateKMLView.this.Browse2ActionPerformed(evt);
            }
        });
        this.ProcessBtn.setText(resourceMap.getString("ProcessBtn.text", new Object[0]));
        this.ProcessBtn.setName("ProcessBtn");
        this.ProcessBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateKMLView.this.ProcessBtnActionPerformed(evt);
            }
        });
        this.CancelBtn.setText(resourceMap.getString("CancelBtn.text", new Object[0]));
        this.CancelBtn.setName("CancelBtn");
        this.CancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateKMLView.this.CancelBtnActionPerformed(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jRadioButton1.setText(resourceMap.getString("jRadioButton1.text", new Object[0]));
        this.jRadioButton1.setName("jRadioButton1");
        this.jRadioButton2.setText(resourceMap.getString("jRadioButton2.text", new Object[0]));
        this.jRadioButton2.setName("jRadioButton2");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jRadioButton3.setText(resourceMap.getString("jRadioButton3.text", new Object[0]));
        this.jRadioButton3.setName("jRadioButton3");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.jLabel3).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -1, 200, Short.MAX_VALUE).addComponent(this.fileName, -2, 129, -2).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.ProcessBtn).addGap(66, 66, 66).addComponent(this.CancelBtn))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1).addComponent(this.jLabel5, -2, 119, -2).addComponent(this.jRadioButton3)).addGap(16, 16, 16)).addGroup(mainPanelLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.outputName).addComponent(this.inputName, -1, 143, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Browse1).addComponent(this.Browse2)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(65, 65, 65).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputName, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.outputName, -2, -1, -2))).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.Browse1).addGap(18, 18, 18).addComponent(this.Browse2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileName, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel5)).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ProcessBtn).addComponent(this.CancelBtn).addComponent(this.jRadioButton3)).addGap(40, 40, 40)).addGroup(mainPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jRadioButton1).addGap(9, 9, 9).addComponent(this.jRadioButton2)))));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(CreateKMLApp.class).getContext().getActionMap(CreateKMLView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 436, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 266, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void Browse1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        int returnd = fc.showOpenDialog(new JFrame());
        if (returnd == 0) {
            File file = fc.getSelectedFile();
            this.inputName.setText(file.getAbsolutePath());
        }
    }

    private void Browse2ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        int returnd = fc.showSaveDialog(new JFrame());
        if (returnd == 0) {
            File file = fc.getSelectedFile();
            this.outputName.setText(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessBtnActionPerformed(ActionEvent evt) {
        BufferedWriter kmlout = null;
        try {
            String inputFile = this.inputName.getText();
            String outputFile = this.outputName.getText();
            File csvfile = new File(inputFile);
            File kmlfile = new File(outputFile);
            String filenm = this.fileName.getText();
            kmlout = new BufferedWriter(new FileWriter(kmlfile));
            if (this.jRadioButton1.isSelected() || this.jRadioButton2.isSelected()) {
                String StlId = "<IconStyle>\n<color>ff05ff9b</color>\n<scale>0.7</scale>\n<Icon>\n<href>http://maps.google.com/mapfiles/kml/shapes/shaded_dot.png</href>\n</Icon>\n</IconStyle>\n<LabelStyle>\n<scale>0</scale>\n</LabelStyle>\n<ListStyle>\n</ListStyle>\n<LineStyle>\n<antialias>0</antialias>\n</LineStyle>\n<PolyStyle>\n<fill>0</fill>\n<outline>0</outline>\n</PolyStyle>\n</Style>";
                String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\">\n<Document>\n<name>" + filenm + "</name>\n<open>1</open>\n<StyleMap " + "id=\"Photo0\">\n<Pair>" + "\n<key>normal</key>\n<styleUrl>" + "#Photo:primary images (site) (normal)0</styleUrl>\n</Pair>" + "\n<Pair>" + "\n<key>highlight</key>\n<styleUrl>#Photo:primary " + "images (site) (highlight)0</styleUrl>\n</Pair>" + "\n</StyleMap>" + "\n<Style id=\"Photo:primary images (site) (normal)0\">" + StlId + "<Style id=\"Photo:primary images (site) (highlight)0\">" + StlId + "\n<ScreenOverlay>\n<name>USGS Visual Identity</name>" + "\n<Icon>" + "\n<href>http://stplidar01.er.usgs.gov/xstorms/oblique/kmz/" + "usgs_black.JPG</href>\n</Icon>" + "\n<overlayXY x=\"0\" " + "y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n<screenXY " + "x=\"0\" y=\"1\" " + "xunits=\"fraction\" yunits=\"fraction\"/>" + "\n<rotationXY x=\"0.5\" y=\"0.5\" xunits=\"fraction\" yunits=" + "\"fraction\"/>" + "\n<size x=\"-1\" y=\"-1\" xunits=\"pixels" + "\" yunits=\"pixels\"/>\n</ScreenOverlay>\n<Folder>" + "\n<name " + "maxLines=\"1\">" + filenm + "</name>\n<Snippet maxLines=\"1\">" + "</Snippet>";
                kmlout.write(header);
                BufferedReader reader = new BufferedReader(new FileReader(csvfile));
                String line = reader.readLine();
                line = reader.readLine();
                if (this.jRadioButton1.isSelected()) {
                    while (line != null) {
                        String[] lineParts = line.split(",");
                        String Lat = lineParts[0];
                        String Lon = lineParts[1];
                        String name = lineParts[3];
                        String spc = "\n";
                        String plcmk = "\n<Placemark>";
                        String nm = "\n<name maxLines=\"1\">" + name + "</name>";
                        String snpt = "\n<Snippet maxLines=\"1\">" + Lat + " " + Lon + " " + name + "</Snippet>";
                        String desc = "\n<description><![CDATA[LATITUDE: " + Lat + "<BR>LONGITUDE: ";
                        String desc1 = Lon + "<BR>SLIDE: " + name;
                        String desc5 = "<BR><font color=\"#ffffff\">]]></description>";
                        String ptStl = "\n<styleUrl>#Photo0</styleUrl>";
                        String pt = "\n<Point>";
                        String altMd = "\n<altitudeMode>relativeToGround</altitudeMode>";
                        String coord = "\n<coordinates>" + Lon + "," + Lat + ",0</coordinates>";
                        String endpt = "\n</Point>";
                        String endplcmk = "\n</Placemark>";
                        kmlout.write(spc + plcmk + nm + snpt + desc + desc1 + desc5 + ptStl + pt + altMd + coord + endpt + endplcmk);
                        line = reader.readLine();
                    }
                    String footer = "</Folder>\n</Document>\n</kml>";
                    kmlout.write(footer);
                    kmlout.close();
                    this.jLabel4.setText("Google Earth file created.");
                } else if (this.jRadioButton2.isSelected()) {
                    while (line != null) {
                        String[] lineParts = line.split(",");
                        String Lat = lineParts[0];
                        String Lon = lineParts[1];
                        String name = lineParts[3];
                        String date = lineParts[9] + lineParts[10] + "," + lineParts[8];
                        String Time = lineParts[2];
                        String photlnk = lineParts[4];
                        String Mlink = lineParts[5];
                        String Vlink = lineParts[6];
                        String Sname = lineParts[12];
                        String spc = "\n";
                        String plcmk = "\n<Placemark>";
                        String nm = "\n<name maxLines=\"1\">" + name + "</name>";
                        String snpt = "\n<Snippet maxLines=\"1\">" + Lat + " " + Lon + " " + name + " ";
                        String snpt1 = date + " " + Time + " " + photlnk + " " + photlnk + " ";
                        String snpt2 = photlnk + " " + Mlink + " " + Vlink + " " + Sname + "</Snippet>";
                        String desc = "\n<description><![CDATA[STORM: " + Sname + "<BR>" + "LATITUDE: " + Lat + "<BR>LONGITUDE: ";
                        String desc1 = Lon + "<BR>SLIDE: " + name + "<BR>DATE:  " + date + "<BR>TIME: ";
                        String desc2 = Time + " GMT<BR><a href=\"" + photlnk + "\"><img " + "border=\"0\" src=\"";
                        String desc3 = photlnk + "\" width=\"300\"><BR></a><li><a href=\"" + photlnk + "\">FULL-SIZE IMAGE LINK</a><BR><a href=\"";
                        String desc4 = Mlink + "\">MULTI-IMAGE GROUP LINK</a><BR><a href=" + "\"" + Vlink + "\">FIVE-MINUTE VIDEO LINK</a>";
                        String desc5 = "<BR><font color=\"#ffffff\">]]></description>";
                        String ptStl = "\n<styleUrl>#Photo0</styleUrl>";
                        String pt = "\n<Point>";
                        String altMd = "\n<altitudeMode>relativeToGround</altitudeMode>";
                        String coord = "\n<coordinates>" + Lon + "," + Lat + ",0</coordinates>";
                        String endpt = "\n</Point>";
                        String endplcmk = "\n</Placemark>";
                        kmlout.write(spc + plcmk + nm + snpt + snpt1 + snpt2 + desc + desc1 + desc2 + desc3 + desc4 + desc5 + ptStl + pt + altMd + coord + endpt + endplcmk);
                        line = reader.readLine();
                    }
                    String footer = "</Folder>\n</Document>\n</kml>";
                    kmlout.write(footer);
                    kmlout.close();
                    this.jLabel4.setText("Google Earth file created.");
                }
            } else if (this.jRadioButton3.isSelected()) {
                String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\">\n<Document>\n<name>" + filenm + "</name>\n<open>1</open>\n<ScreenOverlay>\n" + "<name>USGS Visual Identity</name>" + "\n<Icon>" + "\n<href>http://stplidar01.er.usgs.gov/xstorms/oblique/kmz/" + "usgs_black.JPG</href>\n</Icon>" + "\n<overlayXY x=\"0\" " + "y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n<screenXY " + "x=\"0\" y=\"1\" " + "xunits=\"fraction\" yunits=\"fraction\"/>" + "\n<rotationXY x=\"0.5\" y=\"0.5\" xunits=\"fraction\" yunits=" + "\"fraction\"/>" + "\n<size x=\"-1\" y=\"-1\" xunits=\"pixels" + "\" yunits=\"pixels\"/>\n</ScreenOverlay>\n<Folder>" + "\n<name " + "maxLines=\"1\">" + filenm + "</name>\n<Snippet maxLines=\"1\">" + "</Snippet>";
                kmlout.write(header);
                BufferedReader reader = new BufferedReader(new FileReader(csvfile));
                String line = reader.readLine();
                line = reader.readLine();
                Integer n = 1;
                while (line != null) {
                    String[] lineParts = line.split(",");
                    String Lat = lineParts[0];
                    String Lon = lineParts[1];
                    String name = lineParts[3];
                    String date = lineParts[7] + " " + lineParts[15] + ", " + lineParts[14];
                    String Time = lineParts[2];
                    String photlnk = lineParts[4];
                    String Mlink = lineParts[5];
                    String Vlink = lineParts[6];
                    String Sname = lineParts[9];
                    String geo = lineParts[10] + "," + lineParts[11] + lineParts[12] + "," + lineParts[13];
                    String spc = "\n";
                    String plcmk = "\n<Placemark>";
                    String nm = "\n<name maxLines=\"1\">" + n + "</name>";
                    String snpt = "\n<Snippet maxLines=\"1\">" + Lat + " " + Lon + " " + name + " ";
                    String snpt1 = date + " " + Time + " " + photlnk + " " + photlnk + " ";
                    String snpt2 = photlnk + " " + Mlink + " " + Vlink + " " + Sname + "</Snippet>";
                    String desc = "\n<description><![CDATA[STORM: " + Sname + "<BR>" + "LATITUDE: " + Lat + "<BR>LONGITUDE: ";
                    String desc1 = Lon + "<BR>SLIDE: " + name + "<BR> GEOGRAPHIC AREA: " + geo + "<BR>DATE: " + date + "<BR>TIME: ";
                    String desc2 = Time + " GMT<BR><a href=\"" + photlnk + "\"><img " + "border=\"0\" src=\"";
                    String desc3 = photlnk + "\" width=\"300\"><BR></a><li><a href=\"" + photlnk + "\">FULL-SIZE IMAGE LINK</a><BR><a href=\"";
                    String desc4 = Mlink + "\">MULTI-IMAGE GROUP LINK</a>";
                    String desc5 = "<BR><font color=\"#ffffff\">]]></description>";
                    String ptStl = "\n<Style id = \"sh_pink-blank\">\n<IconStyle>\n<scale>1.1</scale>\n<Icon>\n<href>http://maps.google.com/mapfiles/kml/paddle/pink-blank.png</href>\n</Icon>\n<hotSpot x=\"32\" y=\"1\" xunits=\"pixels\"/>\n</IconStyle>\n</Style>\n<styleUrl>#msn_pink-blank</styleUrl>";
                    String pt = "\n<Point>";
                    String altMd = "\n<altitudeMode>relativeToGround</altitudeMode>";
                    String coord = "\n<coordinates>" + Lon + "," + Lat + ",0</coordinates>";
                    String endpt = "\n</Point>";
                    String endplcmk = "\n</Placemark>";
                    kmlout.write(spc + plcmk + nm + snpt + snpt1 + snpt2 + desc + desc1 + desc2 + desc3 + desc4 + desc5 + ptStl + pt + altMd + coord + endpt + endplcmk);
                    line = reader.readLine();
                    Integer n2 = n;
                    Integer n3 = n = Integer.valueOf(n + 1);
                }
                String footer = "</Folder>\n</Document>\n</kml>";
                kmlout.write(footer);
                kmlout.close();
                this.jLabel4.setText("Google Earth file created.");
            } else {
                this.jLabel4.setText("Please choose a format.");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CreateKMLView.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                kmlout.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CreateKMLView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void CancelBtnActionPerformed(ActionEvent evt) {
        this.inputName.setText("");
        this.outputName.setText("");
        this.fileName.setText("");
    }
}

