10 REM PROGRAM TO DRAW PRELIMINARY CROSS SECTIONS
15 DEFSNG A-Z
20 OPTION BASE 1
25 CLEAR ,,2048
30 DIM X(500),Y(500),XC(500),YC(500)
35 DIM SHARED OPT1%,OPT2%,OPT3%,OPT4%,OPT5%,OPT6%,OPT7%,OPT8%
40 KEY OFF
50 DEF FNPLT(X,Y,Z,SHIFT)=((X/Y)+Z)*1016-SHIFT 
55 CALL MICROSOFT
60 OPEN "CONFIG.CAD" FOR INPUT AS #1
70	INPUT #1,DIGITIZER$
80	INPUT #1,PLOTTER$
90 CLOSE #1
100 GOSUB 2980
110 CLS:SCREEN 0:COLOR 15,1:WIDTH 80:CLS
120 PRINT:PRINT:PRINT:PRINT:PRINT:PRINT
130 PRINT "                       G  S  S  E  C  T"
140 PRINT:PRINT
150 PRINT "                                        CURRENT SECTION: "+FILNAM$
160 PRINT
170 PRINT
180 PRINT"  1  -  START A NEW SECTION"
190 PRINT"  2  -  OPEN AN EXISTING SECTION"
200 PRINT"  3  -  DIGITIZE PROFILE AND CONTACTS"
210 PRINT"  4  -  LIST SECTION VALUES ON THE PRINTER"
220 PRINT"  5  -  PLOT ON THE HARD COPY PLOTTER"
230 PRINT"  6  -  EXIT"
240 PRINT
250 INPUT"                                 ENTER CHOICE BY NUMBER: ", ICHOICE%
260 ON ICHOICE% GOSUB 280,400,570,1240,1370,3300
270 GOTO 110
280 CLS: CLOSE #3 
290 INPUT "ENTER NAME OF SECTION: ",FILNAM$
300 FILNAM$=FILNAM$+".SEC"
310 ON ERROR GOTO 3090
320 OPEN FILNAM$ FOR INPUT AS #3
330 PRINT "A FILE WITH THE SAME NAME ALREADY EXISTS"
340 INPUT "DO YOU WANT TO CONTINUE?(Y/N): ",ICONT$
350 CLOSE #3
360 ON ERROR GOTO 0   
370 IF ICONT$<>"Y" AND ICONT$<>"y" GOTO 290
380 OPEN FILNAM$ FOR OUTPUT AS #3
390 RETURN
400 CLS: CLOSE #3
410 INPUT "ENTER NAME OF SECTION: ",FILNAM$
420 FILNAM$=FILNAM$+".SEC"
430 ON ERROR GOTO 3190 
440 OPEN FILNAM$ FOR INPUT AS #3
450 ON ERROR GOTO 0
460 PRINT "LOADING SECTION DATA"
470 ICNT%=1
480 INPUT#3,IFLAG$,X(ICNT%),Y(ICNT%)
490 IF IFLAG$<>"EOP" THEN ICNT%=ICNT%+1: GOTO 480
500 ICNT%=ICNT%-1
510 ICONT%=1
520 INPUT#3,IFLAG$,XC(ICONT%),YC(ICONT%)
530 IF IFLAG$<>"EOC" THEN ICONT%=ICONT%+1: GOTO 520
540 ICONT%=ICONT%-1: CLOSE #3
550 TOTDIST=X(ICNT%)
560 RETURN
570 CLS:INPUT "ENTER ELEVATION OF STARTING POINT: ",STELEV
580 INPUT "ENTER CONTOUR INTERVAL: ",CONINT
590 ON ERROR GOTO 3140 
600 OPEN DIGITIZER$ AS #1
601 ON ERROR GOTO 0
602 REM ROUTINE TO SYNCHRONIZE DIGITIZER
603 PRINT #1,CHR$(1);
604 CALL DELAY
605 PRINT #1,"IC";
606 CALL DELAY
607 PRINT #1,CHR$(27);	
618 PRINT "ENTER 0(ZERO) KEY ON CURSOR KEYPAD TO SYNCHRONIZE DIGITIZER INPUT"
619 LINE INPUT #1,DSTRING$:BEEP:IF MID$(DSTRING$,1,1)<>"0" GOTO 618
620 PRINT "ENTER STARTING POINT ON DIGITIZER USE 0 KEY"
630 GOSUB 2820:SOUND 196,2
640 XST=XBOARD: YST=YBOARD
650 I%=INT(STELEV/CONINT):CURCONT=I%*CONINT
660 X(1)=0!:Y(1)=STELEV
670 CLS
680 PRINT "ENTER INTERSECTION OF SECTION WITH CONTOUR"
690 PRINT "USE 0 KEY TO INDICATE INCREASING ELEVATION"
700 PRINT "USE 1 KEY TO INDICATE SAME AS PREVIOUS CONTOUR"
710 PRINT "USE 2 KEY TO INDICATE DECREASING ELEVATION"
720 PRINT "USE 3 KEY TO ENTER INFLECTION POINT LOCATION"
730 PRINT "          ENTER ELEVATION VALUE ON KEYPAD"
740 PRINT "          USING NUMERIC KEYS (6 DIGITS MAXIMUM)"
750 PRINT "          IF LESS THAN 6 DIGITS USE 'A' KEY TO END"
760 PRINT "          ELEVATION VALUE"
770 PRINT "USE 4 KEY TO INDICATE END OF SECTION"
780 IEND$="N"
790 ICNT%=1
800 LPRINT ICNT%;X(ICNT%);Y(ICNT%)
810 GOSUB 2820
820 IF ICH$="4" THEN IEND$="Y"
830 ICNT%=ICNT%+1
840 DIST=SQR((XBOARD-XST)^2 + (YBOARD-YST)^2)
850 X(ICNT%)=DIST
860 IF ICH$="0" THEN CURCONT=CURCONT+CONINT
870 IF ICH$="2" AND ICNT%>2 THEN CURCONT=CURCONT-CONINT
880 IF ICH$="3" THEN ND%=6:GOSUB 2880:Y(ICNT%)=SAMP! ELSE Y(ICNT%)=CURCONT
890 K=FIX(CURCONT/100!):X=CURCONT-K*100!
900 IF X=0 THEN SOUND 1318,12 ELSE SOUND 196,8
910 IF IEND$<>"Y" THEN LPRINT ICNT%;X(ICNT%);Y(ICNT%)
920 IF IEND$<>"Y" GOTO 810
930 BEEP
940 INPUT "ENTER ELEVATION OF LAST POINT",Y(ICNT%) 
950 LPRINT ICNT%;X(ICNT%);Y(ICNT%)
960 FMT1$="\  \  ####.###  ######"
970 FOR I%=1 TO ICNT%
980	PRINT#3, USING FMT1$;"PT,";X(I%);Y(I%)
990 NEXT I%
1000 PRINT #3, USING FMT1$;"EOP,";X(ICNT%);Y(ICNT%)
1010 CLS:PRINT "USE 0 KEY TO ENTER CONTACT LOCATIONS"
1020     PRINT "USE 1 KEY TO STOP"
1030 ICONT%=1
1040 GOSUB 2820:SOUND 196,8
1050 IF ICH$="1" GOTO 1190
1060 DIST=SQR((XBOARD-XST)^2+(YBOARD-YST)^2)
1070 FOR I%=1 TO ICNT%-1
1080	IF DIST < X(I%) OR DIST > X(I%+1) GOTO 1130
1090	XC(ICONT%)=DIST
1100	SLOPE=(Y(I%+1)-Y(I%))/(X(I%+1)-X(I%))
1110	YC(ICONT%)=Y(I%)+SLOPE*(DIST-X(I%))
1120    GOTO 1170
1130 NEXT I%
1140 BEEP:BEEP:
1150 PRINT "ERROR NOT WITHIN SECTION DISTANCE - RE-ENTER"
1160 GOTO 1040
1170 PRINT #3, USING FMT1$;"PT,";XC(ICONT%);YC(ICONT%)
1180 ICONT%=ICONT%+1:GOTO 1040
1190 ICONT%=ICONT%-1
1200 PRINT #3,USING FMT1$;"EOC,";XC(ICONT%);YC(ICONT%)
1210 CLOSE #3
1220 RETURN
1230 REM LIST VALUES ON THE PRINTER
1240 LPRINT "SECTION FILENAME= ";FILNAM$
1250 LPRINT
1260 FMT1$="\  \  ####.###  ######"
1270 LPRINT "PROFILE DATA"
1280 FOR I%=1 TO ICNT%
1290	LPRINT USING FMT1$;"PT,";X(I%);Y(I%)
1300 NEXT I%
1310 LPRINT
1320 LPRINT "CONTACT DATA"
1330 FOR I%=1 TO ICONT%
1340	LPRINT USING FMT1$;"PT,";XC(I%);YC(I%)
1350 NEXT I%
1360 RETURN
1370 REM PLOT ON THE HARD COPY PLOTTER
1380 CLS
1390 INPUT "ENTER BASE ELEVATION,TOP ELEVATION: ",BASELEV,ENDELEV
1400 INPUT "ENTER HORIZ SCALE,VERT SCALE,TICK INTERVAL: ",HSCALE,VSCALE,TICK
1410 INPUT "ENTER XOFF,YOFF: ",XOFF,YOFF
1420 INPUT "ROTATE?(Y/N) ",RT$
1430 IF RT$="n" THEN RT$="N"
1440 INPUT "ENTER PEN,SPEED,FORCE: ",PN%,SPEED!,FORCE!
1450 OPEN PLOTTER$ AS #2
1460 ON ERROR GOTO 3250
1470 PRINT #2,CHR$(27);".L"
1480 INPUT #2,L
1490 ON ERROR GOTO 0
1500 CALL InitializePlotter
1510 PRINT #2,"PA;LT;PU;"
1520 PRINT #2,CHR$(27);".L"
1530 INPUT #2,L
1540 TOTDIST=X(ICNT%)
1550 XP%=FNPLT(0!,HSCALE,XOFF,XSHIFT)
1560 TEMP%=XP%-100
1570 FOR H=BASELEV TO ENDELEV STEP TICK
1580	YP=(H-BASELEV): YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1590     PRINT #2,"PU;PA ";TEMP%;",";YP%;";PD;"
1600     PRINT #2,"PA ";XP%;",";YP%;";PU;"
1610 NEXT H
1620 YP=(ENDELEV-BASELEV):YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1630 PRINT#2,"PA";XP%;",";YP%;";PD;"
1640 YP=(BASELEV-BASELEV)
1650 XP%=FNPLT(0!,HSCALE,XOFF,XSHIFT):YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1660 PRINT#2,"PA";XP%;",";YP%;";"
1670 YP=(BASELEV-BASELEV)
1680 XP%=FNPLT(TOTDIST,HSCALE,XOFF,XSHIFT):YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1690 PRINT#2,"PA";XP%;",";YP%;";"
1700 YP=(ENDELEV-BASELEV)
1710 XP%=FNPLT(TOTDIST,HSCALE,XOFF,XSHIFT):YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1720 PRINT#2,"PA";XP%;",";YP%;";PU;"
1730 FOR H=BASELEV TO ENDELEV STEP TICK
1740	YP=(H-BASELEV):YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1750	PRINT #2,"PU;PA ";XP%;",";YP%;";PD;"
1760	PRINT #2,"PA ";XP%+100;",";YP%;";PU;"
1770 NEXT H
1780 FOR I%=1 TO ICNT%
1790	YP=(Y(I%)-BASELEV)
1800	XP%=FNPLT(X(I%),HSCALE,XOFF,XSHIFT):YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1810	PRINT#2,"PA";","XP%;",";YP%;";"
1820	IF I%=1 THEN PRINT #2,"PD;"
1830 NEXT I%
1840 PRINT #2,"PU;"
1850 FOR I%=1 TO ICONT%
1860	XP%=FNPLT(XC(I%),HSCALE,XOFF,XSHIFT)
1870	YP=(YC(I%)-BASELEV)
1880    YP%=FNPLT(YP,VSCALE,YOFF,YSHIFT)
1890	PRINT #2,"PU;PA ";XP%;",";YP%+100;";PD;"
1900    PRINT #2,"PA ";XP%;","YP%;";PU;"
1910 NEXT I%
1920 PRINT #2,"SP0;"
1930 CLOSE #2,#3
1940 CLS: INPUT "SAVE PLOTTED SECTION TO GSDRAW DATA BASE?(Y/N): ",ANS$
1950 IF ANS$="y" THEN ANS$="Y"
1960 IF ANS$<>"Y" THEN RETURN
1965 ICH$=" ":GARY!=FRE(ICH$)
1980 INPUT "ENTER DATA BASE NAME: ",DFILNAM$
1990 IFILNAM$=DFILNAM$+".NDX"
2000 LFILNAM$=DFILNAM$+".LSF"
2010 OPEN "R",#2,IFILNAM$,20
2020 FIELD #2,20 AS IREC$
2030 OPEN "R",#3,LFILNAM$,8
2040 FIELD #3, 8 AS LREC$
2050 ILINE=0:ISTART=5:IEND=5
2060 MID$(IREC$,1,4)=MKS$(ILINE):MID$(IREC$,5,4)=MKS$(ISTART)
2070 MID$(IREC$,9,4)=MKS$(IEND):LSET IREC$=IREC$:PUT #2,1
2080 INPUT "ENTER TITLE: ",TITLE$
2090 MID$(LREC$,1,8)=TITLE$:II=1!
2091 GOSUB 2780
2100 XP=0:YP=(ENDELEV-BASELEV)/VSCALE+YOFF+1:II=2:GOSUB 2770
2130 YP=0:II=3:GOSUB 2770
2140 XP=XOFF+(TOTDIST/HSCALE)+1:YP=0:II=4:GOSUB 2770
2150 YP=(ENDELEV-BASELEV)/VSCALE+YOFF+1:II=5:GOSUB 2770
2170 REM NOW PUT OUT MAIN LINE AROUND SECTION
2180 XP=XOFF:YP=YP-1:II=6:GOSUB 2760
2190 YP=YOFF:II=7:GOSUB 2760
2200 XP=XOFF+(TOTDIST/HSCALE):YP=YOFF:II=8:GOSUB 2760
2210 YP=YOFF+(ENDELEV-BASELEV)/VSCALE:II=9:GOSUB 2760
2220 MID$(IREC$,1,4)=MKS$(6!):MID$(IREC$,5,4)=MKS$(9!):MID$(IREC$,9,4)=MKS$(91!)
2230 MID$(IREC$,13,4)=MKS$(0!):MID$(IREC$,17,4)=MKS$(0!):LSET IREC$=IREC$:PUT #2,2
2240 ISTART=9:IEND=9:ILINE=2
2250 REM NOW DO LEFT TICKS
2260 FOR H=BASELEV TO ENDELEV STEP TICK
2270	XP=XOFF-.1
2280	YP= (H-BASELEV)/VSCALE + YOFF
2290	II=IEND+1:GOSUB 2760
2300	XP=XP +.1:II=IEND+2:GOSUB 2760
2310    ISTART=ISTART+1:IEND=ISTART+1
2320	MID$(IREC$,1,4)=MKS$(ISTART):MID$(IREC$,5,4)=MKS$(IEND)
2330	MID$(IREC$,9,4)=MKS$(92!):LSET IREC$=IREC$:PUT #2,ILINE+1
2350    ISTART=IEND:ILINE=ILINE+1
2360 NEXT H
2370 REM NOW DO RIGHT TICKS
2380 FOR H=BASELEV TO ENDELEV STEP TICK
2390	XP=(TOTDIST/HSCALE)+XOFF
2400	YP= (H-BASELEV)/VSCALE + YOFF
2410	II=IEND+1:GOSUB 2760
2420	XP=XP +.1:II=IEND+2:GOSUB 2760
2430    ISTART=ISTART+1:IEND=ISTART+1
2440	MID$(IREC$,1,4)=MKS$(ISTART):MID$(IREC$,5,4)=MKS$(IEND)
2450	MID$(IREC$,9,4)=MKS$(92!):LSET IREC$=IREC$:PUT #2,ILINE+1
2470    ISTART=IEND:ILINE=ILINE+1
2480 NEXT H
2490 REM NOW DO VERTICAL CUTS
2500 FOR I%=1 TO ICONT%
2510	XP=(XC(I%)/HSCALE)+XOFF
2511	YP=(YC(I%)-BASELEV)/VSCALE +YOFF
2520	II=IEND+1:GOSUB 2760
2530	YP=YP + .1
2540	II=IEND+2:GOSUB 2760
2550	ISTART=ISTART+1:IEND=ISTART+1
2560	MID$(IREC$,1,4)=MKS$(ISTART):MID$(IREC$,5,4)=MKS$(IEND)
2570	MID$(IREC$,9,4)=MKS$(93):LSET IREC$=IREC$:PUT #2,ILINE+1
2580	ISTART=IEND:ILINE=ILINE+1
2590 NEXT I%
2600 REM NOW DO PROFILE
2610 FOR I%=1 TO ICNT%
2620	XP=(X(I%)/HSCALE)+XOFF:YP=(Y(I%)-BASELEV)/VSCALE+YOFF
2630	II=IEND+1:GOSUB 2760:IEND=IEND+1
2640 NEXT I%
2650 ISTART=ISTART+1
2660 MID$(IREC$,1,4)=MKS$(ISTART):MID$(IREC$,5,4)=MKS$(IEND)
2670 MID$(IREC$,9,4)=MKS$(94):LSET IREC$=IREC$:PUT #2,ILINE+1
2700 MID$(IREC$,1,4)=MKS$(ILINE)
2710 MID$(IREC$,5,4)=MKS$(5)
2720 MID$(IREC$,9,4)=MKS$(IEND)
2730 LSET IREC$=IREC$: PUT #2,1
2740 CLOSE #2,#3 
2750 RETURN
2760 REM SUBROUTINE TO WRITE RECORD TO FILE 3
2770 MID$(LREC$,1,4)=MKS$(XP):MID$(LREC$,5,4)=MKS$(YP)
2780 LSET LREC$=LREC$: PUT #3,II
2800 RETURN
2810 REM SUBROUTINE TO INTERFACE TO DIGITIZER BOARD
2820 LINE INPUT #1,DSTRING$
2830 ICH$=MID$(DSTRING$,1,1)
2840 XBOARD=.001*VAL(MID$(DSTRING$,2,5))
2850 YBOARD=.001*VAL(MID$(DSTRING$,8,5))
2860 RETURN
2870 REM ROUTINE TO GET SAMPLE NUMBER OR Z VALUE
2880 SAMP!=0:PUNT$="N"
2890 FOR J%=1 TO ND%
2900    GOSUB 2820
2910    IF ICH$ = ":" GOTO 2940
2920	SAMP!=SAMP!*10 + VAL(ICH$)
2930 NEXT J%
2940 RETURN
2950 IF ERR=57 THEN PRINT "I/O ERROR ON OPEN ON PLOTTER-RETRYING":GOTO 1460
2960 PRINT "ERROR CODE= ";ERR
2970 END
2980 CLS:SCREEN 0:COLOR 15,1:WIDTH 80:CLS
2990 LOCATE  5,27:PRINT "  G  S  S  E  C  T"
3000 LOCATE  7,29:PRINT "    Version 1.0       "
3010 LOCATE 11,13:PRINT "Gary I. Selner, Richard B. Taylor, and Bruce R. Johnson"
3020 LOCATE 12,29:PRINT "U. S. Geological Survey"
3030 LOCATE 15,29:PRINT "     DISCLAIMER          "
3040 LOCATE 17,10:PRINT "Although program tests have been made, no guarantee (expressed";
3050 LOCATE 18,10:PRINT "or implied) is made by the author regarding program correctness,";
3060 LOCATE 19,10:PRINT "accuracy, or proper execution on all computer systems.";
3070 LOCATE 24, 1:PRINT "Press any key to continue.";IDUM$=INPUT$(1)
3080 RETURN
3090 REM ERROR ROUTINE TO AVOID CLOBBERING EXISTING DATA BASE
3100 IF ERR=53 THEN ICONT$="Y":RESUME 360
3110 PRINT "AN ERROR HAS OCCURRED - CHECK DATA BASE NAME"
3120 RESUME 290
3130 REM ERROR TRAP ON OPENING DIGITIZER
3140 IF ERR=57 THEN RESUME 600
3150 CLS: PRINT "UNKNOWN ERROR OPENING DIGITIZER. BASIC CODE= ";ERR
3160 PRINT "HIT ANY KEY TO RETRY"
3170 IDUM$=INPUT$(1)
3180 RESUME 600
3190 REM ERROR ROUTINE FOR EXISTING DATA BASE
3200 PRINT "AN ERROR HAS OCCURRED OPENING DATA BASE ";FILNAM$
3210 PRINT "CHECK DATA BASE NAME. HIT ANY KEY TO RETRY"
3220 IDUM$=INPUT$(1)
3230 RESUME 400
3240 REM ERROR TRAPPING ROUTINE FOR DEVICE I/O ERROR ON OPEN FOR PLOTTER
3250 IF ERR=57 THEN PRINT "DEVICE I/O ERROR ON PLOTTER - RETRYING":RESUME 1470
3260 PRINT "BASIC ERROR CODE ";ERR;" ON OPENING PLOTTER"
3270 PRINT "HIT ANY KEY TO RETRY"
3280 IDUM$=INPUT$(1)
3290 RESUME 1470
3300 END
'
'FOLLOWING ROUTINES ARE PLOTTER DEPENDENT CODE
'MUST BE MODIFIED FOR OTHER THAN HP 7372, 7475, 7550 OR 7585
'
	SUB InitializePlotter Static
	SHARED RT$,PN%,XSHIFT,YSHIFT,SPEED!,FORCE!
'SET UP FOR VARIOUS PLOTTERS
	print #2,"IN;";CHR$(27);".L":input #2,L
	CALL DELAY
	print #2,"RO;"
	IF RT$="Y" OR RT$="y" THEN print #2,"RO 90;"
'GET TYPE OF PLOTTER
	print #2,"OI;"
	input #2,pltyp$
	pltyp$=MID$(pltyp$,1,4)
	CALL DELAY
'GET OPTIONS IMPLEMENTED ON THIS PLOTTER
	print #2,"OO;"
	input #2,OPT1%,OPT2%,OPT3%,OPT4%,OPT5%,OPT6%,OPT7%,OPT8%
	CALL DELAY
	print #2,"IP;";CHR$(27);".L":INPUT #2,L
	print #2,"IW;";CHR$(27);".L":input #2,L
	CALL DELAY
'GET SIZE OF PLOT P1,P2 AREA
	print #2,"OP;"
	input #2,P1X,P1Y,P2X,P2Y
	CALL DELAY
	CALL WaitForEmptyBuffer
'OPT8%=1 PLOTTER HAS CONFIGURABLE MEMORY
	IF OPT8%=0 GOTO SIOB
	print #2,CHR$(27);".T4022;7778;1000:"
	CALL DELAY
SIOB:	CALL WaitForEmptyBuffer
	IF OPT8%=1 THEN print #2,CHR$(27);".@4000:" _
		ELSE print #2,CHR$(27);".@1024;1:"
	CALL DELAY
	IF P1X<0 AND P1Y<0 THEN XSHIFT=(P2X-P1X)/2: _
				YSHIFT=(P2Y-P1Y)/2 _
		else XSHIFT=0:YSHIFT=0
SETSF:	
	print #2,"SP";PN%;";"
	print #2,"SS;":print #2,"VS ";SPEED!;";"
	print #2,"FS ";FORCE!;";"
END SUB
SUB DELAY STATIC
	for delay!=0! to 1! step .01
		xdummy!=sin(delay!)
	next delay!
END SUB
	SUB WaitForEmptyBuffer Static
		print #2,CHR$(27);".L"
		input #2,L
	END SUB
