/*----------------------------------------------------------------------*\
 | Program to convert the meta data file accompanying the CLIMAP core	|
 | top data base of planktonic foraminifera from its original format	|
 | into tab-delimited ASCII suitable for input to ANALOG.				|
 |																		|
 | Peter N. Schweitzer (U.S. Geological Survey, Reston, VA 22092)		|
\*----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LEN	128

static char climap_meta_names[] = "\
Core ID\t\
Latitude degrees\t\
Latitude minutes\t\
Longitude degrees\t\
Longitude minutes\t\
SST cool\t\
SST warm";

main (int argc, char *argv[]) {
	char *input_file;
	FILE *in;
	char master[LEN];
	char line [LEN];
	char *s,*t;
	char id[16];
	int i,j,k,n;
	int verbose = 1;
	char number[8];
	int line_count;

	if (argc > 1) {
		input_file = argv[1];
		if (in = fopen (input_file,"r")) {
			line_count = 0;
			printf ("%s\n",climap_meta_names);
			while (fgets (line,LEN,in)) {
				line_count++;
				s = line + strlen (line) - 1;
				if (*s == '\n') *s-- = 0;
				if (*s == '\r') *s-- = 0;
				if (s > line) {
					memcpy (id,line,12);
					id[12] = 0;
					printf ("%s",id);
					if (verbose) fprintf (stderr,"%s\n",id);
					if ((n = strlen (line)) < 72) {
						while (n < 72) line[n++] = ' ';
						line[n] = 0;
						}
					s = line + 12;
					while (*s) {
						while (*s && isspace (*s)) s++;
						t = number;
						while (*s && !isspace (*s)) *t++ = *s++;
						*t = 0;
						printf ("\t%s",number);
						}
					printf ("\n");
					}
				}
			fclose (in);
			}
		else {
			fprintf (stderr,"Error: could not open input file %s\n",input_file);
			exit (1);
			}
		}
	else {
		fprintf (stderr,"Usage: %s input_file\n",argv[0]);
		exit (0);
		}
	}

/*----------------------------------------------------------------------*\
\*----------------------------------------------------------------------*/
