/*----------------------------------------------------------------------*\
 | Program to convert the CLIMAP core top data base of planktonic		|
 | foraminifera from its original format into tab-delimited ASCII.		|
 |																		|
 | The original format is a loose implementation of that described in	|
 | file 70 of the first SPECMAP data release.  The data records from	|
 | the Atlantic Ocean follow that format precisely, but those from the	|
 | Pacific and Indian Oceans lack key elements and the core identifier	|
 | data are not consistent from one record to the next.					|
 |																		|
 | Peter N. Schweitzer (U.S. Geological Survey, Reston, VA 22092)		|
\*----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LEN	128

static char climap_raw_names[] = "\
Core ID\t\
O. universa\t\
G. conglobatus\t\
G. ruber (pink)\t\
G. ruber (white)\t\
G. ruber (total)\t\
G. tenellus\t\
G. sacculifer (no sac)\t\
G. sacculifer (with sac)\t\
G. sacculifer (total)\t\
S. dehiscens\t\
G. adamsi\t\
G. aequilateralis\t\
G. calida\t\
G. bulloides\t\
G. falconesis\t\
G. digitata\t\
G. rubescens\t\
G. humilis\t\
G. quinqueloba\t\
G. pachyderma (L)\t\
G. pachyderma (R)\t\
G. dutertrei\t\
G. conglomerata\t\
G. hexagona\t\
P. obliquiloculata\t\
G. inflata\t\
G. truncatulinoides (L)\t\
G. truncatulinoides (R)\t\
G. crassaformis\t\
P-D intergrade\t\
G. hirsuta\t\
G. scitula\t\
G. anfracta\t\
G. menardii\t\
G. tumida\t\
G. m. flexuosa\t\
G. menardii complex (total)\t\
C. nitida\t\
G. glutinata\t\
G. iota\t\
G. bradyi\t\
G. pumilio\t\
H. pelagica\t\
H. digitata\t\
Other";

main (int argc, char *argv[]) {
	char *input_file;
	FILE *in;
	char master[LEN];
	char line [LEN];
	char *s;
	char id[16];
	int i,j,k,n;
	int verbose = 1;
	char number[8];
	int line_count;

	if (argc > 1) {
		input_file = argv[1];
		if (in = fopen (input_file,"r")) {
			line_count = 0;
			printf ("%s\n",climap_raw_names);
			while (fgets (master,LEN,in)) {
				line_count++;
				s = master + strlen (master) - 1;
				if (*s == '\n') *s-- = 0;
				if (*s == '\r') *s-- = 0;
				if (s > master) {
					memcpy (id,master,12);
					id[12] = 0;
					printf ("%s",id);
					if (verbose) fprintf (stderr,"%s\n",id);
					for (i=0; i < 3; i++) {
						if (!fgets (line,LEN,in)) {
							fprintf (stderr,"Error: unexpected EOF at line %d\n",line_count);
							exit (1);
							}
						line_count++;
						s = line + strlen (line) - 1;
						if (*s == '\n') *s-- = 0;
						if (*s == '\r') *s-- = 0;
						if (s == line) {
							fprintf (stderr,"Error: unexpected blank line at line %d\n",line_count);
							exit (1);
							}
						if ((n = strlen (line)) < 72) {
							while (n < 72) line[n++] = ' ';
							line[n] = 0;
							}
						s = line + 12;
						for (j=0; j < 15; j++) {
							memcpy (number,s,4);
							number[4] = 0;
							k = atoi (number);
							printf ("\t%d",k);
							s += 4;
							}
						}
					printf ("\n");
					}
				}
			fclose (in);
			}
		else {
			fprintf (stderr,"Error: could not open input file %s\n",input_file);
			exit (1);
			}
		}
	else {
		fprintf (stderr,"Usage: %s input_file\n",argv[0]);
		exit (0);
		}
	}

/*----------------------------------------------------------------------*\
\*----------------------------------------------------------------------*/
