/*----------------------------------------------------------------------*\
 | List in the output file the modern samples that were closest to each	|
 | fossil sample.  Include in the output the meta data that the user	|
 | requested in the run configuration file.								|
 |																		|
 | Peter N. Schweitzer (U.S. Geological Survey, Reston, VA 22092)		|
\*----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "analog.h"

static FILE *out = NULL;

struct meta_variable_index {
	struct meta_variable_index *next;
	struct data_base *data_base;
	int *meta_column;
	};
static struct meta_variable_index *meta_variable_index = NULL;

static void write_tab_results (struct sample *f, struct comparison *score) {
	int i,j,k;
	struct data_base *p;
	struct meta_variable_index *m = NULL;

	if (!out) {
		if (!(out = fopen (report.filespec,"w"))) {
			sprintf (message,"Warning: could not create output file %s, using stdout instead.",
				report.filespec
				);
			warning (message);
			out = stdout;
			}
		fprintf (out,"Sample ID");
		fprintf (out,"\tRank");
		fprintf (out,"\tAnalog ID");
		fprintf (out,"\tDistance");
		for (j=0; j < report.count; j++)
			fprintf (out,"\t%s",report.name[j]);
		}
		fprintf (out,"\n");

	for (i=0; i < report.closest; i++) {
		fprintf (out,"%s",f->id);
		fprintf (out,"\t%d",i);
		fprintf (out,"\t%s",score[i].s->id);
		fprintf (out,"\t%.6lf",score[i].d);

		/*--------------------------------------------------------------*\
		 | Create an integer array that describes where in the meta data|
		 | arrays of this data base we can find the meta variables that	|
		 | the user wants included in the output.						|
		 |																|
		 | Since there will be one such array for each modern data base	|
		 | in the analysis, these arrays must be linked to their data	|
		 | bases.  I use a linked list of structures; each structure	|
		 | contains a pointer to the data base and a pointer to the		|
		 | array of indexes in addition to the (one-way) list link.		|
		 |																|
		 | An array element will contain -1 if the variable that the	|
		 | user has requested is not present in this data base.			|
		\*--------------------------------------------------------------*/

		p = score[i].s->data_base;

		if (!meta_variable_index)
			if (meta_variable_index = (struct meta_variable_index *) malloc (sizeof (struct meta_variable_index))) {
				m = meta_variable_index;
				m->next = NULL;
				m->data_base = p;
				if (m->meta_column = (int *) malloc (report.count * sizeof(int *))) {
					for (j=0; j < report.count; j++) {
						for (k=0; k < p->meta.count; k++)
							if (strcmp (report.name[j],p->meta.name[k]) == 0) {
								m->meta_column[j] = k;
								break;
								}
						if (k == p->meta.count) m->meta_column[j] = -1;
						}
					}
				else
					if (report.count > 0) {
						sprintf (message,"Error: could not allocate meta variable index array");
						error_exit (message);
						}
				}
			else {
				sprintf (message,"Error: could not allocate meta_variable index head");
				error_exit (message);
				}
		else {
			for (m=meta_variable_index; m && m->data_base != p; m=m->next);
			if (!m) {
				for (m=meta_variable_index; m->next; m=m->next);
				if (m->next = (struct meta_variable_index *) malloc (sizeof (struct meta_variable_index))) {
					m = m->next;
					m->next = NULL;
					m->data_base = p;
					if (m->meta_column = (int *) malloc (report.count * sizeof(int *))) {
						for (j=0; j < report.count; j++) {
							for (k=0; k < p->meta.count; k++)
								if (strcmp (report.name[j],p->meta.name[k]) == 0) {
									m->meta_column[j] = k;
									break;
									}
							if (k == p->meta.count) m->meta_column[j] = -1;
							}
						}
					else {
						sprintf (message,"Error: could not allocate meta variable index array");
						error_exit (message);
						}
					}
				else {
					sprintf (message,"Error: could not allocate meta_variable index element");
					error_exit (message);
					}
				}
			}

		/*--------------------------------------------------------------*\
		 | Write out the meta data values.  If the requested variable	|
		 | is not present in this data base, write an empty field.		|
		\*--------------------------------------------------------------*/

		for (j=0; j < report.count; j++)
			if (m->meta_column[j] == -1)
				fprintf (out,"\t");
			else
				fprintf (out,"\t%s",score[i].s->meta[m->meta_column[j]]);
		fprintf (out,"\n");
		}
	}

void write_results (struct sample *f, struct comparison *score) {
	write_tab_results (f,score);
	}

/*----------------------------------------------------------------------*\
\*----------------------------------------------------------------------*/
