/*----------------------------------------------------------------------*\
 | Data are stored in arrays of structures or arrays of pointers to		|
 | structures; the arrays are allocated in blocks of a certain size,	|
 | called the GRANULARITY.  For simplicity, this parameter applies to	|
 | all arrays.															|
\*----------------------------------------------------------------------*/

#define min(a,b) (((a) < (b)) ? (a) : (b))
#define max(a,b) (((a) > (b)) ? (a) : (b))

#define GRANULARITY			 16
#define MAX_NAME_LENGTH		 64
#define MAX_CONFIG_LINE_LEN	256

#define MISSING_VALUE		-999

struct attr {
	char filespec [MAX_NAME_LENGTH];
	char format [MAX_NAME_LENGTH];
	int count;
	char **name;
	char *name_buffer;
	double missing_code;
	};

struct sample {
	char id[MAX_NAME_LENGTH];	/* Some form of identification	*/
	double *raw;				/* Values read from the file	*/
	double *data;				/* Values computed from rules	*/
	char **meta;				/* meta data pointers			*/
	char *meta_buffer;			/* meta data values				*/
	struct data_base *data_base;/* Upward link to data base		*/
	};

struct data_base {
	struct data_base *next;			/* link for list				*/
	int count;						/* Number of samples			*/
	int limit;						/* size of array sample			*/
	struct sample *sample;			/* Sample data					*/
	struct attr raw;				/* Raw variable count and names	*/
	struct attr rule;				/* New variable definitions		*/
	struct attr data;				/* New variable count and names	*/
	struct attr meta;				/* Meta data count and names	*/
	};

struct output {
	char filespec [MAX_NAME_LENGTH];
	char format [MAX_NAME_LENGTH];
	int closest;
	int count;
	int limit;
	char **name;
	};

struct match {
	int p,q;
	};

struct comparison {
	struct sample *s;
	double d;
	};

enum measure_type_t {
	DISTANCE,
	SIMILARITY
	};

extern char version[];
extern char message[];
extern void error_exit (char *message);
extern void warning (char *message);

extern struct data_base *modern;
extern struct data_base *fossil;
extern char distance_measure_name[];
extern enum measure_type_t measure_type;
extern struct output report;
extern int verbose;
extern int search;

extern void parse_run_configuration (char *job_file);
typedef double (*distance_function)(struct sample *s1, struct sample *s2, struct match *m);
extern distance_function set_distance_function (char *name);
extern void read_data_base (struct data_base *p);
extern void read_rules (struct data_base *p);
extern void apply_rules (struct data_base *p);
extern void write_results (struct sample *f, struct comparison *score);

#ifndef HAVE_STRICMP
	extern int stricmp (char *s, char *t);
#endif

/*----------------------------------------------------------------------*\
\*----------------------------------------------------------------------*/
