
                       Subroutine package ASK

               Interactive question/answer interface.



  Purpose:

  1  Supply consistent interface for user interaction.

  2  Isolate application programs from minor variations in compilers.

  3  Provide two extra modes of response in addition to answering a
     question, ie. not_operable (take the default, keep going) and
     no_existance (inappropriate question, back up).

  4  Provide transparent history, journalling, and runtime configuation
     when combined with the ODDF I/O system.  Only journalling is
     activated in this release.



  General Characteristics:

    The routines described below generally print an application program
  supplied prompting message and the current default answer or parameter
  value enclosed in square brackets.

    The user then has three courses of action:

  1)  Enter a new value and then hit the carriage-return key to update 
      the value.

  2)  Hit only the carriage-return key to accept the current value.

  3)  Signal the application that the question is inappropriate and that
      a new question or function is desired: the MU response.


    The update occurs only after the user types an answer on the keyboard
  and then hits the carriage-return key.  This key is denoted below as
  <carriage-return>.

    The MU response is signalled by entering MU or mu and then
  <carriage-return>.  These two characters, both caps or both lowercase, 
  in isolation on the line; or a CTL-EOT at any time (depending on the 
  specific runtime implementation) will trigger the MU response.  CTL-EOT
  (control end-of-text) is commonly set to ^d in UNIX environments and to
  ^z on VAX-VMS.

    The program response to MU depends on the situation but typically the
  interactive question/answer sequence will back up to some previous point
  so the user can choose a new course of action.



            Example code fragment and runtime response

  Update a variable where zstart = -300.25 before the call:

		prompt = 'enter zstart'
		call askf4( prompt, xs, kboard )
		if ( kboard .eq. -2 ) go to 10

  prints to the terminal:

  enter zstart [ -300.25 ]

		where you can enter:

                a new value.
                a carriage_return to take the value in brackets.
                a 'mu' or CTL-EOT to unask the question (the kboard test
                in the example code).



                        SUBROUTINE LIST

      askc    update a character string.

      askf4   update a 4 byte real (single precision) value.
      askf4a  update a 4 byte real array.

      askf8   update a 8 byte real (double precision) value.
      askf8a  update a 8 byte real array.

      aski4   update an 4 byte integer value.
      aski4a  update an 4 byte integer array.
      aski4l  update an 4 byte integer interpreted as logical true or false.

      askpr   print a character string to users terminal.
      askrd   read a character string from users terminal.
      askyn   read a yes or no from users terminal.



                       SUBROUTINE USAGE GUIDE

    Prior to calling these routines the updated variable (the second item in
  the calling sequence) should be set to some default value.  While this is
  not strictly necessary, the purpose of the default is to aid the user in
  selecting a response.

    At any time the CTL-EOT form of the MU response may be issued by the
  user, alternately a line consisting ONLY of the character strings 'mu' or
  'MU' (without the quotes) followed by a <carriage-return> may be issued.
  The MU response is returned to the calling program via KBOARD=-2 (see the
  description for ASKYN for the full KBOARD definition).  The calling program
  then determines the appropriate response.



  PROGRAM USAGE:  ASKF4, ASKF8, ASKI4:

    These routines update a floating point number, a double precision floating
  point number or a longword integer.  The numeric designation indicates the
  number of bytes the updated variable contains.  The askf8, and aski4
  routines are the same as the example below, just change the update variable
  type (the second item in the parameter list).  None of the routines change
  the value of the update variable until a valid response is received.

		programming example:

		call askf4( prompt, fnum, kboard )
		if ( kboard .eq. -2 ) go to nnn

  Where nnn typically points to a statement label higher in the interactive
  sequence.


        name     type   supplied/      description
                        returned

	prompt	char*(*)   S	Prompt is a supplied character string printed
				to the users terminal.  The example above
				would be:  prompt = 'enter zstart'.

	fnum	real*4    S/R	Variable to be interactively updated.

	kboard	integer	   R	Returned user response code.  Since FNUM is 
				not a logical variable, KBOARD cannot equal
				one (see routine ASKYN).

			        kboard:
			                =  0   no special meaning.
			                = -1   you accepted the current value.
			                = -2   you don't want this question.

  Comments:
    The routine must be able to parse the keystrokes entered by the user into
  a valid number based on the variable type.  In case the user's response
  cannot be parsed the ASKI4, ASKF4, and ASKF8 routines allow 2 more chances
  and then not receiving a valid character string will set the variable to
  a large positive number.  Of course a carriage-return or MU response will
  leave the variable with the same value and the program will continue.



  PROGRAM USAGE:  ASKC

    The ASKC routine updates a character string. 

  Operating characteristics:
  1) The ASKC routine will not recycle since there is no character string
     which is intrinsically 'invalid'.  The calling program must define
     character string validity.

  2) As with the rest of the ASK system, carriage-return is the signal to
     take-the-default.  To set the update string to blanks enter a quoted
     blank string.  Either " " or ' ' will work.

  3) Note the above definition of the MU response: the string must be the
     only characters of a user's entry to operate.  The characters mu and
     MU may appear as usual in combination with other characters.


                programming example:

                call askc( prompt, chrstr, kboard )
                if ( kboard .eq. -2 ) go to nnn

  Where nnn typically points to a statement label higher in the interactive
  sequence.


        name     type   supplied/      description
                        returned

        prompt  char*(*)   S    Prompt is a supplied character string printed
                                to the users terminal.  The example above
                                would be:  prompt = 'enter zstart'.

        chrstr  char*(*)  S/R   Character string to be interactively updated.

        kboard   integer    R   Returned user response code.  Since CHRSTR is
                                not a logical variable, KBOARD cannot equal 
                                one (see routine ASKYN).

                                kboard:
                                        =  0   no special meaning.
                                        = -1   you accepted the current value.
                                        = -2   you don't want this question.




  PROGRAM USAGE:  ASKF4A, ASKF8A, ASKI4A

  These routines update a floating or integer array.

  Operating characteristics:
  1) The ASKxxA routines will not recycle in case an update element is
     invalid.  The routines merely skip that element.

  2) Spaces and/or commas may delimit elements.

  3) Once a carriage-return is issued, the routines process the user's entry.
     The user may update as few elements as desired.

  4) A CTL-EOT causes an immediate MU response and the user's entry is not
     processed.  The character string MU must be in isolation to operate.

  3) Given rules 1, 2, and 3 the user has a variety of syntax that may be
     used.  If the current (default) array elements are:  1 2 3 4.  The user
     may enter any of these variations of obtain 1 5 3 7:

     1  5 3  7    Variable number of spaces to delimit elements.

     1,5, 3, 7    Combination of commas and spaces.

     ,5,,7        Commas to delimit only the changed elements.

     * 5,  #, 7   Invalid entry to cause an element skip.  Because
                  different machines interprete garbage strings differently,
                  this method is discouraged. 


		programming example:

	 	call askf4a( prompt, farray, nele, kboard )


        name     type   supplied/      description
                        returned

	prompt	char*(*)  S	same as above.

	farray	real*4   S/R	Same as above except FARRAY is an array.

	nele	integer   S	Length of farray.  MUST be greater than zero.
				
	kboard	integer   R	same as above.



  PROGRAM USAGE: ASKI4L

    This routine treats the updated variable as a logical switch where
  zero is false and one is true. 

  Operating characteristics:
  1) The second variable in the parameter list (IANS) may be only 0 or 1. 

  2) The IANS parameter is displayed on the users terminal as [ n ] or [ y ]
     for false and true respectively.

  3) The routine WILL RESET IANS TO ZERO (false) if it is neither 0 nor 1
     when entering the routine.


		programming example:

		call aski4l( prompt, ians, kboard )
		if ( kboard .eq. -2 ) go to nnn


        name     type   supplied/      description
                        returned

	prompt	char*(*)   S	The prompt that is printed on the users
				terminal.

	ians	integer   S/R	The answer is a logical state in response to
				keyboard input.

				IANS =  1   true or yes.
				     =  0   false or no.

	kboard	integer    R	User response code.  Since aski4l is returning
				a logical answer, KBOARD is the full response 
				of ASKYN described below.

                  


  PROGRAM USAGE:  ASKYN

  Return only a logical state code in response to the user's input.  There
  is no prompting by the routine.

                programming example:

		call askyn( kboard )

        name     type   supplied/      description
                        returned

	kboard	integer     R	Returned logical state in presponse to
				keyboard input.


   Your response     kboard equals   logical                action
                                    interpretation

   y, Y, yes, YES           1        true                yes branch
   n, N, no,  NO            0        false               no branch 
   <carriage-return>       -1        is not operable     current branch
   mu, MU, <control-eot>   -2        does not exist      back up the tree



   PROGRAM USAGE:  ASKPR

	call askpr( prompt )

        name     type   supplied/      description
                        returned

	prompt	char*(*)   S	Character string to be printed to users
				terminal.  If journalling has been activated,
				the prompt is also directed to the journal
				file.  Future upgrade to ODDF will take
				the character string and append it to a
				processing history and/or runtime
				configuration file.


   PROGRAM USAGE:  ASKRD

   Accept a line of text from the users terminal and return it in the 
   character string TXTREC.  If the users response is 'mu', 'MU', or a
   control end_of_text then KBOARD = -2 and TXTREC is set to blanks.  

	call askrd( txtrec, kboard )

        name     type   supplied/      description
                        returned

	txtrec	char*(*)   R	Character string read from the users terminal.
				Control characters are replaced with blanks.

	kboard   integer    R    Response code either 0, -1, or -2.





    SOFTWARE REQUIRED:
      GENCHAR - general character manipulation.


