

                       Subroutine package GENCHAR

                 General operations on character string


  Purpose:

  1  Provide a consistent definition of an operation for other portions
     of ODDF.

  2  Provide external usage to simplify application programs.



                    General Characteristics

    All of the routines in this package are callable by users applications.
  The routines described below are independent of other subroutine packages
  and most call no other General Character subroutines.  Some print
  warning messages to the users screen but all have default operation in
  case of an error.  None of these routines use a common area. 



               General classification of characters.

    These routines were written to support the Object Description Language
  parse and construction of attributes of the form "keyword = value".
  Some of the definitions, notibly alpha-numeral, are concerned with keyword
  detection and verification.  So the '+' symbol which might be considered 
  to be an alpha-numeric character is not a numeral for keyword purposes.


  The ASCII encoding sequence may be summarized as:

  character    ASCII character        GenChar class

    0-31       eg. null, linefeed     control characters 

    32         space                  generic word delimiter and string pad

   33-47       !"#$%&'()*+,-./        not classified 

   48-57       0123456789             numerals

   58-64       :;<=>?@                not classified

   65-90       uppercase letters      alphabetic characters

   91-94       [\]^                   not classified

    95         _ (underscore)         alphabetic character

    96         `                      not classified

   97-122      lowercase letters      alphabetic characters

  122-126      {|}~                   not classified

  127-255      unassigned             not classified

  In addition, the following control characters are considered to be
  print control characters: 

     8         bell                   not used
     9         backspace              not used
    10         linefeed               used in label processing
    11         vertical tab           not used
    12         form feed              not used
    13         carriage return        used in label processing

  Printing characters are considered to be ASCII 32 to 126, where the
  space is a printing character.

  Non-Printing Character are ASCII 0 to 31 and 127 to 255.



           Subroutine list and brief description

  gcaptx  Append new text onto old text.
  gccvc   Convert case.
  gclast  Return the position of the last nonblank character.
  gcleft  Left justify a character string.
  
  gcnthw  Return the nth word in a string.
  gcnxtw  Return the next word of a string.
  
  gcpalf  Return the position of the first alphabetic character.
  gcpaln  Return the position of the first alpha-numeral character.
  gcpct   Return the position of the first control character.
  gcpnal  Return the position of the first non-alphanumeral character.

  gcrf4   Read first word into a binary 4 byte real.
  gcrf8   Read first word into a binary 8 byte real (double precision).
  gcri4   Read first word into a binary 4 byte integer.
  
  gcrite  Right justify a string.
  
  gcrpcc  Replace C comments with blanks.
  gcrpcm  Replace commas with blanks.
  gcrpct  Replace control characters with blanks.
  gcrplt  Replace literals with blanks.
  gcrpnp  Replace nonprinting characters with blanks.
  gcrpnv  Replace nonvisible characters with blanks.

  gcwf4   Write 4 byte real value into character string.
  gcwf8   Write 8 byte real value into character string.
  gcwi4   Write 4 byte integer value into character string.







                 Users guide to Programming Syntax


                            Disclaimer

   The desired behavior of each routine is stated in the descriptions or
  comments.  Any behavior not stated must be considered as undocumented
  and subject to change without notice.  Undocumented behavior is normally
  caused by compilers on various machines interpreting the source code
  according to their own undocumented assumptions and/or the occasional
  oversight of the author.  Changes in the documented behavior will 
  hopefully be rare and will be detailed in update notices.


                Conventions used in the descriptions

  Uppercase words refer to subroutine names or variables.

  'Supplied' means the value has been supplied by the calling routine.

  'Returned' means the value is returned to the calling routine.

  char*(*)   indicates a character variable with any length greater
               than zero and less than some very large maximum.

  integer    indicates a 4 byte signed integer.  Other forms are not used.

  real*4     indicates a 4 byte floating point variable.

  real*8     indicates an 8 byte double precision floating point variable.


                     Substring Position

    The GCaaaa routines return position variables, say the last character
  of a string, relative to the string that was passed to the routine.
  Therefore if you pass a substring via 

  call gcaaaa( txtrec(istart:nn), ... ipos, ...),

  then IPOS is relative to the start character location ISTART (ie. GCaaaa
  does not know it is dealing with a substring).  The absolute position is
  then: IABS = ( IPOS - 1 ) + ISTART.



                   Subroutine Descriptions



GCAPTX	Append a second text string to the first string.  The last non-blank
        character of TXTREC is found and then NEW is appended after that
	character.  NEW is not modified (eg. left justify) before the
	append operation.

	call gcaptx( txtrec, new, nchtxt )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	The supplied string that will have NEW appended
				to it.  The returned TXTREC has string NEW
				appended to it.

	new	char*(*)   S	String to be appended to TXTREC.

	nchtxt	integer    R	Position of the last non-blank character.
				Note substring position warning.



GCCVC	Convert case, lower to upper and vice versa, of all alphabetic
        characters in the string.

	call gccvc( txtrec, iopr )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	String to be converted,  only a-z aand A-Z
				affected.  Result is returned in this string.

	iopr	integer    S	set to 1 for uppercase output.
				       2 for lowercase.
				Anything else is no-operation.



GCLAST	Return the position of the last non-blank character.

	call gclast( txtrec, ipos )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)   S	input string.

	ipos	integer    R	postion of the last character.
				Note substring position warning.

	Comments:
        The NULL character is considered a blank.



GCLEFT	Left justify a string.  Strip preceeding blanks and move the
	remaining string left to position one.

	call gcleft( txtrec, lastch )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	input string and returned left-justified
				string.

	lastch	integer    R	position of the last nonblank character.
				Note subsring position warning.

	Comments:
	If there are no nonblank characters, then LASTCH = 0.



GCNTHW	Return the Nth word, where a 'word' is a string bounded by
	spaces or the first or last position of the string.

	call gcnxtw( txtrec, nthwrd, ipos, wrd, nchwrd )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)   S	input string.

	nthwrd	integer    S	desired word.

	ipos	integer    R	Position of the first character of WRD in
				TXTREC.  Note substring position warning.

	wrd	char*(*)   R	returned word.

	nchwrd	integer    R	number of characters in WRD.


        Comments:
	This routine makes sequential calls to gcnxtw.
        If there are more than 256 spaces to the next word, the routine fails.
	If there are no more words, then NCHWRD = IPOS = 0 and WRD = ' '.



GCNXTW	Return the next word, where a 'word' is a string bounded by
	spaces or the first or last position of the string.

	call gcnxtw( txtrec, ipos, wrd, nchwrd )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)   S	input string.

	ipos	integer    R	Position of the first character of WRD in
				TXTREC.  Note substring postion warning.

	wrd	char*(*)   R	returned word.

	nchwrd	integer    R	number of characters in WRD.


        Comments:
	If there is no word, then NCHWRD = IPOS = 0 nad WRD = ' '.
        If the returned word is longer than WRD, then WRD is returned as
        blanks but NCHWRD and IPOS have the values correct they would have
 	had if WRD were long enough. 



GCPALF  Return position of the first alphabetic character.
        Alphabetic characters are : a-z, A-Z and "_".

        call gcpalf( txtrec, ipos )

        item      type   Supplied/        description
                         Returned

        txtrec  char*(*)   S    Supplied character string.

        ipos    integer    R    Returned position of the first
                                alphanumeric character.  NOTE substring
                                position warning.



GCPALN	Return position of the first alpha-numeral character.

	Alphanumeral characters are : a-z, A-Z, 0-9, and the
	underscore character "_".  The hyphen is not an alphanumeral.

	call gcpaln( txtrec, ipos )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)   S	Supplied character string.

	ipos	integer    R	Returned position of the first
				alphanumeric character.  NOTE substring
				position warning.



GCPCT	Return the position of the first control character.  Control
	characters are ASCII 0 to 31 (base 10).

	call gcpct( txtrec, ipos )

	arguments same as for gcpaln.



GCPNAL	Return the position of the first non-alphanumeral character.  
	This routine is the inverse of gcpaln.

	call gcpnal( txtrec, ipos )

	agruments same as for gcpaln.

        Comments:
	The space character (ASCII 32 base 10) is ignored in GCPNAL.



GCRF4   Return binary real*4, real*8, or integer*4 intepreted from
GCRF8	the first word in a supplied character string.  A word is a
GCRI4	character string delimited by spaces or the string boundaries.
	Note the input (txtrec) preceeds the output (f4, f8, i4).

	call gcrf4( txtrec, f4, ierror )
	call gcrf8( txtrec, f8, ierror )
	call gcri4( txtrec, i4, ierror )

        item      type   Supplied/        description
                         Returned

	txtrec	 char    S	supplied character string.

	f4   	real*4	 R	interpreted number read from the
				first word in txtrec.
	f8   	real*8	 R	interpreted double precision number read from
				the first word in txtrec.
	i4   	integer  R	interpreted number read from the
				first word in txtrec.

	ierror	integer  R	Error code.  Zero means ok.
				In case of read error, not only is
				IERROR set nonzero but F4, F8, or I4 are set
				close to their maximum values.

        Comments:

	The 'maximum' values are a convenient transportible value somewhat
        less than the hardware coded values.
        Real*4  3.4e38  (3.4 x 10 ^ 38)
	Real*8  3.4d38
	Integer*4  2147483647

	The strings NaN, +INF, -INF (ie. the IEEE NotANumber and INFinity)
        are not recognized and cause an error.

	These three routines do the operation of a starred read from
	a character variable.  Fortran example:

	  txtrec = '1234.56 is a number'
	  read( txtrec, *, iostat=ierr ) f4

	  sets f4 = 1234.56



GCRITE	Right justify a string.  Move a string right until all trailing 
	blank characters are removed, pad the beginning of the string
	with blanks.

	call gcrite( txtrec, ifirst )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	Input string and returned string where trailing
				blanks are removed and the non-blank contents
				moved to the right.  Blanks are added in front
				of the right justified contents.  GCRITE is
				the inverse of GCLEFT.

	ifirst	integer    R	Position of the first non-blank character in
				the returned string.  Note substring position
				warning.


		
GCRPCM	Replace commas in a string with blanks.

	call gcrpcm( txtrec )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	Supplied character string and returned string
				with commas replaced with blanks.



GCRPCT	Replace control characters with blanks.

	call gcrpct( txtrec )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	Supplied character string and returned string
				with control characters replaced with blanks.



GCRPNP	Replace nonprinting characters with blanks.

	call gcrpnp( txtrec )

	item      type   Supplied/        description
	                 Returned

	txtrec	char*(*)  S&R	Supplied character string and returned string
				with nonprinting characters replaced with
				blanks.

	Comments:
	The print control characters are considered to be printing characters.


GCRPNV  Replace nonvisible characters with blanks.

        call gcrpnp( txtrec )

        item      type   Supplied/        description
                         Returned

        txtrec  char*(*)  S&R   Supplied character string and returned string
                                with nonprinting characters replaced with
                                blanks.

	Comments:
	The print control characters are NOT considered to be visible
	characters.
	


GCWF4   Encode a real*4, real*8, or integer*4 binary value into a character
GCWF8	string.  In the real*4 and real*8 case, format for best readability.
GCWI4   Note the input (f4, f8, i4) preceeds the output (txtrec).

	call gcwf4( f4, txtrec, ierror )
	call gcwf8( f8, txtrec, ierror )
	call gcwi4( i4, txtrec, ierror )

	There are three routines described here the only difference among
	them is the variable type of the first parameter.

	f4   	real*4     S	Supplied single precision floating point number
	f8   	real*8     S	Supplied double precision number.
	i4   	integer    S	Supplied single precision fixed point (integer)
				number.

	txtrec	 char*(*)  R	Returned character string.  Length guide:
				real*4 numbers need at least 16 characters.
				real*8 numbers need at least 24 characters.
				int*4  numbers need at least 12 characters.
				The characters are left justified in TXTREC.

	ierror	integer    R	Fortran error code.  Zero means ok.
				In case of read error, not only is
				IERROR set nonzero but TXTREC is set to blank.

	Comments:

	The IEEE  NaN, +INF, -INF  character strings are not recognized.

	These three routines do the operation of a starred write to a 
	character variable.  Fortran example:

	  f4 = 1234.56
	  write( txtrec, *, iostat=ierr ) f4

	  yields   txtrec = '1234.560'

	  The text representation of the floating point numbers is
	  formatted such that numbers with most-significant digits
	  greater than 999,999.9 or less than .001 are in exponential
	  form.  The appropriate number of significant figures are
	  maintained and trailing zeroes are removed in both decimal
	  and exponential forms.



