      subroutine gheader(mode,iunit,title,ncol,nrow,xo,dx,yo,dy,ierr)
      entry gh1f4(mode,iunit,title,ncol,nrow,xo,dx,yo,dy,ierr)
c
c  read or write a binary grid header
c
c  mode:        'r' or 'w'
c  iunit:       fortran unit number
c  title:       grid identification
c  ncol:        number of columns
c  nrow:        number of rows
c  xo:          x-origin (leftmost column coordinate)
c  dx:          x-increment
c  yo:          y-origin (bottommost row coordinate)
c  dy:          y-increment
c  ierr:        returns 0 if no errors
c
      dimension title(14)
      character mode*1
      include 'iosys.cmn'
      if(mode.eq.'r'.or.mode.eq.'R') then
        rewind(iunit,err=30,iostat=ierr)
        read(iunit,err=20,iostat=ierr) title,oldpgm,ncol,nrow,nz,xo,dx,
     &  yo,dy,iproj,cmdeg,bldeg
        go to 30
   20   rewind(iunit,err=30,iostat=ierr)
        read(iunit,err=30,iostat=ierr) title,oldpgm,ncol,nrow,nz,xo,dx,
     &  yo,dy
        iproj=0
      else if(mode.eq.'w'.or.mode.eq.'W') then
        rewind(iunit,err=30,iostat=ierr)
        nz=1
        if(iproj.ne.0) then
          write(iunit,err=30,iostat=ierr) title,pgm,ncol,nrow,nz,xo,dx,
     &    yo,dy,iproj,cmdeg,bldeg
        else
          write(iunit,err=30,iostat=ierr) title,pgm,ncol,nrow,nz,xo,dx,
     &    yo,dy
        endif
      else
        ierr=1
      endif
   30 if(nz.ne.1) ierr=1
      return
      end
