      subroutine gopen(iunit,file,status,mode,ierr)
c
c  opens a binary grid file
c
c  iunit:       fortran unit number
c  file:        file name
c  status:      'new','old','unknown', or 'scratch'
c  mode:        'read','write',or 'readwrite'
c  ierr:        returns 0 on no error
c
      character file*(*),status*(*),mode*(*)
      character share*6
c
      if(status.eq.'old'.or.status.eq.'OLD') then
        share='denywr'
      else
        share='compat'
      endif
      if(status.eq.'scratch'.or.status.eq.'SCRATCH') then
        open(iunit,status=status,form='unformatted',mode=mode,
     &  share=share,iostat=ierr)
      else
        open(iunit,file=file,status=status,form='unformatted',
     &  mode=mode,share=share,iostat=ierr)
      endif
      if(ierr.eq.6415) then
c          print*,ierr
        nf=len_trim(file)
c        print*,file
        print'(a\)',' File '
        print'(a\)',file(1:nf)
        print'(a\)',' exists -- OK to overwrite? [n] '
        read(5,20) ans
20      format(a)
        if(ans.eq.'y'.or.ans.eq.'Y') then
      open(iunit,file=file,status='unknown',form='unformatted',
     & mode=mode,share=share,iostat=ierr)
        endif
      endif
      return
      end
