      program p2mincmd

c..Constructs a minc command file to match the
c..limits in x & y of an xyz or post file.
c..Input is a projected xyz or post file (use genproj)
c..from which is calculated the location and 
c..dimensions of the grid. A variable border of
c..dvals can be specified (in km) around the valid grid data.
c..modified from a MAD subroutine by Dave Daniels 1996

      character*80 cmdfile,ifile,ofile,title
      dimension cm(3),bl(3)

      call askin
      print*,'constructs a minc command file from an xyz or post file'
      ifile=' '
400   call askc('name of projected xyz or post file',ifile,ierr)
      if(ierr.ne.0) stop
      call xopen(10,ifile,'old','read',itype,ierr)
      if(ierr.ne.0) go to 400
      if(itype.lt.0) stop 'invalid input format'
c
      i=index(ifile,'.')
      ofile=ifile(1:i)//'grd'
      cmdfile=ifile(1:i-1)//'.cmd'
401   call askc('name of grid file',ofile,ierr)
      if(ierr.eq.-2) then
        close(10)
        go to 400
      endif
402   call askc('name of command file',cmdfile,ierr)
      if(ierr.eq.-2) go to 401
c
      open(11,file=cmdfile,form='formatted',status='new',iostat=ierr)
      if(ierr.eq.6415) then
         ians=0
         call aski4l(' File exists -- OK to overwrite?',ians,ierr)
         if(ians.eq.1) then
           open(11,file=cmdfile,status='unknown',form='formatted',
     1             iostat=ierr)
         else
           go to 402
         endif
      endif
c
c..Get min-max of projected xyz or post data file
c
      call xymm1(itype,ymin,ymax,xmin,xmax)
      xran=abs(xmax-xmin)
      yran=abs(ymax-ymin)
      print*,'x-range = ',xran,' y-range = ',yran
c
c..The following are user chosen parameters
c
      del=.1
403   call askf4('grid interval (km)',del,ierr)
      if(ierr.eq.-2) go to 402
      radi=0.
404   call askf4('radius',radi,ierr)
      if(ierr.eq.-2) go to 403
      slope=0.
405   call askf4('slope',slope,ierr)
      if(ierr.eq.-2) go to 404
      xmar=0.
406   call askf4('extra margin around data (km)',xmar,ierr)
      if(ierr.eq.-2) go to 405
      title=' '
407   call askc('grid id',title,ierr)
      if(ierr.eq.-2) go to 406
      izchan=0
      if(itype.gt.0) then
        izchan=itype-2
408      call aski4('channel to grid',izchan,ierr)
         if(ierr.eq.-2) go to 407
         if(izchan.lt.1.or.izchan.gt.itype-2) go to 408
      endif
      call mphnam
      iproj=0
409   call aski4('projection code',iproj,ierr)
      if(ierr.eq.-2) go to 407
      if(iproj.gt.0) then
        baslat=0.
410     call askf4('base latitude',baslat,ierr)
        if(ierr.eq.-2) go to 409
        cm=-100.
411     call askf4('central meridian',cmerid,ierr)
        if(ierr.eq.-2) go to 410
        call d2dms(cmerid,cm)
        call d2dms(baslat,bl)
      endif
c
c..Calculate xo,yo,nc,nr from min,max,margin,del
c
      xo=del*int((xmin-xmar-del)/del)
      yo=del*int((ymin-xmar-del)/del)
      x1=del*int((xmax+xmar+del)/del)
      y1=del*int((ymax+xmar+del)/del)
      xc=(x1-xo)/del
      yc=(y1-yo)/del
c      xc=(xmax-xmin+2.0*xmar)/del
c      xr=(ymax-ymin+2.0*xmar)/del
      nc=xc+1.
      nr=yc+1.
c
c..Write parms file for input to minc
c
      write(11,101)
 101  format(' $parms')
      write(11,102) ifile,ofile,title
 102  format(' ifile=',1h',a20,1h',',',/
     1       ,' ofile=',1h',a20,1h',',',/
     2       ,' title  =',1h',a50,1h',',')
      write(11,103) izchan
 103  format(' izchan=',i2)
      if(iproj.gt.0) then
        write(11,104) iproj,int(bl(1)),int(bl(2)),bl(3),
     1                int(cm(1)),int(cm(2)),cm(3)
 104    format(' iproj=',i2,', baslat=',i3,i3,f7.3,', cm=',i4,i3,f7.3)
      endif
      write(11,105) xo,yo,nc,nr,del,radi,slope
 105  format(' xo=',f12.4,',  yo=',f12.4,',   nc=',i5,',   nr=',i5,
     1   ',   del=',f12.4,',',/' radius=',f6.2,', slope=',f6.2,' $')
      close(11)
c10    format(a)
      stop
      end

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine xymm1(itype,ymin,ymax,xmin,xmax)

      dimension xyz(24)
 
      nrec=0
      dval=1.0e38
      xmax=-dval
      xmin=dval
      ymax=-dval
      ymin=dval
 
30    if(itype.eq.0) then
        call xioxyz('r',10,xyz,3,ierr)
      else
        call xiopst('r',10,id,xyz,itype,ierr)
      endif
      if(ierr.ne.0) go to 99
      nrec=nrec+1
      xmax=max(xyz(1),xmax)
      xmin=min(xyz(1),xmin)
      ymax=max(xyz(2),ymax)
      ymin=min(xyz(2),ymin)
      go to 30

99    close(10)

      print *,'  NUMBER OF RECORDS=',nrec

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
        subroutine d2dms( d, dms)
        dimension dms(3)
        signd=1.
        if(d.lt.0.0) signd=-1.
        dms(1)=int(d)
        dms(2)=signd*int((d-dms(1))*60.)
        dms(3)=((signd*(d-dms(1))*60.)-dms(2))*60.
        return
        end

