/*
	fotoview.c

	companion to 'textview.c' -- looks at pictures if the name of an '.lbl'
	file is passed to it.

*/
#include <conio.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "font.h"
#include "mouseg.h"
#include <process.h>
#include <stdlib.h>

#define M_GREY      244
#define ORANGE      245
#define YELLOW      246
#define GREEN       247  
#define D_YELLOW    248
#define BLUE        249  
#define D_BLUE      250  
#define RED         251
#define CYAN        252  
#define WHITE       253
#define D_CYAN      254  
#define L_GREY      256
#define B_LINES 48
#define NUM_IMAGE 2
#define MENU_IV  2
#define MAX_NUM 300
#define S_SIZE 40
#define STR_LEN 100
#define MENUXC 550
#define NUM_DP 100
#define MAX_X 640

extern int Mouse;
int FontSize=2;
char Suffix[20];
char LastFile[STR_LEN];int NumPath=1;
char Path[NUM_DP][STR_LEN];
struct board
{
	int row,col,color;
}B_Id;
extern char GF_String[MAX_NUM][S_SIZE];
int ScreenXs,ScreenYs;
char VideoType='X';
unsigned char MT_Buff[12][MAX_X],Mbuff[B_LINES][MAX_X],Buffer[MAX_X];

char *Menu_iv[MENU_IV]=
	{"zoom",
	"exit image"
};
struct   Color 
{ 
	unsigned char  r, g, b; 
}lutc[256],luts[256]; 
int Black=0,White=191,Center=128,Num_Color=256;
int D_Grey=46,L_Grey=191,M_Grey=128;
struct Color Blk={  0,  0,  0};
struct Color D_G={ 46, 46, 46};
struct Color M_G={127,127,127};
struct Color L_G={191,191,191};
struct Color Wht={255,255,255};
unsigned char ActiveLut;
int Img=0,Sample=1,Xc=0,Yc=0,Speed=16,Row,Col,ZoomSample=1,ScreenZoom=1;
char *SubType;
struct equipment
{
	int printers; 		/* number present */
	int sprinter;		/* serial printer installed?  0=no  1=yes */
	int game;			/* game adapter installed? */
	int sports;			/* number of serial ports */
	int dma;				/* DMA chip installed? */
	int drives;			/* number of disk drives */
	int video;			/* video mode 1=40 color 2=80 color 3=80 B/W */
	int disk;			/* any disk drives? */
	int memory;			/* memory size in Kbytes */
};
extern struct equipment Eq;
extern int GF_Order[MAX_NUM];
extern char GF_String[MAX_NUM][S_SIZE];
struct file_id
{
	char name[S_SIZE];
	long size;
	unsigned date,time;
};
extern struct file_id GF_File[MAX_NUM];
extern int Monitor;

struct image_header
{
	int row,col;
	int sample;
	int record_bytes,file_records;
	int record_col_header;
	int row_col_header;
	int header_bytes;
	int imbedded_header;
	int sample_bits;
	char infile[100],image[100],Lut[100],pal_type,label[100];
	int vga_color[256];
	struct Color lut[256],lutc[256];
}Hdr[NUM_IMAGE];


int picture_view(char *string);
int read_lbl(char *label,int filenum);
int process_image(int filenum);
int load_image(int filenum);
int IV_set_lut(char type,char *filename);
int plot_sub_image(FILE *fp,int sample,int filenum);
int plot_full_image(FILE *fp,int sample,int filenum);
int limit_area_fixed(int *xc,int *yc,int *xs,int *ys,int *speed,int *sample);
int add_disk_path(char *string);
int video_on(void);
FILE *open_to_write_text(char *name);
FILE *open_to_write_binary(char *name);
FILE *open_to_read_text(char *name);
FILE *open_to_read_binary(char *name);
int M_do_menu(char *menu[],int num,int xc,int yc,int start,
		int back,int words,int boxs,int font[128][25]);
char fsplit(char *,char *,char *,char *);

FILE *fperr;

/***********************************************************************
**
**
**
**
************************************************************************/

int picture_view(char *string)

{
	int i,j,k;
	char filename[STR_LEN],str1[50],str2[50],str3[50],str4[50];
	int ans;
	FILE *fp;
	char instring[STR_LEN],infile[STR_LEN];

	strcpy(filename,string);
	Img=0;
	for(k=0;k<strlen(filename);k++)
	if(filename[k]=='.')
		filename[k]='\0';
	strcpy(string,filename);
	strcat(string,".lbl");		
	strcpy(Hdr[Img].label,string);

fperr=fopen("fotoview.err","at");
fprintf(fperr,"trying file '%s'\n",Hdr[Img].label);
fclose(fperr);

	if(read_lbl(Hdr[Img].label,Img)>0)
	{
		video_on();
		process_image(Img);
		SetVideoMode(0);			
	}
}


/**************************************************************************
**
**
**
************************************************************************* */

int read_lbl(char *label,int filenum)

{
	int i,j,k;
	char string1[100],string2[100],string3[100];
	FILE *fp;
	int status=1,numread;

	fp=open_to_read_binary(label);
	if(!fp)
		return(-1);
	Hdr[filenum].sample_bits=Hdr[filenum].record_bytes=0;
	Hdr[filenum].file_records=0;
	Hdr[filenum].pal_type=0;
	Hdr[filenum].row_col_header=0;
	while(fscanf(fp,"%s",string1)==1)
	{
		if(strcmpi(string1,"end")==0)
		{
			fclose(fp);
			return(status);
		}
		if(strcmpi(string1,"image_lines")==0&&Hdr[filenum].file_records==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			sscanf(string3,"%d",&Hdr[filenum].row);
			printf("Row = %d\n",Hdr[filenum].row);
		}
		if(strcmpi(string1,"sample_bits")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			sscanf(string3,"%d",&Hdr[filenum].sample_bits);
			printf("Sample_Bits = %d\n",Hdr[filenum].sample_bits);
		}
		if(strcmpi(string1,"file_records")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			sscanf(string3,"%d",&Hdr[filenum].row);
			printf("Row = %d\n",Hdr[filenum].row);
			Hdr[filenum].file_records=Hdr[filenum].row;
		}
		if(strcmpi(string1,"line_samples")==0&&Hdr[filenum].record_bytes==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			sscanf(string3,"%d",&Hdr[filenum].col);
			printf("Col = %d\n",Hdr[filenum].col);
		}
		if(strcmpi(string1,"record_bytes")==0||
			strcmpi(string1,"image_record_bytes")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			sscanf(string3,"%d",&Hdr[filenum].col);
			printf("Col = %d\n",Hdr[filenum].col);
			Hdr[filenum].record_bytes=Hdr[filenum].col;
		}
		if(strcmpi(string1,"header_bytes")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			sscanf(string3,"%d",&Hdr[filenum].header_bytes);
			printf("Header_Bytes = %d\n",Hdr[filenum].header_bytes);
		}
		if(strcmpi(string1,"image_pointer")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			k=0;
			for(i=0;i<strlen(string3);i++)
				if(string3[i]!=39)		/* single quote */
					Hdr[filenum].image[k++]=string3[i];
			Hdr[filenum].image[k]='\0';
			printf("Image = %s\n",Hdr[filenum].image);
		}
		if(strcmpi(string1,"pal_type")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			k=0;
			for(i=0;i<strlen(string3);i++)
				if(string3[i]!=39)		/* single quote */
					string1[k++]=string3[i];
			string1[k]='\0';
			Hdr[filenum].pal_type=string1[0];
			printf("Pal_Type = %c\n",Hdr[filenum].pal_type);
		}
		if(strcmpi(string1,"pal_pointer")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			k=0;
			for(i=0;i<strlen(string3);i++)
				if(string3[i]!=39)		/* single quote */
					Hdr[filenum].Lut[k++]=string3[i];
			Hdr[filenum].Lut[k]='\0';
			printf("Lut = %s\n",Hdr[filenum].Lut);
		}
		if(strcmpi(string1,"row_col_header")==0)
		{
			numread=fscanf(fp,"%s%s",string2,string3);
			if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
				numread<2)
			{
				fclose(fp);
				return(status);
			}			
			Hdr[filenum].row_col_header=1;
			Hdr[filenum].header_bytes=4;
		}
	}
	fclose(fp);
	return(status);
}

/**************************************************************************
**
**
**
************************************************************************* */

int process_image(int filenum)

{
	int num=0;
	int ix=ScreenXs/2,iy=ScreenYs/2,speed=16;
	int meni_iv=0;

	load_image(filenum);	
	do
	{
/*        num=M_do_menu(Menu_iv,MENU_IV,MENUXC,25,num,D_Grey,L_Grey,White,Font);*/
        num=M_do_menu(Menu_iv,MENU_IV,MENUXC,25,num,D_Grey,L_Grey,RED,Font);
		if(num==0)
		{
			load_image(filenum);			
		}
	}while(num<MENU_IV-1);
	ZoomSample=1;
}

/**************************************************************************
**
**
**
************************************************************************* */

int load_image(int filenum)

{
	int i,j,k;
	int sample=0;
	int xs,ys;
	FILE *fp;
	long offset=0;
	char string[100];

	Row=Hdr[filenum].row;
	Col=Hdr[filenum].col;
	if(VideoType=='S')
		Speed=8;

	if(Hdr[filenum].sample_bits==0)
		Hdr[filenum].sample_bits=8;

	if((Row==0||Col==0)&&Hdr[filenum].row_col_header==0)
		return(-1);
	fp=open_to_read_binary(Hdr[filenum].image);
	if(!fp)
		return(-1);
	if(Hdr[filenum].row_col_header==1)
	{
		fread((char *)&Hdr[filenum].row,sizeof(int),1,fp);
		fread((char *)&Hdr[filenum].col,sizeof(int),1,fp);
		Col=Hdr[filenum].col;
		Row=Hdr[filenum].row;
		if(Row<=0||Col<=0)
			return(-1);
	}
	else if(Hdr[filenum].imbedded_header==1)
	{
		offset=Hdr[filenum].col;
		fseek(fp,offset,SEEK_SET);
	}
	else if(Hdr[filenum].header_bytes>0)
	{
		offset=Hdr[filenum].header_bytes;
		fseek(fp,offset,SEEK_SET);
	}
	video_on();
	do
	{
		Sample=sample+=1;
		Row=Hdr[filenum].row/sample;
		Col=Hdr[filenum].col/sample;
		offset=(sample-1);
		offset*=Hdr[filenum].col;
	}while(Col>ScreenXs||Row>ScreenYs);
	Hdr[filenum].sample=sample;
	if(Hdr[filenum].pal_type>0)
		IV_set_lut(Hdr[filenum].pal_type,Hdr[filenum].Lut);
	else
	{
		if(IV_set_lut('P',Hdr[filenum].Lut)<0)
			IV_set_lut('G',Hdr[filenum].Lut);
	}
	plot_full_image(fp,sample,filenum);

	if(sample>-8)
	{
		sample=ZoomSample;
		if(limit_area_fixed(&Xc,&Yc,&xs,&ys,&Speed,&sample)!=27)
		{
			ZoomSample=sample;
			plot_sub_image(fp,sample,filenum);
		}
	}
	fclose(fp);
}

/********************************************************************
**
**	type  g -- grey all lut[] files
**			G -- grey only lut[]
**			i -- initial header map
**			r -- reset lut[] to lutc[]
**			p -- positive (0-127) magenta, negative (128-255) green
**
********************************************************************* */

int IV_set_lut(char type,char *filename)

{
	int i,k,hue,brite,j;
	int r,g,b;
	float color[3];
	double dbrite,dval;
	float val,minval,sat,inten;
	float fval,fk;
	FILE *fplut;
	int end=0,scale,sum;
	char string[100];
	long del,mindel,l1,l2,l3,l4;

	scale=1;
	if(Num_Color==16)
		scale=17;
	if(type=='P')
	{
		fplut=open_to_read_binary(filename);
		if(fplut)
		{
			i=0;
			do
			{
				i+=1;
				fscanf(fplut,"%s",string);
			}while(strcmpi(string,"end")!=0&&i<50);
			if(strcmpi(string,"end")!=0)
				rewind(fplut);
			for(i=0;i<256;i++)
			{
				fscanf(fplut,"%d%d%d%d",&k,&r,&g,&b);
				Hdr[Img].lut[i].r=r;
				Hdr[Img].lut[i].g=g;
				Hdr[Img].lut[i].b=b;
			}
			fclose(fplut);
		}
		else
			return(-1);
		if(VideoType=='V'||VideoType=='E')
		{
			for(i=0;i<256;i++)
			{
				sum=(int)Hdr[Img].lut[i].r*10;
				sum+=(int)Hdr[Img].lut[i].g*8;
				sum+=(int)Hdr[Img].lut[i].b*2;
				sum/=319;
				Hdr[Img].vga_color[i]=sum;
			}
			for(k=0;k<Num_Color;k++)
			{
				Hdr[Img].lut[k].r=k*scale;
				Hdr[Img].lut[k].g=k*scale;
				Hdr[Img].lut[k].b=k*scale;
			}
		}
		ActiveLut='P';
	}
	if(type=='g')
	{
		for(k=0;k<Num_Color;k++)
		{
			Hdr[Img].lutc[k].r=Hdr[Img].lut[k].r=k*scale;
			Hdr[Img].lutc[k].g=Hdr[Img].lut[k].g=k*scale;
			Hdr[Img].lutc[k].b=Hdr[Img].lut[k].b=k*scale;
		}
		ActiveLut='g';
	}
	if(type=='G')
	{
		for(k=0;k<Num_Color;k++)
		{
			Hdr[Img].lut[k].r=k*scale;
			Hdr[Img].lut[k].g=k*scale;
			Hdr[Img].lut[k].b=k*scale;
		}
		ActiveLut='G';
	}
	if(type=='i')
	{
		for(k=0;k<Num_Color;k++)
		{
			Hdr[Img].lutc[k].r=Hdr[Img].lut[k].r=k*scale;
			Hdr[Img].lutc[k].g=Hdr[Img].lut[k].g=k*scale;
			Hdr[Img].lutc[k].b=Hdr[Img].lut[k].b=k*scale;
		}
		Hdr[Img].lut[ 64].r=  0;Hdr[Img].lut[ 64].g=  0;Hdr[Img].lut[ 64].b=128;
		Hdr[Img].lut[127].r=  0;Hdr[Img].lut[127].g=100;Hdr[Img].lut[127].b=  0;
		Hdr[Img].lut[191].r=255;Hdr[Img].lut[191].g=  0;Hdr[Img].lut[191].b=  0;
		Hdr[Img].lut[192].r=255;Hdr[Img].lut[192].g=128;Hdr[Img].lut[192].b=  0;
		Hdr[Img].lut[193].r=255;Hdr[Img].lut[193].g=255;Hdr[Img].lut[193].b=  0;
		Hdr[Img].lut[194].r=  0;Hdr[Img].lut[194].g=255;Hdr[Img].lut[194].b=  0;
		Hdr[Img].lut[195].r=  0;Hdr[Img].lut[195].g=255;Hdr[Img].lut[195].b=255;
		Hdr[Img].lut[196].r= 20;Hdr[Img].lut[196].g= 55;Hdr[Img].lut[196].b=255;
		Hdr[Img].lut[253].r=100;Hdr[Img].lut[253].g=  1;Hdr[Img].lut[253].b=  1;
		Hdr[Img].lut[254].r=100;Hdr[Img].lut[254].g=  1;Hdr[Img].lut[254].b=  1;
		ActiveLut='i';
	}
	if(type=='r')
	{
		for(k=0;k<Num_Color;k++)
		{
			Hdr[Img].lut[k].r=Hdr[Img].lutc[k].r;
			Hdr[Img].lut[k].g=Hdr[Img].lutc[k].g;
			Hdr[Img].lut[k].b=Hdr[Img].lutc[k].b;
		}
		ActiveLut='r';
	}
	mindel=16777216;
	for(i=0;i<Num_Color;i++)
	{
		l1=Blk.r;
		l2=Hdr[Img].lut[i].r;
		l3=Hdr[Img].lut[i].g;
		l4=Hdr[Img].lut[i].b;
		del=(l1-l2)*(l1-l2)+(l1-l3)*(l1-l3)+(l1-l4)*(l1-l4);
		if(del<mindel)
		{
			mindel=del;
			Black=i;
		}
	}
	mindel=16777216;
	for(i=0;i<Num_Color;i++)
	{
		l1=D_G.r;
		l2=Hdr[Img].lut[i].r;
		l3=Hdr[Img].lut[i].g;
		l4=Hdr[Img].lut[i].b;
		del=(l1-l2)*(l1-l2)+(l1-l3)*(l1-l3)+(l1-l4)*(l1-l4);
		if(del<mindel)
		{
			mindel=del;
			D_Grey=i;
		}
	}
	mindel=16777216;
	for(i=0;i<Num_Color;i++)
	{
		l1=M_G.r;
		l2=Hdr[Img].lut[i].r;
		l3=Hdr[Img].lut[i].g;
		l4=Hdr[Img].lut[i].b;
		del=(l1-l2)*(l1-l2)+(l1-l3)*(l1-l3)+(l1-l4)*(l1-l4);
		if(del<mindel)
		{
			mindel=del;
			M_Grey=i;
		}
	}
	mindel=16777216;
	for(i=0;i<Num_Color;i++)
	{
		l1=L_G.r;
		l2=Hdr[Img].lut[i].r;
		l3=Hdr[Img].lut[i].g;
		l4=Hdr[Img].lut[i].b;
		del=(l1-l2)*(l1-l2)+(l1-l3)*(l1-l3)+(l1-l4)*(l1-l4);
		if(del<mindel)
		{
			mindel=del;
			L_Grey=i;
		}
	}
	mindel=16777216;
	for(i=0;i<Num_Color;i++)
	{
		l1=Wht.r;
		l2=Hdr[Img].lut[i].r;
		l3=Hdr[Img].lut[i].g;
		l4=Hdr[Img].lut[i].b;
		del=(l1-l2)*(l1-l2)+(l1-l3)*(l1-l3)+(l1-l4)*(l1-l4);
		if(del<mindel)
		{
			mindel=del;
			White=i;
		}
	}
	WritePalette(Hdr[Img].lut);
	return(1);
}


/**************************************************************************
**
**
**
************************************************************************* */

int plot_sub_image(fp,sample,filenum)

FILE *fp;
int sample,filenum;

{
	int i,j,k;
	long offset;
	int val,nsample=sample*-1+2,zscale=1;

	ScreenZoom=sample;
	if(sample<1)
		zscale=nsample;
	rewind(fp);
	offset=Hdr[filenum].col;
	offset*=Yc*Sample;
	offset+=Xc*Sample;
	if(Hdr[filenum].header_bytes>0)
		offset+=Hdr[filenum].header_bytes;
	fseek(fp,offset,SEEK_SET);
	Row=ScreenYs;
	Col=ScreenXs;
	offset=Hdr[filenum].col;
	if(sample>0)
	{
		if((Yc*Sample+Row*sample)>Hdr[filenum].row)
			Row=(Hdr[filenum].row-Yc*Sample)/sample;
		if((Xc*Sample+Col*sample)>Hdr[filenum].col)
			Col=(Hdr[filenum].col-Xc*Sample)/sample;
	}
	else
	{
		if((Yc*Sample+Row/nsample)>Hdr[filenum].row)
			Row=(Hdr[filenum].row-Yc*Sample)*nsample;
		if((Xc*Sample+Col/nsample)>Hdr[filenum].col)
			Col=(Hdr[filenum].col-Xc*Sample)*nsample;
		offset=0;
	}
	offset*=(sample-1);
	for(i=0;i<Row/zscale;i++)
	{
		if(fread((char *)Buffer,sizeof(char),Hdr[filenum].col,fp)<1)
			return(-1);
		if(kbhit()>0)
		{
			val=getch();
			if(val==27)
				return(-2);
		}
		if(offset>0)
			fseek(fp,offset,SEEK_CUR);
		if(sample>1)
			for(j=0;j<Col;j++)
				Buffer[j]=Buffer[j*sample];
		if(sample<1)
			for(j=Col-1;j>0;j--)
				Buffer[j]=Buffer[j/nsample];
		if(VideoType=='V'||VideoType=='E')
		{
			if(ActiveLut=='P')
			{
				for(j=0;j<Col;j++)
					Buffer[j]=Hdr[filenum].vga_color[Buffer[j]];
			}
			else
			{
				for(j=0;j<Col;j++)
					Buffer[j]/=16;
			}
		}
		if(sample>0)
			plotrow(3,0,Col-1,i,Buffer);
		else
			for(k=0;k<nsample;k++)
				plotrow(3,0,Col-1,i*nsample+k,Buffer);
	}
	return(1);
}

/**************************************************************************
**
**
**
************************************************************************* */

int plot_full_image(FILE *fp,int sample,int filenum)

{
	int i,j,k;
	long offset;
	char string[100];
	int row,col;
	FILE *fpsub;

	strcpy(string,Hdr[filenum].image);
	for(i=0;i<strlen(string);i++)
		if(string[i]=='.')
			string[i]='\0';
	strcat(string,SubType);
	fpsub=open_to_read_binary(string);
	if(fpsub)
	{
		fread((char *)&row,sizeof(int),1,fpsub);
		fread((char *)&col,sizeof(int),1,fpsub);
		for(i=0;i<row;i++)
		{
			fread((char *)Mbuff[0],sizeof(char),col,fpsub);
			plotrow(0,0,col-1,i,Mbuff[0]);
		}
		fclose(fpsub);
	}
	else
	{
		rewind(fp);
		offset=Hdr[filenum].header_bytes;
		if(offset>0)
			fseek(fp,offset,SEEK_SET);
		offset=(sample-1);
		offset*=Hdr[filenum].col;
		for(i=0;i<Row;i++)
		{
			fread((char *)Mbuff[0],sizeof(char),Hdr[filenum].col,fp);
			if(offset>0)
				fseek(fp,offset,SEEK_CUR);
			if(sample>1)
				for(j=0;j<Col;j++)
					Mbuff[0][j]=Mbuff[0][j*sample];
			if(VideoType=='V'||VideoType=='E')
			{
				if(ActiveLut=='P')
				{
					for(j=0;j<Col;j++)
						Mbuff[0][j]=Hdr[filenum].vga_color[Mbuff[0][j]];
				}
				else
				{
					for(j=0;j<Col;j++)
						Mbuff[0][j]/=16;
				}
			}
			plotrow(3,0,Col-1,i,Mbuff[0]);
		}
		if(sample>1)
		{
			fpsub=open_to_write_binary(string);
			if(fpsub)
			{
				fwrite((char *)&Row,sizeof(int),1,fpsub);
				fwrite((char *)&Col,sizeof(int),1,fpsub);
				for(i=0;i<Row;i++)
				{
					getrow(0,0,Col-1,i,Mbuff[0]);
					fwrite((char *)Mbuff[0],sizeof(char),Col,fpsub);
				}
				fclose(fpsub);
			}
		}
	}
}



/**************************************************************************
**
**
**
************************************************************************* */

int limit_area_fixed(xc,yc,xs,ys,speed,sample)

int *xc,*yc,*xs,*ys,*speed,*sample;

{
	int i,j,k;
	int xco=*xc,yco=*yc,xso,yso;
	char ans;

	if(*sample>0)
	{
		xso=*xs=ScreenXs/Sample*(*sample);
		yso=*ys=ScreenYs/Sample*(*sample);
	}
	else
	{
		xso=*xs=ScreenXs/Sample/(*sample*-1+2);
		yso=*ys=ScreenYs/Sample/(*sample*-1+2);
	}
	if(*sample>0)
		tbox_val(3,*xc,*yc,*xs,*ys,Mbuff,Black,White,Center);
	else
		tbox_val(3,*xc,*yc,*xs,*ys,Mbuff,RED,RED,Center);
	do
	{
		ans=getch();
		unbox(3,*xc,*yc,*xs,*ys,Mbuff);
		if(ans==27)
		{
			return(27);
		}
		else if(ans=='-'&&*speed>1)*speed/=2;
		else if(ans=='+'&&*speed<ScreenYs)*speed*=2;
		else if(ans=='l'&&*sample<Sample)
			*sample+=1;
		else if(ans=='s')
			*sample-=1;
		if(*sample>0)
		{
			*xs=ScreenXs/Sample*(*sample);
			*ys=ScreenYs/Sample*(*sample);
		}
		else
		{
			*xs=ScreenXs/Sample/(*sample*-1+2);
			*ys=ScreenYs/Sample/(*sample*-1+2);
		}
		if(ans==0)
		{
			ans=getch();
			if(ans==71)
			{
				*xc-=*speed;
				*yc-=*speed;
			}
			else if(ans==73)
			{
				*xc+=*speed;
				*yc-=*speed;
			}
			else if(ans==79)
			{
				*xc-=*speed;
				*yc+=*speed;
			}
			else if(ans==81)
			{
				*xc+=*speed;
				*yc+=*speed;
			}
			else if(ans==72)
				*yc-=*speed;
			else if(ans==80)
				*yc+=*speed;
			else if(ans==75)
				*xc-=*speed;
			else if(ans==77)
				*xc+=*speed;
		}
		if(*xs>ScreenXs)*xs=ScreenXs;
		if(*ys>ScreenYs)*ys=ScreenYs;
		if(*xs<2)*xs=2;
		if(*ys<2)*ys=2;
		if((*xc+*xs)>=ScreenXs)*xc=ScreenXs-*xs;
		if((*yc+*ys)>=ScreenYs)*yc=ScreenYs-*ys;
		if(*xc<0)*xc=0;
		if(*yc<0)*yc=0;
		if(*sample>0)
			tbox_val(3,*xc,*yc,*xs,*ys,Mbuff,Black,White,Center);
		else
			tbox_val(3,*xc,*yc,*xs,*ys,Mbuff,RED,RED,Center);
	}while(ans!=83&&ans!='x'&&ans!=27&&ans!=13);
	unbox(3,*xc,*yc,*xs,*ys,Mbuff);
	return(ans);
}


/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_write_text(char *name)

{
	int i,j,k;
	FILE *fp;
	char string[STR_LEN];

	for(j=0;j<NumPath;j++)
	{
		sprintf(string,"%s%s",Path[j],name);
		fp=fopen(string,"wt");
		if(fp)
		{
			strcpy(LastFile,name);
			return(fp);
		}
	}
	clearerr(fp);
	fp=NULL;
	return(fp);
}

/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_write_binary(char *name)

{
	int i,j,k;
	FILE *fp;
	char string[STR_LEN];

	for(j=0;j<NumPath;j++)
	{
		sprintf(string,"%s%s",Path[j],name);
		fp=fopen(string,"wb");
		if(fp)
		{
			strcpy(LastFile,name);
			return(fp);
		}
	}
	clearerr(fp);
	fp=NULL;
	return(fp);
}


/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_read_binary(char *name)

{
	int i,j,k;
	FILE *fp;
	char string[STR_LEN];
	int len;

	string[0]='\0';
	for(j=0;j<NumPath;j++)
	{
		len=strlen(Path[j])+strlen(name);
		if(len>0&&len<STR_LEN);
		{
			sprintf(string,"%s%s",Path[j],name);
			fp=fopen(string,"rb");
			if(fp)
			{
				strcpy(LastFile,name);
				return(fp);
			}	
		}
	}
	clearerr(fp);
	fp=NULL;
	return(fp);
}
/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_read_text(char *name)

{
	int i,j,k;
	FILE *fp;
	char string[STR_LEN];
	int len;

	string[0]='\0';
	for(j=0;j<NumPath;j++)
	{
		len=strlen(Path[j])+strlen(name);
		if(len>0&&len<STR_LEN);
		{
			sprintf(string,"%s%s",Path[j],name);
			fp=fopen(string,"rt");
			if(fp)
			{
				strcpy(LastFile,name);
				return(fp);
			}	
		}
	}
	clearerr(fp);
	fp=NULL;
	return(fp);
}

/**************************************************************************
**
**
**
************************************************************************* */

int add_disk_path(char *string)

{
	int i,j,k;
	char dsk,pth[STR_LEN],nam[10],typ[10],str[STR_LEN];
	int match,add=0;

	dsk=fsplit(string,pth,nam,typ);
	if(dsk>0)
		sprintf(str,"%c:%s",dsk,pth);
	else
		sprintf(str,"%s",pth);
	if((dsk>0||strlen(pth)>0)&&NumPath<NUM_DP)
	{
		match=0;
		for(i=0;i<NumPath;i++)
		{
			if(strcmpi(Path[i],str)==0)
				match=1;
		}
		if(match==0)
		{
			strcpy(Path[NumPath],str);
			NumPath+=1;
			add+=1;
		}
	}
	return(add);
}
/**************************************************************************
**
**
**
************************************************************************* */

char fsplit(instring,path,name,type)

char *instring,*path,*name,*type;

{
	int i,j,k;
	int dot=-1,last_slash=-1,len=strlen(instring),first_slash=-1;
	int num=0,colon=-1;
	int disk=0;
	char string[STR_LEN];

	strcpy(string,instring);
	path[0]='\0';
	name[0]='\0';
	type[0]='\0';

	for(i=0;i<len;i++)
	{
		if(string[i]==':')
			colon=i;
		else if(string[i]=='\\')
		{
			last_slash=i;
			if(first_slash<0)
				first_slash=i;
		}	
		else if(string[i]=='.')
			dot=i;
	}
	if(dot<0&&first_slash>=0&&last_slash<len-1)  /* d:test */
	{
		string[len]='\\';
		last_slash=len;
		len+=1;
		string[len]='\0';
	}
	if(dot<0&&first_slash<0&&len>colon-1)
	{
		string[len]='.';
		dot=len;
		len+=1;
		string[len]='\0';
	}
	if(colon>0)
		disk=string[0];
	if(first_slash>=0)
	{
		for(i=first_slash;i<=last_slash;i++)
			path[i-first_slash]=string[i];
		path[last_slash-first_slash+1]='\0';
	}
	if(last_slash>0&&last_slash<len-1&&dot>0)
	{
		for(i=last_slash+1;i<dot;i++)
			name[i-last_slash-1]=string[i];
		name[dot-last_slash-1]='\0';
	}
	if(colon>0&&last_slash<0&&dot>0)	/* d:test.img */
	{
		for(i=colon+1;i<dot;i++)
			name[i-colon-1]=string[i];
		name[dot-colon]='\0';
	}
	if(colon<0&&last_slash<0&&dot>0)	/* test.img */
	{
		for(i=0;i<dot;i++)
			name[i]=string[i];
		name[dot]='\0';
	}
	if(dot>0&&dot<len-1)
	{
		for(i=dot+1;i<len;i++)
			type[i-dot-1]=string[i];
		type[len-dot-1]='\0';
		if(strlen(type)>3)
			type[3]='\0';
	}
	return(disk);
}

/**************************************************************************
**
**
**
************************************************************************* */

int video_on(void)

{
	int i,row;

	i=GetVideoBoardID();
	if(i==0)
		VideoType='E';
	else if(i==1&&(VideoType=='X'||VideoType=='Y'))
		VideoType='V';
	if(VideoType=='X')
	{
		row=SetVideoMode(480,&B_Id);
		if(B_Id.color==256&&B_Id.row==480)
		{
			ScreenXs=640;
			ScreenYs=480;
			strcpy(Suffix,".xmp");
		}
		else if(B_Id.color==256&&B_Id.row==400)
			VideoType='Y';
		else
			VideoType='V';
	}
	if(VideoType=='Y')
	{
		row=SetVideoMode(400,&B_Id);
		if(B_Id.row<400)
			VideoType='V';
		else
		{
			ScreenXs=640;
			ScreenYs=row;
		}
		strcpy(Suffix,".ymp");
	}
	if(VideoType=='V')
	{
		row=SetVideoMode(0x12,&B_Id);
		if(B_Id.row!=480||row!=480||B_Id.color!=16||B_Id.col!=640)
			VideoType='E';
		else
		{
			ScreenXs=640;
			ScreenYs=480;
			Num_Color=16;
			strcpy(Suffix,".vmp");
		}
	}
	if(VideoType=='S')
	{
		row=SetVideoMode(0x13,&B_Id);
		if(B_Id.row!=200)
		{
			SetVideoMode(0,&B_Id);
			printf("Could not boot color board.\n");
			exit(0);
		}
		ScreenXs=320;
		ScreenYs=200;
		Num_Color=256;
		strcpy(Suffix,".smp");
		FontSize=3;
	}
	if(VideoType=='E')
	{
		row=SetVideoMode(0x10,&B_Id);
		if(B_Id.row!=350||row<350||B_Id.col!=640)
		{
			SetVideoMode(0,&B_Id);
			printf("Could not boot color board.\n");
			exit(0);
		}
		ScreenXs=640;
		ScreenYs=350;
		Num_Color=16;
		strcpy(Suffix,".emp");
	}
	if(B_Id.row<0)
	{
		SetVideoMode(0,&B_Id);
		printf("Could not boot board -- row = %d\n\n",row);
		exit(0);
	}
	strcpy(SubType,Suffix);
	SubType[3]='g';
}

/********************************************************************
**
**	WARNING!!!!  YOU MUST CALL decode_font() or set_files() before using
**
**     options:
**
**       -1 -- remove menu but get no answer
**        0 -- return answer and set menu colors to greys
**        1 -- return answer but leave colors alone
**
********************************************************************* */

int M_do_menu(char *menu[],int num,int xc,int yc,int start,
		int back,int words,int boxs,int font[128][25])

{
	int i,j,k;
	char ans=-1,ans2;
	int len=0,l,size=FontSize,val,kval,valo=-1,kbh=0;
	int black=0,dgrey=back,lgrey=words,white=boxs;
	int wide;
	long lxs,lys,buffersize=(long)B_LINES*(long)MAX_X;
	int io=-1,times,jo=-1;
	int row,col,right,left;
	int rowo=-1,colo=-1;
	int top=yc,bot=yc+num*(30/size)-1;

	for(k=0;k<num;k++)
		if((l=strlen(menu[k]))>len)len=l;
	if(len==0)return(-1);
	do
	{
		wide=(len+1)*15/size+1;
		if((ScreenXs-1-wide)<xc)xc=ScreenXs-1-wide;
		lxs=(len+1)*15/size+1;
		lys=30/size*num+1;
		if(lxs*lys>buffersize)
			size+=1;
		if(size>4)
		{
			SetVideoMode(0);			
			printf("Could not fit menu into buffer for 'save_box()'\n");
			exit(0);
		}
	}while(lxs*lys>buffersize);
	if((xc+(len+1)*15/size+1)<ScreenXs)
	{
		if(Mouse>0)
		{
			MouseMove=1;
			mouse_vertical_range(yc,yc+num*(30/size)-1);
			mouse_horizontal_range(xc,xc+(len+1)*15/size);
		}
		save_box(0,dgrey,Mbuff,
			xc,yc,(len+1)*15/size+1,30/size*num+1);
		for(k=0;k<num;k++)
		{	
			box(0,xc,yc+k*(30/size),dgrey,(len+1)*15/size,30/size);
			plot_font_h(lgrey,
					xc+15/size,yc+k*30/size+5/size,menu[k],size,font);
		}
		box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);

		val=valo=start;
		box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
		if(Mouse==0)
		{
			do
			{
				if((ans=getch())==0)
				{
					ans2=getch();
					if(ans2==50)
					{
						unsave_box(0,dgrey,Mbuff,
							xc,yc,(len+1)*15/size+1,30/size*num+1);
						getch();
						paint_box(0,dgrey,MT_Buff,
							xc,yc,(len+1)*15/size+1,30/size*num+1);
						for(k=0;k<num;k++)
						{	
							plot_font_h(lgrey,xc+15/size,
								yc+k*30/size+5/size,menu[k],size,font);
						}
					}
					if(ans2=='H')
					{
						if(val>0)val-=1;
						else val=num-1;
					}
					if(ans2=='P')
					{
						if(val<num-1)val+=1;
						else val=0;
					}
				}
				for(i=0;i<num;i++)
					if(ans==menu[i][0])
					{
						val=i;
						ans=13;
					}
				box(0,xc,yc+valo*(30/size),dgrey,(len+1)*15/size,30/size);
				valo=val;
				box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);
				box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
				if(ans==27)
				{
					val=num-1;
					ans=13;
				}
			}while(ans!=13);
		}
		else
		{
			mouse_times_released(LEFT_BUTTON,&times,&row,&col);
			mouse_times_released(RIGHT_BUTTON,&times,&row,&col);
			kbh=0;
			if((kval=mouse_information(&right,&left,&row,&col))!=0)
			{
				kbh=1;
				if(kval>255)
				{
					kval/=256;
					if(kval==72)
						row-=30/size;
					if(kval==80)
						row+=30/size;
					if(row<top)row=top;
					if(row>bot)row=bot;
					mouse_move_cursor(row,col);
				}
			}
			colo=col;
			rowo=row;	
			do
			{
				kbh=0;
				if((kval=mouse_information(&right,&left,&row,&col))!=0)
				{
					kbh=1;
					if(kval>255)
					{
						kval/=256;
						if(kval==72)
							row-=30/size;	
						if(kval==80)
							row+=30/size;
						if(row<top)row=top;
						if(row>bot)row=bot;
						mouse_move_cursor(row,col);
					}
				}
				if(row!=rowo||col!=colo)
				{
					colo=col;
					rowo=row;
				}
				val=row-yc;
				val/=30/size;
				if(val!=valo)
				{
					box(0,xc,yc+valo*(30/size),dgrey,(len+1)*15/size,30/size);
					valo=val;
					box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);
					box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
				}
				if(left>0)
				{
					if(kbh==0)
						do
						{
							mouse_times_released(LEFT_BUTTON,&times,&row,&col);
						}while(times==0);
						ans=13;
				}
				if(right>0)
				{
					val=num-1;
					ans=13;
					if(kbh==0)
						do
						{
							mouse_times_released(RIGHT_BUTTON,&times,&row,&col);
						}while(times==0);
				}
			}while(ans!=13);
			MouseMove=4;
			mouse_vertical_range(0,ScreenYs-1);
			mouse_horizontal_range(0,ScreenXs-1);
		}
	}
	box(0,xc,yc,dgrey,(len+1)*15/size,30/size*num);
	box(0,xc,yc+val*(30/size),lgrey,(len+1)*15/size,30/size);
	unsave_box(0,dgrey,Mbuff,
			xc,yc,(len+1)*15/size+1,30/size*num+1);
	return(val);
}




                                                                                                                            
