#define MAXCMDLEN 9
#define MAXLEN 42
#define MAXLEN1 63
#define MAXITEM 18
#define MAXMENU 26
#define TRUE  1
#define FALSE 0

/* Sample key codes for getkey. Additional codes in the same format may
 * be added.
 */
#define U_UP    0x0148      /* Unshifted */
#define U_DN    0x0150
#define U_LT    0x014b
#define U_RT    0x014d
#define S_UP    0x0248      /* Shifted */
#define S_DN    0x0250
#define S_LT    0x024b
#define S_RT    0x024d

#define N_PLUS  0x014e      /* PLUS and MINUS on numeric keypad */
#define N_MINUS 0x014a

#define ENTER   13          /* ASCII */

/* Action codes for getkey */
enum WAITACTION { NO_WAIT, WAIT, CLEAR_WAIT };

/* Text output colors. Note that monochrome can only use _TBLACK,
 * _TWHITE, _TBRIGHTWHITE, and _TUNDERLINE. Graphics black-and-white
 * can only use the first three of these. The first eight colors
 * can be used as background colors (although they may need to be
 * cast to long).
 */
enum TEXTCOLORS
{
    _TBLACK,        _TBLUE,         _TGREEN,        _TCYAN,
    _TRED,          _TMAGENTA,      _TBROWN,        _TWHITE,
    _TGREY,         _TLIGHTBLUE,    _TLIGHTGREEN,   _TLIGHTCYAN,
    _TLIGHTRED,     _TLIGHTMAGENTA, _TLIGHTYELLOW,  _TBRIGHTWHITE,
    _TUNDERLINE = 1
};

/* Structure and global variable for menu attributes */

struct PASSED
{
    int     num;
    int     pause;
    char    cmdline[MAXCMDLEN+MAXLEN1];
    int     indx[MAXMENU];
};

struct GSMENU
{
    char    banner1[MAXLEN], banner2[MAXLEN];
    struct MNU
    {
        char    title[MAXLEN];
        struct ITEM
        {
            int     iHilite;
            char    achItem[MAXLEN];
        } item[MAXITEM];
        struct ACTION
        {
            short   ret;
            short   menucall;
            short   systemcall;
            short   prompt;
            short   pause;
            char    command[MAXCMDLEN];
            char    example[MAXLEN1];
        } action[MAXITEM];
    } menu[MAXMENU];
};
struct MENUCOLOR
{
    int     fgBorder, fgNormal, fgSelect, fgNormHilite, fgSelHilite;
    long    bgBorder, bgNormal, bgSelect, bgNormHilite, bgSelHilite, bgScreen;
    int     fCentered;
    unsigned char   chNW, chNE, chSE, chSW, chNS, chEW;
};
extern struct MENUCOLOR mnuAtrib;


