/*
    lbl2ppm.c

    cl /AL /F 1000 lbl2ppm.c getfile3

    converts a '.lbl' ,'.pal', and '.dat' file' to a '.ppm' file.

*/
#include <stdio.h>
#include <string.h>
#include "nomouse.h"

#define MAX_COL 32768

int Mouse=0;
int PAL=0;

struct ppmhdr
{
    char magic_num[3];               /* always P6 */
    int pixels_per_line;
    int lines;
    int max_color;
} ph = {"P6",0,0,255};
unsigned char Pal[256][3]=
{
    {  0,   0,   0},
    {  1,   1,   1},
    {  2,   2,   2},
    {  3,   3,   3},
    {  4,   4,   4},
    {  5,   5,   5},
    {  6,   6,   6},
    {  7,   7,   7},
    {  8,   8,   8},
    {  9,   9,   9},
    { 10,  10,  10},
    { 11,  11,  11},
    { 12,  12,  12},
    { 13,  13,  13},
    { 14,  14,  14},
    { 15,  15,  15},
    { 16,  16,  16},
    { 17,  17,  17},
    { 18,  18,  18},
    { 19,  19,  19},
    { 20,  20,  20},
    { 21,  21,  21},
    { 22,  22,  22},
    { 23,  23,  23},
    { 24,  24,  24},
    { 25,  25,  25},
    { 26,  26,  26},
    { 27,  27,  27},
    { 28,  28,  28},
    { 29,  29,  29},
    { 30,  30,  30},
    { 31,  31,  31},
    { 32,  32,  32},
    { 33,  33,  33},
    { 34,  34,  34},
    { 35,  35,  35},
    { 36,  36,  36},
    { 37,  37,  37},
    { 38,  38,  38},
    { 39,  39,  39},
    { 40,  40,  40},
    { 41,  41,  41},
    { 42,  42,  42},
    { 43,  43,  43},
    { 44,  44,  44},
    { 45,  45,  45},
    { 46,  46,  46},
    { 47,  47,  47},
    { 48,  48,  48},
    { 49,  49,  49},
    { 50,  50,  50},
    { 51,  51,  51},
    { 52,  52,  52},
    { 53,  53,  53},
    { 54,  54,  54},
    { 55,  55,  55},
    { 56,  56,  56},
    { 57,  57,  57},
    { 58,  58,  58},
    { 59,  59,  59},
    { 60,  60,  60},
    { 61,  61,  61},
    { 62,  62,  62},
    { 63,  63,  63},
    { 64,  64,  64},
    { 65,  65,  65},
    { 66,  66,  66},
    { 67,  67,  67},
    { 68,  68,  68},
    { 69,  69,  69},
    { 70,  70,  70},
    { 71,  71,  71},
    { 72,  72,  72},
    { 73,  73,  73},
    { 74,  74,  74},
    { 75,  75,  75},
    { 76,  76,  76},
    { 77,  77,  77},
    { 78,  78,  78},
    { 79,  79,  79},
    { 80,  80,  80},
    { 81,  81,  81},
    { 82,  82,  82},
    { 83,  83,  83},
    { 84,  84,  84},
    { 85,  85,  85},
    { 86,  86,  86},
    { 87,  87,  87},
    { 88,  88,  88},
    { 89,  89,  89},
    { 90,  90,  90},
    { 91,  91,  91},
    { 92,  92,  92},
    { 93,  93,  93},
    { 94,  94,  94},
    { 95,  95,  95},
    { 96,  96,  96},
    { 97,  97,  97},
    { 98,  98,  98},
    { 99,  99,  99},
    {100, 100, 100},
    {101, 101, 101},
    {102, 102, 102},
    {103, 103, 103},
    {104, 104, 104},
    {105, 105, 105},
    {106, 106, 106},
    {107, 107, 107},
    {108, 108, 108},
    {109, 109, 109},
    {110, 110, 110},
    {111, 111, 111},
    {112, 112, 112},
    {113, 113, 113},
    {114, 114, 114},
    {115, 115, 115},
    {116, 116, 116},
    {117, 117, 117},
    {118, 118, 118},
    {119, 119, 119},
    {120, 120, 120},
    {121, 121, 121},
    {122, 122, 122},
    {123, 123, 123},
    {124, 124, 124},
    {125, 125, 125},
    {126, 126, 126},
    {127, 127, 127},
    {128, 128, 128},
    {129, 129, 129},
    {130, 130, 130},
    {131, 131, 131},
    {132, 132, 132},
    {133, 133, 133},
    {134, 134, 134},
    {135, 135, 135},
    {136, 136, 136},
    {137, 137, 137},
    {138, 138, 138},
    {139, 139, 139},
    {140, 140, 140},
    {141, 141, 141},
    {142, 142, 142},
    {143, 143, 143},
    {144, 144, 144},
    {145, 145, 145},
    {146, 146, 146},
    {147, 147, 147},
    {148, 148, 148},
    {149, 149, 149},
    {150, 150, 150},
    {151, 151, 151},
    {152, 152, 152},
    {153, 153, 153},
    {154, 154, 154},
    {155, 155, 155},
    {156, 156, 156},
    {157, 157, 157},
    {158, 158, 158},
    {159, 159, 159},
    {160, 160, 160},
    {161, 161, 161},
    {162, 162, 162},
    {163, 163, 163},
    {164, 164, 164},
    {165, 165, 165},
    {166, 166, 166},
    {167, 167, 167},
    {168, 168, 168},
    {169, 169, 169},
    {170, 170, 170},
    {171, 171, 171},
    {172, 172, 172},
    {173, 173, 173},
    {174, 174, 174},
    {175, 175, 175},
    {176, 176, 176},
    {177, 177, 177},
    {178, 178, 178},
    {179, 179, 179},
    {180, 180, 180},
    {181, 181, 181},
    {182, 182, 182},
    {183, 183, 183},
    {184, 184, 184},
    {185, 185, 185},
    {186, 186, 186},
    {187, 187, 187},
    {188, 188, 188},
    {189, 189, 189},
    {190, 190, 190},
    {191, 191, 191},
    {192, 192, 192},
    {193, 193, 193},
    {194, 194, 194},
    {195, 195, 195},
    {196, 196, 196},
    {197, 197, 197},
    {198, 198, 198},
    {199, 199, 199},
    {200, 200, 200},
    {201, 201, 201},
    {202, 202, 202},
    {203, 203, 203},
    {204, 204, 204},
    {205, 205, 205},
    {206, 206, 206},
    {207, 207, 207},
    {208, 208, 208},
    {209, 209, 209},
    {210, 210, 210},
    {211, 211, 211},
    {212, 212, 212},
    {213, 213, 213},
    {214, 214, 214},
    {215, 215, 215},
    {216, 216, 216},
    {217, 217, 217},
    {218, 218, 218},
    {219, 219, 219},
    {220, 220, 220},
    {221, 221, 221},
    {222, 222, 222},
    {223, 223, 223},
    {224, 224, 224},
    {225, 225, 225},
    {226, 226, 226},
    {227, 227, 227},
    {228, 228, 228},
    {229, 229, 229},
    {230, 230, 230},
    {231, 231, 231},
    {232, 232, 232},
    {233, 233, 233},
    {234, 234, 234},
    {235, 235, 235},
    {236, 236, 236},
    {237, 237, 237},
    {238, 238, 238},
    {239, 239, 239},
    {240, 240, 240},
    {241, 241, 241},
    {242, 242, 242},
    {243, 243, 243},
    {244, 244, 244},
    {245, 245, 245},
    {246, 246, 246},
    {247, 247, 247},
    {248, 248, 248},
    {249, 249, 249},
    {250, 250, 250},
    {251, 251, 251},
    {252, 252, 252},
    {253, 253, 253},
    {254, 254, 254},
    {255, 255, 255}
};
unsigned char Buffer[MAX_COL];
unsigned char Vga[16][3]=
{
	{   0,  0,  0},
	{  46, 46, 46},
	{ 128,128,128},
	{ 255,255,255},
	{ 105, 90, 75},
	{ 130,111, 93},
	{  96, 28, 14},
	{ 255,  0,  0},
	{ 255,128,  0},
	{ 160,160,  0},
	{   0,200,  0},
	{   0,120,  0},
	{   0, 72,  0},
	{   0,  0,200},
	{   0, 20, 60},
	{ 255,  0,255}
};

main()
{
    int i,j,k,r,g,b,ret;
    char lblname[100],string[100],palname[100],datname[100];
    FILE *fp,*fpppm;
    unsigned char pheader[128],pal[3];
/*    struct ppmhdr ph;*/

    ClearScreen(3);
    SetCursor(0,0);
    printf("LBL2PPM - convert a PDS image\n");
    printf("          to a PPM image.\n\n");
    printf("Select file using up/down arrow\n");
    printf("  keys and <Enter> key, or type\n");
    printf("  first few characters of name \n");
    printf("  and hit <Enter> key twice.\n\n");
    printf("Hit <Esc> key to exit.\n");

    if((ret=get_file_name("*.lbl",lblname,0))>=0)
	{
        printf("lbl file = '%s'\n",lblname);
        fp=fopen(lblname,"rt");
        if(!fp)
		{
            printf("Could not open '%s'\n",lblname);
			exit(0);
        }
        for(k=0;k<strlen(lblname);k++)
            if(lblname[k]=='.')
                lblname[k]='\0';

        read_lbl(fp,palname,datname);
        fp=fopen(palname,"rt");
        if(!fp)
        {
            printf("Could not open '%s'\n",palname);
            exit(0);
        }
        PAL=1;
        for(i=0;i<256;i++)
        {
            fscanf(fp,"%d%d%d%d",&k,&r,&g,&b);
            pal[0]=r;
            pal[1]=g;
            pal[2]=b;
            for(k=0;k<3;k++) Pal[i][k]=pal[k];
        }
        fclose(fp);
    }
        fp=fopen(datname,"rb");
        if(!fp)
        {
            printf("Could not open '%s'\n",datname);
            exit(0);
        }
    ConvertDatPpm(lblname,fpppm,fp);
        printf("Hit any key to continue\n\n");
        getch();
    ClearScreen(7);
    SetCursor(0,0);
    if(ret == -2) printf("No .LBL files found\n");
}
/**********************************************************************
**
**
**
**********************************************************************/
int ConvertDatPpm(char *name,FILE *fpppm, FILE *fpdat)
{
    int i,j,k,color;
    char string[100];
    unsigned char dat[3];
    long offset,lrow=ph.lines,lcol=ph.pixels_per_line;
    char cr=0xd;

    sprintf(string,"%s.ppm",name);
    fpppm=fopen(string,"wb");
    if(!fpppm)
    {
        printf("Could not open '%s' to write\n\n",string);
        exit(0);
    }
    if(lcol>MAX_COL)
    {
        printf("Image too wide\n\n");
        exit(0);
    }
    WritePpmHeader(name,fpppm);
    printf("      of %d",ph.lines);
    for(i=0;i<lrow;i++)
    {
        printf("%c%5d",cr,i+1);
        fread((char *)Buffer,sizeof(char),lcol,fpdat);
        for(j=0;j<lcol;j++)
        {
            color=Buffer[j];
            fputc(Pal[color][0],fpppm);
            fputc(Pal[color][1],fpppm);
            fputc(Pal[color][2],fpppm);
        }
    }
}
int WritePpmHeader(char *name,FILE *fpppm)
{
/*    ph.magic_num="P6";
    ph.max_color=255;*/
    fprintf(fpppm,"%s\n",ph.magic_num);
    fprintf(fpppm,"%d %d\n",ph.pixels_per_line,ph.lines);
    fprintf(fpppm,"%d\n",ph.max_color);
}
/**********************************************************************
**
**
**
**********************************************************************/

int read_lbl(FILE *fp, char *palname, char *datname)

{
	int i,j,k;
    int status=1,numread;
    char string1[100],string2[100],string3[100];

/*    ph.pixels_per_line=0;
    ph.lines=0;*/
    while(fscanf(fp,"%s",string1)==1)
    {
        if(strcmpi(string1,"end")==0)
        {
            printf("END\n");
            if(fp) close(fp);
            return(status);
        }
        if(strcmpi(string1,"image_lines")==0&&ph.lines==0)
        {
            numread=fscanf(fp,"%s%s",string2,string3);
            if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
                numread<2)
            {
                if(fp) close(fp);
                return(status);
            }
            sscanf(string3,"%d",&ph.lines);
            printf("IMAGE_LINES = %5d\n",ph.lines);
        }
        if(strcmpi(string1,"line_samples")==0&&ph.pixels_per_line==0)
        {
            numread=fscanf(fp,"%s%s",string2,string3);
            if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
                numread<2)
            {
                if(fp) close(fp);
                return(status);
            }
            sscanf(string3,"%d",&ph.pixels_per_line);
            printf("LINE_SAMPLES = %5d\n",ph.pixels_per_line);
        }
        if(strcmpi(string1,"image_pointer")==0)
        {
            numread=fscanf(fp,"%s%s",string2,string3);
            if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
                numread<2)
            {
                if(fp) close(fp);
                return(status);
            }
            k=0;
            for(i=0;i<strlen(string3);i++)
                if(string3[i]!=39)          /* single quote */
                    datname[k++]=string3[i];
            datname[k]='\0';
            printf("IMAGE_POINTER = '%s'\n",datname);
        }
        if(strcmpi(string1,"pal_pointer")==0||
            strcmpi(string1,"palette_pointer")==0)
        {
            numread=fscanf(fp,"%s%s",string2,string3);
            if(strcmpi(string2,"end")==0||strcmpi(string3,"end")==0||
                numread<2)
            {
                if(fp) close(fp);
                return(status);
            }
            k=0;
            for(i=0;i<strlen(string3);i++)
                if(string3[i]!=39)          /* single quote */
                    palname[k++]=string3[i];
            palname[k]='\0';
            printf("PAL_POINTER = '%s'\n",palname);
        }
    }
}

