#include <stdio.h>
#include <string.h>
#include "nomouse.h"
void set_lut(char c){};

#define NUM_DP 100
#define STR_LEN 100
#define S_SIZE 40

struct board
{
	int row,col,color;
};
struct   Color
{
	unsigned char  r, g, b;
};
extern struct board B_Id;
extern char *SubType;
extern int A_Int;
extern int A_Reverse,A_Black;
extern int A_Brite,A_Norm;
extern int A_Flash;
extern int LastN;

extern int NumPath;
extern char Path[NUM_DP][STR_LEN];

int GF_Menu;  /* 0x70 black on white */
int GF_Title;  /* 0x4 white on red */
int GF_Box;  /* 0x70 black on white */
int GF_Bar;  /* 0x13 cyan on blue */
int GF_Text;  /* 0xc b_red on black */
int GF_Help;  /* 0x70 black on white */
extern int Monitor;
struct equipment
{
	int printers; 		/* number present */
	int sprinter;		/* serial printer installed?  0=no  1=yes */
	int game;			/* game adapter installed? */
	int sports;			/* number of serial ports */
	int dma;				/* DMA chip installed? */
	int drives;			/* number of disk drives */
	int video;			/* video mode 1=40 color 2=80 color 3=80 B/W */
	int disk;			/* any disk drives? */
	int memory;			/* memory size in Kbytes */
};
extern struct equipment Eq;
int Menu=0;
int old_mode;
double X0,Y0,PixelSize; /* Projections */
extern char GF_String[][S_SIZE];
char MString[300][25];
Mouse=0;

FILE *open_to_read_text(char *);

main(argc,argv)

int argc;
char *argv[];

{
	int i,j,k;
	int wildcard=0,num=0,len,slen,val;
	char pathbuffer[101],string[100],message[100],filename[100],mstring[100];
	FILE *fp,*fpmenu;

	NumPath=1;
	for(i=0;i<argc;i++)
	{
		if(argv[i][1]==':')
			add_disk_path(argv[i]);
		if(argv[i][0]=='\\')
			add_disk_path(argv[i]);
		if(argv[i][0]=='/'&&argv[i][1]=='m')
		{
			strcpy(mstring,argv[i+1]);
			fpmenu=open_to_read_text(mstring);
			if(!fpmenu)
			{
				printf("Could not open menu file '%s' to read.\n",mstring);
				exit(0);
			}
			fgets(mstring,100,fpmenu);
			while(fgets(string,100,fpmenu))
			{
				for(i=0;i<strlen(string);i++)
					if(string[i]==0xa||string[i]==0xd)
						string[i]='\0';
				sscanf(string,"%s",MString[Menu++]);
				len=strlen(MString[Menu-1]);
				slen=strlen(string);
				strcpy(GF_String[Menu-1],string+len+1);
			}
			if(Menu<1)
			{
				printf("No menu entries\n\n");
				exit(0);
			}
		}
	}
    old_mode=fg_getmode();
	video_on();
    SetVideoMode(0);

/* use SubPaths with type of SubType for sub images */
									/* move all Path up 1 */
	for(i=NumPath;i>0;i--)
		strcpy(Path[i],Path[i-1]);
	NumPath+=1;
									/* add '?mg\' to a new set of Paths */
	for(i=2;i<NumPath;i++)
		sprintf(Path[NumPath+i-2],"%s%s\\",Path[i],SubType+1);
	NumPath+=NumPath-2;

	getcwd(pathbuffer,100);
	sprintf(Path[0],"%s\\%s\\",pathbuffer,SubType+1);

	if(Menu>0)
	{
		WriteStringAtxy(40,0,39,(char)112,mstring);
		while((val=scroll_list(40,1,40,21,GF_String,Menu,string))>=0)
		{
			LastN=val;
			fp=fopen(MString[val],"rb");
			if(fp)
			{
				fclose(fp);
                if(text_view(MString[val],(long)6000)<0)
					printf("Could not open '%s'\n\n",MString[val]);
			WriteStringAtxy(40,0,39,(char)112,mstring);
		}
		else
			printf("Could not open '%s'\n\n",MString[val]);
		}
		exit(0);
	}
	else
	{
		if(argc>1)
			strcpy(string,argv[1]);
		else
			strcpy(string,"*.txt");
		for(i=0;i<strlen(string);i++)
			if(string[i]=='*'||string[i]=='?')
			{
				wildcard=1;
				break;
			}
		if(wildcard>0)
		{
			Monitor=check_equip(&Eq);
			if(Monitor==2)
			A_Brite=0x1b;
			GF_Text=0x74;
			GF_Box=0x13;
			GF_Bar=0x1b;
			GF_Help=0x74;
			ClearScreen(GF_Menu);
			print_help();
			while((num=get_file_name(string,filename,num))>=0)
			{
				LastN=num;
				sprintf(message,"file:  %s",filename);
				text_view(filename,(long)6000);	
				ClearScreen(GF_Menu);
				print_help();
			}
			ClearScreen(A_Black);
		}
		else
		{
			fp=fopen(string,"rb");
			if(fp)
			{
				fclose(fp);
				sprintf(message,"file:  %s",string);
                if(text_view(string,(long)6000)<0)
					printf("Could not open '%s'\n\n",string);
			}
			else
				printf("Could not open '%s'\n\n",string);
		}
	}
}
/***********************************************************************
**
**
**
**
************************************************************************/

int print_help()

{
	int i=0;

	SetCursor(0,0);
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"     Select a file from the window");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"to view by positioning the bar over");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"it then hitting 'Enter'.  Files are");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"in alphabetical order and there may");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"be more files than you can see in");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"the window.");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"  Up Arrow -- moves bar up one file");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"Down Arrow -- moves bar down one");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"     Pg Up -- moves bar to top or");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"              scrolls up one screen");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"     Pg Dn -- moves bar to bottom  ");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"              or scrolls down one");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"              screen");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		" type text -- searches for text");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"     Enter -- exits text mode or");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"              chooses file");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"       Esc -- exits program");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"     Once you select a file you will");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"be able to view it.  To get instruc-");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"tions for viewing the file hit F3,");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"'h' or 'H' while the viewing program");
	WriteStringAtxy(0,i++,GF_Menu,GF_Menu,
		"is running.");
}
/*****************************************************************
**
**      Subroutine to set the video mode
**
**      USAGE:  SetVideoMode(mode)
**
**         mode = integer selecting the mode
**                0 return to initial mode
**                480 : 640x480x256 colors
**                400 : 640x400x256 colors
**                0x13 : 320x200x256 colors
**
*****************************************************************/


int SetVideoMode(int mode)
{
    int ret;

    if(mode==480)
    {
/*      Try VESA initialization first */
        ret=fg_svgainit(1);
/*      Check to see if this mode is available */
        if(fg_testmode(25,1))
        {
/*          Attempt to set the mode */
            fg_setmode(25);
/*          Check to see if the correct mode was set */
            if(fg_getmode()!=25)
            {
/*              If not, try chipset initialization */
                ret=fg_svgainit(0);
                if(fg_testmode(25,1))
                {
                    fg_setmode(25);
                }
            }
        }
        if(fg_getmode()!=25)
        {
/*          If the mode is still wrong, reset and print message */
            fg_setmode(old_mode);
            fg_reset();
            printf("Mode X requires an SVGA graphics card\n");
            printf("with at least 512K video memory.\n");
            return(0);
        }
        else
        {
            B_Id.row=480;
            B_Id.col=640;
            B_Id.color=256;
        }

    }
    if(mode==400)
    {
        ret=fg_svgainit(1);
        if(fg_testmode(24,1))
        {
            fg_setmode(24);
            if(fg_getmode()!=24)
            {
                ret=fg_svgainit(0);
                if(fg_testmode(24,1))
                {
                    fg_setmode(24);
                }
            }
        }
        if(fg_getmode()!=24)
        {
            fg_setmode(old_mode);
            fg_reset();
            printf("Mode Y requires an SVGA graphics card\n");
            printf("with at least 256K video memory.\n");
            return(0);
        }
        else
        {
            B_Id.row=400;
            B_Id.col=640;
            B_Id.color=256;
        }
    }
    if(mode==0x13)
    {
        ret=fg_svgainit(1);
        if(fg_testmode(19,1))
        {
            fg_setmode(19);
            if(fg_getmode()!=19)
            {
                ret=fg_svgainit(0);
                if(fg_testmode(19,1))
                {
                    fg_setmode(19);
                }
            }
        }
        if(fg_getmode()!=19)
        {
            fg_setmode(old_mode);
            fg_reset();
            printf("Mode S requires a VGA graphics card.\n");
            return(0);
        }
        else
        {
            B_Id.row=200;
            B_Id.col=320;
            B_Id.color=256;
        }
    }
    if(mode==0)
    {
        fg_setmode(old_mode);
        fg_reset();
    }
    return(ret);
}

/*****************************************************************
**
**      Subroutine to write the palette into the Video DACs
**
**      USAGE:  WritePalette(Img)
**
**         Img = name of Color structure
**
*****************************************************************/

WritePalette(struct Color Img1[])

{
    int i,j,r,g,b;
    char colors[778];
    j=0;
    for (i=0;i<256;i++)
    {
        {
            r = (int) ( ( (float) Img1[i].r/255.0 ) * 63);
            g = (int) ( ( (float) Img1[i].g/255.0 ) * 63);
            b = (int) ( ( (float) Img1[i].b/255.0 ) * 63);
        }
        colors[j++]= (char)r;
        colors[j++]= (char)g;
        colors[j++]= (char)b;
    }
    fg_setdacs(0,256,colors);
}
/***********************************************************************
**
**		x,y in screen coordinates
**
**
************************************************************************/

int ll_xy(double *x,double *y,double lat,double lon)

{
/*    double nsample=(double)ZoomSample*-1.0+2.0;

    switch(ProjType)
	{
    case 'A':
		all_xy_e(x,y,lat,lon);
		*x=(*x-X0)/PixelSize;
		*y=(Y0-*y)/PixelSize;	
		if(ZoomSample>0)
		{
			*x=(*x-(double)Xc*(double)Sample)/(double)ZoomSample;
			*y=(*y-(double)Yc*(double)Sample)/(double)ZoomSample;
		}
		else
		{
			*x=(*x-(double)Xc*(double)Sample)*nsample;
			*y=(*y-(double)Yc*(double)Sample)*nsample;
        }
        break;
    case 'E':
        tll_xy_e(x,y,lat,lon);
        *x=(*x-X0)/PixelSize;
        *y=(Y0-*y)/PixelSize;   
        if(ZoomSample>0)
        {
            *x=(*x-(double)Xc*(double)Sample)/(double)ZoomSample;
            *y=(*y-(double)Yc*(double)Sample)/(double)ZoomSample;
        }
        else
        {
            *x=(*x-(double)Xc*(double)Sample)*nsample;
            *y=(*y-(double)Yc*(double)Sample)*nsample;
        }
        break;
    case 'N':
        *x=lon;
        *y=lat;
        *x=(*x-X0)/PixelSize;
        *y=(Y0-*y)/PixelSize;   
        if(ZoomSample>0)
        {
            *x=(*x-(double)Xc*(double)Sample)/(double)ZoomSample;
            *y=(*y-(double)Yc*(double)Sample)/(double)ZoomSample;
        }
        else
        {
            *x=(*x-(double)Xc*(double)Sample)*nsample;
            *y=(*y-(double)Yc*(double)Sample)*nsample;
        }
        break;
    default:
        printf("ProjType = %s",ProjType);
        break;
    }*/
}
                             
