#include <stdio.h>
#include <string.h>
#include <malloc.h>
/*#include "alb_elip.h" commented out by J.Phillips 3/93 */
#include "imvis.h"

#define MENUXC 550
#define MAX 50
#define S_SIZE 40
#define B_LINES 96
#define MAX_X  640
#define LEFT_BUTTON  0
#define RIGHT_BUTTON 1

int *G[MAX];
struct file_id
{
	char name[S_SIZE];
	long size;
	unsigned date,time;
};
extern int ScreenXs,ScreenYs;
extern struct file_id GF_File[];
extern int GF_Order[];
extern int D_Grey,L_Grey,M_Grey;
extern int Black,White,Center,Num_Color;
extern int Font[128][25];
extern double X0,Y0,PixelSize;	/* Albers elip */
extern int Mouse;
extern int FontSize;
unsigned char BarBuffer[17][640];
int MouseMove;


/***********************************************************************
**
**
**
**
************************************************************************/

int graph_plot(char *type_plot)

{
	int i,j,k;
	int num_files,g_num=0,type;
	FILE *fp;
	char string1[100],string2[100],string3[100],string[100];
	char *menu_g[50];

	for(i=0;i<MAX;i++)
	{
		G[i]=(int *)malloc(MAX*sizeof(int));
		if(G[i]==NULL)
		{
            SetVideoMode(0);
			printf(
"at i = %d in graph_plot() -- Not enough space for graphs to be loaded.\n\n",i);
			exit(0);
		}
	}
	num_files=load_names("*.grf");
	if(num_files<1)
	{
		free_G();
		return(0);
	}
	sort_name(num_files);
	for(k=0;k<num_files;k++)
		menu_g[k]=GF_File[GF_Order[k]].name;
    menu_g[num_files]="exit menu";
	if(strcmpi(type_plot,"all")!=0)
	{
        do
        {
            g_num=M_do_menu(menu_g,num_files+1,MENUXC,25,g_num,
						D_Grey,L_Grey,White,Font);
            if(g_num<num_files)
            {
                fp=fopen(menu_g[g_num],"rt");
                if(!fp)
                {
                    free_G();
                    return(-1);
                }
                fgets(string,100,fp);
                sscanf(string,"%s%s%s",string1,string2,string3);
                if(strcmpi(string1,"TYPE")==0)
                    type=get_type(string1,string2,string3);
                if(type<1)
                {
                    free_G();
                    fclose(fp);
                    return(-2);
                }
                do
                {
                    if(type==1)
                       type=plot_pie(fp);
                    if(type==2)
                        type=plot_rectangle_text(fp);
                }while(type>0);
                fclose(fp);
            }
        }while(g_num<num_files);
    }
	else
	{
		for(k=0;k<num_files;k++)
		{		
			fp=fopen(menu_g[k],"rt");
			if(fp)
			{
				fgets(string,100,fp);
				sscanf(string,"%s%s%s",string1,string2,string3);
				if(strcmpi(string1,"TYPE")==0)
					type=get_type(string1,string2,string3);
				if(type>0)
				{
					do
					{
						if(type==1)
							type=plot_pie(fp);
						if(type==2)
							type=plot_rectangle_text(fp);
					}while(type>0);
				}
				fclose(fp);
			}
		}
	}
	free_G();
	return(1);
}


/***********************************************************************
**
**
**
**
************************************************************************/

int plot_pie(fp)

FILE *fp;

{
	int i,j,k;
	float dat[10],sum;
	char name[10][50];
	char string1[100],string2[100],string3[100],string[100];
	int num,size,radius,type=0;
	int color[10];
	double lat,lon,x,y;
	int ix,iy,limit[10],val;
	int keyxs=0,keyys,keyxc=0,keyyc=0,fontsize=FontSize;
	int len,num_files,g_num=0;

	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"DATA_TYPES")==0)
	{
		sscanf(string3,"%d",&num);
		if(num>10)
		{
			fclose(fp);
			return(-3);
		}
		for(k=0;k<num;k++)
		{
			fgets(string,100,fp);
			sscanf(string,"%s%s%s",name[k],string2,string3);
			sscanf(string2,"%d",color+k);
			len=strlen(name[k])*15/fontsize;
			if(len>keyxs)
				keyxs=len;
		}
		keyxs+=2;
		keyys=30/fontsize*num;
		for(k=0;k<num;k++)
		{
			paint_box(0,color[k],BarBuffer,
				keyxc,keyyc+k*30/fontsize,keyxs,30/fontsize);
			plot_font_h(0,keyxc+1,keyyc+k*30/fontsize+1,name[k],fontsize,Font);
		}
	}	
	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"SYMBOL_SIZE")==0)
	{
		sscanf(string3,"%d",&size);
		radius=size/2;
	}
	else
		return(-2);
	for(i=0;i<size;i++)
		for(j=0;j<size;j++)
			fscanf(fp,"%d",&G[i][j]);
	fscanf(fp,"%s",string);
	if(strcmpi(string,"END")!=0)
	{
		fclose(fp);
		return(-4);
	}
	while(fscanf(fp,"%s",string)>0)
	{
		if(strcmpi(string,"TYPE")==0)
		{
			fgets(string,100,fp);
			sscanf(string,"s%s",string2,string3);
			type=get_type(string,string2,string3);
			return(type);
		}
		fscanf(fp,"%lf%lf",&lat,&lon);
		for(k=0;k<num;k++)
			fscanf(fp,"%f",dat+k);
		ll_xy(&x,&y,lat,lon);
		ix=x;
		iy=y;
		if(ix>=-size&&ix<ScreenXs+size&&iy>=-size&&iy<ScreenYs+size)
		{
			sum=0.0;
			for(k=0;k<num;k++)
			{
				sum+=dat[k];
				limit[k]=sum+0.5;
			}
			for(i=0;i<size;i++)
				for(j=0;j<size;j++)
				{
					if(G[i][j]>0)
					{
						for(k=0;k<num;k++)
						{
							val=color[k];
							if(G[i][j]<limit[k])
								break;
						}
						plotpt(0,ix-radius+j,iy-radius+i,val);
					}
				}
		}
	}
	return(-1);
}


/***********************************************************************
**
**
**
**
************************************************************************/

int free_G()

{
	int i;

	for(i=0;i<MAX;i++)
		free(G[i]);
}



/***********************************************************************
**
**
**
**
************************************************************************/

int get_type(string1,string2,string3)

char *string1,*string2,*string3;

{
	int type=-1;

	if(strcmpi(string3,"PIE_CHART")==0||strcmpi(string2,"PIE_CHART")==0)
		type=1;
	else if(strcmpi(string3,"RECTANGLE+TEXT")==0||
				strcmpi(string2,"RECTANGLE+TEXT")==0)
		type=2;
	return(type);
}


/***********************************************************************
**
**
**
**
************************************************************************/

int plot_rectangle_text(fp)

FILE *fp;

{
	int i,j,k;
	char string1[100],string2[100],string3[100],string[100];
	char string4[50],string5[50];
	int num,size,radius,type=0;
	int hot_col=-1,hot_row=-1;
	int row,col,text,mx,my,tx,ty;
	double lat,lon,x,y;
	int ix,iy,limit[10],val,end=0,numread;
	float maxpix,minpix,pixsize=PixelSize/1000.0;

	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"PIXEL_RANGE")==0)
	{
		sscanf(string,"%s%s%f%f",string1,string2,&maxpix,&minpix);
	}
	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"COLORS")==0)
	{
		sscanf(string3,"%d",&num);
		if(num>10)
		{
			fclose(fp);
			return(-3);
		}
		for(k=0;k<num;k++)
			fgets(string,100,fp);
	}	
	else
		return(-2);
	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"TEXT_COLOR")==0)
	{
		sscanf(string3,"%d",&text);
		text+=240;
	}
	else
		return(-2);
	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"TEXT_SIZE")==0)
	{
		sscanf(string3,"%d",&size);
		ty=23/size;
		ty/=2;
	}
	else
		return(-2);
	fgets(string,100,fp);
	numread=sscanf(string,"%s%s%s%s%s",
		string1,string2,string3,string4,string5);
	if(strcmpi(string1,"SYMBOL_ROWS")==0)
	{
		sscanf(string3,"%d",&row);
		if(row>MAX)
		{
			printf("Too many rows in symbol.\n\n");
			exit(0);
		}
		my=row/2;
		if(numread>4)
		{
			sscanf(string5,"%d",&hot_row);
			my=hot_row;
			ty+=row/2-my;
		}
	}
	else
		return(-2);
	fgets(string,100,fp);
	numread=sscanf(string,"%s%s%s%s%s",
		string1,string2,string3,string4,string5);
	if(strcmpi(string1,"SYMBOL_COLS")==0)
	{
		sscanf(string3,"%d",&col);
		if(col>MAX*2)
		{
			printf("Too many columns in symbol.\n\n");
			exit(0);
		}
		mx=col/2;
		if(numread>4)
		{
			sscanf(string5,"%d",&hot_col);
			mx=hot_col;
		}
	}
	else
		return(-2);
	fgets(string,100,fp);
	sscanf(string,"%s%s%s",string1,string2,string3);
	if(strcmpi(string1,"BEGIN_SYMBOL")==0)
	{
		for(i=0;i<row;i++)
		{
			for(j=0;j<col;j++)
			{
				fscanf(fp,"%s",string);
				if(strcmpi(string,"END")==0)
				{
					end=1;
					break;
				}
				if(string[0]=='*')
					G[i][j]=-1;
				else if(string[0]>='a'&&string[0]<='f')
					G[i][j]=string[0]-'a'+10;
				else
					G[i][j]=string[0]-'0';
			}
			if(end==1)
				break;
		}
	}
	else
		return(-2);
	fgets(string,100,fp);
	fgets(string,100,fp);
	while(fscanf(fp,"%s",string)>0)
	{
		if(strcmpi(string,"TYPE")==0)
		{
			fgets(string1,100,fp);
			sscanf(string1,"%s%s",string2,string3);
			type=get_type(string,string2,string3);
			return(type);
		}
		fscanf(fp,"%lf%lf%s",&lat,&lon,string1);
		if(kbhit()>0)
		{
			val=getch();
			if(val==27)
				return(-2);
		}
		if(maxpix>pixsize&&minpix<=pixsize)
		{
			ll_xy(&x,&y,lat,lon);
			ix=x;iy=y;
			tx=strlen(string);
			tx*=15/size;
			tx-=5/size;
			tx/=2;
			if((ix+mx>=0&&ix-mx<ScreenXs&&iy+my>=0&&iy-my<ScreenYs))
			{
				for(i=0;i<row;i++)
					for(j=0;j<col;j++)
						if(G[i][j]>=0)
                            plotpt(0,ix-mx+j,iy-my+i,G[i][j]+240);
/*                            plotpt(0,ix-mx+j,iy-my+i,G[i][j]);*/
				plot_font_h(text,ix-tx,iy-ty,string,size,Font);
			}
		}
	}
	return(-1);
}
                                                                                                                          
