/* vimage3.c 11/09/89 */

/* ***** include ***** */

#include <io.h>
#include <fcntl.h> 
#include <sys\types.h> 
#include <sys\stat.h> 
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <process.h>
#include <string.h>
#include <conio.h>
#include <errno.h>
#include <string.h>
#include <dos.h>
#include "getfile3.c"
#include <math.h>

/* ***** define ***** */
#define DEG_RAD 0.01745329251				/* converts degrees to radians */
#define BANK_SEL  0xC0000400L		/* Address of bank select register */
#define DISP_BUFF 0xA0000000L		/* Base address of display buffer */
#define VIDIOBUFF 0xA0000000L		/* Base address of display buffer */
#define ROWSIZE  640
#define NWORDS   0x8000				/* Number of words in bank */
#define NUMSYM 7
#define MAX_DIR 20
#define MAX_FIL 20
#define MAX_LIST 300


/* ***** variables ***** */

	/* ***** internal ***** */

	int List_Fil_Read=0;

	/* ***** external ***** */

	extern int ScreenXs,ScreenYs;

/* ***** arrays ***** */

	/* ***** internal ***** */

	int V_dark=16,V_light=255,V_cursor=0;
	unsigned char *Vimage_Buffer,Vimage_Line_Buffer[640];
	unsigned char Vi_Inbuff1[BUFSIZ],Vi_Inbuff2[BUFSIZ],Vi_Outbuff[BUFSIZ];
	char Dir[MAX_DIR][30],Fil[MAX_FIL][20];
	/* ***** external ***** */

/* ***** stuctures ***** */

	/* ***** definitions ***** */

	/* ***** declarations ***** */

	FILE *Vimage_Save1,*Vimage_Save2;
	struct symbol
	{
		int scale,num;
		int side[15][2];
	}sym[NUMSYM]=
	{
		{1,8, -1,-1,  1,-1,  1, 1, -1, 1, -1,-1, -1, 1,  1, 1,  1,-1, -1,-1},
		{1,4,  0,-1,  1, 0,  0, 1, -1, 0,  0,-1},
		{1,3,  0,-1,  1, 1, -1, 1,  0,-1},
		{2,8, -1,-2,  1,-2,  2,-1,  2, 1,  1, 2, -1, 2, -2, 1, -2,-1, -1,-2},
		{3,12, -1,-1, -1,-3,  1,-3,  1,-1,  3,-1,  3, 1,  1, 1,
				  1, 3, -1, 3, -1, 1, -3, 1, -3,-1, -1,-1},
		{2,12,  0,-1,  1,-2,  2,-1,  1, 0,  2, 1,  1, 2,  0, 1,
				 -1, 2, -2, 1, -1, 0, -2,-1, -1,-2,  0,-1},
		{1,3,  0, 1,  1,-1, -1,-1,  0, 1}
	};

	struct line_draw
	{
		int num;
		char pat[16];
	}line[NUMSYM]=
	{
		{ 2,  1,0 },
		{ 4,  1,1,0,0},
		{ 6,  1,1,1,1,0,0},
		{ 8,  1,1,1,1,1,0,0,0},
		{10,  1,1,1,1,0,0,1,1,0,0},
		{12,  1,1,1,1,1,1,0,0,1,1,0,0},
		{16,  1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0}
	};

/* ***** functions ***** */

	/* ***** external ***** */

	/* ***** internal ***** */

void 				box(int,int,int,int,int,int);		/* draws a box */
void 				cursor(int,int,int,int,int);	/* plots a cursor */
void 				decode_font(int [128][25]);		/* reads 'font.hex' */
int 				do_menu(char *[],int,int,int,int,int,int,int,int [128][25]); 
int 				file_r(char *); 	/* opens a file to read from */
int 				file_w(char *); 	/* opens a file to write to */
int 				fillin(int,int,int,int,int,int);
char 				get_ans(unsigned char *,char *,char *,int,int,int,int,int,int,
						int[128][25],int);
char 				getpad(int *,int *,int *,int *,int);
int 				get_fil(int,int,int,char *);
unsigned char 	getpt(int,int,int);			/* returns the value of a pixel */
void 				getrow(int,unsigned int,unsigned int,unsigned int,
						unsigned char far *);
int 				get_string(char *,unsigned char *,char *,char *,
						int,int,int,int,int,int,int [128][25],int);
void 				help(int);
int 				limit_area(int *,int *,int *,int *,int *,int,int,
						unsigned char *);
int 				limit_area_all(int *,int *,int *,int *,int *,
                        int,int,int,int,int,unsigned char *,int,int,int);
int 				list_dir(char *,char *);
void 				list_error(int);
void 				move_image();
int 				paint(int,int);
void 				paint_box(int,int,unsigned char *,int,int,int,int);
void 				paintcol(int,unsigned int,unsigned int,unsigned int,int);
void 				pix_val(int,int);
void 				plot_font_h(int,int,int,char *,int,int [128][25]);	
void 				plot_font_v(int,int,int,char *,int,int [128][25]);
int  				plotln(int,int,int,int,int,int);
int 				plotpt(int,int,int,int);		/* plots the value of a pixel */
int 				plotrow(int,int,int,int,unsigned char *);
int 				plotsym( int , int , int , int , int , int );
int 				read_fil(int *,int *, int *);
void 				recall_sub(int,int,int,int,FILE *);
void 				save_box(int,int,unsigned char *,int,int,int,int);
void 				save_sub(int,int,int,int,FILE *);
void 				set_files(void);
void 				tbox(int,int,int,int,int,unsigned char *);
int 				tbox_val(int,int,int,int,int,
						unsigned char *,int,int,int);
int 				tcursor(int,int,int,int,unsigned char *);
int 				t_do_menu(char [][2][50],int,int,int,int,int,
						int,int,int [128][25],int *); 
int 				tplotln_inv_dot(int,int,int,int,int,
						unsigned char *,int);
int 				tplotln_val(int,int,int,int,int,unsigned char *,int);
void 				unbox(int,int,int,int,int,unsigned char *);
void 				uncursor(int,int,int,int,unsigned char *);
int 				unplotln(int,int,int,int,int,unsigned char *);
void 				unsave_box(int,int,unsigned char *,int,int,int,int);


/********************************************************************
**
**
**
********************************************************************* */

void list_error(val)

int val;

{
	if(val==-4)
		printf("\n\nNo such file in directory!\n\n");
	if(val==-5)
		printf("\n\nDirectory contains more than %d such files!\n\n",
			MAX_LIST);
	if(val==-3)
		printf("\n\nYou chose a file number outside the range!\n\n");

}



#ifdef TESTER
/********************************************************************
**
**
**
********************************************************************* */

int get_fil(num_dir,num_fil,num,string)

int num_dir,num_fil,num;
char *string;

{
	int i,n,d,f;
	char str_dir[30],str_fil[20];
	int other=0;

	if(List_Fil_Read==0)
		read_fil(string);
	printf("----------------------------------(data from file 'list.fil')\n");
	printf("Directory                File\n\n");
	for(i=0;i<num;i++)
	{
		if(i<num_dir)
		{
			printf("%c--%s",'a'+i,Dir[i]);
			for(n=0;n<(22-strlen(Dir[i]));n++)
				printf(" ");
		}
		else
			printf("                         ");
		if(i<num_fil)
			printf("%c -- %s\n",'a'+i,Fil[i]);
		else
			printf("\n");
	}
	printf("x -- other               x -- other\n");
	printf("\ngive directory\n ");
	d=getch()-'a';
	if(d=='x'-'a')
	{
		printf("\n\nGive full directory and file type.\n");
		scanf("%s",string);
		return(1);
	}
	if(d>=0&&d<num_dir)
	{
		printf("%c               and File  ",d+'a');
		f=getch()-'a';
		if(f=='x'-'a')
		{
			printf("\n\nGive full directory and file type.\n");
			scanf("%s",string);
			return(1);
		}
		if(f>=0&&f<num_fil)
		{
			printf("%c\n",f+'a');
			strcpy(string,Dir[d]);
			strcpy(str_fil,Fil[f]);
			strcat(string,Fil[f]);
			return(1);
		}
		else
		{
			printf("\n\nLetter out of range!\n\n");
			return(-1);
		}
	}
	else
	{
		printf("\n\nLetter out of range!\n\n");
		return(-1);
	}
		
}


/********************************************************************
**
**
**
********************************************************************* */

int read_fil(num_dir,num_fil,num)

int *num_dir,*num_fil,*num;

{
	int i,j,k;
	FILE *fp;
	char string[100];
	int end=0,si=0,fi=0,num_read;

	List_Fil_Read=1;

	fp=fopen("list.fil","rt");
	if(!fp)
	{
		printf("Could not find file 'list.fil'\n\n");
		return(-1);
	}

	i=0;
	do
	{
		num_read=fscanf(fp,"%s",string);
		if(strcmpi(string,"directories")==0)
			si=1;
		i+=1;
	}while(i<MAX_DIR+MAX_FIL+2&&si==0&&num_read>0);

	i=end=0;
	if(si=1) /* found 'directories' */
	{
		do
		{
			num_read=fscanf(fp,"%s",Dir[i]);
			if(num_read<=0)
				end=1;
			else if(strcmpi(Dir[i],"file_types")==0)
			{
				end=1;
				fi=1;
			}
			if(end==0)
				i+=1;
		}while(end==0&&i<MAX_DIR);
		*num_dir=i;
	}
	end=i=0;
	if(fi=1) /* found 'file_types' */
	{
		do
		{
			num_read=fscanf(fp,"%s",Fil[i]);
			if(num_read<=0)
				end=1;
			if(end==0)
				i+=1;
		}while(end==0&&i<MAX_FIL);
		*num_fil=i;
	}
	*num=*num_fil;
	if(*num_dir>*num)*num=*num_dir;
	fclose(fp);
}

#endif
/********************************************************************
**
**
**
********************************************************************* */

int list_dir(what,which)

char *what,*which;

{
	int i=0,j,k,p,l,e,n,m;
	FILE *fp;
	char string[100],directory[80],data[5][30];
	int num_read,end=0,lines=0,l_extra=0,pages=1,p_extra=0,num=0,le;
	char ans;
	int val,eof=0;

	num=load_names(what);
	if(num>0)
	{
		sort_name(num);
		return(get_name(num,which));
	}
	else
		return(-1);
}






/********************************************************************
**
**
**
********************************************************************* */

int get_string(string,buffer,string1,string2,xc,yc,xs,ys,save,remove,
		font,brite)

int xc,yc,xs,ys,save,remove;
unsigned char *buffer;
char *string1,*string2,*string;
int font[128][25],brite;

{
	int j,k;
	int i=yc+1,ans;
	int size=2;
	int txc=xc,tyc=yc+31,txs=7,tys=15;
	char ltr[2],tstring[100];
	unsigned char buff[100];
	double number;
    int val,hue;

	if(brite<0||brite>255)
		brite=191;

	ltr[1]='\0';

	if(save==1)
        save_box(0,0,buffer,xc,yc,xs,ys);
	plot_font_h(brite,xc+2,yc+1,string1,size,font);
	plot_font_h(brite,xc+2,yc+30/size+1,string2,size,font);
	k=0;
	do
	{	
		ans=getch();
		if(ans==27)
		{
			if(remove==1)
				unsave_box(0,0,buffer,xc,yc,xs,ys);
			return(0);
		}
		if(ans==0)
		{
			if(getch()==33)
			{
                SetVideoMode(3);
				val=get_file_name(string,tstring);
				if(val>0)
				{
                    SetVideoMode(480);
					set_lut('G');
					return(val);
				}
				else 
				{
					printf("No file chosen.  HIT ANY KEY TO CONTINUE!\n\n");
					getch();
                    SetVideoMode(480);
					set_lut('G');
					return(0);
				}
			}
			else
				ans=' ';
		}
		i=yc+60/size+2;
		paint_box(0,0,buff,txc,tyc,txs,tys);
		if((ans>=' '&&ans<='}'))
		{
			string[k]=ans;
			ltr[0]=ans;
			plot_font_h(brite,txc,i,ltr,size,font);
			k+=1;
			txc+=7;
		}
		if(ans==8&&k>0)
		{
			string[k]='\0';
			k-=1;
			txc-=7;
			paint_box(0,0,buff,txc,tyc,txs,tys);
		}
	}while(ans!=13);
	string[k]='\0';
	if(remove==1)
		unsave_box(0,0,buffer,xc,yc,xs,ys);
	return(k);
}





/********************************************************************
**
**
**
********************************************************************* */

char get_ans(buffer,string1,string2,xc,yc,xs,ys,save,remove,font,brite)

int xc,yc,xs,ys,save,remove;
unsigned char *buffer;
char *string1,*string2;
int font[128][25],brite;

{
	int i=yc+1,ans;
	int size=2;

	if(brite<0||brite>255)
		brite=191;

	if(save==1)
		save_box(0,0,buffer,xc,yc,xs,ys);
	plot_font_h(brite,xc+1,i,string1,size,font);
	i+=30/size;
	plot_font_h(brite,xc+1,i,string2,size,font);
	i+=30/size;
	ans=getch();
	if(remove==1)
		unsave_box(0,0,buffer,xc,yc,xs,ys);

	return(ans);
}





/********************************************************************
**
**
**
********************************************************************* */

void help(num)

int num;

{
	int xc=10,yc=10;

/*	save_sub(xc-2,yc-2,COL*7+4,ROW*15+4,Vimage_Save1);
	read_block(output,num);
	plot_block(output,10,10);
	getch();
	recall_sub(xc-2,yc-2,COL*7+4,ROW*15+4,Vimage_Save1);*/
}



/********************************************************************
**
**	WARNING!!!!  YOU MUST CALL decode_font() or set_files() before using
**
**     options:
**
**       -1 -- remove menu but get no answer
**        0 -- return answer and set menu colors to greys
**        1 -- return answer but leave colors alone
**
********************************************************************* */

int do_menu(menu,num,xc,yc,start,back,words,boxs,font)

char *menu[];
int num,xc,yc,start,back,words,boxs;
int font[128][25];

{
	int i,j,k;
	char ans,ans2;
	int len=0,l,size=2,val,valo;
	int black=0,dgrey=back,lgrey=words,white=boxs;
	int wide;

	Vimage_Buffer=(unsigned char *)malloc(16384);
	if(Vimage_Buffer==NULL)
	{
        SetVideoMode(0);
		printf("at Vimage_Buffer malloc failed\n\n");
		exit(0);
	}

	for(k=0;k<num;k++)
		if((l=strlen(menu[k]))>len)len=l;
	if(len==0)
	{
		free(Vimage_Buffer);
		return(-1);
	}
	wide=(len+1)*15/size+1;
	if(((ScreenXs-1)-wide)<xc)xc=(ScreenXs-1)-wide;

	if((xc+(len+1)*15/size+1)<ScreenXs)
	{
		save_sub(xc,yc,(len+1)*15/size+1,30/size*num+1,Vimage_Save1);
		paint_box(0,dgrey,Vimage_Buffer,xc,yc,(len+1)*15/size+1,30/size*num+1);
		for(k=0;k<num;k++)
		{	
			box(0,xc,yc+k*(30/size),dgrey,(len+1)*15/size,30/size);
			plot_font_h(lgrey,xc+15/size,yc+k*30/size+5/size,menu[k],size,font);
		}
		box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);

		val=valo=start;
		box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
		do
		{
			if((ans=getch())==0)
			{
				ans2=getch();
				if(ans2==50)
				{
					recall_sub(xc,yc,(len+1)*15/size+1,30/size*num+1
							,Vimage_Save1);
					getch();
					paint_box(0,dgrey,Vimage_Buffer,
						xc,yc,(len+1)*15/size+1,30/size*num+1);
					for(k=0;k<num;k++)
					{	
						plot_font_h(lgrey,xc+15/size,
									yc+k*30/size+5/size,menu[k],size,font);
					}
				}
				if(ans2=='H')
				{
					if(val>0)val-=1;
					else val=num-1;
				}
				if(ans2=='P')
				{
					if(val<num-1)val+=1;
					else val=0;
				}
			}

			for(i=0;i<num;i++)
				if(ans==menu[i][0])
				{
					val=i;
					ans=13;
				}

			box(0,xc,yc+valo*(30/size),dgrey,(len+1)*15/size,30/size);
			valo=val;
			box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);
			box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
		}while(ans!=13);
	}
	box(0,xc,yc,dgrey,(len+1)*15/size,30/size*num);
	box(0,xc,yc+val*(30/size),lgrey,(len+1)*15/size,30/size);

	recall_sub(xc,yc,(len+1)*15/size+1,30/size*num+1,Vimage_Save1);
	free(Vimage_Buffer);
	return(val);
}


/********************************************************************
**
**	WARNING!!!!  YOU MUST CALL decode_font() or set_files() before using
**
**     options:
**
**       -1 -- remove menu but get no answer
**        0 -- return answer and set menu colors to greys
**        1 -- return answer but leave colors alone
**
********************************************************************* */

int t_do_menu(menu,num,xc,yc,start,back,words,boxs,font,off_on)

char menu[][2][50];
int num,xc,yc,start,back,words,boxs;
int font[128][25],*off_on;

{
	int i,j,k;
	char ans,ans2;
	int len=0,l,size=2,val,valo;
	int black=0,dgrey=back,lgrey=words,white=boxs;
	int wide;

	for(k=0;k<num;k++)
		if((l=strlen(menu[k][0]))>len)len=l;
	if(len==0)
	{
		free(Vimage_Buffer);
		return(-1);
	}
	wide=(len+1)*15/size+1;
	if(((ScreenXs-1)-wide)<xc)xc=(ScreenXs-1)-wide;

	Vimage_Buffer=(unsigned char *)malloc(16384);
	if(Vimage_Buffer==NULL)
	{
        SetVideoMode(0);
		printf("at Vimage_Buffer malloc failed\n\n");
		exit(0);
	}

	if((xc+(len+1)*15/size+1)<ScreenXs)
	{
		save_sub(xc,yc,(len+1)*15/size+1,30/size*num+1,Vimage_Save1);
		paint_box(0,dgrey,Vimage_Buffer,xc,yc,(len+1)*15/size+1,30/size*num+1);
		for(k=0;k<num-3;k++)
		{	
			box(0,xc,yc+k*(30/size),dgrey,(len+1)*15/size,30/size);
			plot_font_h(lgrey,xc+15/size,yc+k*30/size+5/size,menu[k][off_on[k]],
				size,font);
		}
		for(k=num-3;k<num;k++)
		{	
			box(0,xc,yc+k*(30/size),dgrey,(len+1)*15/size,30/size);
			plot_font_h(lgrey,xc+15/size,yc+k*30/size+5/size,menu[k][0],
				size,font);
		}
		box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);

		val=valo=start;
		box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
		do
		{
			ans=getch();
			if(ans==13)
			{
				if(val<num-3)
				{
					if(off_on[val]==0)
						off_on[val]=1;
					else
						off_on[val]=0;
				}
				if(val==num-3)
					for(k=0;k<num-3;k++)
						off_on[k]=1;
				if(val==num-2)
					for(k=0;k<num-3;k++)
						off_on[k]=0;
				paint_box(0,dgrey,Vimage_Buffer,xc,yc,
					(len+1)*15/size+1,30/size*num+1);
				for(k=0;k<num-3;k++)
				{	
					box(0,xc,yc+k*(30/size),dgrey,(len+1)*15/size,30/size);
					plot_font_h(lgrey,xc+15/size,yc+k*30/size+5/size,
							menu[k][off_on[k]],size,font);
				}
				for(k=num-3;k<num;k++)
				{	
					box(0,xc,yc+k*(30/size),dgrey,(len+1)*15/size,30/size);
					plot_font_h(lgrey,xc+15/size,yc+k*30/size+5/size,
							menu[k][0],size,font);
				}
				box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);
			}
			if(ans==13&&val==num-1)
				ans=27;
			if(ans==0)
			{
				ans2=getch();
				if(ans2==50)
				{
					recall_sub(xc,yc,(len+1)*15/size+1,30/size*num+1
							,Vimage_Save1);
					getch();
					paint_box(0,dgrey,Vimage_Buffer,
						xc,yc,(len+1)*15/size+1,30/size*num+1);
					for(k=0;k<num;k++)
					{	
						plot_font_h(lgrey,xc+15/size,
							yc+k*30/size+5/size,menu[k][off_on[k]],size,font);
					}
				}
				if(ans2=='H')
				{
					if(val>0)val-=1;
					else val=num-1;
				}
				if(ans2=='P')
				{
					if(val<num-1)val+=1;
					else val=0;
				}
			}
			for(i=0;i<num;i++)
				if(ans==menu[i][0][0])
				{
					val=i;
					ans=27;
				}
			box(0,xc,yc+valo*(30/size),dgrey,(len+1)*15/size,30/size);
			valo=val;
			box(0,xc,yc,lgrey,(len+1)*15/size,30/size*num);
			box(0,xc,yc+val*(30/size),white,(len+1)*15/size,30/size);
		}while(ans!=27);
	}
	box(0,xc,yc,dgrey,(len+1)*15/size,30/size*num);
	box(0,xc,yc+val*(30/size),lgrey,(len+1)*15/size,30/size);

	recall_sub(xc,yc,(len+1)*15/size+1,30/size*num+1,Vimage_Save1);
	free(Vimage_Buffer);
	return(val);
}


/********************************************************************
**
**
**
********************************************************************* */

void save_sub(xc,yc,xs,ys,fp)

int xc,yc,xs,ys;
FILE *fp;

{
	int i,j,k;

	rewind(fp);

	fwrite((char *)&ys,sizeof(int),1,fp);
	fwrite((char *)&xs,sizeof(int),1,fp);

	for(i=0;i<ys;i++)
	{
		getrow(3,xc,xc+xs-1,i+yc,Vimage_Line_Buffer);
		fwrite((char *)Vimage_Line_Buffer,sizeof(char),xs,fp);
	}
}

/********************************************************************
**
**
**
********************************************************************* */

void recall_sub(xc,yc,xs,ys,fp)

int xc,yc,xs,ys;
FILE *fp;

{
	int i,j,k;

	xs=ys=0;

	rewind(fp);

	fread((char *)&ys,sizeof(int),1,fp);
	fread((char *)&xs,sizeof(int),1,fp);

	if(xc+xs>ScreenXs)xc=ScreenXs-xs;
	if(yc+ys>ScreenYs)yc=ScreenYs-ys;
	if(xc<0||yc<0)return;

	for(i=0;i<ys;i++)
	{
		fread((char *)Vimage_Line_Buffer,sizeof(char),xs,fp);
		PlotLine(i+yc,xc,i+yc,xc+xs-1,Vimage_Line_Buffer);
	}
}


/********************************************************************
**
**	paints a box and saves contents in buffer
**
********************************************************************* */

void save_box(hue,val,buffer,xc,yc,xsize,ysize)

int hue,val,xc,yc,xsize,ysize;

unsigned char *buffer;

{
	int i,j,k,x2,y2;

	x2=xc+xsize-1;
	y2=yc+ysize;
	for(k=0;k<xsize;k++)Vimage_Line_Buffer[k]=val;
	for(j=0;j<ysize;j++)
	{
		getrow(3,xc,x2,j+yc,buffer+j*xsize);
		PlotLine(j+yc,xc,j+yc,x2,Vimage_Line_Buffer);
	}
}

/********************************************************************
**
**	unpaints a box and saves contents in buffer
**
********************************************************************* */

void unsave_box(hue,val,buffer,xc,yc,xsize,ysize)

int hue,val,xc,yc,xsize,ysize;

unsigned char *buffer;

{
	int i,j,k,x2,y2;

	x2=xc+xsize-1;
	y2=yc+ysize;
	for(j=0;j<ysize;j++)
	{
		PlotLine(j+yc,xc,j+yc,x2,buffer+j*xsize);
	}
}

/********************************************************************
**
**
**
********************************************************************* */

int limit_area_all(x,y,xsize,ysize,speed,max_x,max_y,max_xs,max_ys,iop,buffer,lo,hi,cent)

int *x,*y,*xsize,*ysize,*speed,max_x,max_y,max_xs,max_ys,iop,lo,hi,cent;
unsigned char *buffer;

{
	char ans;
	int size=0,xo,yo,menu=1;
	int spd=*speed;
	int dir=1;

	xo=*x;
	yo=*y;

	tbox_val(3,*x,*y,*xsize,*ysize,buffer,lo,hi,cent);
	do
	{
		ans=getpad(&size,x,y,speed,menu);	/* use number pad to move box */
		if(ans=='c')dir*=(-1);
		spd=*speed*dir;
		menu=0;	/* turn off menu print */
		unbox(3,xo,yo,*xsize,*ysize,buffer); /* remove old box */
		if(iop==1)            /* change x size */
		{
			if(ans=='x')
				*xsize+=spd;
			if(ans=='y')
				*ysize+=spd;
			if(ans=='N'||ans=='s')*xsize-=*speed;
			if(ans=='W'||ans=='l')*xsize+=*speed;
			if(ans=='S'||ans=='s')*ysize-=*speed;
			if(ans=='H'||ans=='l')*ysize+=*speed;
            if(*xsize>max_xs)*xsize=max_xs;
			if(*xsize<0)*xsize=2;
            if(*ysize>max_ys)*ysize=max_ys;
			if(*ysize<0)*ysize=2;
		}
		if(*x<0)*x=0;							/* make sure all is on screen */
		if(*y<0)*y=0;
		if(*x+*xsize>max_x)*x=max_x-*xsize;
		if(*y+*ysize>max_y)*y=max_y-*ysize;
		tbox_val(3,*x,*y,*xsize,*ysize,buffer,lo,hi,cent);
		xo=*x;									/* set old location */
		yo=*y;
    }while(ans!=13&&ans!=27);
	unbox(3,xo,yo,*xsize,*ysize,buffer); /* remove old box */

	return(ans);
}



/********************************************************************
**
**
**
********************************************************************* */

int limit_area(x,y,xsize,ysize,speed,maxbox,iop,buffer)

int *x,*y,*xsize,*ysize,*speed,maxbox,iop;
unsigned char *buffer;

{
	char ans;
	int size=0,xo,yo,menu=1;
	int spd=*speed;
	int dir=1;

	if(*xsize>ScreenXs)
		*xsize=ScreenXs;
	if(*x+*xsize>=ScreenXs)
		*x=ScreenXs-*xsize;
	if(*ysize>ScreenYs)
		*ysize=ScreenYs;
	if(*y+*ysize>=ScreenYs)
		*y=ScreenYs-*ysize;
	xo=*x;
	yo=*y;
	tbox(3,*x,*y,*xsize,*ysize,buffer); /* plot 1st box on overlay */
	do
	{
		ans=getpad(&size,x,y,speed,menu);	/* use number pad to move box */
		if(ans=='c')dir*=(-1);
		spd=*speed*dir;
		menu=0;	/* turn off menu print */
		unbox(3,xo,yo,*xsize,*ysize,buffer); /* remove old box */
		if(iop==1)            /* change x size */
		{
			if(ans=='x')
				*xsize+=spd;
			if(ans=='y')
				*ysize+=spd;
			if(ans=='n')*xsize-=*speed;
			if(ans=='w')*xsize+=*speed;
			if(ans=='s')*ysize-=*speed;
			if(ans=='h')*ysize+=*speed;
			if(*xsize>maxbox)*xsize=maxbox;
			if(*xsize<0)*xsize=8;
			if(*ysize>maxbox)*ysize=maxbox;
			if(*ysize<0)*ysize=8;
		}
		if(*x<0)*x=0;							/* make sure all is on screen */
		if(*y<0)*y=0;
		if(*x+*xsize>(ScreenXs-1))*x=(ScreenXs-1)-*xsize;
		if(*y+*ysize>(ScreenYs-1))*y=(ScreenYs-1)-*ysize;
		tbox(3,*x,*y,*xsize,*ysize,buffer);  /* plot new box on overlay */		
		xo=*x;									/* set old location */
		yo=*y;
	}while(ans!=83&&ans!=13&&ans!=27);
	unbox(3,xo,yo,*xsize,*ysize,buffer); /* remove old box */

	return(ans);
}




/* ******************************************************************
**
**	draw a line on the image
**
********************************************************************* */

void plotlnsym(hue,sym,x1,y1,x2,y2,val)

int hue;	/* image plane */
int sym; /* line number */
int x1,y1;	/* coordinates of 1st point */
int x2,y2;	/* coordinates of 2nd point */
int val;	/* brightness of line */

{
	int n=0,nn;
	int   i, j, k, numx, numy;
	float x, y, dy, dx;

	if(hue<0 || hue>3) return;
	if(val<0 || val >255) return;

	numx = ( x2 > x1 ) ? x2-x1 : x1-x2;
	numy = ( y2 > y1 ) ? y2-y1 : y1-y2;

	if(numx==0 && numy==0) return;

	if( numx>numy ) {
		dy = (float)(y2-y1)/(float)(x2-x1);
		dx = (x2>x1) ? 1.0 : -1.0;
		i = x = x1;
		j = y = y1;
		for(k=0;k<=(numx);k++)
		{
			nn=n++%line[sym].num;
			WritePixel(j,i,val*line[sym].pat[nn]);
			x += dx;
			y += dy*dx;
			if(dy>=0.0)
			{
				i = x;
				j = y;
			}
			else
			{
				i = x;
				j = y+0.5;
			}
		}
	}
	else{
		dx = (float)(x2-x1)/(float)(y2-y1);
		dy = (y2>y1) ? 1.0 : -1.0;
		i = x = x1;
		j = y = y1;
		for(k=0;k<=(numy);k++)
		{
			nn=n++%line[sym].num;
			WritePixel(j,i,val*line[sym].pat[nn]);
			x += dx*dy;
			y += dy;
			if(dx>=0.0)
			{
				i = x;
				j = y;
			}
			else
			{
				i = x+0.5;
				j = y;
			}
		}
	}

}





/********************************************************************
**
**
**
********************************************************************* */

int plotsym(hue,num,x,y,size,val)

int hue,num,x,y,size,val;

{
	int i,j,k;
	int x1,y1,x2,y2;
	int dist,sign;

	if(num>=NUMSYM)return(0);

	if(size<1)size=1;

	for(i=0;i<sym[num].num;i++)
	{
		dist=abs(sym[num].side[i][0]);
		sign=(sym[num].side[i][0]>0)?1:-1;
		x1=dist;
		x1*=size;
		x1/=sym[num].scale;
		x1*=sign;

		dist=abs(sym[num].side[i][1]);
		sign=(sym[num].side[i][1]>0)?1:-1;
		y1=dist;
		y1*=size;
		y1/=sym[num].scale;
		y1*=sign;

		dist=abs(sym[num].side[i+1][0]);
		sign=(sym[num].side[i+1][0]>0)?1:-1;
		x2=dist;
		x2*=size;
		x2/=sym[num].scale;
		x2*=sign;

		dist=abs(sym[num].side[i+1][1]);
		sign=(sym[num].side[i+1][1]>0)?1:-1;
		y2=dist;
		y2*=size;
		y2/=sym[num].scale;
		y2*=sign;
		DrawVector(y+y1,x+x1,y+y2,x+x2,val);
	}
	return(NUMSYM);
}




/********************************************************************
**
**	paints a box
**
********************************************************************* */

void paint_box(hue,val,buffer,xc,yc,xsize,ysize)

int hue,val,xc,yc,xsize,ysize;

unsigned char *buffer;

{
	int i,j,k,x2,y2;

	x2=xc+xsize-1;
	y2=yc+ysize;

/*	for(k=0;k<xsize;k++)buffer[k]=val;*/

	for(j=yc;j<y2;j++)
	{
		DrawVector(j,xc,j,x2,val);
/*		PlotLine(j,xc,j,x2,buffer);*/
	}
}


/********************************************************************
**
**	unboxes
**
********************************************************************* */

void unbox(hue,xc,yc,xsize,ysize,buffer)

int hue,xc,yc,xsize,ysize;
unsigned char *buffer;

{
	int x,y;
	unsigned char val;

	if(xsize<=1&&ysize<=1)
	{
		WritePixel(y,x,*buffer);
		return;
	}

	if(xsize>1)
		for(x=xc;x<xc+xsize;x++)
		{
			y=yc;
			WritePixel(y,x,*buffer++);
		}
	if(ysize>2)
		for(y=yc+1;y<yc+ysize-1;y++)
		{
			x=xc+xsize-1;
			WritePixel(y,x,*buffer++);
		}
	if(xsize>1)
		for(x=xc;x<xc+xsize;x++)
		{
			y=yc+ysize-1;
			WritePixel(y,x,*buffer++);
		}
	if(ysize>2)
		for(y=yc+1;y<yc+ysize-1;y++)
		{
			x=xc;
			WritePixel(y,x,*buffer++);
		}
}


/********************************************************************
**
**	creates a box on color plane hue which can be erased by unbox()
**
********************************************************************* */

int tbox_val(hue,xc,yc,xsize,ysize,buffer,low_color,high_color,center_val)

int hue,xc,yc,xsize,ysize,low_color,high_color,center_val;
unsigned char *buffer;

{
	int x,y;
	unsigned char val;
	
	if(xsize<=1&&ysize<=1)
	{
		*buffer=getpt(hue,x,y);
		val=(*buffer>center_val)?low_color:high_color;
        if(val==*buffer) val=(*buffer>center_val)?high_color:low_color;
		WritePixel(y,x,val);
		return(0);
	}

	if(xsize>1)
		for(x=xc;x<xc+xsize;x++)
		{
			y=yc;
			*buffer=getpt(hue,x,y);
			val=(*buffer>center_val)?low_color:high_color;
            if(val==*buffer) val=(*buffer>center_val)?high_color:low_color;
			buffer+=1;
			WritePixel(y,x,val);
		}
	if(ysize>2)
		for(y=yc+1;y<yc+ysize-1;y++)
		{
			x=xc+xsize-1;
			*buffer=getpt(hue,x,y);
			val=(*buffer>center_val)?low_color:high_color;
            if(val==*buffer) val=(*buffer>center_val)?high_color:low_color;
			buffer+=1;
			WritePixel(y,x,val);
		}
	if(xsize>1)
		for(x=xc;x<xc+xsize;x++)
		{
			y=yc+ysize-1;
			*buffer=getpt(hue,x,y);
			val=(*buffer>center_val)?low_color:high_color;
            if(val==*buffer) val=(*buffer>center_val)?high_color:low_color;
			buffer+=1;
			WritePixel(y,x,val);
		}
	if(ysize>2)
		for(y=yc+1;y<yc+ysize-1;y++)
		{
			x=xc;
			*buffer=getpt(hue,x,y);
			val=(*buffer>center_val)?low_color:high_color;
            if(val==*buffer) val=(*buffer>center_val)?high_color:low_color;
			buffer+=1;
			WritePixel(y,x,val);
		}
}




/********************************************************************
**
**	creates a box on color plane hue which can be erased by unbox()
**
********************************************************************* */

void tbox(hue,xc,yc,xsize,ysize,buffer)

int hue,xc,yc,xsize,ysize;
unsigned char *buffer;

{
	int x,y;
	unsigned char val;
	
	if(xsize<=1&&ysize<=1)
	{
		*buffer=getpt(hue,x,y);
		val=(*buffer<127)?243:3;
		WritePixel(y,x,val);
		return;
	}

	if(xsize>1)
		for(x=xc;x<xc+xsize;x++)
		{
			y=yc;
			*buffer=getpt(hue,x,y);
			val=(*buffer<127)?243:3;
			buffer+=1;
			WritePixel(y,x,val);
		}
	if(ysize>2)
		for(y=yc+1;y<yc+ysize-1;y++)
		{
			x=xc+xsize-1;
			*buffer=getpt(hue,x,y);
			val=(*buffer<127)?243:3;
			buffer+=1;
			WritePixel(y,x,val);
		}
	if(xsize>1)
		for(x=xc;x<xc+xsize;x++)
		{
			y=yc+ysize-1;
			*buffer=getpt(hue,x,y);
			val=(*buffer<127)?243:3;
			buffer+=1;
			WritePixel(y,x,val);
		}
	if(ysize>2)
		for(y=yc+1;y<yc+ysize-1;y++)
		{
			x=xc;
			*buffer=getpt(hue,x,y);
			val=(*buffer<127)?243:3;
			buffer+=1;
			WritePixel(y,x,val);
		}
}

/********************************************************************
**
**	find pixel values
**
********************************************************************* */

void pix_val(fx,fy)

int fx,fy;			/* starting point of cursor */

{

	int ans,size,speed,x,y,xo,yo,k;
	static unsigned char tbuff[200];

	speed=5;
	size=0;
	xo=x=fx;
	yo=y=fy;
	tcursor(3,x,y,5,tbuff);
	while((ans=getpad(&size,&x,&y,&speed,0))!=83)
	{
		uncursor(3,xo,yo,5,tbuff);
		tcursor(3,x,y,5,tbuff);
		xo=x;
		yo=y;
/*		if(ans==13)	
			printf("x = %3d  y = %3d     r = %3d  g = %3d  b = %3d  o = %3d\n",
				x,y,getpt(0,x,y),getpt(1,x,y),getpt(2,x,y),getpt(3,x,y));*/

	}
	uncursor(3,xo,yo,5,tbuff);
	return;
}


/********************************************************************
**  get_row reads a line segment from the video buffer into the
**  callers buffer
**
********************************************************************* */

void getrow(hue,x1,x2,y,buffer)

int hue;
unsigned char *buffer;
unsigned int x1;  /* beginning column to read             */
unsigned int x2;  /* ending column to read                */
unsigned int y ;  /* row to read                          */
{
	if(y<0||y>=ScreenYs)
		return;
	if(x1<0||x2>=ScreenXs||x1>x2)
		return;

	ReadLine(y,x1,y,x2,buffer);
}


/********************************************************************
**  get_row reads a line segment from the video buffer into the
**  callers buffer
**
********************************************************************* */

void paintcol(hue,x,y1,y2,val)

int hue;
int val;
unsigned int y1;  /* beginning row to read             */
unsigned int y2;  /* ending row to read                */
unsigned int x ;  /* column to read                          */
{
	DrawVector(y1,x,y2,x,val);
}


/********************************************************************
**
**	plot a row of data
**
********************************************************************* */

int plotrow(hue,x1,x2,y,buffer)

unsigned char *buffer;
int hue,x1,x2,y;

{
	int status=1;

	if(y<0||y>=ScreenYs)
		return(-1);
	if(x1<0||x2>=ScreenXs||x1>x2)
		return(-1);
	PlotLine(y,x1,y,x2,buffer);
	return(status);
}


/* ******************************************************************
**
**	plots a point at coordinates x and y with gun hue and brightness val
**
**	functions called: -- none
**
**	return:
**		 1 = point plotted
**		-1 = point not plotted
********************************************************************* */

int plotpt(hue,x,y,val)

int hue;	/* color plane -- 0-3 */
int x,y;	/* pixel coordinates */
int val;	/* brighness of pixel 0-255 */

{
	int status;
	
	status = -1;
	if(hue<0 || hue>3) return(status);
	if(val<0 || val >255) return(status);
	if(x<0||x>=ScreenXs) return(status);
	if(y<0||y>=ScreenYs) return(status);
	status = 1;
	WritePixel(y,x,val);
	return(status);
}



/* ******************************************************************
**
**	plots a string(hue,val,x,y,string,size) vertical
**
**	functions called:
**		plotpt();
**
********************************************************************* */

void plot_font_v(val,x,y,string,size,font)

int val;	/* brightness of redm green and blue */
int x,y;				/* location of upper right corner of 1st letter */
int size;				/* size 1 = full size  2 = 1/2 size  3 = 1/3 size */
char string[80];		/* text to plot */
int font[128][25];	/* binary font maps */

{
	int i,j,k,l,m,n;
	int mask;

	n = 0;
	while(string[n]!='\0'){
		for(l=0;l<25;l++){
			k = string[n];
			mask = 512;
			for(m=0;m<10;m++) 
			{
				if(font[k][l]&mask)
				{
					if(l%size == 0) 
						plotpt(0,x+l/size,y-m/size,val);

/*						WritePixel(y-m/size,x+l/size,val);*/
				}
				mask /= 2;
			}
		}
		n++;
		y -= 15/size;
	}
}

/* ******************************************************************
**
**	plots a string(hue,val,x,y,string,size) horizontal
**
**	functions called:
**		plotpt();
**
********************************************************************* */

void plot_font_h(val,x,y,string,size,font)

int val;					/* color to be plotted */
int x,y;					/* location of upper right corner of 1st letter */
int size;				/* size 1 = full size  2 = 1/2 size  3 = 1/3 size */
char *string;			/* text to plot */
int font[128][25];	/* binary font maps */

{
	int i,j,k,l,m,n;
	int mask;

	n = 0;
	while(string[n]!='\0')
	{
		for(l=0;l<25;l++)
		{
			k = string[n];
			mask = 512;
			for(m=0;m<10;m++) 
			{
				if(font[k][l]&mask) 
				{
					if(l%size == 0) 
					{
						plotpt(0,x+m/size,y+l/size,val);
/*						WritePixel(y+l/size,x+m/size,val);*/
					}
				}
				mask /= 2;
			}
		}
		n++;
		x += 15/size;
	}

}

/* ******************************************************************
**
**	plots a string(hue,val,x,y,string,size,rot) rotated rot degrees
**
**	functions called:
**		plotpt();
**
********************************************************************* */

int plot_font_rot(val,x,y,string,size,font,rot)

int val;					/* color to be plotted */
int x,y;					/* location of upper right corner of 1st letter */
int size;				/* size 1 = full size  2 = 1/2 size  3 = 1/3 size */
char *string;			/* text to plot */
int font[128][25];	/* binary font maps */
double rot;				/* rotation uo from horizontal (degrees) */

{
	int i,j,k,l,m,n;
	int mask;
	double dx=x,dy=y,dl,dm,dsize=size;
	double cosrot=cos(rot*DEG_RAD),sinrot=sin(rot*DEG_RAD);
	int ix,iy;
	
	n = 0;
	while(string[n]!='\0')
	{
		for(l=0;l<25;l++)
		{
			dl=l;
			k = string[n];
			mask = 512;
			for(m=0;m<10;m++) 
			{
				dm=m;
				if(font[k][l]&mask) 
				{
					ix=dx+dm/dsize*cosrot+dl/dsize*sinrot;
					iy=dy+dl/dsize*cosrot-dm/dsize*sinrot;
					plotpt(0,ix,iy,val);
/*					WritePixel(y+l/size,x+m/size,val);*/
				}
				mask /= 2;
			}
		}
		n++;
		dx+=15/dsize*cosrot;
		dy-=15/dsize*sinrot;
	}
}


/* ******************************************************************
**	
**	decodes 'font.raw' and makes 'font.hex'
**
**	functions called:
**		read();	requires -- <io.h>
**		open();              <fcntl.h> <sys\type.h> <sys\stat.h> 
**									<io.h> 
**		close();					<io.h>
**
********************************************************************* */
		
void decode_font(font)

int font[128][25];	/* binary font maps */

{
	int ffp;
	ffp = open("font.hex",O_RDONLY|O_BINARY);
	read(ffp,(char *)font,6400);
	close(ffp);
	Vimage_Save1=fopen("image1.sav","w+b");
	setbuf(Vimage_Save1,Vi_Inbuff1);
	Vimage_Save2=fopen("image2.sav","w+b");
	setbuf(Vimage_Save2,Vi_Inbuff2);
}

/* ******************************************************************
**	
**		sets input files for do_menu() etc.
**
********************************************************************* */
		
void set_files()

{
	Vimage_Save1=fopen("image1.sav","w+b");
	setbuf(Vimage_Save1,Vi_Inbuff1);
	Vimage_Save2=fopen("image2.sav","w+b");
	setbuf(Vimage_Save2,Vi_Inbuff2);
}


/***********************************************************************
**
**
**
**
************************************************************************/

int swap(a,b)

int *a,*b;

{
	int t;

	t=*a;
	*a=*b;
	*b=t;
}


/***********************************************************************
**
**
**
**
************************************************************************/

int plotln(hue,x1,y1,x2,y2,val)

int hue,x1,y1,x2,y2,val;

{
	int d,dx,dy;
	int a_incr,b_incr,y_incr,x_incr;
	int x,y;

	dx=abs(x2-x1);
	dy=abs(y2-y1);
	if(dx>dy)
	{
		if(x1>x2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(y2>y1)						/* determine increment for y */
			y_incr=1;
		else
			y_incr=-1;
		dx=x2-x1;						/* initialize constants */
		dy=abs(y2-y1);
		d=2*dy-dx;
		a_incr=2*(dy-dx);				/* initial x and y */
		b_incr=2*dy;
		x=x1;
		y=y1;
		plotpt(hue,x,y,val);			/* plot pixel */
		for(x=x1+1;x<=x2;x++)
		{
			if(d>=0)
			{
				y+=y_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			plotpt(hue,x,y,val);
		}
	}
	else
	{
		if(y1>y2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(x2>x1)						/* determine increment for y */
			x_incr=1;
		else
			x_incr=-1;
		dy=y2-y1;						/* initialize constants */
		dx=abs(x2-x1);
		d=2*dx-dy;
		a_incr=2*(dx-dy);				/* initial x and y */
		b_incr=2*dx;
		x=x1;
		y=y1;
		plotpt(hue,x,y,val);			/* plot pixel */
		for(y=y1+1;y<=y2;y++)
		{
			if(d>=0)
			{
				x+=x_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			plotpt(hue,x,y,val);
		}
	}
}


/* ******************************************************************
**
**	draw a line on the image and save data destroyed in buffer
**
**	returns the number of points ploted
**
********************************************************************* */

int tplotln_val(hue,x1,y1,x2,y2,buffer,val)

int hue;	/* image plane */
int x1,y1;	/* coordinates of 1st point */
int x2,y2;	/* coordinates of 2nd point */
unsigned char *buffer;
int val;

{
	int numpts=0;
	int d,dx,dy;
	int a_incr,b_incr,y_incr,x_incr;
	int x,y;

	dx=abs(x2-x1);
	dy=abs(y2-y1);
	if(dx>dy)
	{
		if(x1>x2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(y2>y1)						/* determine increment for y */
			y_incr=1;
		else
			y_incr=-1;
		dx=x2-x1;						/* initialize constants */
		dy=abs(y2-y1);
		d=2*dy-dx;
		a_incr=2*(dy-dx);				/* initial x and y */
		b_incr=2*dy;
		x=x1;
		y=y1;
		if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
		{
			*buffer++=getpt(hue,x,y);
			numpts+=1;
			plotpt(hue,x,y,val);			/* plot pixel */
		}
		for(x=x1+1;x<=x2;x++)
		{
			if(d>=0)
			{
				y+=y_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
			{
				*buffer++=getpt(hue,x,y);
				numpts+=1;
				plotpt(hue,x,y,val);			/* plot pixel */
			}
		}
	}
	else
	{
		if(y1>y2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(x2>x1)						/* determine increment for y */
			x_incr=1;
		else
			x_incr=-1;
		dy=y2-y1;						/* initialize constants */
		dx=abs(x2-x1);
		d=2*dx-dy;
		a_incr=2*(dx-dy);				/* initial x and y */
		b_incr=2*dx;
		x=x1;
		y=y1;
		if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
		{
			*buffer++=getpt(hue,x,y);
			numpts+=1;
			plotpt(hue,x,y,val);			/* plot pixel */
		}
		for(y=y1+1;y<=y2;y++)
		{
			if(d>=0)
			{
				x+=x_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
			{
				*buffer++=getpt(hue,x,y);
				numpts+=1;
				plotpt(hue,x,y,val);			/* plot pixel */
			}
		}
	}
	return(numpts);
}

/* ******************************************************************
**
**	draw a line on the image and save data destroyed in buffer
**
**	returns the number of points ploted
**
********************************************************************* */

int tplotln_inv_dot(hue,x1,y1,x2,y2,buffer,dot)

int hue;	/* image plane */
int x1,y1;	/* coordinates of 1st point */
int x2,y2;	/* coordinates of 2nd point */
unsigned char *buffer;
int dot;

{
	int numpts=0;
	int d,dx,dy;
	int a_incr,b_incr,y_incr,x_incr;
	int x,y,val;

	dx=abs(x2-x1);
	dy=abs(y2-y1);
	if(dx>dy)
	{
		if(x1>x2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(y2>y1)						/* determine increment for y */
			y_incr=1;
		else
			y_incr=-1;
		dx=x2-x1;						/* initialize constants */
		dy=abs(y2-y1);
		d=2*dy-dx;
		a_incr=2*(dy-dx);				/* initial x and y */
		b_incr=2*dy;
		x=x1;
		y=y1;
		if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenXs)
		{
			*buffer++=val=getpt(hue,x,y);
			numpts+=1;
			if(val>128)
				val==0;
			else
				val=225;
			plotpt(hue,x,y,val);			/* plot pixel */
		}
		for(x=x1+1;x<=x2;x++)
		{
			if(d>=0)
			{
				y+=y_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
			{
				*buffer++=val=getpt(hue,x,y);
				numpts+=1;
				if(val>128)
					val==0;
				else
					val=225;
				plotpt(hue,x,y,val);			/* plot pixel */
			}
		}
	}
	else
	{
		if(y1>y2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(x2>x1)						/* determine increment for y */
			x_incr=1;
		else
			x_incr=-1;
		dy=y2-y1;						/* initialize constants */
		dx=abs(x2-x1);
		d=2*dx-dy;
		a_incr=2*(dx-dy);				/* initial x and y */
		b_incr=2*dx;
		x=x1;
		y=y1;
		if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
		{
			*buffer++=val=getpt(hue,x,y);
			numpts+=1;
			if(val>128)
				val==0;
			else
				val=225;
			plotpt(hue,x,y,val);			/* plot pixel */
		}
		for(y=y1+1;y<=y2;y++)
		{
			if(d>=0)
			{
				x+=x_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
			{
				*buffer++=val=getpt(hue,x,y);
				numpts+=1;
				if(val>128)
					val==0;
				else
					val=225;
				plotpt(hue,x,y,val);			/* plot pixel */
			}
		}
	}
	return(numpts);
}

/* ******************************************************************
**
**	removes a line drawn with tplot_val()
**
********************************************************************* */

int unplotln(hue,x1,y1,x2,y2,buffer)

int hue;	/* image plane */
int x1,y1;	/* coordinates of 1st point */
int x2,y2;	/* coordinates of 2nd point */
unsigned char *buffer;

{
	int numpts=0;
	int d,dx,dy;
	int a_incr,b_incr,y_incr,x_incr;
	int x,y;

	dx=abs(x2-x1);
	dy=abs(y2-y1);
	if(dx>dy)
	{
		if(x1>x2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(y2>y1)						/* determine increment for y */
			y_incr=1;
		else
			y_incr=-1;
		dx=x2-x1;						/* initialize constants */
		dy=abs(y2-y1);
		d=2*dy-dx;
		a_incr=2*(dy-dx);				/* initial x and y */
		b_incr=2*dy;
		x=x1;
		y=y1;
		if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
			plotpt(hue,x,y,*buffer++);
		for(x=x1+1;x<=x2;x++)
		{
			if(d>=0)
			{
				y+=y_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
				plotpt(hue,x,y,*buffer++);
		}
	}
	else
	{
		if(y1>y2)
		{
			swap(&x1,&x2);
			swap(&y1,&y2);
		}
		if(x2>x1)						/* determine increment for y */
			x_incr=1;
		else
			x_incr=-1;
		dy=y2-y1;						/* initialize constants */
		dx=abs(x2-x1);
		d=2*dx-dy;
		a_incr=2*(dx-dy);				/* initial x and y */
		b_incr=2*dx;
		x=x1;
		y=y1;
		if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
			plotpt(hue,x,y,*buffer++);
		for(y=y1+1;y<=y2;y++)
		{
			if(d>=0)
			{
				x+=x_incr;
				d+=a_incr;
			}
			else
				d+=b_incr;
			if(x>=0&&x<ScreenXs&&y>=0&&y<ScreenYs)
				plotpt(hue,x,y,*buffer++);
		}
	}
}


/* ******************************************************************
**
**	draw a line on the image
**
********************************************************************* */

int plotln_val(hue,x1,y1,x2,y2,high,low,center,first)

int hue;	/* image plane */
int x1,y1;	/* coordinates of 1st point */
int x2,y2;	/* coordinates of 2nd point */
int high,low,center;	/* brightness of line */
int first;

{

	int   i, j, k, numx, numy,val;
	float x, y, dy, dx;

/*	DrawVector(y1,x1,y2,x2,val);*/

	numx = ( x2 > x1 ) ? x2-x1 : x1-x2;
	numy = ( y2 > y1 ) ? y2-y1 : y1-y2;
	if(numx==0 && numy==0) return(0);
	if( numx>numy ) 
	{
		dy = (float)(y2-y1)/(float)(x2-x1);
		dx = (x2>x1) ? 1.0 : -1.0;
		i = x = x1;
		j = y = y1;
		for(k=0;k<=(numx);k++)
		{
			val=(getpt(0,i,j)<center)?low:high;
			if(k>=first)
				plotpt(3,i,j,val);
			x += dx;
			y += dy*dx;
			if(dy>=0.0)
			{
				i = x;
				j = y;
			}
			else
			{
				i = x;
				j = y+0.5;
			}
		}
	}
	else{
		dx = (float)(x2-x1)/(float)(y2-y1);
		dy = (y2>y1) ? 1.0 : -1.0;
		i = x = x1;
		j = y = y1;
		for(k=0;k<=(numy);k++)
		{
			val=(getpt(0,i,j)<center)?low:high;
			if(k>=first)
				plotpt(3,i,j,val);
			x += dx*dy;
			y += dy;
			if(dx>=0.0)
			{
				i = x;
				j = y;
			}
			else
			{
				i = x+0.5;
				j = y;
			}
		}
	}
}



/* ******************************************************************
**
**	draws a box of brightness 'val' at 'xc,yc' size 'size'
**
**	functions called: 
**		plotpt();
**
**
********************************************************************* */

void box(hue,xc,yc,val,xsize,ysize)

int hue;	/* image plane */
int xc,yc;	/* coordinates of box upper left corner */
int val;	/* brightness of box */
int xsize,ysize;	/* length of sides */

{
	int i,j,k,y1,y2,x1,x2;
	
	y1 = yc;
	y2 = yc+ysize;
	x1 = xc;
	x2 = xc+xsize;

	for(i=y1;i<=y2;i++)
	{
		plotpt(3,x1,i,val);
		plotpt(3,x2,i,val);
	}
	for(i=x1;i<=x2;i++)
	{
		plotpt(3,i,y1,val);
		plotpt(3,i,y2,val);
	}
}


/* ******************************************************************
**
**	draws a cursor (usually hue = 3)
**
**	functions called:
**		plotpt();
**
********************************************************************* */

void cursor(hue,x,y,val,size)

int hue;	/* image plane */
int x,y;	/* cursor center coordinates */
int val;	/* brightness of cursor */
int size;	/* length of arms */

{
	int i,j;

	for(i=y-size;i<=y+size;i++)
		if(i!=y)
			plotpt(hue,x,i,val);
	for(j=x-size;j<=x+size;j++)
		if(j!=x)
			plotpt(hue,j,y,val);
}

/* ******************************************************************
**
**	draws a cursor and puts points removed in buff
**
**	returns number of points removed
**
**	functions called:
**		plotpt();
**		getpt();
**
********************************************************************* */

int tcursor(hue,x,y,size,buff)

int hue;	/* image plane */
int x,y;	/* cursor center coordinates */
int size;	/* length of arms */
unsigned char *buff;	/* points removed */

{
	int i,j,num=0,val;

	if(hue==3)
	{
		for(i=y-size;i<=y+size;i++)
			if(i>=0&&i<ScreenYs&&i!=y) 
			{
				buff[num]=getpt(hue,x,i);
				val=(buff[num++]%128>64)?V_dark:V_light;
				WritePixel(i,x,val);
			}
		for(j=x-size;j<=x+size;j++)
			if(j>=0&&j<ScreenXs&&j!=x) 
			{
				buff[num]=getpt(hue,j,y);
				val=(buff[num++]%128>64)?V_dark:V_light;
				WritePixel(y,j,val);
			}
	}
	else
	{
		for(i=y-size;i<=y+size;i++)
			if(i>=0&&i<ScreenYs&&i!=y) 
			{
				buff[num]=getpt(hue,x,i);
				val=(buff[num++]>128)?V_dark:V_light;
				WritePixel(i,x,val);
			}
		for(j=x-size;j<=x+size;j++)
			if(j>=0&&j<ScreenXs&&j!=x) 
			{
				buff[num]=getpt(hue,j,y);
				val=(buff[num++]>128)?V_dark:V_light;
				WritePixel(y,j,val);
			}
	}
	if(V_cursor>0)
		cursor(0,x,y,V_cursor,size);
	return(num);
}


/* ******************************************************************
**
**	draws a cursor and puts points removed in buff
**
**	returns number of points removed
**
**	functions called:
**		plotpt();
**		getpt();
**
********************************************************************* */

int tcursor_val(hue,x,y,size,buff,low_color,high_color,center_val)

int hue;	/* image plane */
int x,y;	/* cursor center coordinates */
int size;	/* length of arms */
int low_color,high_color,center_val;
unsigned char *buff;	/* points removed */

{
	int i,j,num=0,val;

	for(i=y-size;i<=y+size;i++)
		if(i>=0&&i<ScreenYs&&i!=y) 
		{
			buff[num]=getpt(hue,x,i);
			val=(buff[num++]>center_val)?low_color:high_color;
			WritePixel(i,x,val);
		}
	for(j=x-size;j<=x+size;j++)
		if(j>=0&&j<ScreenXs&&j!=x) 
		{
			buff[num]=getpt(hue,j,y);
			val=(buff[num++]>center_val)?low_color:high_color;
			WritePixel(y,j,val);
		}
	return(num);
}

/* ******************************************************************
**
**	undraws a cursor using the points removed in buff
**
**	functions called:
**		plotpt();
**
********************************************************************* */

void uncursor(hue,x,y,size,buff)

int hue;	/* image plane */
int x,y;	/* cursor center coordinates */
int size;	/* length of arms */
unsigned char *buff;	/* points removed */

{
	int i,j,num=0;

	for(i=y-size;i<=y+size;i++)
		if(i>=0&&i<ScreenYs&&i!=y) 
			WritePixel(i,x,*buff++);
	for(j=x-size;j<=x+size;j++)
		if(j>=0&&j<ScreenXs&&j!=x)
			WritePixel(y,j,*buff++);
}


/* ******************************************************************
**
**	fills in color plane 'hue'
**
**	functions called:
**		plotpt();
**		getpt();
**		printf();  requires --  <stdio.h>
**		scanf();						<stdio.h>
**
******************************************************************** */

int fillin(hue,minn,x1,x2,y1,y2)

int hue;	/* color plane -- 0-3 */
int minn;	/* minimum number of vlaues used to fill */
int x1,x2,y1,y2;	/* portion of image to fill */

{

	int num, sum, row, col, subrow, subcol;
	int val;
	int numfld; /* number filled in */

	char misng = 0;			/* missing data value */
	char minnbr;			/* min number of neighbors needed to compute */

	numfld = 0;
	num = 0;

	if( minn == 0 ) {
/*		printf("%s\n",
		"Give minimum number of neigbors to use for filling. ( recomend 5 )");*/
		scanf("%d",&minnbr);
/*		printf("\n%s%d\n","Using minimum neighbors = ",minnbr);*/
	}
	else {
		minnbr = minn;
	}	

	paint(3,0);
	for( row = y1; row <= y2; row++ ){
		for( col = x1; col <= x2; col++ ){
			val = getpt(hue,col,row);
			if( val == misng ){
				num = 0;
				sum = 0;
				for( subrow = row-1; subrow <= row + 1; subrow++){
					if( subrow >= y1 && subrow <= y2 ) {
						for( subcol = col-1; subcol <= col + 1; subcol++){
							if( subcol >= x1 && subcol <= x2 ) {
								val = getpt(hue,subcol,subrow);
								if( val != misng && (getpt(3,subcol,subrow)) != 255 ){
									num += 1;
									sum += val;
								}
							}				
						}
					}
				}
				if( num >= minnbr ){
					val = sum / num;
					WritePixel(row,col,val);
					WritePixel(row,col,255);
					numfld += 1;
				}
			}
		}
	}
	paint(3,0);
	return(numfld);
}	


/* ******************************************************************
**
** 	paints color plane 'hue' with value 'val' 
**
**	functions called: -- none
**
**	returns: 1  = painted
**				-1 = illegal hue
**
********************************************************************* */

int paint(hue,val)

int hue;	/* color plane -- 0-3 */
int val;	/* brighness of pixel 0-255 */

{

	char far *bankSelect = (char far *) BANK_SEL;
	unsigned i;				/* loop counter */
	int j;					/* buffer counter */
	int far *dispBuff = (int far *) DISP_BUFF;
	int status;

	status = -1;
	if(hue<0 || hue>3) return(status);
	status = 1;

	val += val*256;
	for ( j = hue*4; j <= hue*4+3; j++ ) {
		*bankSelect = j;
		for ( i = 0; i < NWORDS; i++ ) {
			*dispBuff++ = val;
		}
	}
	return(status);
}


/* ******************************************************************
**
**	gets val at coordinates x and y with gun hue
**
**	functions called: -- none
**
********************************************************************* */

unsigned char getpt(hue,x,y)

int hue;	/* color plane -- 0-3 */
int x,y;	/* pixel coordinates */

{
	int val;
	unsigned char cval;

	if(x<0||x>=ScreenXs||y<0||y>=ScreenYs)
		return(0);
    cval=ReadPixel(y,x);
/*    cval=val;*/
	return (cval);
}


/* ******************************************************************
**
**	define output file
**
**	functions called:
**		creat();  requires -- <sys\types.h> <sys\stat.h> <io.h>
**		printf();				<stdio.h>
**		scanf();					<stdio.h>
**
********************************************************************* */

int file_w(fnameout)

char fnameout[40];

{
	int fp;	/* file handle */
/*	printf("\n%s\n","Give name of output file.");*/
	scanf("%s",fnameout);

	fp = creat(fnameout,0777);
	return(fp);
}


/* ******************************************************************
**
**	define input file
**
**	functions called:
**		open();  requires -- <fcntl.h> <sys\type.h> <sys\stat.h> 
**									<io.h> <stdlib.h> <errno.h>
**		printf();				<stdio.h>
**		scanf();					<stdio.h>
**
********************************************************************* */

int file_r(fnamein)

char fnamein[40];

{
	int fp;		/* file handle */

/*	printf("\n%s\n","Give name of input file.");*/
	scanf("%s",fnamein);

	while( (fp = open(fnamein,O_RDONLY|O_BINARY)) == 0) {
		if(errno == EACCES) {
			printf("Given path name is a directory; or an attempt was\n");
			printf("made to open a read-only file for writing; or a shar-\n ");
			printf("ing violation occured (the file's sharing mode does\n ");
			printf("not allow the specific operations; MS-DOS Version 3.0\n");
			printf("or later only.\n ");
		}
		if(errno == EEXIST) {
			printf("the O_CREAT and O_EXCL flags are specified \n");
			printf("but the named file already exists.\n ");
		}
		if(errno == EMFILE) {
			printf("No more file handles available (too many open\n ");
			printf("files)\n ");
		}
		if(errno == ENOENT) {
			printf("File or path name not found. \n");
		}
		printf("%s is not a valid file name.  Please try again.\n\n",fnamein);
		printf("\n%s\n","Give name of input file.");
		scanf("%s",fnamein);
	}
	return(fp);
}

/*********************************************************************
**
**	reads the number pad and changes values
**
********************************************************************* */
 
char getpad(size,x,y,speed,menu)

int *size,*x,*y;
int *speed,menu;	/* menu = 1 -- menu else no menu */

{
    int row,col,right,left,right_down,left_down;
/*    char ans,ans2;*/
    int ans;
    char ans2;
	menu=0;
	
/*    ans=getch();*/
    mouse_move_cursor(*y,*x);
    do
    {
        ans=mouse_information(&right,&left,&row,&col);
    }while(ans==0&&row==*y&&col==*x&&left==0&&right==0);
    if(left!=0||right!=0)
    {
        do
        {
            mouse_information(&right_down,&left_down,&row,&col);
            if(right_down!=0) right=right_down;
            if(left_down!=0) left=left_down;
        }while(right_down!=0||left_down!=0);
    }
    if(ans==0)
    {
        if(left!=0) ans=13;
        if(right!=0) ans=27;
        *x=col;
        *y=row;
    }
    ans2=ans;
/*    if(ans==0)*/
    if(ans>255)
	{
        ans/=256;
        ans2=ans;
/*        ans2=getch();*/
		if(ans2==59)
			return(ans2);
		if(ans2==71||ans2==72||ans2==73)
			*y-=*speed;
		if(ans2==79||ans2==80||ans2==81)
			*y+=*speed;
		if(ans2==71||ans2==75||ans2==79)
			*x-=*speed;
		if(ans2==73||ans2==77||ans2==81)
			*x+=*speed;
		if(*x<0)
			*x=0;
		if(*x>=ScreenXs)
			*x=ScreenXs-1;
		if(*y<0)
			*y=0;
		if(*y>=ScreenYs)
			*y=ScreenYs-1;
        ans2=0;
	}
    if(ans2=='+'&&*speed<ScreenYs/4)
		*speed*=2;
    if(ans2=='-'&&*speed>1)
		*speed/=2;
    return(ans2);
}
/***********************************************************************
**
**  This subroutine plots a solid line between points (x1,y1) and
**  (x2,y2).
**
**  USAGE:  plotln(x1,y1,x2,y2,color)
**
**  (x1,y1) = xy-coordinates of the starting point
**  (x2,y2) = xy-coordinates of the ending point
**      color = the integer value of the color to be used
**
**  NOTE:   The x-coordinate refers to the horizontal direction (pixel) and
**              zero is at the left side of the screen.
**          The y-coordinate refers to the vertical direction (scanline) and
**              zero is at the top of the screen.
**
************************************************************************/

int DrawVector(y1,x1,y2,x2,color)

int x1,y1,x2,y2,color;

{
    if( color<0 || color>255 )
        return -1;
    fg_setcolor(color);
    fg_move(x1,y1);
    fg_draw(x2,y2);
    return 0;
}
/********************************************************************
**
**      This subroutine returns the color of the image at a selected
**      Pixel.
**
**      USAGE: i = getpt(x,y)
**
**      (x,y) = xy-coordinates of the selected pixel in screen coordinates
**
**      NOTE:  Depends on the externally defined size of the screen
**              Screenxs and ScreenYs (integers)
**
**      REMINDER:
**      The x-coordinate refers to the horizontal directions and zero
**          is on the left side of the screen.
**      The y-coordinate refers to the vertical directions and zero
**          is at the top the screen.
**
********************************************************************* */

int ReadPixel(y,x)

int x,y;        /* pixel coordinates */

{
    int color;

    if(x<0||x>=ScreenXs||y<0||y>=ScreenYs)
        return(0);
    color = fg_getpixel(x,y);
    return (color);
}
/*******************************************************************
**
**      This subroutine writes a specified color pixel.
**
**      USAGE:  i = plotpt(x,y,color)
**
**      (x,y) = xy-coordinates where color is to be plotted
**      color = integer value of the color to be used
**
**      returns:
**               1 = point plotted
**              -1 = point not plotted
********************************************************************* */

int WritePixel(y,x,color)

int x,y;        /* pixel coordinates */
int color;        /* Pixel color 0-255 */

{
    int status=-1;
    
    if(color<0 || color >255) return(status);
    if(x<0||x>=ScreenXs) return(status);
    if(y<0||y>=ScreenYs) return(status);
    fg_setcolor(color);
    status = 1;
    fg_point(x,y);
    return(status);
}
/********************************************************************
**
**      This subroutine reads a row of screen image data and stores
**      it in the supplied scanline.
**
**      USAGE:  i = getrow(x1,x2,y,&scanline)
**
**        x1 = starting x-coordinate
**        x2 = ending x-coordinate
**         y = y-coordinate of the row to be read
**  scanline = the buffer where the data are to be stored    
**
**      NOTE:  Depends on the externally defined size of the screen
**              Screenxs and ScreenYs (integers)
**
**      REMINDER:
**      The x-coordinate refers to the horizontal directions and zero
**          is on the left side of the screen.
**      The y-coordinate refers to the vertical directions and zero
**          is at the top the screen.
**
********************************************************************* */

int ReadLine(y,x1,y,x2,scanline)

unsigned char *scanline;
int x1;  /* beginning column to read             */
int x2;  /* ending column to read                */
int y ;  /* row to read                          */
{
    int npixel, status = 0;
    if(y<0||y>=ScreenYs)
        return (-1);
    if(x1<0||x2>=ScreenXs||x1>x2)
        return (-1);
    npixel = x2 - x1 + 1;
    fg_move(x1,y);
    fg_getimage(scanline,npixel,1);
    return(status);
}
/********************************************************************
**
**      This subroutine writes a single scanline of an image
**      to the screen.
**
**      USAGE: i = plotrow(x1,x2,y,scanline)
**
**      (x1,y) = the starting xy-coordinates for the scanline
**      (x2,y) = the ending xy-coordinates for the scanline
**    scanline = character array containing the data
**
**      NOTE:  Depends on the externally defined size of the screen
**              Screenxs and ScreenYs (integers)
**
**      REMINDER:
**      The x-coordinate refers to the horizontal directions and zero
**          is on the left side of the screen.
**      The y-coordinate refers to the vertical directions and zero
**          is at the top the screen.
**
********************************************************************* */

int PlotLine(y,x1,y,x2,scanline)

int x1,x2,y;
unsigned char *scanline;

{
    int ncol,status=0;  

    if(y<0||y>=ScreenYs)
        return(-1);
    if(x1<0||x2>=ScreenXs||x2>x2)
        return(-1);
    fg_move(x1,y);
    ncol = x2 - x1 + 1;
    fg_putimage(scanline,ncol,1);
    return(status);
}

    
