/*
    pfhelp.c - help file browser

    If pfhelp.exe and browse.exe are in the directory \pf\bin,
    the help files with the suffix .hlp must be in the
    directory \pf\help.

    compile: cl /AL pfhelp.c getfile3

    Jeff Phillips 8/30/94
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>
#include "nomouse.h"

#define TRUE  1

int Mouse=0;

void main(int argc, char **argv)
{
    char *df,dfile[80],efile[80],name[100];
    int num;

    df = strrchr(argv[0],'\\');
    if(df != NULL)
    {
        num = df - argv[0] + 1;
        strncpy(efile,argv[0],num);
        efile[num] = '\0';
        strcat(efile,"browse.exe");
    }
    else
        strcpy(efile,"browse.exe");

    if(df != NULL)
    {
        num = df - argv[0] + 1;
        while (TRUE)
        {
             strncpy(dfile,argv[0],num);
             dfile[num-4] = '\0';
             strcat(dfile,"help\\");
             if(argv[1] == NULL)
             {
                 strcat(dfile,"*.hlp");
                 ClearScreen(3);
                 SetCursor(0,0);
                 printf("PFHELP - help file viewer for\n\n");
                 printf("  U.S. GEOLOGICAL SURVEY\n");
                 printf("  Potential Field Programs\n\n");
                 printf("Select file using up/down arrow\n");
                 printf("  keys and <Enter> key, or type\n");
                 printf("  first few characters of name \n");
                 printf("  and hit <Enter> key twice.\n\n");
                 printf("Hit <Esc> key to exit.\n");
                 if(get_file_name(dfile,name,0) >= 0)
                 {
                     if(_spawnl( _P_WAIT, efile, efile, name, NULL ) == -1)
                     {
                        printf("%s not found\n",efile);
                        exit(0);
                     }
                 }
                 else
                 {
                     ClearScreen(7);
                     SetCursor(0,0);
                     exit(0);
                 }

             }
             else
             {
                 strcat(dfile,argv[1]);
                 strcat(dfile,".hlp");
                 if(_spawnl( _P_WAIT, efile, efile, dfile, NULL ) == -1)
                 {
                    printf("%s not found\n",efile);
                    exit(0);
                 }
             }
             argv[1] = NULL;
        }
    }
}
