#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <dos.h>
#include <malloc.h>
#include "mouseg.h"

#define MAX_NUM 300
#define PAUSE printf("HIT ANY KEY TO CONTINUE.\n");getch()
#define SCREEN_WIDTH 160
#define EQLIST 0x410
#define MEMSIZ 0x413
#define NAME_SIZE 100
#define S_SIZE 40
#define F_SIZE 20
#define T_SIZE 15
#define MAX_WIDE 256
#define MAX_LINE 10000

struct file_id
{
	char name[S_SIZE];
	long size;
	unsigned date,time;
};
extern struct file_id GF_File[];
extern FILE *Fpout;
char Lstr[MAX_WIDE];
/***********************************************************************
**		bit map of colors
*
**		F B B B R T T T
**
**		F = flash  0 = OFF  1 = ON
**		B = Background Color
**		R = Brightness 0 = Dark  1 = Bright
**		T = Text Color
**
**		0 = black
**		1 = blue
**		2 = green
**		3 = cyan
**		4 = red
**		5 = magenta
**		6 = yellow
**		7 = white
**
************************************************************************/

int A_Int=0x3f;
int A_Reverse=0x78,A_Black=0x07;
int A_Brite=0x13,A_Norm=0x70;
int A_Flash=0xcf;
int X1=0,X2=79,Y1=1,Y2=22;
extern unsigned char far *Video_Buffer[4];
int Monitor;

int Char1=0;
union REGS regs;
struct equipment
{
	int printers; 		/* number present */
	int sprinter;		/* serial printer installed?  0=no  1=yes */
	int game;			/* game adapter installed? */
	int sports;			/* number of serial ports */
	int dma;				/* DMA chip installed? */
	int drives;			/* number of disk drives */
	int video;			/* video mode 1=40 color 2=80 color 3=80 B/W */
	int disk;			/* any disk drives? */
	int memory;			/* memory size in Kbytes */
}Eq;

char *Help1[20]=
{
"  h or H or F1 -- Help Screens                                               ",
"            F2 -- Search for Character String (case independent)             ",
"                  Type string and hit 'Enter' or F2 again                    ",
"                  Hitting F2 twice will search for same string again         ",
"       Ctrl F2 -- Search for Character String (case sensitive)               ",
"            F4 -- Print file to printer                                      ",
"            F5 -- Prints one long line on the screen (tries not to cut words)",
"            F6 -- Search for image names in square brackets, e.g. [fig_1]    ",
"          Home -- Positions highlight to top of file                         ",
"           End -- Positions highlight to bottom of file                      ",
"                                                                             ",
"         Pg Up -- If Highlight at top Moves up one screen in file            ",
"                  Else -- Moves Highlighted line to top of screen            ",
"    Ctrl Pg Up -- Moves up to top of next text page;  looks for end of page  ",
"                  or form feeds in file.                                     ",
"         Pg Dn -- If Highlight at bottom -- Moves down one screen in file    ",
"                  Else -- Moves Highlight to bottom of screen                ",
"    Ctrl Pg Dn -- Moves down to top of next text page;  looks for end of page",
"                  or form feeds in file.                                     ",
"         <<<< HIT ANY KEY TO CONTINUE HELP -- 'Esc' TO QUIT HELP >>>>        "
};
char *Help2[20]=
{
"          -->  -- Scrolls text window 5 characters to the right              ",
"     Ctrl -->  -- Scrolls text window to end of highlighted line             ",
"          <--  -- Scrolls text window 5 characters to the left               ",
"     Ctrl <--  -- Scrolls text window to beginning of highlighted line       ",
"     Up Arrow  -- Moves highlight up one line;  scrolls if necessary         ",
"     Up Arrow  -- Moves highlight down one line;  scrolls if necessary       ",
"      'Enter'  -- Exits file                                                 ",
"        'Esc'  -- Exits file                                                 ",
"                                                                             ",
"INFORMATION DISPLAYED ON SCREEN:                                             ",
"Upper Left Corner:                                                           ",
"   file: -- The name of the file being veiwed.                               ",
"Lower Right Corner:                                                          ",
"    char -- The number of the first (leftmost) character displayed.  If not 1",
"            the screen is scrolled right.                                    ",
"    line -- The line number in the file of the highlighted line.             ",
"                                                                             ",
"                                                                             ",
"              <<<<  HIT ANY KEY TO RETURN TO DOCUMENT >>>>                   ",
"                                                                             "
};
long *Line_Offset;
int *StrLen;
char *TV_Buffer[24];
long Max_Line;

int Monitor;
int Page=0xc;

void SetCursor(int,int);
void ClearScreen(int);
void ClearBox();
void WriteStringAtxy();
void ScrollUp();
void ScrollDown();
void DoubleBox();
int load_File();
int check_equip();
int scroll_list();
int search(char *word,int *cx,int *cy,int y1,int y2,int x1, int x2,
		FILE *fp,int *n1,int *n2,int numline,int maxline,int start,int iop,
		char *message);
int look_at_image(char *word,int x1,int x2,int y1,int y2,FILE *fp,
		int l1,int l2,int cy);
int make_bpt(FILE *fp,FILE *fpbpt,char *name,char *message,char *filename,
			int x1,int x2,int y1,int y2,int n1,int n2,int cy,int xs,int ys);

/***********************************************************************
**
**
**
**
************************************************************************/

int text_view(char *string,long max_line)

{
	int i,j,k;
	int wildcard=0;
	char message[100],filename[100];
	FILE *fp;

	Max_Line=max_line;
	for(i=0;i<24;i++)
	{
		TV_Buffer[i]=(char *)calloc(MAX_WIDE,sizeof(char));
		if(TV_Buffer[i]==NULL)
		{
			printf(
			"at i = %d   Not enough space for screen buffer to be loaded.\n\n",i);
			exit(0);
		}
	}
	Line_Offset=(long *)malloc(Max_Line*sizeof(long));
	if(Line_Offset==NULL)
	{
		printf(
		"Not enough space for line pointers to be loaded.\n\n",i);
		for(i=0;i<24;i++)
			free(TV_Buffer[i]);
		exit(0);
	}
	StrLen=(int *)calloc(Max_Line,sizeof(long));
	if(StrLen==NULL)
	{
		printf(
		"Not enough space for string lengths to be loaded.\n\n",i);
		for(i=0;i<24;i++)
			free(TV_Buffer[i]);
		free(Line_Offset);
		exit(0);
	}
	for(i=0;i<strlen(string);i++)
		if(string[i]=='*'||string[i]=='?')
		{
			wildcard=1;
			break;
		}
	if(wildcard>0)
	{
		if(get_file_name(string,filename)>=0)		
		{
			sprintf(message,"file:  %s",filename);
			scan_text(filename,message,0xc);	
		}
		else
			printf("Could not find any '%s' files\n\n",string);
	}
	else
	{
		fp=fopen(string,"rb");
		if(fp)
		{
			fclose(fp);
			sprintf(message,"file:  %s",string);
			if(scan_text(string,message,0xc)<0)
				printf("Could not open '%s'\n\n",string);
		}
		else
			printf("Could not open '%s'\n\n",string);
	}
	for(i=0;i<24;i++)
		free(TV_Buffer[i]);
	free(Line_Offset);
	free(StrLen);
}


/**************************************************************************
**
**
**
**
***************************************************************************/

int scan_text(filename,message,page)

char *filename,*message;

{
	int i,j,k;
	char string[100],lookfor[100];
	int x1=X1,x2=X2,y1=Y1,y2=Y2;

	Page=page;
	Monitor=check_equip(&Eq);
	if(Monitor==2)
		A_Brite=0x1b;
	ClearScreen(A_Norm);
	DoubleBox(x1,x2,y1,y2,A_Norm);
	WriteStringAtxy(0,0,80,A_Int,message);
	WriteStringAtxy(0,y2+1,80,A_Int,
"Home, End, PgUp, PgDn, Ctrl PgUp, Ctrl PgDn and up & down arrows to move:");
	WriteStringAtxy(0,y2+2,80,A_Int,
		"arrows=scroll, F2=search, F1=Help or Esc to exit");
	if(display_text(x1,x2,y1,y2,filename,message)<0)
		return(-1);
	ClearScreen(A_Black);
	SetCursor(0,0);
}


/**************************************************************************
**
**
**
**
***************************************************************************/

int display_text(x1,x2,y1,y2,filename,message)

int x1,x2,y1,y2;
char *filename,*message;

{
	int i,j,k,l=0;
	long numline=0;
	int cy=y1+1,cx=x1+1,val;
	FILE *fp,*fpout;
	FILE *fpbpt;		/* browse pointers */
	char string[MAX_WIDE],string2[50],word[100],name[100];
	unsigned char ans,ans2;
	int xs=x2-x1-1,ys=y2-y1-1,len;
	int n1=0,n2=ys-1,n;
	int maxline=ys,attrib;
	int speed=5,textwide=x2-x1-1,start=0;
	long offset;
	unsigned date,time;

	word[0]='\0';
	fp=fopen(filename,"rt");
	if(!fp)
		return(-1);
	strcpy(name,filename);
	for(k=0;k<strlen(name);k++)
		if(name[k]=='.')
			name[k]='\0';
	sprintf(string,"%s.bpt",name);
	sprintf(string2,"Searching for pointers",
		Char1+1,n1+(cy-(y1+1))+1);
	WriteStringAtxy(50,y2+2,0,A_Flash,string2);
	fpbpt=fopen(string,"rb");
	if(!fpbpt)	/* no browse pointer file present */
	{
		numline=make_bpt(fp,fpbpt,name,message,filename,
									x1,x2,y1,y2,n1,n2,cy,xs,ys);
	}
	else
	{
		sprintf(string2,"   Loading pointers   ",
			Char1+1,n1+(cy-(y1+1))+1);
		WriteStringAtxy(50,y2+2,0,A_Flash,string2);
		load_names(filename);
		fread((char *)&date,sizeof(int),1,fpbpt);
		fread((char *)&time,sizeof(int),1,fpbpt);
		if(time==GF_File[0].time&&date==GF_File[0].date)
		{
			fread((char *)&numline,sizeof(long),1,fpbpt);
			fread((char *)Line_Offset,sizeof(long),(int)numline,fpbpt);
			fread((char *)StrLen,sizeof(int),(int)numline,fpbpt);
			fclose(fpbpt);
			print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
		}
		else
		{
			fclose(fpbpt);
			numline=make_bpt(fp,fpbpt,name,message,filename,
									x1,x2,y1,y2,n1,n2,cy,xs,ys);
		}
	}
	l=maxline;
	n1=0;
	n2=n1+maxline-1;
	if(n2>=Max_Line)
		n2=Max_Line-1;
	sprintf(string2,"char = %3d  line = %5d",
		Char1+1,n1+(cy-(y1+1))+1);
	WriteStringAtxy(50,y2+2,0,A_Int,string2);
	while((ans=getch())!=27&&ans!=13)
	{
		if(ans=='h'||ans=='H')
		{
			print_help_page(x1+1,x2-1,y1+1,y2-1,n1,n2,cy);
			print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
		}
		if(ans==0)
		{
			ans2=getch();
			if(ans2==59)					/* F1 */
			{
				print_help_page(x1+1,x2-1,y1+1,y2-1,n1,n2,cy);
				print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==63)					/* F5 */
			{
				fold_line(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
				getch();
				print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==60||ans2==31)		/* F2 or Alt S */
				start=search(word,&cx,&cy,y1,y2,x1,x2,fp,&n1,&n2,
					numline,maxline,start,1,message);
			if(ans2==64)		/* F6 */
				start=search(word,&cx,&cy,y1,y2,x1,x2,fp,&n1,&n2,
					numline,maxline,start,2,message);
			if(ans2==95)		/* Ctrl F2 */
				start=search(word,&cx,&cy,y1,y2,x1,x2,fp,&n1,&n2,
					numline,maxline,start,0,message);
			if(ans2==62)		/* F4 */
			{
				fpout=fopen("PRN","wt");
				rewind(fp);
				ClearScreen(0);
				printf("\n\n\n\n  Printing entire file -- Hit 'Esc' to stop\n\n\n");
				while(fgets(string,81,fp))
				{
					if(kbhit()>0)
					{
						val=getch();
						if(val==27)
							exit(0);
					}
					fprintf(fpout,"%s",string);
				}
				exit(0);
			}
			if(ans2==81)		/* Screen Down */
			{
				start=0;
				if(cy==y2-1)	/* cursor at bottom */
				{
					n1+=maxline;
					n2=n1+maxline-1;
					if(n2>=numline)
					{
						n2=numline-1;
						n1=n2-maxline+1;
						if(n1<0)
							n1=0;
					}
					print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
				}
				else		/* move cursor to bottom */
				{
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Norm,TV_Buffer[cy]+Char1);
					cy=y2-1;
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Brite,TV_Buffer[cy]+Char1);
					SetCursor(x1+1,cy);
				}
			}
			if(ans2==73)		/* Screen Up */
			{
				start=0;
				if(cy==y1+1)	/* cursor at top */
				{
					n1-=maxline;
					if(n1<0)
						n1=0;
					n2=n1+maxline-1;
					if(n2>=numline)
					{
						n2=numline-1;
						n1=n2-maxline+1;
					}
					print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
				}
				else		/* move cursor to top */
				{
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Norm,TV_Buffer[cy]+Char1);
					cy=y1+1;
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Brite,TV_Buffer[cy]+Char1);
					SetCursor(x1+1,cy);
				}
			}
			if(ans2==132)		/* PgUp */
			{
				start=0;
				for(n=n1-1;n>=0;n--)
					if(Line_Offset[n]<0)
						break;
				n1=n;
				if(n1<0)
					n1=0;
				n2=n1+maxline-1;
				if(n2>=numline)
				{
					n2=numline-1;
					n1=n2-maxline+1;
					if(n1<0)
						n1=0;
				}
				cy=y1+1;
				print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
				SetCursor(x1+1,cy);
			}
			if(ans2==118)		/* PgDn */
			{
				start=0;
				for(n=n1+1;n<numline;n++)
					if(Line_Offset[n]<0)
						break;
				n1=n;
				n2=n1+maxline-1;
				if(n2>=numline)
				{
					n2=numline-1;
					n1=n2-maxline+1;
					if(n1<0)
						n1=0;
				}
				cy=y1+1;
				print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
				SetCursor(x1+1,cy);
			}
			if(ans2==75&&Char1>0)	/* left arrow */
			{
				Char1-=speed;
				if(Char1<0)
					Char1=0;
				re_print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==115&&Char1>0)	/* Ctrl -- left arrow */
			{
				start=Char1=0;
				re_print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==77&&Char1+textwide<MAX_WIDE)	/* right arrow */
			{
				Char1+=speed;
				if(Char1+textwide>=MAX_WIDE)
					Char1=MAX_WIDE-textwide+1;
				re_print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==116&&Char1+textwide<MAX_WIDE)	/* Ctrl -- right arrow */
			{
				Char1=StrLen[n1+cy-y1-1]-(x2-x1-1);
				if(Char1<0)
					Char1=0;
				if(Char1>start)
					start=Char1;
				if(Char1+textwide>=MAX_WIDE)
					Char1=MAX_WIDE-textwide+1;
				re_print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==72)		/* up arrow */
			{
				start=0;
				if(cy>y1+1)		/* not at top */
				{	
					cy-=1;
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Brite,TV_Buffer[cy]+Char1);
					SetCursor(x1+1,cy);
					if(StrLen[n1+cy-y1]>Char1)
						WriteStringAtxy(x1+1,cy+1,xs,A_Norm,TV_Buffer[cy+1]+Char1);
				}
				else if(n1>0)	/* cursor at top of screen but not of file */
				{
					if(StrLen[n1+cy-y1-1]>Char1)	/*cursor off*/
						WriteStringAtxy(x1+1,cy,xs,A_Norm,TV_Buffer[cy]+Char1);
					ScrollDown(1,x1+1,x2-1,y1+1,y2-1,A_Norm);
					for(i=y2-1;i>y1+1;i--)
						strcpy(TV_Buffer[i],TV_Buffer[i-1]);
					n1-=1;
					n2-=1;
					if(Line_Offset[n1]>=0)
						offset=Line_Offset[n1];
					else
						offset=Line_Offset[n1]*-1;
					fseek(fp,offset,SEEK_SET);
					fgets(string,MAX_WIDE-1,fp);
					len=strlen(string);
					string[len-1]='\0';
					strcpy(TV_Buffer[cy],string);
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Brite,TV_Buffer[cy]+Char1);
					SetCursor(x1+1,cy);
				}
			}
			if(ans2==80)		/* down arrow */
			{
				start=0;
				if(cy<y2-1)		/* not at bottom */
				{	
					cy+=1;
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Brite,TV_Buffer[cy]+Char1);
					SetCursor(x1+1,cy);
					if(StrLen[n1+cy-y1-2]>Char1)
						WriteStringAtxy(x1+1,cy-1,xs,A_Norm,TV_Buffer[cy-1]+Char1);
				}
				else if(n2<numline)/* cursor at bottom of screen but not of file */
				{
					if(StrLen[n1+cy-y1-1]>Char1)	/* cursor off */
						WriteStringAtxy(x1+1,cy,xs,A_Norm,TV_Buffer[cy]+Char1); 
					ScrollUp(1,x1+1,x2-1,y1+1,y2-1,A_Norm);
					for(i=y1+1;i<y2-1;i++)
						strcpy(TV_Buffer[i],TV_Buffer[i+1]);
					n1+=1;
					n2+=1;
					if(Line_Offset[n2]>=0)
						offset=Line_Offset[n2];
					else
						offset=Line_Offset[n2]*-1;
					fseek(fp,offset,SEEK_SET);
					fgets(string,MAX_WIDE-1,fp);
					len=strlen(string);
					string[len-1]='\0';
					strcpy(TV_Buffer[cy],string);
					if(StrLen[n1+cy-y1-1]>Char1)
						WriteStringAtxy(x1+1,cy,xs,A_Brite,TV_Buffer[cy]+Char1);
					SetCursor(x1+1,cy);
				}
			}
			if(ans2==71)		/* Home */
			{
				start=0;
				n1=0;
				n2=n1+maxline-1;
				if(n2>=numline)
				{
					n2=numline-1;
					n1=n2-maxline+1;
					if(n1<0)
						n1=0;
				}
				cy=y1+1;
				print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
			if(ans2==79)		/* End */
			{
				start=0;
				n2=numline-1;
				n1=n2-maxline+1;
				if(n1<0)
					n1=0;
				cy=y2-1;
				print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
			}
		}
		sprintf(string2,"char = %3d  line = %5d",
			Char1+1,n1+(cy-(y1+1))+1);
		WriteStringAtxy(50,y2+2,0,A_Int,string2);
	}
	return(1);
}


/**************************************************************************
**
**
**
**
***************************************************************************/

int make_bpt(FILE *fp,FILE *fpbpt,char *name,char *message,char *filename,
			int x1,int x2,int y1,int y2,int n1,int n2,int cy,int xs,int ys)

{
	int j;
	long numline=0;
	char string[MAX_WIDE];
	int len;
	int maxline=ys,attrib;

	strcpy(string,"    Scanning File     ");
	WriteStringAtxy(50,y2+2,0,A_Flash,string);
	Line_Offset[numline++]=ftell(fp);	
	while(fgets(string,MAX_WIDE-1,fp)&&numline<Max_Line)
	{
		len=strlen(string);
		string[len-1]='\0';
		StrLen[numline-1]=len-1;
		if(numline<=maxline)
		{
			if(y1+numline==cy)
				attrib=A_Brite;
			else
				attrib=A_Norm;
			WriteStringAtxy(x1+1,y1+(int)numline,xs,attrib,string+Char1);
			strcpy(TV_Buffer[y1+numline],string);
		}
		Line_Offset[numline]=ftell(fp);
		if(string[0]==Page)		/* form feed */
			Line_Offset[numline-1]*=-1;
		numline+=1;
		if(numline>=Max_Line)
		{
			ClearScreen(A_Norm);
			j=Max_Line;
			printf("Too many lines in file.\n");
			printf("Can only work first %d lines.\n",j);
			printf("\nHIT ANY KEY TO CONTINUE\n\n");
			getch();
			ClearScreen(A_Norm);
			DoubleBox(x1,x2,y1,y2,A_Norm);
			WriteStringAtxy(0,0,80,A_Int,message);
			WriteStringAtxy(0,y2+1,80,A_Int,
"Use Home, End, PgUp, PgDn, and up & down arrows to move:  Enter to quit");
			WriteStringAtxy(0,y2+2,80,A_Int,
"arrows=scroll, F2=search, F1=Help or Esc to exit");
			re_print_page(x1+1,x2-1,y1+1,y2-1,fp,n1,n2,cy);
		}
	}
	if(numline<Max_Line)
	{
		sprintf(string,"%s.bpt",name);
		fpbpt=fopen(string,"wb");
		if(fpbpt)
		{
			load_names(filename);
			fwrite((char *)&GF_File[0].date,sizeof(int),1,fpbpt);
			fwrite((char *)&GF_File[0].time,sizeof(int),1,fpbpt);
			fwrite((char *)&numline,sizeof(long),1,fpbpt);
			fwrite((char *)Line_Offset,sizeof(long),(int)numline,fpbpt);
			fwrite((char *)StrLen,sizeof(int),(int)numline,fpbpt);
			fclose(fpbpt);
		}
	}
	sprintf(string,"char = %3d  line = %5d",
		Char1+1,n1+(cy-(y1+1))+1);
	WriteStringAtxy(50,y2+2,0,A_Int,string);
	return(numline);
}



/**************************************************************************
**
**
**
**
***************************************************************************/

int fold_line(x1,x2,y1,y2,fp,l1,l2,cy)

int x1,x2,y1,y2;
FILE *fp;
int l1,l2,cy;

{
	int i,j,k,y;
	char string[MAX_WIDE],substr[100];
	int attrib,xs=x2-x1+1,len;
	long offset;
	int c1=0,c2=0,cs=0,end=0;

	ClearBox(x1,x2,y1,y2,A_Norm);
	offset=Line_Offset[l1+cy-y1];
	fseek(fp,offset,SEEK_SET);
	SetCursor(x1+1,cy);
	y=cy;
	fgets(string,MAX_WIDE-1,fp);
	len=strlen(string);
	string[len-1]='\0';
	attrib=A_Brite;
	i=2;
	do
	{
		c2=c1+xs;
		if(c2>=len)
		{
			c2=len;
			end=1;
		}
		while(c2>=c1&&string[c2]!=' '&&string[c2]!=0x9)	/* space or tab */
			c2-=1;
		while(c1<=c2&&(string[c1]==' '||string[c1]==0x9)) /* space or tab */
			c1+=1;
		cs=c2-c1+1;
		for(k=c1;k<=c2;k++)
			substr[k-c1]=string[k];
		substr[k-c1]='\0';
		if(cs>1)
			WriteStringAtxy(x1,y1+i,xs,attrib,substr);
		else
		{
			c2=c1+xs;
			WriteStringAtxy(x1,y1+i,xs,attrib,string+c1);
		}
		i+=1;
		c1=c2;
	}while(end==0);
}



/**************************************************************************
**
**
**
**
***************************************************************************/

int print_help_page(x1,x2,y1,y2,l1,l2,cy)

int x1,x2,y1,y2;
int l1,l2,cy;

{
	int i,j,k,y;
	char string[MAX_WIDE];
	int attrib,xs=x2-x1+1,len;
	long offset;

	ClearBox(x1,x2,y1,y2,A_Norm);
	SetCursor(x1+1,cy);
	for(i=l1;i<=l2;i++)
	{
		y=i-l1+y1;
		attrib=A_Brite;
		WriteStringAtxy(x1,y,xs,attrib,Help1[i-l1]);
	}
	if(getch()==27)
		return(0);
	for(i=l1;i<=l2;i++)
	{
		y=i-l1+y1;
		attrib=A_Brite;
		WriteStringAtxy(x1,y,xs,attrib,Help2[i-l1]);
	}
	getch();
}


/***********************************************************************
**
**		return:  1 -- valid word
**				  -1 -- no word chosen
**
**    iop:   0 -- case insensitive
**           1 -- case sensitive
**           2 -- search for characters between square brackets [...]
**
************************************************************************/

int search(char *word,int *cx,int *cy,int y1,int y2,int x1, int x2,
		FILE *fp,int *n1,int *n2,int numline,int maxline,int start,int iop,
		char *message)

{
	int i,j,k,n;
	char string[MAX_WIDE],*txt,lword[100];
	int ret=1,hit=0,tabs=0,over=0,skip;
	long offset;
	int val;

	for(i=0;i<80;i++)
		string[i]=' ';
	WriteStringAtxy(0,y2+2,80,0xc,string);
	WriteStringAtxy(0,y2+2,80,0xc,word);
	SetCursor(0,y2+2);
	if(iop<2)
		ret=load_word(string,word,y2);
	else
		strcpy(word,"[");
	if(iop==1)	/* case insensitive */
	{
		strcpy(lword,word);
		strlwr(lword);	
	}
	n=*cy-(y1+1)+*n1;
	if(Line_Offset[n]>=0)			/* check for form feed */
		offset=Line_Offset[n];
	else
		offset=Line_Offset[n]*-1;
	fseek(fp,offset,SEEK_SET);
	if(start<0)
		start=0;
	start+=strlen(word);
	for(i=n;i<numline;i++)	/* check to end of file */
	{
		if(kbhit()>0)
		{
			val=getch();
			if(val==27)
			{
				
				WriteStringAtxy(0,y2+2,80,A_Int,
					"Use arrows to scroll, F4 to print, or Esc to exit");
				SetCursor(*cx+1,*cy);
				return(ret);
			}
		}
		fgets(string,MAX_WIDE,fp);							/* read a line from file */
		if(iop==1)	/* case insensitive */
		{
			strcpy(Lstr,string);
			strlwr(Lstr);
			if((txt=strstr(Lstr+start,lword))!=NULL)
			{
				over=start;
				n=i;
				hit=1;
				break;
			}
		}
		else
		{
			if((txt=strstr(string+start,word))!=NULL)		
			{
				over=start;
				n=i;
				hit=1;
				break;
			}
		}
		start=0;
	}
	if(hit==0)
	{
		rewind(fp);
		for(i=0;i<n;i++)	/* check top of file */
		{
			if(kbhit()>0)
			{
				val=getch();
				if(val==27)
				{
					WriteStringAtxy(0,y2+2,80,A_Int,
					"Use arrows to scroll, F4 to print, or Esc to exit");
					SetCursor(*cx+1,*cy);
					return(ret);
				}
			}
			fgets(string,MAX_WIDE,fp);
			if(iop==1)	/* case insensitive */
			{
				strcpy(Lstr,string);
				strlwr(Lstr);
			}
			if((iop==0||iop==2)&&(txt=strstr(string,word))!=NULL)/*case sensitive*/
			{
				n=i;
				hit=1;
				break;
			}
			else if(iop==1&&(txt=strstr(Lstr,lword))!=NULL)	/* case insensitive */
			{
				n=i;
				hit=1;
				break;
			}
		}
	}
	if(hit>0)
	{
		if(iop==1)
			skip=(int)(txt-Lstr);
		else if(iop==0)
			skip=(int)(txt-string);
		else if(iop==2)
		{
			txt+=1;
			skip=(int)(txt-string);
		}
		if(iop==1)
			for(k=0;k<strlen(word);k++)
				word[k]=string[k+skip];
		else if(iop==2)
		{
			k=0;
			while(string[k+skip]!=']'&&string[k+skip]!=0xa&&string[k+skip]!=0xd)
			{
				word[k]=string[k+skip];
				k+=1;
			}
			word[k]='\0';
		}
		*n1=n-9;
		if(*n1<0)
			*n1=0;
		*n2=*n1+maxline-1;
		if(*n2>=numline)
		{
			*n2=numline-1;
			*n1=*n2-maxline+1;
			if(*n1<0)
				*n1=0;
		}
		*cy=n-*n1+y1+1;
		if(iop==1)
			ret=start=(int)(txt-Lstr);
		else
			ret=start=(int)(txt-string);
		if(Char1==0&&string[0]==0xc)	/* 1st char of text is a form feed */
			start-=1;
		for(j=0;j<start;j++)
			if(string[j]==0x9)	/* tab */
				tabs+=1;
		if(start+tabs*4+x1+1-Char1<x1)
			Char1=start+tabs*4+x1;
		if(start+tabs*4+x1+1+strlen(word)-Char1>x2-1)
			Char1=start+tabs*4+x1+1+strlen(word)-x2;
		print_page(x1+1,x2-1,y1+1,y2-1,fp,*n1,*n2,*cy);
		WriteStringAtxy(start+tabs*4+x1+1-Char1,*cy,
			80-(start+tabs*4+x1+1-Char1),0x4f,word);
	}
	WriteStringAtxy(0,y2+2,80,A_Int,
		"Use arrows to scroll, F4 to print, or Esc to exit");
	if(iop==2&&strlen(word)>0)
	{
		look_at_image(word,x1,x2,y1,y2,fp,*n1,*n2,*cy);
		ClearScreen(A_Norm);
		DoubleBox(x1,x2,y1,y2,A_Norm);
		WriteStringAtxy(0,0,80,A_Int,message);
		WriteStringAtxy(0,y2+1,80,A_Int,
"Home, End, PgUp, PgDn, Ctrl PgUp, Ctrl PgDn and up & down arrows to move:");
		WriteStringAtxy(0,y2+2,80,A_Int,
			"arrows=scroll, F2=search, F1=Help or Esc to exit");
		print_page(x1+1,x2-1,y1+1,y2-1,fp,*n1,*n2,*cy);
	}
	SetCursor(*cx+1,*cy);
	return(ret);
}

/***********************************************************************
**
**
**
**
************************************************************************/

int look_at_image(char *word,int x1,int x2,int y1,int y2,FILE *fp,
		int l1,int l2,int cy)

{
	char string[100],ans;

	WriteStringAtxy(0,y2+2,80,0x4f,
		" Hit 'Enter' to view image or 'F6' to continue   ");
	ans=getch();
	if(ans==13)
	{
		picture_view(word);
		print_page(x1,x2,y1,y2,fp,l1,l2,cy);
	}
	WriteStringAtxy(0,y2+2,80,A_Int,
		"Use arrows to scroll, F4 to print, or Esc to exit");
}



/***********************************************************************
**
**
**
**
************************************************************************/

int load_word(char *string,char *word,int y2)

{
	char ans;
	int k=0,ret=1,time=0,end=0;

	do		/* load 'word' */
	{
		ans=getch();
		if(ans==0)
		{
			ans=getch();
			if(ans==60||ans==31||ans==95)		/* F2 or Alt S */
			{
				end=1;
				if(time==0)
				{
					if(strlen(word)>0)
						ret=1;
					else
						ret=-1;
				}
				else
					word[k]='\0';
			}
		}
		if(ans==13)		/* Enter */
		{
			end=1;
			if(time==0)
			{
				end=1;
				if(strlen(word)>0)
					ret=1;
				else
					ret=-1;
			}
			word[k]='\0';
		}
		if(ans==8)
		{
			if(k>0)
				k-=1;
			word[k]='\0';
			SetCursor(k,y2+2);
		}
		else if(end==0)
		{
			word[k++]=ans;
			word[k]='\0';
			SetCursor(k,y2+2);
		}
		WriteStringAtxy(0,y2+2,80,0xc,string);
		WriteStringAtxy(0,y2+2,80,0xc,word);
			time+=1;
	}while(end==0);
	return(ret);
}

/**************************************************************************
**
**
**
**
***************************************************************************/

int re_print_page(x1,x2,y1,y2,fp,l1,l2,cy)

int x1,x2,y1,y2;
FILE *fp;
int l1,l2,cy;

{
	int i,j,k,y;
	char string[MAX_WIDE];
	int attrib,xs=x2-x1+1,len;

	ClearBox(x1,x2,y1,y2,A_Norm);
	SetCursor(x1+1,cy);
	for(i=l1;i<=l2;i++)
	{
		y=i-l1+y1;
		if(y==cy)
			attrib=A_Brite;
		else
			attrib=A_Norm;
		if(StrLen[i]>Char1)
			WriteStringAtxy(x1,y,xs,attrib,TV_Buffer[y]+Char1);
	}
}

/**************************************************************************
**
**
**
**
***************************************************************************/

int print_page(x1,x2,y1,y2,fp,l1,l2,cy)

int x1,x2,y1,y2;
FILE *fp;
int l1,l2,cy;

{
	int i,j,k,y;
	char string[MAX_WIDE];
	int attrib,xs=x2-x1+1,len;
	long offset;

	ClearBox(x1,x2,y1,y2,A_Norm);
	if(Line_Offset[l1]>=0)
		offset=Line_Offset[l1];
	else
		offset=Line_Offset[l1]*-1;
	fseek(fp,offset,SEEK_SET);
	SetCursor(x1+1,cy);
	for(i=l1;i<=l2;i++)
	{
		y=i-l1+y1;
		fgets(string,MAX_WIDE-1,fp);
		len=strlen(string);
		string[len-1]='\0';
		if(y==cy)
			attrib=A_Brite;
		else
			attrib=A_Norm;
		if(StrLen[i]>Char1)
			WriteStringAtxy(x1,y,xs,attrib,string+Char1);
		strcpy(TV_Buffer[y],string);
	}
}

                                      