/*
    tga2pcx.c

    tl1.bat = cl /AL tga2pcx.c getfile

    converts a '.tga' file to a '.pcx' file

*/
#include <stdio.h>
#include <string.h>
#include "nomouse.h"

#define MAX_COL 32768

int Mouse=0;
int PAL=0;

struct tgahdr
{
	int id_size;					/* byte 0 */
	int color_map;					/* byte 1 (1 if PAL else 0) */
	unsigned char image_type;	/* byte 2 */
										/*  0 -- no image data      */
										/*  1 -- Uncomp,color map   */
										/*  2 -- Uncomp,true color  */
										/*  3 -- Uncomp, B&W        */
										/*  9 -- Comprs,color map   */
										/* 10 -- Comprs,true color  */
										/* 11 -- Comprs, B&W        */
	int map_length;				/* bytes 6 and 5 */
	int bits_per_color;			/*	byte 7 */
	int col;							/* bytes 13 & 12 */
	int row;							/* bytes 15 & 14 */
	int pixel_depth;				/* byte 16 */
	int first_pixel;				/* byte 17 */
										/*  0 -- Bottom Left  */
										/* 16 -- Bottom Right */
										/* 32 -- Top Left     */
										/* 48 -- Top Right    */
};
struct pcxhdr
{
    char manufacturer;          /* always 0xa0 */
    char version;               /* version number (5) */
    char encoding;              /* always 1 */
    char bits_per_pixel;        /* color bits */
    int xmin,ymin;              /* image origin */
    int xmax,ymax;              /* image dimensions */
    int hres;                   /* resolution values */
    int vres;
    char palette[48];           /* color palette */
    char reserved;
    char color_planes;          /* color planes */
    int bytes_per_line;         /* line buffer size */
    int palette_type;           /* grey or color palette */
    char filler[58];
};
unsigned char Pal[256][3]=
{
    {  0,   0,   0},
    {  1,   1,   1},
    {  2,   2,   2},
    {  3,   3,   3},
    {  4,   4,   4},
    {  5,   5,   5},
    {  6,   6,   6},
    {  7,   7,   7},
    {  8,   8,   8},
    {  9,   9,   9},
    { 10,  10,  10},
    { 11,  11,  11},
    { 12,  12,  12},
    { 13,  13,  13},
    { 14,  14,  14},
    { 15,  15,  15},
    { 16,  16,  16},
    { 17,  17,  17},
    { 18,  18,  18},
    { 19,  19,  19},
    { 20,  20,  20},
    { 21,  21,  21},
    { 22,  22,  22},
    { 23,  23,  23},
    { 24,  24,  24},
    { 25,  25,  25},
    { 26,  26,  26},
    { 27,  27,  27},
    { 28,  28,  28},
    { 29,  29,  29},
    { 30,  30,  30},
    { 31,  31,  31},
    { 32,  32,  32},
    { 33,  33,  33},
    { 34,  34,  34},
    { 35,  35,  35},
    { 36,  36,  36},
    { 37,  37,  37},
    { 38,  38,  38},
    { 39,  39,  39},
    { 40,  40,  40},
    { 41,  41,  41},
    { 42,  42,  42},
    { 43,  43,  43},
    { 44,  44,  44},
    { 45,  45,  45},
    { 46,  46,  46},
    { 47,  47,  47},
    { 48,  48,  48},
    { 49,  49,  49},
    { 50,  50,  50},
    { 51,  51,  51},
    { 52,  52,  52},
    { 53,  53,  53},
    { 54,  54,  54},
    { 55,  55,  55},
    { 56,  56,  56},
    { 57,  57,  57},
    { 58,  58,  58},
    { 59,  59,  59},
    { 60,  60,  60},
    { 61,  61,  61},
    { 62,  62,  62},
    { 63,  63,  63},
    { 64,  64,  64},
    { 65,  65,  65},
    { 66,  66,  66},
    { 67,  67,  67},
    { 68,  68,  68},
    { 69,  69,  69},
    { 70,  70,  70},
    { 71,  71,  71},
    { 72,  72,  72},
    { 73,  73,  73},
    { 74,  74,  74},
    { 75,  75,  75},
    { 76,  76,  76},
    { 77,  77,  77},
    { 78,  78,  78},
    { 79,  79,  79},
    { 80,  80,  80},
    { 81,  81,  81},
    { 82,  82,  82},
    { 83,  83,  83},
    { 84,  84,  84},
    { 85,  85,  85},
    { 86,  86,  86},
    { 87,  87,  87},
    { 88,  88,  88},
    { 89,  89,  89},
    { 90,  90,  90},
    { 91,  91,  91},
    { 92,  92,  92},
    { 93,  93,  93},
    { 94,  94,  94},
    { 95,  95,  95},
    { 96,  96,  96},
    { 97,  97,  97},
    { 98,  98,  98},
    { 99,  99,  99},
    {100, 100, 100},
    {101, 101, 101},
    {102, 102, 102},
    {103, 103, 103},
    {104, 104, 104},
    {105, 105, 105},
    {106, 106, 106},
    {107, 107, 107},
    {108, 108, 108},
    {109, 109, 109},
    {110, 110, 110},
    {111, 111, 111},
    {112, 112, 112},
    {113, 113, 113},
    {114, 114, 114},
    {115, 115, 115},
    {116, 116, 116},
    {117, 117, 117},
    {118, 118, 118},
    {119, 119, 119},
    {120, 120, 120},
    {121, 121, 121},
    {122, 122, 122},
    {123, 123, 123},
    {124, 124, 124},
    {125, 125, 125},
    {126, 126, 126},
    {127, 127, 127},
    {128, 128, 128},
    {129, 129, 129},
    {130, 130, 130},
    {131, 131, 131},
    {132, 132, 132},
    {133, 133, 133},
    {134, 134, 134},
    {135, 135, 135},
    {136, 136, 136},
    {137, 137, 137},
    {138, 138, 138},
    {139, 139, 139},
    {140, 140, 140},
    {141, 141, 141},
    {142, 142, 142},
    {143, 143, 143},
    {144, 144, 144},
    {145, 145, 145},
    {146, 146, 146},
    {147, 147, 147},
    {148, 148, 148},
    {149, 149, 149},
    {150, 150, 150},
    {151, 151, 151},
    {152, 152, 152},
    {153, 153, 153},
    {154, 154, 154},
    {155, 155, 155},
    {156, 156, 156},
    {157, 157, 157},
    {158, 158, 158},
    {159, 159, 159},
    {160, 160, 160},
    {161, 161, 161},
    {162, 162, 162},
    {163, 163, 163},
    {164, 164, 164},
    {165, 165, 165},
    {166, 166, 166},
    {167, 167, 167},
    {168, 168, 168},
    {169, 169, 169},
    {170, 170, 170},
    {171, 171, 171},
    {172, 172, 172},
    {173, 173, 173},
    {174, 174, 174},
    {175, 175, 175},
    {176, 176, 176},
    {177, 177, 177},
    {178, 178, 178},
    {179, 179, 179},
    {180, 180, 180},
    {181, 181, 181},
    {182, 182, 182},
    {183, 183, 183},
    {184, 184, 184},
    {185, 185, 185},
    {186, 186, 186},
    {187, 187, 187},
    {188, 188, 188},
    {189, 189, 189},
    {190, 190, 190},
    {191, 191, 191},
    {192, 192, 192},
    {193, 193, 193},
    {194, 194, 194},
    {195, 195, 195},
    {196, 196, 196},
    {197, 197, 197},
    {198, 198, 198},
    {199, 199, 199},
    {200, 200, 200},
    {201, 201, 201},
    {202, 202, 202},
    {203, 203, 203},
    {204, 204, 204},
    {205, 205, 205},
    {206, 206, 206},
    {207, 207, 207},
    {208, 208, 208},
    {209, 209, 209},
    {210, 210, 210},
    {211, 211, 211},
    {212, 212, 212},
    {213, 213, 213},
    {214, 214, 214},
    {215, 215, 215},
    {216, 216, 216},
    {217, 217, 217},
    {218, 218, 218},
    {219, 219, 219},
    {220, 220, 220},
    {221, 221, 221},
    {222, 222, 222},
    {223, 223, 223},
    {224, 224, 224},
    {225, 225, 225},
    {226, 226, 226},
    {227, 227, 227},
    {228, 228, 228},
    {229, 229, 229},
    {230, 230, 230},
    {231, 231, 231},
    {232, 232, 232},
    {233, 233, 233},
    {234, 234, 234},
    {235, 235, 235},
    {236, 236, 236},
    {237, 237, 237},
    {238, 238, 238},
    {239, 239, 239},
    {240, 240, 240},
    {241, 241, 241},
    {242, 242, 242},
    {243, 243, 243},
    {244, 244, 244},
    {245, 245, 245},
    {246, 246, 246},
    {247, 247, 247},
    {248, 248, 248},
    {249, 249, 249},
    {250, 250, 250},
    {251, 251, 251},
    {252, 252, 252},
    {253, 253, 253},
    {254, 254, 254},
    {255, 255, 255}
};
unsigned char Buffer[MAX_COL],InBuff[1024][4];
unsigned char Vga[16][3]=
{
	{   0,  0,  0},
	{  46, 46, 46},
	{ 128,128,128},
	{ 255,255,255},
	{ 105, 90, 75},
	{ 130,111, 93},
	{  96, 28, 14},
	{ 255,  0,  0},
	{ 255,128,  0},
	{ 160,160,  0},
	{   0,200,  0},
	{   0,120,  0},
	{   0, 72,  0},
	{   0,  0,200},
	{   0, 20, 60},
	{ 255,  0,255}
};

int trans_header(unsigned char *dat,struct tgahdr *th);
int print_hdr(struct tgahdr h);
int ConvertTgaPcx(char *name,FILE *fppcx, FILE *fptga, struct tgahdr th);
int WritePcxHeader(char *name,FILE *fppcx,struct pcxhdr ph,struct tgahdr th);

main()
{
    int i,j,k,r,g,b,ret;
    char name[100],string[100],pname[100];
    FILE *fptga,*fppcx,*fppal;
    unsigned char theader[18],pal[3];
    struct tgahdr th;

    ClearScreen(3);
    SetCursor(0,0);
    printf("TGA2PCX - convert a Targa image\n");
    printf("          to a PCX image.\n\n");
    printf("Select file using up/down arrow\n");
    printf("  keys and <Enter> key, or type\n");
    printf("  first few characters of name \n");
    printf("  and hit <Enter> key twice.\n\n");
    printf("Hit <Esc> key to exit.\n");
    if((ret=get_file_name("*.tga",name,0))>=0)
	{
        printf("targa file = '%s'\n",name);
		fptga=fopen(name,"rb");
		if(!fptga)
		{
			printf("Could not open '%s'\n",name);
			exit(0);
		}
		for(k=0;k<strlen(name);k++)
            if(name[k]=='.') name[k]='\0';
        if(get_file_name("*.pal",pname,0)>=0)
        {
            printf("palette file = '%s'\n",pname);
            fppal=fopen(pname,"rb");
            if(!fppal)
            {
                printf("Could not open '%s'\n",pname);
                exit(0);
            }
            PAL=1;
            for(i=0;i<256;i++)
            {
                fscanf(fppal,"%d%d%d%d",&k,&r,&g,&b);
                pal[0]=r;
                pal[1]=g;
                pal[2]=b;
                for(k=0;k<3;k++) Pal[i][k]=pal[k];
            }
            fclose(fppal);
        }
        if(fread((char *)theader,sizeof(char),18,fptga)<18)
		{
            printf("Could not read targa header.\n\n");
			exit(0);
		}
        trans_header(theader,&th);
        print_hdr(th);
        printf("Hit any key to continue\n\n");
        getch();
        if(th.row<=0||th.col<=0)
		{
			printf("Bad image size\n");
			exit(0);
		}
        ConvertTgaPcx(name,fppcx,fptga,th);
    }
    ClearScreen(7);
    SetCursor(0,0);
    if(ret == -2) printf("No .TGA files found\n");
}


/**********************************************************************
**
**
**
**********************************************************************/
int ConvertTgaPcx(char *name,FILE *fppcx, FILE *fptga, struct tgahdr th)
{
    int i,j,k;
    char string[100];
    unsigned char dat[3];
    long offset,lrow=th.row,lcol=th.col;
    struct pcxhdr ph;
    char cr=0xd;

    sprintf(string,"%s.pcx",name);
    fppcx=fopen(string,"wb");
    if(!fppcx)
    {
        printf("Could not open '%s' to write\n\n",string);
        exit(0);
    }
    WritePcxHeader(name,fppcx,ph,th);
    printf("      of %d",th.row);
    for(i=0;i<th.row;++i)
    {
        printf("%c%5d",cr,i+1);
        if(th.first_pixel==0)
        {
            offset=18+(lrow-(long)(1+i))*lcol*4;
            fseek(fptga,offset,SEEK_SET);
        }
/*        fread((char *)Buffer,sizeof(char),th.col,fptga);*/
        fread((char *)InBuff,sizeof(char),th.col*4,fptga);
        for(j=0;j<th.col;j++)
        {
            for(k=0;k<256;k++)
            {
                if(Pal[k][0]==InBuff[j][2]&&Pal[k][1]==InBuff[j][1]&&Pal[k][2]==InBuff[j][0])
                {
                    Buffer[j]=k;
                    break;
                }
            }
            if(k==256)
            {
                printf("%c%5d   of %d Warning: %d %d %d not found in palette",
                    cr,i+1,th.row,InBuff[j][2],InBuff[j][1],InBuff[j][0]);
                Pal[0][0]=InBuff[j][2];
                Pal[0][1]=InBuff[j][1];
                Pal[0][2]=InBuff[j][0];
                Buffer[j]=0;
            }
        }
        WritePcxLine(Buffer,fppcx,th.col);
    }
    fputc(0x0c,fppcx);
    for(i=0;i<256;i++)
    {
        fputc(Pal[i][0],fppcx);
        fputc(Pal[i][1],fppcx);
        fputc(Pal[i][2],fppcx);
    }
}
int WritePcxHeader(char *name,FILE *fppcx,struct pcxhdr ph,struct tgahdr th)
{
    memset((char *) &ph,0,sizeof(ph));
    ph.manufacturer=0x0a;
    ph.version=5;
    ph.encoding=1;
    ph.bits_per_pixel=8;
    ph.xmin=ph.ymin=0;
    ph.xmax=th.col-1;
    ph.ymax=th.row-1;
    ph.color_planes=1;
    ph.bytes_per_line=th.col;
    ph.palette_type=2;
    return(fwrite((char *) &ph,1,sizeof(ph),fppcx));
}

WritePcxLine(p,fp,n)
    char *p;
    FILE *fp;
    unsigned int n;
{
    unsigned int i=0,j=0,t=0;

    do {
        i=0;
        while((p[t+i]==p[t+i+1]) && ((t+i) < n) && (i<63)) ++i;
        if(i>0) {
            fputc(i | 0xc0,fp);
            fputc(p[t],fp);
            t+=i;
            j+=2;
        }
        else {
            if(((p[t]) & 0xc0)==0xc0) {
                fputc(0xc1,fp);
                ++j;
            }
            fputc(p[t++],fp);
            ++j;
        }
    } while(t<n);
    if(ferror(fp)) j=0;
    return(j);
}

/**********************************************************************
**
**
**
**********************************************************************/

int print_hdr(struct tgahdr h)

{
	printf("       id_size = %d\n",h.id_size);
	printf("     color_map = %d\n",h.color_map);
	printf("    image_type = %d\n",h.image_type);
	printf("    map_length = %d\n",h.map_length);
	printf("bits_per_color = %d\n",h.bits_per_color);
	printf("           col = %d\n",h.col);
	printf("           row = %d\n",h.row);
	printf("   pixel_depth = %d\n",h.pixel_depth);
	printf("   first_pixel = %d\n",h.first_pixel);
}



/**********************************************************************
**
**
**
**********************************************************************/

int trans_header(unsigned char *dat,struct tgahdr *h)

{
	int i,j,k;

	h->id_size=dat[0];
	h->color_map=dat[1];
	h->image_type=dat[2];
	h->map_length=(int)dat[6]*256+(int)dat[5];
	h->bits_per_color=dat[7];
	h->col=(int)dat[13]*256+(int)dat[12];
	h->row=(int)dat[15]*256+(int)dat[14];
	h->pixel_depth=dat[16];
	h->first_pixel=dat[17];
}
                                        
