/*************************************************************************
 **
 ** Program:    vectb2a
 **
 ** Purpose:    To convert a binary vector file to an ASCII vector file.
 **
 ** Usage:      vectb2a infile outfile MaxLat MinLat MaxLon MinLon
 **
 **             infile = name of the input binary vector file
 **            outfile = name of the output ASCII vector file 
 **             MaxLat = maximum latitude
 **             MinLat = minimum latitude
 **             MaxLon = maximum longitude
 **             MinLon = minimum longitude
 **
 ************************************************************************
 */
#include <stdio.h>
#include <string.h>

float MaxLat=90.1,MinLat=-90.1,MaxLon=360.1,MinLon=-360.1;

#define STR_LEN 100
#define NUM_DP 100
#define TRUE  1

int NumPath=1;
int FontSize=2;
int L_Grey=191;
unsigned char Mbuff[100];
char Path[NUM_DP][STR_LEN];
char LastFile[STR_LEN];
char *name;
FILE *open_to_write_text(char *name);
FILE *open_to_read_text(char *name);
FILE *open_to_write_binary(char *name);
FILE *open_to_read_binary(char *name);

main(argc,argv)

int argc;
char *argv[];

{
	int i,j,k,n=0;
	char Drive[5];
	char Dir[256];
	char Fname[10];
	char Ext[5];
	int numseg,numpts,doit;
	float latlon[2],mll[4],mnln,mxln,mnlt,mxlt;
	FILE *fpbin,*fpout,*fpatr;
	char name[100],string[100],cr=0xd,file[100];
	long lattrib;
	int attrib,atr=0;

	if(argc<=2)
	{
		printf("********* VECTB2A **********\n\n");
		printf("This is a program to convert a binary data set that\n");
		printf("contains vector line data to an ASCII file.\n\n");
        printf("USAGE:    vectb2a infile outfile [mxlt mnlt mxln mnln]\n\n");
		printf("where\n"); 
		printf("infile is the name of the binary vector file\n");
		printf("outfile is the name of the output file.\n");
		printf("mxlt is an optional maximum latitude\n");
		printf("mnlt is an optional minimum latitude\n");
		printf("mxln is an optional maximum longitude\n"); 
		printf("mnln is an optional minimum longitude\n\n");
		printf("The minimum/maximum latitude and longitude define an area\n");
		printf("within which the data will be converted.  This program DOES\n");
		printf("NOT split lines.\n");
		return(0);
	}
	fpbin=open_to_read_binary(argv[1]);
	if(!fpbin)
	{
		printf("Could not open '%s'\n",argv[1]);
		exit(0);
	}
	printf("input file = %s  ",argv[1]);
	fpout=open_to_write_text(argv[2]);
	printf("\nOutput name is '%s'\n",argv[2]);
	if(argc==7)
	{
		sscanf(argv[3],"%f",&MaxLat);
		sscanf(argv[4],"%f",&MinLat);
		sscanf(argv[5],"%f",&MaxLon);
		sscanf(argv[6],"%f",&MinLon);
		printf("\nMaxlat = %f MinLat = %f MaxLon = %f MinLon = %f\n",
			MaxLat,MinLat,MaxLon,MinLon);
	}
	_splitpath(argv[1],Drive,Dir,Fname,Ext);
	printf("file = '%s'\n",Fname);
	sprintf(name,"%s.atr",Fname);
	fpatr=open_to_read_binary(name);
	if(fpatr)
	{
		printf("Attribute file present.\n");
		atr=1;
	}
	else
		printf("No attribute file found.\n");
	fread((char *)&numseg,sizeof(int),1,fpbin);
	printf("numseg = %d\n",numseg);
	for(i=0;i<numseg;i++)
	{
		fread((char *)&numpts,sizeof(int),1,fpbin);
		fread((char *)mll,sizeof(float),4,fpbin);
		if(atr==1)
		fread((char *)&lattrib,sizeof(long),1,fpatr);
		mnln=mll[0];mxln=mll[1];mnlt=mll[2];mxlt=mll[3];
		doit=1;
		if(mnln>MaxLon||mnlt>MaxLat||mxln<MinLon||mxlt<MinLat)
			doit=0;
		if(doit==1)
		{
			if(atr==0)
				fprintf(fpout,"%5d",i+1);
			else
			{
				fprintf(fpout,"%5ld",lattrib);
				printf("%8ld",lattrib);
			}
		}
		for(j=0;j<numpts;j++)
		{
			fread((char *)latlon,sizeof(float),2,fpbin);
			if(doit==1)
			{
				if(j%3==0)
					fprintf(fpout,"\n");
				else
					fprintf(fpout,"  ");
				fprintf(fpout,"%8.5f %11.5f",latlon[0],latlon[1]);
			}
		}
		if(doit==1)
		{
			fprintf(fpout,"//\n");
			n+=1;
		}
		printf("%6d %6d of %6d%c",i+1,n,numseg,cr);
	}
	printf("\n");
	if(fpout)
		fclose(fpout);
	if(fpbin)
		fclose(fpbin);
	if(fpatr)
		fclose(fpatr);
}
/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_write_text(char *name)

{
		int i,j,k;
		FILE *fp;
		char string[STR_LEN];

		for(j=0;j<NumPath;j++)
		{
				sprintf(string,"%s%s",Path[j],name);
				fp=fopen(string,"wt");
				if(fp)
				{
						strcpy(LastFile,name);
						return(fp);
				}
		}
		clearerr(fp);
		fp=NULL;
		return(fp);
}

/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_read_text(char *name)

{
		int i,j,k;
		FILE *fp;
		char string[STR_LEN];

		for(j=0;j<NumPath;j++)
		{
				sprintf(string,"%s%s",Path[j],name);
				fp=fopen(string,"rt");
				if(fp)
				{
						strcpy(LastFile,name);
						return(fp);
				}
		}
		clearerr(fp);
		fp=NULL;
		return(fp);
}

/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_write_binary(char *name)

{
		int i,j,k;
		FILE *fp;
		char string[STR_LEN];

		for(j=0;j<NumPath;j++)
		{
				sprintf(string,"%s%s",Path[j],name);
				fp=fopen(string,"wb");
				if(fp)
				{
						strcpy(LastFile,name);
						return(fp);
				}
		}
		clearerr(fp);
		fp=NULL;
		return(fp);
}


/***********************************************************************
**
**
**
**
************************************************************************/

FILE *open_to_read_binary(char *name)

{
		int i,j,k;
		FILE *fp;
		char string[STR_LEN];
		int len;

		string[0]='\0';
		for(j=0;j<NumPath;j++)
		{
				len=strlen(Path[j])+strlen(name);
				if(len>0&&len<STR_LEN);
				{
						sprintf(string,"%s%s",Path[j],name);
						fp=fopen(string,"rb");
						if(fp)
						{
								strcpy(LastFile,name);
								return(fp);
						}       
				}
		}
		clearerr(fp);
		fp=NULL;
		return(fp);
}

