c  ES_COF.FOR
c
c  To calculate dft coefficients (fftfil.cof file) from equivalent-
c  source set of sources.  (Be sure to use complete sources set, i.e.
c  incorporating phony data if necessary to fill no-data areas.)
c
c  See comments in subroutine MODIFY regarding switch of coordinate
c  axes from x=east, y=north; to x=north, y=east.
c
c  Lin Cordell, 6 Feb 91.
c
c      character*50 ifile
      dimension g(2,1024),x(2000),y(2000),z(2000),cm(2000)
      data lnri/16/
      ierror=0
      print*,'Enter ncol,nrow,x0,y0,dx,dy of eventual grid:'
c  Note switch of axes to x=north, y=east, z=down.
      print 1
1     format(' *',$)
      read*,n2,n1,y0,x0,dy,dx
      write(6,7)
7     format(' Enter no. of rows & cols added to grid(nadd):'/1x'*'$)
      read(5,*)nadd
      icmd=10
      l=lnri+1
      lnri21=lnri/2+1
c  set no. of rows for fft: need m=l*2**k, m.gt. or .eq. nx+2*nadd.
c  m=no. of rows, l=no. from 9-16, k=interger.
      n1=n1+2*nadd
  190 l=l-1
      if(l.lt.lnri21) go to 260
      mr=n1/l+0.0000001
      k=1
      idiv=2
  200 iquot=mr/idiv+0.0000001
      if(iquot.lt.idiv) go to 210
      k=k+1
      mr=iquot
      go to 200
  210 k=k+1
      m=l*2**k
  220 mtest=l*2**(k-1)
      if(mtest.lt.n1) go to 230
      k=k-1
      m=mtest
      if(k.eq.0) go to 230
      go to 220
  230 lnxa=m-n1
      if(l.ne.lnri) go to 250
      nxa16=lnxa
  240 nri=l
      nxa=lnxa
      go to 190
  250 if(lnxa.ge.nxa) go to 190
      go to 240
  260 n1=n1+nxa
c  check to see if row block size of 16 will be more efficient
      n116=n1-nxa+nxa16
      ntest=0.9*n116
      if(ntest.gt.n1.or.n116.gt.2048) go to 270
      n1=n1-nxa+nxa16
      nxa=nxa16
      nri=16
  270 n2=n2+2*nadd
      write(6,275)nri
  275 format(' blocking rows =',i3)
      if(n1.gt.2048.or.n2.gt.2048) go to 320
      nxa=nxa+2*nadd
      id2=n1
      if(n2.gt.n1)id2=n2
      id2=2*id2
c  Blocking parameters for fft are set; call subroutine.
      n22=2*n2
      open(12,access='direct',status='new',
     1 form='unformatted',file='fftfil.cof',
     2 recl=n22*4)
      call modify(g,x,y,z,cm,n2,n1,n22,x0,dx,y0,dy)
      go to 99
320   write(6,321)
321   format(1x,'Extended rows/columns exceeds 2048; run aborted.')
99    continue
      close(14)
      close(12)
      stop
      end
      subroutine modify(g,x,y,z,cm,n2,n1,n22,x0,dx,y0,dy)
c  Note:  In contrast with standard-grid notation, the x,dx,v1
c  direction is north; y,dy,v2 direction is east, and angles are
c  measured clockwise from the +x (north) direction.
      dimension g(n22)
      dimension x(1),y(1),z(1),cm(1)
      character*8 id
      character*50 ifile
      write(6,10)
10    format(1x,'Enter input sources post-file name:'/1x'*'$)
      read(5,100)ifile
100   format(a50)
      open(10,file=ifile,status='old',form='unformatted')
      print*,'Enter surface elevation (up is negative) in km:'
      print 1
1     format(' *',$)
      read*,zlevel
      print*,'Enter field datum as output by ES program:'
      print 1
      read*,datum
      ncp1=n2+1
      cn=1./(n2*dy)
      rn=1./(n1*dx)
      nrnq=float(n1)/2.+1.0000001
      ncnq=float(n2)/2.+1.0000001
      pi=3.1415927e0
      twopi=2.*pi
      k=1
200   read(10,end=201)id,y(k),x(k),z(k),cm(k),v,v,v,v
      z(k)=zlevel-z(k)
      y(k)=y(k)-y0
      x(k)=x(k)-x0
      cm(k)=cm(k)/(dx*dy)
      k=k+1
      go to 200
201   kmax=k-1
      write(6,202) kmax
202   format(' Number of sources = ',i4)
c
c  Calculate fftfil.cof file.
c   First row, DC term treated separately.
      jr=1
c   DC term.
      g(1)=datum
      g(2)=0.0
c
c   Rest of row 1.
      do 101 i=2,n2
      ic=2*i
      ii=i-1
      if(i.gt.ncnq) ii=-(ncp1-i)
      v2=float(ii)*cn
      w=abs(v2)
      twopiw=twopi*w
      gr=0
      gi=0
      do 300 k=1,kmax
      ga=(cm(k)/w)*exp(twopiw*z(k))
      ang=twopi*(v2*y(k))
      gr=gr+ga*cos(ang)
      gi=gi-ga*sin(ang)
300   continue
      g(ic-1)=gr
      g(ic)=gi
101   continue
      write(12,rec=jr)g
c
c  Rest of fftfil.cof file, row-wise.
      do 3 jr=2,nrnq
      jj=jr-1
      v1=float(jj)*rn
      v1sq=v1*v1
      do 2 i=1,n2
      ic=2*i
      ii=i-1
      if(i.gt.ncnq) ii=-(ncp1-i)
      v2=float(ii)*cn
      v2sq=v2*v2
      w=sqrt(v1sq+v2sq)
      twopiw=twopi*w
      gr=0
      gi=0
      do 301 k=1,kmax
      ga=(cm(k)/w)*exp(twopiw*z(k))
      ang=twopi*(v1*x(k)+v2*y(k))
      gr=gr+ga*cos(ang)
      gi=gi-ga*sin(ang)
301   continue
      g(ic-1)=gr
      g(ic)=gi
2     continue
      write(12,rec=jr)g
3     continue
c
c  Fold into lower two quadrants.
      nrp2=n1+2
      ncp2=n2+2
      do 5 i=2,nrnq-1
      ir=i
      read(12,rec=ir)g
      ik=nrp2-i
      g(2)=-g(2)
      do 4 j=2,ncnq
      jc=2*j
      jk=ncp2-j
      jkc=2*jk
      gr=g(jc-1)
      gi=-g(jc)
      g(jc-1)=g(jkc-1)
      g(jc)=-g(jkc)
      g(jkc)=gi
      g(jkc-1)=gr
4     continue
      write(12,rec=ik)g
5     continue
      return
      end
