
c  program digrf - definative IGRF one-shot calculation
c                  written by M. Webring, USGS, Denver

	dimension   vec(6)
	character   ans*80, blank*80
	blank = ' '
1	format( a )
	write(6,*) ' DIGRF model calculation'

	iyr   = 1980
	iday  = 1
	idate = 1000 * iyr + iday

	deg2r = 3.141597 / 180.
	dlat  =   40.
	dlon  = -105.
	rlat  = deg2r * dlat
	rlon  = deg2r * dlon

	alt   = 1500.

10      write(6,*) ' enter year and day [ eg.', iyr, iday, '  ]'
c        read(5,1) ans
c        if ( ans .ne. blank ) then
c          read( ans, * ) iyr, iday
        read(5,*) iyr,iday
          idate = 1000 * iyr + iday
c        endif

        write(6,*) ' enter lat (deg), long (deg positive EAST )  [ eg.',
     1         dlat, dlon, ' ]'
c        read(5,1) ans
c        if ( ans .ne. blank ) then
c          read( ans, * ) dlat, dlon
        read(5,*) dlat,dlon
	  rlat = deg2r * dlat
	  rlon = deg2r * dlon
c        endif

        write(6,*) ' enter altitude in meters asl  [ eg.', alt, ' ]'
c        read(5,1) ans
c        if ( ans .ne. blank ) read( ans, * ) alt
        read(5,*) alt

c        write(6,*) ' input=', idate, rlat, rlon, alt
        write(6,*) ' input=', idate, dlat, dlon, alt

	call digrf( rlat, rlon, alt, idate, vec, 6 )
	einc = vec(5) / deg2r
	edec = vec(6) / deg2r

	write(6,*)
	write(6,*) '   total field       inclination      declination'
	write(6,87) vec(1), einc, edec
87	format( 3f15.2 )
	write(6,*)	

	write(6,*) ' components: North        East         Vertical '
	write(6,88) vec(2), vec(3), vec(4)
88	format( 3f15.2 )
	write(6,*)

	write(6,*)  ' another ? [y]'
	read(5,1) ans
	if ( ans(1:1) .eq. 'n'   .or.   ans(1:1) .eq. 'N' ) stop
	go to 10
	end
c*******************************************************************************
          subroutine digrf(lat,long,alt,idate,vec,icode)
          save
c
c DIGRF GENERATES MAIN GEOMAGNETIC FIELD COMPONENTS, USING THE
c DEFINITIVE IGRF 1945 - 1990, IGRF 1995, & THE IGRF 1995
c SECULAR CHANGE COEFFICIENTS.
c
c_______________________________________________________________________
c
c     PROGRAM BASED ON:
c      "COMPUTATION OF THE MAIN GEOMAGNETIC FIELD FROM
c       SPHERICAL HARMONIC EXPANSIONS"
c       BY: J. C. CAIN, ET. AL., NASA DATA USERS NOTE, NSSDC 68-11,
c       MAY,1968
c
c     PROGRAM MODIFIED BY:
c       GERALD I. EVENDEN
c       U. S. GEOLOGICAL SURVEY
c       DENVER FEDERAL CENTER
c       DENVER, COLORADO   80225
c
c     PROGRAM FURTHER MODIFIED BY:
c       RONALD E. SWEENEY
c       U. G. GEOLOGICAL SURVEY
c       DENVER FEDERAL CENTER
c       DENVER, COLORADO   80225
c
c       SO AS TO INCLUDE CURRENT EARTH ELLIPSOIDAL PARAMETERS:
c
c       A=6371.2
c       RE=6378.16
c       FLAT=1./298.25
c
c_______________________________________________________________________
c
c     PARAMETER DESCRIPTION:
c       LAT,LONG : LATITUDE, LONGITUDE COORDINATES IN RADIANS
c                  POS. NORTH LATITUDE
c                  POS. EAST LONGITUDE
c       ALT      : ALTITUDE OF POINT ABOVE SEA LEVEL (METERS)
c       IDATE    : DATE IN YEAR*1000+DAY
c                  IE. 1972035.. YEAR 1972, DAY 35
c       VEC      : RESULTANT EARTH FIELD VECTOR(S)
c       ICODE    : RESULTANT VECTOR(S) STORED IN VEC
c             =1 : TOTAL FIELD              (GAMMAS)
c             =2 : E-W HORIZONTAL COMPONENT (GAMMAS)
c             =3 : N-S HORIZONTAL COMPONENT (GAMMAS)
c             =4 : VERTICAL COMPONENT       (GAMMAS)
c             =5 : ALL OF THE ABOVE STORED IN VEC(1) THRU VEC(4)
c                  RESPECTIVELY,... PLUS
c                  VEC(5)=INCLINATION (RADIANS)
c                  VEC(6)=DECLINATION (RADIANS)
c
c_______________________________________________________________________
c
          dimension vec(6)
          real lat,long
          logical notall
c
          dimension g(66),h(66),gt(66),ht(66),p(66),dp(66),const(66),
     &      sp(11),cp(11),g45(66),h45(66),g50(66),h50(66),
     &      g55(66),h55(66),g60(66),h60(66),g65(66),h65(66),
     &      g70(66),h70(66),g75(66),h75(66),g80(66),h80(66),
     &      g85(66),h85(66),g90(66),h90(66),g95(66),h95(66),
     &      gh0(132,11),gh(132),ght(132)
          equivalence  (gh0(1,1),g45(1)),(gh0(67,1),h45(1)),
     &      (gh0(1,2),g50(1)),(gh0(67,2),h50(1)),
     &      (gh0(1,3),g55(1)),(gh0(67,3),h55(1)),
     &      (gh0(1,4),g60(1)),(gh0(67,4),h60(1)),
     &      (gh0(1,5),g65(1)),(gh0(67,5),h65(1)),
     &      (gh0(1,6),g70(1)),(gh0(67,6),h70(1)),
     &      (gh0(1,7),g75(1)),(gh0(67,7),h75(1)),
     &      (gh0(1,8),g80(1)),(gh0(67,8),h80(1)),
     &      (gh0(1,9),g85(1)),(gh0(67,9),h85(1)),
     &      (gh0(1,10),g90(1)),(gh0(67,10),h90(1)),
     &      (gh0(1,11),g95(1)),(gh0(67,11),h95(1)),
     &      (gh(1),g(1)),(gh(67),h(1)),
     &      (ght(1),gt(1)),(ght(67),ht(1))
          equivalence (p(2),sind,sinla2),
     &      (p(3),cosd,den2),
     &      (p(4),notall,den),
     &      (p(5),altk),
     &      (p(6),fac)
c
c  DIGRF COEFFICIENTS, GAUSS NORMALIZED.
c
      data g45/
     &   0.0000000E+00, 3.0594000E+04, 2.2850000E+03, 1.8660000E+03,
     &  -5.1788319E+03,-1.3665881E+03,-3.2050000E+03, 5.6154552E+03,
     &  -2.4302970E+03,-7.2178988E+02,-4.1300000E+03,-4.2943731E+03,
     &  -2.1287367E+03, 8.8058468E+02,-2.2481103E+02, 1.9923750E+03,
     &  -3.5176371E+03,-1.4909313E+03, 9.4124253E+01, 3.1503125E+02,
     &   5.7527982E+01,-8.5181250E+02,-1.0774781E+03,-8.9665394E+01,
     &   2.4508541E+03, 1.3642155E+02,-4.8863090E+01, 6.9856102E+01,
     &  -1.8768750E+03, 1.4187841E+03, 0.0000000E+00, 0.0000000E+00,
     &   3.5811900E+02, 6.1744654E+01,-3.6327369E+01,-1.8770536E+01,
     &  -6.5355469E+02,-4.6921875E+02, 4.4865894E+02, 2.0709787E+02,
     &  -2.4062598E+02,-1.0381410E+02, 6.8652274E+01,-1.7547786E+01,
     &  -1.2534133E+00,-4.7480469E+02, 2.6754728E+03,-1.0865004E+02,
     &   9.1281124E+02,-1.6912722E+02,-5.3905516E+02, 5.2193792E+01,
     &   3.0134100E+01, 7.7519332E+00, 2.4361976E+00, 5.4127734E+02,
     &  -2.6761468E+03,-2.1069192E+02,-3.3056068E+02, 5.8435425E+02,
     &   7.3915615E+01,-3.3056068E+02, 2.0043185E+01, 2.4547788E+01,
     &  -1.3273924E+01, 1.1872558E+00 /
      data h45/
     &   0.0000000E+00, 0.0000000E+00,-5.8100000E+03, 0.0000000E+00,
     &   2.9479505E+03,-4.1309412E+02, 0.0000000E+00, 1.5278692E+03,
     &  -3.6018745E+02, 8.6962636E+00, 0.0000000E+00,-7.9689397E+02,
     &   1.0800208E+03, 1.1504075E+02, 1.3163278E+02, 0.0000000E+00,
     &   1.2199898E+02,-7.3009524E+02, 3.1531625E+02, 2.6400506E+02,
     &  -5.7527982E+01, 0.0000000E+00,-1.1341875E+02,-1.4944232E+03,
     &  -1.5940514E+02, 4.9111759E+01, 3.7229021E+01, 2.6196038E+01,
     &   0.0000000E+00, 1.5961322E+03, 5.2129458E+02,-4.0956770E+01,
     &  -7.4093585E+01,-1.7288503E+02, 4.1171018E+01, 1.4239717E+01,
     &   0.0000000E+00,-8.0437500E+02, 1.1777297E+03, 4.9703488E+02,
     &   1.8715354E+02,-2.9661173E+01,-1.2357409E+02,-7.5204799E+00,
     &   6.8937732E+00, 0.0000000E+00, 3.4398936E+03,-1.8470507E+03,
     &  -2.4065024E+03, 5.0738165E+02,-1.3476379E+02,-1.5658138E+02,
     &  -4.5201150E+01,-2.5839777E+00,-4.8723951E+00, 0.0000000E+00,
     &  -1.2164304E+03,-2.1069192E+02, 3.3056068E+03, 1.1687085E+02,
     &   4.4349369E+02,-2.4792051E+02, 8.0172741E+01, 1.6365192E+01,
     &   0.0000000E+00, 1.1872558E+00 /
      data g50/
     &   0.0000000E+00, 3.0554000E+04, 2.2500000E+03, 2.0115000E+03,
     &  -5.1926883E+03,-1.3648560E+03,-3.2425000E+03, 5.7838577E+03,
     &  -2.4670904E+03,-7.0835020E+02,-4.1737500E+03,-4.3829168E+03,
     &  -2.0661268E+03, 8.5339323E+02,-2.2407152E+02, 1.8900000E+03,
     &  -3.5481369E+03,-1.6215800E+03, 9.4124253E+01, 3.2612390E+02,
     &   5.3318618E+01,-7.7962500E+02,-1.0774781E+03,-5.9776929E+01,
     &   2.4608169E+03, 8.7309793E+01,-2.7921766E+01, 7.0527795E+01,
     &  -1.7428125E+03, 1.9508282E+03,-5.7921620E+01,-2.0478385E+01,
     &   4.9395723E+02, 4.3221258E+01,-1.2109123E+01,-1.2297937E+01,
     &  -1.1060156E+03,-1.0054688E+03, 2.2432947E+02, 4.1419573E+01,
     &  -2.9409842E+02,-2.2245879E+02, 8.9247957E+01,-1.2534133E+01,
     &   6.2670665E-01,-2.8488281E+02, 8.9182427E+02, 1.0865004E+02,
     &   2.0745710E+03,-5.6375738E+02,-1.6845474E+02, 8.6989653E+01,
     &   1.5067050E+01,-7.7519332E+00,-4.8723951E+00, 1.4434063E+03,
     &  -9.7314430E+02, 2.1069192E+02,-2.1486444E+03, 4.6748340E+02,
     &  -2.9566246E+02,-4.9584102E+02,-6.0129556E+01,-1.6365192E+01,
     &  -2.6547848E+01,-1.7808838E+00 /
      data h50/
     &   0.0000000E+00, 0.0000000E+00,-5.8150000E+03, 0.0000000E+00,
     &   3.1350120E+03,-3.2995568E+02, 0.0000000E+00, 1.4574464E+03,
     &  -3.9891728E+02, 3.6366193E+01, 0.0000000E+00,-7.5262208E+02,
     &   1.0878471E+03, 7.7391052E+01, 1.5529709E+02, 0.0000000E+00,
     &  -3.0499744E+01,-7.9157695E+02, 4.0944050E+02, 2.7066065E+02,
     &  -5.6124861E+01, 0.0000000E+00, 1.8903125E+01,-1.4794790E+03,
     &  -3.2877311E+02, 6.5482345E+01, 2.7921766E+01, 2.0150799E+01,
     &   0.0000000E+00, 1.2414361E+03, 4.9233377E+02, 0.0000000E+00,
     &  -1.2348931E+02,-2.2228076E+02, 4.3592843E+01, 1.0356158E+01,
     &   0.0000000E+00,-3.3515625E+02, 1.2338121E+03, 0.0000000E+00,
     &   5.6146061E+02, 1.1864469E+02,-1.1670887E+02, 1.0027306E+01,
     &   1.0654013E+01, 0.0000000E+00, 3.0576832E+03,-2.0643508E+03,
     &  -9.9579408E+02,-1.1275148E+02,-6.7381895E+01,-1.3918344E+02,
     &  -6.0268199E+01, 2.8423755E+01, 4.2633457E+00, 0.0000000E+00,
     &  -3.1627190E+03, 4.2138384E+02, 1.6528034E+03,-2.3374170E+02,
     &   2.2174685E+02,-2.4792051E+02, 6.0129556E+01,-4.9095577E+01,
     &  -2.9202632E+01,-4.7490233E+00 /
      data g55/
     &   0.0000000E+00, 3.0500000E+04, 2.2150000E+03, 2.1600000E+03,
     &  -5.2013486E+03,-1.3691862E+03,-3.2550000E+03, 5.9522601E+03,
     &  -2.4942013E+03,-6.9728222E+02,-4.1912500E+03,-4.4050528E+03,
     &  -1.9956907E+03, 8.3038508E+02,-2.1445789E+02, 1.8033750E+03,
     &  -3.6599693E+03,-1.7675990E+03, 1.0824289E+02, 3.3721655E+02,
     &   4.8407692E+01,-6.7856250E+02,-1.0774781E+03,-4.4832697E+01,
     &   2.4608169E+03, 4.3654897E+01,-1.6287697E+01, 7.1871182E+01,
     &  -1.7428125E+03, 1.9862978E+03,-5.7921620E+01,-2.0478385E+02,
     &   3.9516579E+02, 6.7919120E+01,-2.1796421E+01,-1.1650677E+01,
     &  -5.5300781E+02,-6.0328125E+02, 3.3649420E+02, 5.7987403E+02,
     &  -1.6041732E+02,-1.4830586E+02, 4.8056592E+01,-1.5040960E+01,
     &  -5.6403599E+00,-3.7984375E+02,-1.1466312E+03, 4.3460017E+02,
     &   4.1491420E+02,-1.1275148E+02,-1.3476379E+02,-1.7397931E+01,
     &  -1.5067050E+01,-5.1679555E+00,-3.0452470E+00, 5.4127734E+02,
     &   1.2164304E+03, 2.1069192E+02,-3.3056068E+02, 3.5061255E+02,
     &  -5.1740931E+02,-1.6528034E+02, 4.0086371E+01,-4.9095577E+01,
     &   5.3095695E+00, 0.0000000E+00 /
      data h55/
     &   0.0000000E+00, 0.0000000E+00,-5.8200000E+03, 0.0000000E+00,
     &   3.2874324E+03,-2.5201339E+02, 0.0000000E+00, 1.4145803E+03,
     &  -4.1828220E+02, 6.5617261E+01, 0.0000000E+00,-7.3602013E+02,
     &   1.0721946E+03, 4.8107952E+01, 1.7008729E+02, 0.0000000E+00,
     &  -1.5249872E+02,-8.4537344E+02, 4.6120884E+02, 2.6844212E+02,
     &  -5.4721739E+01, 0.0000000E+00, 1.7012812E+02,-1.4346463E+03,
     &  -4.7821543E+02, 8.7309793E+01, 2.7921766E+01, 1.6120639E+01,
     &   0.0000000E+00, 1.7734802E+03, 6.9505944E+02, 8.1913541E+01,
     &  -9.8791447E+01,-1.7288503E+02, 4.8436492E+01, 1.1650677E+01,
     &   0.0000000E+00,-6.7031250E+02, 8.4123551E+02,-2.0709787E+02,
     &   6.1493305E+02,-4.4491759E+01,-1.5790023E+02, 1.0027306E+01,
     &   8.1471865E+00, 0.0000000E+00, 1.4014381E+03,-1.3038005E+03,
     &  -5.8087988E+02,-3.3825443E+02, 6.7381895E+01,-1.7397931E+02,
     &  -5.2734674E+01, 1.5503866E+01,-3.0452470E+00, 0.0000000E+00,
     &   9.7314430E+02, 0.0000000E+00, 1.3222427E+03, 2.3374170E+02,
     &   2.9566246E+02,-4.1320085E+01, 6.0129556E+01,-5.7278173E+01,
     &   2.6547848E+00, 1.7808838E+00 /
      data g60/
     &   0.0000000E+00, 3.0421000E+04, 2.1690000E+03, 2.3325000E+03,
     &  -5.1996165E+03,-1.3769804E+03,-3.2550000E+03, 6.0992295E+03,
     &  -2.4961378E+03,-6.9411995E+02,-4.1868750E+03,-4.4271887E+03,
     &  -1.9722120E+03, 8.2411013E+02,-1.9892818E+02, 1.7482500E+03,
     &  -3.6803024E+03,-1.8598216E+03, 1.2236153E+02, 3.4609067E+02,
     &   4.4198328E+01,-6.6412500E+02,-1.0963812E+03,-1.4944232E+01,
     &   2.3611887E+03, 5.4568621E+00, 4.6536276E+00, 7.5901342E+01,
     &  -1.7964375E+03, 1.9862978E+03,-1.4480405E+02,-3.0717578E+02,
     &   3.9516579E+02, 4.3221258E+01,-4.1171018E+01,-5.1780788E+00,
     &  -7.5410156E+02,-4.0218750E+02, 2.2432947E+02, 4.5561531E+02,
     &  -5.3472439E+01,-1.4830586E+02, 3.4326137E+01,-2.5068266E+01,
     &  -5.0136532E+00,-3.7984375E+02,-7.6442080E+02, 0.0000000E+00,
     &   7.4684556E+02,-5.6375738E+01,-1.3476379E+02, 1.7397931E+01,
     &   1.5067050E+01,-7.7519332E+00, 6.0904939E-01,-1.8042578E+02,
     &   7.2985822E+02,-8.4276768E+02, 0.0000000E+00, 1.1687085E+02,
     &  -2.9566246E+02,-2.4792051E+02,-2.0043185E+01, 8.1825962E+00,
     &  -5.3095695E+00, 0.0000000E+00 /
      data h60/
     &   0.0000000E+00, 0.0000000E+00,-5.7910000E+03, 0.0000000E+00,
     &   3.4069439E+03,-1.7840123E+02, 0.0000000E+00, 1.2676109E+03,
     &  -4.3377413E+02, 1.0277402E+02, 0.0000000E+00,-7.4708810E+02,
     &   1.0878471E+03,-6.2749502E+00, 1.8857504E+02, 0.0000000E+00,
     &  -1.6266530E+02,-9.6065163E+02, 5.5062688E+02, 2.5291241E+02,
     &  -5.6826422E+01, 0.0000000E+00, 1.8903125E+02,-1.4794790E+03,
     &  -5.9776929E+02, 1.0913724E+02, 2.5594952E+01, 1.1418786E+01,
     &   0.0000000E+00, 1.9508282E+03, 8.1090268E+02, 1.2287031E+02,
     &  -8.6442516E+01,-1.4201271E+02, 4.3592843E+01, 1.1003417E+01,
     &   0.0000000E+00,-7.3734375E+02, 7.8515314E+02,-2.8993701E+02,
     &   4.8125195E+02,-5.9322345E+01,-1.5790023E+02,-2.5068266E+00,
     &   1.2534133E+01, 0.0000000E+00, 2.2932624E+03,-1.3038005E+03,
     &  -1.6596568E+02, 0.0000000E+00, 1.0107284E+02,-1.5658138E+02,
     &  -6.0268199E+01, 0.0000000E+00,-3.0452470E+00, 0.0000000E+00,
     &  -9.7314430E+02,-2.1069192E+02, 0.0000000E+00,-2.3374170E+02,
     &   3.6957808E+02,-4.1320085E+01, 2.0043185E+01,-4.9095577E+01,
     &   0.0000000E+00, 4.1553954E+00 /
      data g65/
     &   0.0000000E+00, 3.0334000E+04, 2.1190000E+03, 2.4930000E+03,
     &  -5.1909563E+03,-1.3804445E+03,-3.2425000E+03, 6.2400751E+03,
     &  -2.5019472E+03,-6.7672742E+02,-4.1868750E+03,-4.4493247E+03,
     &  -1.8743840E+03, 8.1574353E+02,-1.8635651E+02, 1.7246250E+03,
     &  -3.6396361E+03,-1.9520441E+03, 1.4589259E+02, 3.4830920E+02,
     &   4.3496767E+01,-6.4968750E+02,-1.1530906E+03,-1.1955386E+02,
     &   2.2715233E+03,-2.1827448E+01,-2.3268138E+00, 7.4557955E+01,
     &  -2.0109375E+03, 2.0217674E+03,-1.1584324E+02,-2.6621901E+02,
     &   3.2107220E+02, 3.7046793E+01,-3.1483720E+01,-6.4725985E-01,
     &  -6.5355469E+02,-3.3515625E+02, 2.2432947E+02, 5.7987403E+02,
     &   0.0000000E+00,-1.1864469E+02, 6.8652274E+00,-2.7575093E+01,
     &  -2.5068266E+00,-7.5968750E+02,-1.2740347E+03,-2.1730008E+02,
     &   1.0787769E+03,-5.6375738E+02, 3.3690948E+01, 1.7397931E+01,
     &  -3.7667625E+01,-2.5839777E+00, 1.2180988E+00, 3.6085156E+02,
     &   7.2985822E+02,-4.2138384E+02, 8.2640170E+02, 2.3374170E+02,
     &  -2.9566246E+02,-1.6528034E+02, 0.0000000E+00,-1.6365192E+01,
     &  -5.3095695E+00, 0.0000000E+00 /
      data h65/
     &   0.0000000E+00, 0.0000000E+00,-5.7760000E+03, 0.0000000E+00,
     &   3.4918144E+03,-9.8726896E+01, 0.0000000E+00, 1.2369923E+03,
     &  -4.6475800E+02, 1.3044395E+02, 0.0000000E+00,-8.1902991E+02,
     &   1.0526290E+03,-2.7191451E+01, 1.9892818E+02, 0.0000000E+00,
     &  -1.9316504E+02,-9.8370727E+02, 5.9298279E+02, 2.1519740E+02,
     &  -5.6826422E+01, 0.0000000E+00, 2.0793437E+02,-1.4944232E+03,
     &  -6.7747186E+02, 1.7461959E+02, 1.8614510E+01, 4.7018530E+00,
     &   0.0000000E+00, 2.1636458E+03, 7.8194187E+02, 4.0956770E+01,
     &  -7.4093585E+01,-1.6053610E+02, 5.5701966E+01, 7.7671182E+00,
     &   0.0000000E+00,-4.6921875E+02, 6.7298841E+02,-3.7277616E+02,
     &   4.2777951E+02,-5.9322345E+01,-1.6476546E+02, 7.5204799E+00,
     &   1.0654013E+01, 0.0000000E+00, 2.8028763E+03,-1.6297506E+03,
     &  -5.8087988E+02, 2.2550295E+02, 1.6845474E+02,-1.7397931E+02,
     &  -7.5335249E+01, 1.0335911E+01,-6.0904939E-01, 0.0000000E+00,
     &  -4.8657215E+02,-2.1069192E+02,-3.3056068E+02,-7.0122510E+02,
     &   2.9566246E+02, 0.0000000E+00, 4.0086371E+01,-2.4547788E+01,
     &   0.0000000E+00, 3.5617675E+00 /
      data g70/
     &   0.0000000E+00, 3.0220000E+04, 2.0680000E+03, 2.6715000E+03,
     &  -5.1961524E+03,-1.3951669E+03,-3.2175000E+03, 6.4023538E+03,
     &  -2.4748364E+03,-6.6249717E+02,-4.1650000E+03,-4.4271887E+03,
     &  -1.8039478E+03, 8.2620178E+02,-1.7304533E+02, 1.7010000E+03,
     &  -3.6498027E+03,-2.0135258E+03, 1.9766093E+02, 3.5496479E+02,
     &   3.9287403E+01,-6.2081250E+02,-1.2098000E+03,-2.2416348E+02,
     &   2.1121182E+03,-1.0913724E+01,-6.9804414E+00, 7.5229648E+01,
     &  -1.9305000E+03, 2.0217674E+03,-2.8960810E+01,-2.8669739E+02,
     &   2.7167648E+02, 1.2348931E+01,-3.1483720E+01, 1.2945197E+00,
     &  -7.0382813E+02,-4.0218750E+02, 1.1216473E+02, 5.3845445E+02,
     &   8.0208659E+01,-7.4152931E+01, 0.0000000E+00,-2.7575093E+01,
     &  -1.8801200E+00,-7.5968750E+02,-1.2740347E+03,-2.1730008E+02,
     &   9.9579408E+02,-5.6375738E+02, 3.3690948E+01, 0.0000000E+00,
     &  -2.2600575E+01,-2.5839777E+00, 6.0904939E-01, 5.4127734E+02,
     &   7.2985822E+02,-4.2138384E+02, 8.2640170E+02, 1.1687085E+02,
     &  -4.4349369E+02,-1.6528034E+02,-2.0043185E+01, 0.0000000E+00,
     &  -7.9643543E+00, 5.9362792E-01 /
      data h70/
     &   0.0000000E+00, 0.0000000E+00,-5.7370000E+03, 0.0000000E+00,
     &   3.5455080E+03,-2.1650635E+01, 0.0000000E+00, 1.1206416E+03,
     &  -4.8605941E+02, 1.5495161E+02, 0.0000000E+00,-9.2417565E+02,
     &   1.0408896E+03,-5.4382902E+01, 2.0632328E+02, 0.0000000E+00,
     &  -2.6433111E+02,-1.0682446E+03, 6.5416356E+02, 2.0188622E+02,
     &  -5.8229543E+01, 0.0000000E+00, 2.2683750E+02,-1.4944232E+03,
     &  -7.1732315E+02, 2.0190390E+02, 1.3960883E+01,-6.7169329E-01,
     &   0.0000000E+00, 2.4828722E+03, 7.8194187E+02, 8.1913541E+01,
     &  -9.8791447E+01,-1.4201271E+02, 5.5701966E+01, 7.1198583E+00,
     &   0.0000000E+00,-4.6921875E+02, 8.4123551E+02,-2.4851744E+02,
     &   4.5451573E+02,-8.8983518E+01,-1.4416978E+02, 1.5040960E+01,
     &   1.0027306E+01, 0.0000000E+00, 2.6754728E+03,-1.7384007E+03,
     &  -4.9789704E+02, 2.2550295E+02, 1.6845474E+02,-1.7397931E+02,
     &  -8.2868774E+01, 5.1679555E+00,-6.0904939E-01, 0.0000000E+00,
     &  -2.4328607E+02,-2.1069192E+02,-4.9584102E+02,-4.6748340E+02,
     &   2.9566246E+02, 0.0000000E+00, 2.0043185E+01,-2.4547788E+01,
     &  -2.6547848E+00, 2.3745117E+00 /
      data g75/
     &   0.0000000E+00, 3.0100000E+04, 2.0130000E+03, 2.8530000E+03,
     &  -5.2134729E+03,-1.4133535E+03,-3.1900000E+03, 6.5646325E+03,
     &  -2.4399795E+03,-6.5617261E+02,-4.1387500E+03,-4.3773829E+03,
     &  -1.7139461E+03, 8.4711828E+02,-1.5973415E+02, 1.7167500E+03,
     &  -3.6193029E+03,-2.0288963E+03, 2.7766655E+02, 3.5274626E+02,
     &   3.4376477E+01,-6.4968750E+02,-1.2476062E+03,-4.1843850E+02,
     &   1.9726387E+03,-5.4568621E+00,-1.3960883E+01, 7.4557955E+01,
     &  -1.9036875E+03, 1.9862978E+03,-2.8960810E+01,-3.2765416E+02,
     &   1.7288503E+02, 0.0000000E+00,-2.9061895E+01, 3.2362992E+00,
     &  -7.0382813E+02,-4.0218750E+02, 5.6082367E+01, 4.9703488E+02,
     &   2.1388976E+02,-5.9322345E+01, 0.0000000E+00,-2.5068266E+01,
     &  -6.2670665E-01,-6.6472656E+02,-1.2740347E+03,-2.1730008E+02,
     &   9.9579408E+02,-5.6375738E+02, 3.3690948E+01, 1.7397931E+01,
     &  -3.0134100E+01,-2.5839777E+00, 1.2180988E+00, 5.4127734E+02,
     &   7.2985822E+02,-4.2138384E+02, 8.2640170E+02, 2.3374170E+02,
     &  -3.6957808E+02,-1.6528034E+02,-2.0043185E+01, 0.0000000E+00,
     &  -7.9643543E+00, 5.9362792E-01 /
      data h75/
     &   0.0000000E+00, 0.0000000E+00,-5.6750000E+03, 0.0000000E+00,
     &   3.5801490E+03, 5.8889727E+01, 0.0000000E+00, 1.0196001E+03,
     &  -5.0736082E+02, 1.7629698E+02, 0.0000000E+00,-1.0569913E+03,
     &   1.0369765E+03,-8.1574353E+01, 2.1297887E+02, 0.0000000E+00,
     &  -3.1516402E+02,-1.1374115E+03, 7.1534432E+02, 1.8413798E+02,
     &  -6.1737347E+01, 0.0000000E+00, 2.4574062E+02,-1.4794790E+03,
     &  -7.4721161E+02, 2.2373135E+02, 9.3072552E+00,-7.3886262E+00,
     &   0.0000000E+00, 2.7311595E+03, 7.5298106E+02, 1.0239193E+02,
     &  -1.2348931E+02,-1.3583824E+02, 5.5701966E+01, 7.7671182E+00,
     &   0.0000000E+00,-4.0218750E+02, 8.9731788E+02,-1.6567829E+02,
     &   5.0798817E+02,-8.8983518E+01,-1.2357409E+02, 2.5068266E+01,
     &   1.0654013E+01, 0.0000000E+00, 2.6754728E+03,-1.7384007E+03,
     &  -5.8087988E+02, 2.2550295E+02, 1.6845474E+02,-1.7397931E+02,
     &  -8.2868774E+01, 7.7519332E+00,-6.0904939E-01, 0.0000000E+00,
     &  -2.4328607E+02,-2.1069192E+02,-4.9584102E+02,-4.6748340E+02,
     &   2.9566246E+02, 4.1320085E+01, 2.0043185E+01,-2.4547788E+01,
     &  -2.6547848E+00, 2.9681396E+00 /
      data g80/
     &   0.0000000E+00, 2.9992000E+04, 1.9560000E+03, 2.9955000E+03,
     &  -5.2429178E+03,-1.4402002E+03,-3.2025000E+03, 6.6748595E+03,
     &  -2.4225511E+03,-6.5854432E+02,-4.1037500E+03,-4.3275770E+03,
     &  -1.5574213E+03, 8.7640138E+02,-1.4716248E+02, 1.7167500E+03,
     &  -3.6294695E+03,-2.0058406E+03, 3.4825974E+02, 3.5940185E+02,
     &   3.3674916E+01,-6.9300000E+02,-1.2476062E+03,-6.2765776E+02,
     &   1.9128617E+03,-2.1827448E+01,-3.2575393E+01, 7.2542875E+01,
     &  -1.9305000E+03, 2.0927066E+03,-5.7921620E+01,-4.3004609E+02,
     &   1.4818717E+02,-6.1744654E+00,-2.6640071E+01, 1.2945197E+00,
     &  -9.0492188E+02,-4.0218750E+02, 0.0000000E+00, 4.5561531E+02,
     &   1.8715354E+02,-5.9322345E+01,-2.0595682E+01,-1.5040960E+01,
     &   6.2670665E-01,-4.7480469E+02,-1.2740347E+03,-1.0865004E+02,
     &   9.9579408E+02,-5.0738165E+02, 1.0107284E+02, 1.7397931E+01,
     &  -5.2734674E+01,-5.1679555E+00, 3.0452470E+00, 7.2170313E+02,
     &   9.7314430E+02,-4.2138384E+02, 8.2640170E+02, 2.3374170E+02,
     &  -3.6957808E+02,-1.2396026E+02,-2.0043185E+01,-1.6365192E+01,
     &  -7.9643543E+00, 0.0000000E+00 /
      data h80/
     &   0.0000000E+00, 0.0000000E+00,-5.6040000E+03, 0.0000000E+00,
     &   3.6875362E+03, 1.7320508E+02, 0.0000000E+00, 1.0287857E+03,
     &  -5.2478924E+02, 1.9922349E+02, 0.0000000E+00,-1.1732050E+03,
     &   1.0056716E+03,-1.1085745E+02, 2.1963446E+02, 0.0000000E+00,
     &  -4.6766274E+02,-1.1527820E+03, 7.1063811E+02, 1.7304533E+02,
     &  -6.4543590E+01, 0.0000000E+00, 2.8354687E+02,-1.3898136E+03,
     &  -7.0736033E+02, 2.3464507E+02, 4.6536276E+00,-1.1418786E+01,
     &   0.0000000E+00, 2.9085075E+03, 7.8194187E+02, 1.0239193E+02,
     &  -1.9758289E+02,-1.1114038E+02, 5.5701966E+01, 6.4725985E+00,
     &   0.0000000E+00,-4.6921875E+02, 1.0094826E+03,-1.6567829E+02,
     &   5.8819683E+02,-1.3347528E+02,-1.0984364E+02, 3.2588746E+01,
     &   9.4005998E+00, 0.0000000E+00, 2.6754728E+03,-1.7384007E+03,
     &  -7.4684556E+02, 2.8187869E+02, 2.0214569E+02,-1.5658138E+02,
     &  -7.5335249E+01, 1.5503866E+01,-1.2180988E+00, 0.0000000E+00,
     &  -2.4328607E+02, 0.0000000E+00,-4.9584102E+02,-7.0122510E+02,
     &   2.9566246E+02, 0.0000000E+00, 2.0043185E+01,-3.2730385E+01,
     &   0.0000000E+00, 3.5617675E+00 /
      data g85/
     &   0.0000000E+00, 2.9873000E+04, 1.9050000E+03, 3.1080000E+03,
     &  -5.2723627E+03,-1.4609849E+03,-3.2400000E+03, 6.7605917E+03,
     &  -2.4148051E+03,-6.5538205E+02,-4.0950000E+03,-4.3165090E+03,
     &  -1.4126359E+03, 8.8685963E+02,-1.2571670E+02, 1.6852500E+03,
     &  -3.6091364E+03,-1.9443589E+03, 4.3767778E+02, 3.6383891E+02,
     &   3.2271795E+01,-7.6518750E+02,-1.2287031E+03,-7.6215585E+02,
     &   1.8431220E+03,-2.1827448E+01,-3.7229021E+01, 6.8512716E+01,
     &  -1.9841250E+03, 2.1991154E+03,-8.6882430E+01,-4.9148124E+02,
     &   7.4093585E+01,-2.4697862E+01,-2.4218246E+01, 0.0000000E+00,
     &  -1.0557422E+03,-4.0218750E+02, 0.0000000E+00, 4.5561531E+02,
     &   2.4062598E+02,-5.9322345E+01,-2.7460910E+01,-1.0027306E+01,
     &   2.5068266E+00,-4.7480469E+02,-1.2740347E+03,-1.0865004E+02,
     &   9.9579408E+02,-5.0738165E+02, 1.0107284E+02, 1.7397931E+01,
     &  -5.2734674E+01,-2.5839777E+00, 3.0452470E+00, 7.2170313E+02,
     &   9.7314430E+02,-6.3207576E+02, 8.2640170E+02, 2.3374170E+02,
     &  -3.6957808E+02,-1.2396026E+02,-2.0043185E+01,-1.6365192E+01,
     &  -7.9643543E+00, 0.0000000E+00 /
      data h85/
     &   0.0000000E+00, 0.0000000E+00,-5.5000000E+03, 0.0000000E+00,
     &   3.8053156E+03, 2.6500377E+02, 0.0000000E+00, 9.4917728E+02,
     &  -5.4996364E+02, 2.3479912E+02, 0.0000000E+00,-1.2838847E+03,
     &   9.7436662E+02,-1.4432385E+02, 2.1963446E+02, 0.0000000E+00,
     &  -4.7782932E+02,-1.1527820E+03, 7.2475675E+02, 1.6638974E+02,
     &  -6.6648272E+01, 0.0000000E+00, 3.0245000E+02,-1.3150924E+03,
     &  -6.8743468E+02, 2.6192938E+02, 2.3268138E+00,-1.4105559E+01,
     &   0.0000000E+00, 2.9439771E+03, 7.8194187E+02, 4.0956770E+01,
     &  -2.4697862E+02,-1.0496591E+02, 5.5701966E+01, 4.5308189E+00,
     &   0.0000000E+00,-5.3625000E+02, 1.0655650E+03,-2.0709787E+02,
     &   6.1493305E+02,-1.6313645E+02,-9.6113184E+01, 3.7602399E+01,
     &   6.8937732E+00, 0.0000000E+00, 2.6754728E+03,-1.6297506E+03,
     &  -7.4684556E+02, 3.3825443E+02, 2.0214569E+02,-1.5658138E+02,
     &  -6.7801724E+01, 1.8087844E+01,-1.2180988E+00, 0.0000000E+00,
     &  -2.4328607E+02, 0.0000000E+00,-4.9584102E+02,-7.0122510E+02,
     &   2.9566246E+02, 0.0000000E+00, 2.0043185E+01,-3.2730385E+01,
     &   0.0000000E+00, 3.5617675E+00 /
      data g90/
     &    .0000000E+00, 2.9775000E+04, 1.8480000E+03, 3.1965000E+03,
     &  -5.2983434E+03,-1.4601188E+03,-3.2850000E+03, 6.8555094E+03,
     &  -2.4167416E+03,-6.3403667E+02,-4.1081250E+03,-4.3165090E+03,
     &  -1.2717637E+03, 8.8476798E+02,-1.0427091E+02, 1.6852500E+03,
     &  -3.5888032E+03,-1.8828772E+03, 5.1297718E+02, 3.6605744E+02,
     &   2.5256187E+01,-8.8068750E+02,-1.2287031E+03,-8.8170970E+02,
     &   1.7733822E+03,-1.6370586E+01,-4.1882649E+01, 6.4482556E+01,
     &  -2.0645625E+03, 2.2700546E+03,-5.7921620E+01,-5.3243801E+02,
     &   1.2348931E+01,-3.0872327E+01,-2.1796421E+01,  .0000000E+00,
     &  -1.1562891E+03,-3.3515625E+02, 5.6082367E+01, 4.1419573E+02,
     &   3.2083464E+02,-4.4491759E+01,-2.7460910E+01,-5.0136532E+00,
     &   3.7602399E+00,-3.7984375E+02,-1.1466312E+03,-1.0865004E+02,
     &   9.9579408E+02,-5.0738165E+02, 1.3476379E+02, 3.4795861E+01,
     &  -5.2734674E+01,-2.5839777E+00, 3.6542964E+00, 5.4127734E+02,
     &   9.7314430E+02,-4.2138384E+02, 8.2640170E+02, 2.3374170E+02,
     &  -2.9566246E+02,-1.2396026E+02,-2.0043185E+01,-2.4547788E+01,
     &  -7.9643543E+00,  .0000000E+00 /
      data h90/
     &    .0000000E+00,  .0000000E+00,-5.4060000E+03,  .0000000E+00,
     &   3.9473438E+03, 3.2302748E+02,  .0000000E+00, 8.6956886E+02,
     &  -5.6739206E+02, 2.7828043E+02,  .0000000E+00,-1.3668945E+03,
     &   9.3914855E+02,-1.7569861E+02, 2.2111348E+02,  .0000000E+00,
     &  -4.6766274E+02,-1.1835228E+03, 7.2005054E+02, 1.5307856E+02,
     &  -6.8051394E+01,  .0000000E+00, 3.0245000E+02,-1.2254270E+03,
     &  -6.8743468E+02, 2.8375683E+02,-2.3268138E+00,-1.6120639E+01,
     &    .0000000E+00, 2.8375683E+03, 7.5298106E+02,  .0000000E+00,
     &  -2.5932755E+02,-1.0496591E+02, 5.5701966E+01, 2.5890394E+00,
     &    .0000000E+00,-6.7031250E+02, 1.0655650E+03,-2.4851744E+02,
     &   5.8819683E+02,-1.7796704E+02,-8.2382729E+01, 4.0109226E+01,
     &   6.2670665E+00,  .0000000E+00, 2.5480693E+03,-1.6297506E+03,
     &  -9.1281124E+02, 3.9463017E+02, 2.3583663E+02,-1.5658138E+02,
     &  -6.0268199E+01, 1.8087844E+01,-1.2180988E+00,  .0000000E+00,
     &  -4.8657215E+02,-2.1069192E+02,-4.9584102E+02,-7.0122510E+02,
     &   2.9566246E+02,  .0000000E+00, 4.0086371E+01,-2.4547788E+01,
     &   2.6547848E+00, 3.5617675E+00 /
      data g95/
     &    .0000000E+00, 2.9682000E+04, 1.7890000E+03, 3.2955000E+03,
     &  -5.3243242E+03,-1.4592528E+03,-3.3225000E+03, 6.9443034E+03,
     &  -2.4186781E+03,-6.0794788E+02,-4.1168750E+03,-4.3275770E+03,
     &  -1.1387176E+03, 8.8058468E+02,-8.5783157E+01, 1.6537500E+03,
     &  -3.5786366E+03,-1.8213955E+03, 5.7415794E+02, 3.7049450E+02,
     &   1.8240580E+01,-9.5287500E+02,-1.2098000E+03,-9.7137510E+02,
     &   1.7136053E+03,-1.0913724E+01,-3.9555835E+01, 6.3139169E+01,
     &  -2.0913750E+03, 2.3764634E+03,-2.8960810E+01,-5.9387317E+02,
     &  -4.9395723E+01,-4.9395723E+01,-2.4218246E+01, 1.2945197E+00,
     &  -1.2065625E+03,-2.6812500E+02, 5.6082367E+01, 3.7277616E+02,
     &   3.7430707E+02,-5.9322345E+01,-3.4326137E+01,  .0000000E+00,
     &   4.3869466E+00,-3.7984375E+02,-1.1466312E+03,-1.0865004E+02,
     &   9.9579408E+02,-5.0738165E+02, 1.3476379E+02, 3.4795861E+01,
     &  -5.2734674E+01,  .0000000E+00, 3.6542964E+00, 5.4127734E+02,
     &   9.7314430E+02,-4.2138384E+02, 8.2640170E+02, 2.3374170E+02,
     &  -2.9566246E+02,-1.2396026E+02,-2.0043185E+01,-2.4547788E+01,
     &  -7.9643543E+00,  .0000000E+00 /
      data h95/
     &    .0000000E+00,  .0000000E+00,-5.3180000E+03,  .0000000E+00,
     &   4.0807117E+03, 3.6806080E+02,  .0000000E+00, 8.0526975E+02,
     &  -5.8482049E+02, 3.2097118E+02,  .0000000E+00,-1.4499043E+03,
     &   9.0784360E+02,-2.0498171E+02, 2.2259250E+02,  .0000000E+00,
     &  -4.4732958E+02,-1.2065785E+03, 7.1534432E+02, 1.4198591E+02,
     &  -6.9454515E+01,  .0000000E+00, 3.0245000E+02,-1.1507059E+03,
     &  -6.6750904E+02, 3.1104114E+02,-9.3072552E+00,-1.8807412E+01,
     &    .0000000E+00, 2.7311595E+03, 7.2402025E+02,-6.1435155E+01,
     &  -2.7167648E+02,-9.8791447E+01, 5.5701966E+01, 1.9417795E+00,
     &    .0000000E+00,-8.0437500E+02, 1.1216473E+03,-2.8993701E+02,
     &   5.6146061E+02,-1.7796704E+02,-6.8652274E+01, 4.2616052E+01,
     &   6.2670665E+00,  .0000000E+00, 2.4206659E+03,-1.6297506E+03,
     &  -9.1281124E+02, 3.9463017E+02, 2.3583663E+02,-1.5658138E+02,
     &  -5.2734674E+01, 2.0671822E+01,-6.0904939E-01,  .0000000E+00,
     &  -4.8657215E+02,-2.1069192E+02,-4.9584102E+02,-7.0122510E+02,
     &   2.9566246E+02,  .0000000E+00, 4.0086371E+01,-2.4547788E+01,
     &   2.6547848E+00, 3.5617675E+00 /
      data gt/
     &    .0000000E+00,-1.7600000E+01,-1.3000000E+01, 1.9800000E+01,
     &  -6.4085881E+00, 6.9282033E-01,-3.7500000E+00, 1.9595918E+01,
     &   3.8729834E-01, 6.4036126E+00,-3.5000001E+00,-4.9805872E+00,
     &   2.7000521E+01,-1.0458250E+00, 3.4017458E+00,-6.3000001E+00,
     &  -1.0166581E+00, 1.1527820E+01, 9.4124253E+00, 2.2185300E-01,
     &  -1.6135897E+00,-7.2187500E+00, 7.5612500E+00,-8.9665397E+00,
     &  -1.8929361E+01, 1.0913724E+00, 4.6536277E-01,  .0000000E+00,
     &   5.3625001E+00, 2.8375683E+01, 1.7376487E+01,-1.2287032E+01,
     &  -1.4818718E+01,-6.1744655E-01,-4.8436493E-01, 3.8835593E-01,
     &  -1.5082032E+01, 1.3406250E+01,-5.6082368E+00,-1.6567830E+01,
     &   2.9409842E+01,-4.4491761E+00,-1.3730455E+00, 2.2561439E+00,
     &   1.8801200E-01,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00 /
      data ht/
     &    .0000000E+00,  .0000000E+00, 1.8299999E+01,  .0000000E+00,
     &   2.5980762E+01, 7.6210237E+00,  .0000000E+00,-1.2553635E+01,
     &  -4.2602818E+00, 9.5658902E+00,  .0000000E+00,-9.9611744E+00,
     &  -4.6957429E+00,-5.6474553E+00, 7.3950997E-01,  .0000000E+00,
     &  -2.0333163E+00,-9.2222561E+00,-1.4118639E+00,-3.9933537E+00,
     &  -6.3140467E-01,  .0000000E+00,-5.6709376E+00, 2.3910772E+01,
     &   1.9925643E+00, 4.9111757E+00,-2.3268138E+00,-1.4777253E+00,
     &    .0000000E+00,-2.8375683E+01,-5.7921621E+00,-1.2287032E+01,
     &   4.9395724E+00,  .0000000E+00, 7.2654741E-01,  .0000000E+00,
     &    .0000000E+00,-2.6812500E+01, 1.1216474E+01,-8.2839148E+00,
     &  -1.8715353E+01,  .0000000E+00, 8.2382732E+00, 1.7547786E+00,
     &   3.7602401E-01,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00,  .0000000E+00,  .0000000E+00,
     &    .0000000E+00,  .0000000E+00 /
c
c                              COMPUTATIONAL COEFFICIENTS
c
      data const/
     &   0.0000000E+00, 0.0000000E+00, 1.0000000E+00, 3.3333333E-01,
     &   0.0000000E+00,-1.0000000E+00, 2.6666667E-01, 2.0000000E-01,
     &   0.0000000E+00,-3.3333333E-01, 2.5714286E-01, 2.2857143E-01,
     &   1.4285714E-01, 0.0000000E+00,-2.0000000E-01, 2.5396825E-01,
     &   2.3809524E-01, 1.9047619E-01, 1.1111111E-01, 0.0000000E+00,
     &  -1.4285714E-01, 2.5252525E-01, 2.4242424E-01, 2.1212121E-01,
     &   1.6161616E-01, 9.0909091E-02, 0.0000000E+00,-1.1111111E-01,
     &   2.5174825E-01, 2.4475524E-01, 2.2377622E-01, 1.8881119E-01,
     &   1.3986014E-01, 7.6923077E-02, 0.0000000E+00,-9.0909091E-02,
     &   2.5128205E-01, 2.4615385E-01, 2.3076923E-01, 2.0512821E-01,
     &   1.6923077E-01, 1.2307692E-01, 6.6666667E-02, 0.0000000E+00,
     &  -7.6923077E-02, 2.5098039E-01, 2.4705882E-01, 2.3529412E-01,
     &   2.1568627E-01, 1.8823529E-01, 1.5294118E-01, 1.0980392E-01,
     &   5.8823529E-02, 0.0000000E+00,-6.6666667E-02, 2.5077399E-01,
     &   2.4767802E-01, 2.3839009E-01, 2.2291022E-01, 2.0123839E-01,
     &   1.7337461E-01, 1.3931889E-01, 9.9071207E-02, 5.2631579E-02,
     &   0.0000000E+00,-5.8823529E-02 /
          data a2,a4,b2,a2b2,a4b4,lastdt,tzero/
     & 4.0680925e07,
     & 1.65493766e15,
     & 4.04085822e07,
     & 2.72342737e05,
     & 2.20841384e13,
     & -99999999,
     & 1945.  /
          data cp(1),sp(1),dp(1),p(1)/1.,0.,0.,1./
c
c TIME CORRECTION
c
          if (idate.eq.lastdt) go to 100
          t=float(idate/1000)+float(mod(idate,1000))/365. - tzero
          lastdt=idate
      if(t.ge.0.0) go to 20
      write(6,10) idate
   10 format(2x,'Error--DIGRF called with IDATE = ',i7,/,
     &9x,'For any IDATE < 1945000, DIGRF invalid!!')
      stop
   20 if(t.lt.50.) go to 40
c
c   Here use 1995 coefficients & time terms.
c
      t=t-50.
      do 30 n=1,132
   30 gh(n)=gh0(n,11)+t*ght(n)
      go to 100
c
c   Here interpolate between the 1945 thru 1995 coefficients.
c
   40 frac=t/5.+1.
      ncoef1=frac
      frac=amod(frac,1.0)
      ncoef2=ncoef1+1
      do 50 n=1,132
   50 gh(n)=gh0(n,ncoef1)+frac*(gh0(n,ncoef2)-gh0(n,ncoef1))
c
c POSITION COMPUTATIONS
c
100       sinla=sin(lat)
          sinla2=sinla**2
          cosla2=1.-sinla2
          den2=a2-a2b2*sinla2
          den=sqrt(den2)
          altk=alt*1e-3
          fac=(((altk*den)+a2)/((altk*den)+b2))**2
          ct=sinla/sqrt(fac*cosla2+sinla2)
          st=sqrt(1.-ct**2)
          sp(2)=sin(long)
          cp(2)=cos(long)
          n=2
          do 120 m=3,11
          sp(m)=sp(2)*cp(n)+cp(2)*sp(n)
          cp(m)=cp(2)*cp(n)-sp(2)*sp(n)
120       n=n+1
          aor=6371.2/sqrt(altk*(altk+2.*den)+(a4-a4b4*sinla2)/den2)
          ar=aor**2
          bt=0.
          bp=0.
          br=0.
          n1m=1
          n2m=1
          fn=2.
          nm=2
c
c POLYNOMIAL EVALUATION LOOP
c
          do 300 n=2,11
          ar=aor*ar
          fm=0.
          do 290 m=1,n
          if (n.ne.m) go to 240
          k=nm-n
          p(nm)=st*p(k)
          dp(nm)=st*dp(k)+ct*p(k)
          go to 250
240       p(nm)=ct*p(n1m)-const(nm)*p(n2m)
          dp(nm)=ct*dp(n1m)-st*p(n1m)-const(nm)*dp(n2m)
250       par=p(nm)*ar
          temp=g(nm)*cp(m)+h(nm)*sp(m)
          bp=bp-(g(nm)*sp(m)-h(nm)*cp(m))*fm*par
          bt=bt+temp*dp(nm)*ar
          br=br-temp*fn*par
          nm=nm+1
          n1m=n1m+1
          n2m=n2m+1
290       fm=fm+1.
          fn=fn+1.
          n1m=n1m-1
300       n2m=n2m-2
          bp=bp/st
c
c TRANSFORM, IF REQUIRED
c
          notall=icode.lt.5
          if (icode.eq.1) go to 411
          sind=sinla*st-sqrt(cosla2)*ct
          cosd= sqrt(1.-sind**2)
          n=1
          go to (411,412,413,414,411),icode
411       vec(1)=sqrt(bp**2+bt**2+br**2)
          if (notall) go to 500
          n=n+1
412       vec(n)=-bt*cosd-br*sind
          if (notall) go to 500
          n=n+1
413       vec(n)=bp
          if (notall) go to 500
          n=n+1
414       vec(n)=bt*sind-br*cosd
          if (notall) go to 500
          call polar(sqrt(vec(2)**2+vec(3)**2),vec(4),vec(5),bt)
          call polar(vec(2),vec(3),vec(6),bt)
500       return
          end
c
          subroutine polar(zr,zi,rad,amp)
c        PARMS  ZR = GIVEN REAL(Z) OR X-COORD.
c               ZI = GIVEN IMAG(Z) OR Y-COORD.
c               RAD= COMPUTED PHASE IN RADIANS (0,2PI)
c               AMP= COMPUTED AMPLITUDE.
c
          data pi,pi2/3.1415927,6.2831853/
          if(zr.eq.0.and.zi.eq.0) go to 9
          pv=atan2(abs(zi),abs(zr))
          if(zi.ge.0.and.zr.ge.0) go to 10
          if(zi.ge.0.and.zr.lt.0) go to 20
          if(zi.lt.0.and.zr.le.0) go to 30
          rad=pi2-pv
          go to 40
9         rad=0.
          amp=0.
          return
10        rad=pv
          go to 40
20        rad=pi-pv
          go to 40
30        rad=pi+pv
40        amp=sqrt(zr*zr+zi*zi)
          return
          end
