      SUBROUTINE HPSET(ICODE)
C
C	POSSIBLE VALUES FOR ICODE:
C	
C	ICODE = -1  PRE LINE/CHAR
C	      =  0  POST LINE/CHAR
C		 1  PRE SCALE WHEN UNSCALED
C		 2  POST SCALE
C		 3  PRE ENDPT
C		 4  PLTST CALL
C	VARIABLES:
C		XRASP, YRASP = RASTERS PER PLOT UNIT
C		XRASX, YRASX = MAXIMUM RASTERS PER DEVICE
C		               TO BE RETURNED TO USER
C			       VIA THE PLTSET CALL
C
C      INTEGER*2 IBUF
      INTEGER JBAUD(4)
      CHARACTER*80 STRING
C
$INCLUDE:'pxz99.cmn'
C
      EQUIVALENCE (IDWRK(1),IXLS1),(IDWRK(2),IXLS2),(IDWRK(3),IYLS1)
     1 ,(IDWRK(4),IYLS2),(IDWRK(5),IPEN),(IDWRK(6),IPLTST),
     2  (IDWRK(7),IPCHAR),(IDWRK(8),IXLS3),(IDWRK(9),IYLS3)
	 INTEGER P1(2), P2(2)
         CHARACTER WAITDUMMY*1,DFILE*80
         COMMON /HPSIZE/ WIDTH,HEIGHT,JCOM
      DATA JBAUD/#83,#A3,#C3,#E3/
C
C	PRE LINE/CHAR
	IF (ICODE .EQ. -1) THEN
		RETURN
C
C
C	POST LINE/CHAR
	ELSE IF (ICODE .EQ. 0) THEN
		IF (LUOUT.NE.LUTTY) RETURN
		CALL PXZ07(0.,0.,-1)
		IPLTST=0
		RETURN
C
C
C	PRE SCALE WHEN UNSCALED
	ELSE IF (ICODE .EQ. 1) THEN
		XRASP=1016.0
		YRASP=1016.0
		XRASX=WIDTH
		YRASX=HEIGHT
		IXLS1=0
		IYLS1=0
		IYLS2=0
		IXLS2=0
		IXLS3=0
		IYLS3=0
		NCCMX=256
		NCMAX=4
		RETURN
C
C
	ELSE IF (ICODE .EQ. 2) THEN
C	POST SCALE CALL
C		PLOTTER ON, INITIALIZE PLOTTER STATUS
		IPEN=0
		IPLTST=1
		IPCHAR=0
		IPENVM=0
		RETURN
C
C	PRE ENDPT
	ELSE IF (ICODE .EQ. 3) THEN
C		NO NEED FOR TO FLUSH BUFFERS FOR HP7580,
C		SO JUST RETURN.
		RETURN
C
C	PLTST ENTRY
	ELSE
C
C		PAUSE FOR OPERATOR TO SET PEN SPEED, ETC.
      write(*,'(1x,a,$)')'HP PLOTTER OUTPUT HAS BEEN SELECTED.'
      WRITE(6,*) ' YOU HAVE TWO OPTIONS FOR THE OUTPUT:'
      WRITE(6,*) ' P = DIRECT TO THE PLOTTER VIA A COM PORT'
      WRITE(6,*) ' F = TO A DISK FILE'
      WRITE(6,*) ' MAKE YOUR CHOICE: '
      READ(5, '(A1)') WAITDUMMY
      IF(WAITDUMMY.EQ.'F'.OR.WAITDUMMY.EQ.'f') THEN
       ICOM=0
       jcom=0
       WRITE(6,*) ' ENTER THE DISK FILE NAME: '
       READ(5,'(A80)') DFILE
       OPEN(20,FILE=DFILE,STATUS='UNKNOWN',RECL=80,
     1 FORM='FORMATTED',IOSTAT=ISTAT)
       IF(ISTAT.NE.0) THEN
        WRITE(6,*) ' ERROR OPENING OUTPUT FILE -- STATUS ',
     1 ISTAT
        STOP ' HP FILE ERROR'
       ENDIF
      ELSE

   50 WRITE(*,'(1X,A)')'ENTER BAUD RATE AND COM PORT NUMBER'
		READ(*,'(2i4)')ibaud,icom
                jcom = icom
C
C               INITIALIZE RS232 AT IBAUD BAUD,8 DATA BITS,1 STOP BIT
             IF(IBAUD.EQ.1200) THEN
             KBAUD=JBAUD(1)
             ELSE IF(IBAUD.EQ.2400) THEN
             KBAUD=JBAUD(2)
             ELSE IF(IBAUD.EQ.4800) THEN
             KBAUD=JBAUD(3)
             ELSE IF(IBAUD.EQ.9600) THEN
             KBAUD=JBAUD(4)
             ELSE
             KBAUD=0
             ENDIF
             IF(ICOM.LT.1.OR.ICOM.GT.4) THEN
             WRITE(*,55) ICOM
   55        FORMAT(' PORT NUMBER ',I5,' LT 1 OR GT 4')
             GO TO 50
             ENDIF
             IF(KBAUD.NE.0) THEN
             CALL INT232(KBAUD,ICOM,ISTAT)
             ELSE
             WRITE(*,60)
   60        FORMAT(' INPUT BAUD RATE NOT SUPPORTED',
     &      ';TRY 1200,2400,4800 OR 9600')
             GO TO 50
             ENDIF
           ENDIF
C
C
C
C		SINCE XON/XOFF IS DISABLED, TELL PLOTTER
C		TO SEND A CONTROL S WHEN WITHIN 120 CHARACTERS
C		OF BEING FULL.  WHEN BUFFER IS HALF
C		FULL, SIGNAL TO BEGIN FILLING IT AGAIN
C		BY SENDING A CONTROL Q.
c    c    c     string(1:11)=char(27)//'.I120;;17:'
c    c    c     call sndchr(string,11,ier)
c    c    c     write(*,*) 'i120',ier
c    c    c     string(1:7)=char(27)//'.N;19:'
c    c    c     call sndchr(string,7,ier)
c    c    c     write(*,*) 'n;19',ier
C               Initialize plotter and get it's size
                string(1:4)=' IN;'
                IF (ICOM.EQ.0) THEN
                 WRITE(20,'(A)') STRING(1:4)
                ELSE
                nchar=4
                call sndchr(string,nchar,ier)
                ENDIF
C
C		SET THE DELAY FOLLOWING AN OUTPUT REQUEST
C		TO THE PLOTTER.
                string(1:7)=' '//char(27)//'.M50:'
                IF (ICOM.EQ.0) THEN
                 WRITE(20,'(A)') STRING(1:7)
                ELSE
                call sndchr(string,7,ier)
                ENDIF
C               Plotter may experience communication difficulties
C               at higher baud rates, so retry operation five times
C               before aborting.
                if (icom.ne.0) then
                do 100 kount=1,5
                string(1:4)=' OP;'
                nchar=4
                call sndchr(string,nchar,ier)
                call recchr(string,26,ier)
             if(kount.eq.1) go to 100
             ic1=index(string,',')
             read(string(1:ic1-1),1000) p1(1)
             string=string(ic1+1:26)
             ic1=index(string,',')
             read(string(1:ic1-1),1000) p1(2)
             string=string(ic1+1:26)
             ic1=index(string,',')
             read(string(1:ic1-1),1000) p2(1)
             string=string(ic1+1:26)
             read(string,1000) p2(2)
1000         format(i6)
C
100		CONTINUE
             write(6,*) 'THE PLOTTER RETURNS THE PLOT SIZE AS: '
             write(6,*) ' X1 = ',p1(1),' Y1 = ',p1(2)
             write(6,*) ' X2 = ',p2(1),' Y2 = ',p2(2)
             write(6,*) 'IN FOUR HUNDREDTHS OF CENTIMETERS, OR'
C
C		SAVE WIDTH AND HEIGHT IN PLOTTER UNITS FOR
C		FUTURE CALLS TO HPSET.
                else
                write(20,*) 'SP1;'
                write(6,*) ' ENTER THE X,Y COORDINATES OF THE PLOT'
                write(6,*) ' ORIGIN (LOWER LEFT CORNER) AND THE X,Y'
                write(6,*) ' COORDINATES OF THE UPPER RIGHT CORNER'
                write(6,*) ' OF THE PLOT IN UNITS OF FOUR HUNDREDTHS'
                write(6,*) ' OF CENTIMETERS.  FOR EXAMPLE, TO FILL AN'
                write(6,*) ' 8-1/2 BY 11 INCH SHEET OF PAPER TRY'
                write(6,*) '         -5000 -3600 5000 3600'
                write(6,*) ' IF YOUR PLOTTER MEASURES FROM THE CENTER'
                write(6,*) ' OF THE PAPER, OR TRY'
                write(6,*) '         250 596 10250 7796'
                write(6,*) ' IF YOUR PLOTTER MEASURES FROM THE LOWER'
                write(6,*) ' LEFT CORNER OF THE PAPER:'
                read(5,*) p1,p2
                endif
120             WIDTH = P2(1)-P1(1)
		HEIGHT = P2(2)-P1(2)
C
C		CONVERT TO INCHES
		XRASX=.025/25.4*WIDTH
		YRASX=.025/25.4*HEIGHT
             write(*,150) xrasx,yrasx
  150        format(' WIDTH = 'f4.1,' INCHES, HEIGHT = ',f4.1,' INCHES')
            pause 'IF THIS LOOKS OK HIT RETURN; OTHERWISE HIT CNTRL C'
C		MOVE ORIGIN TO LOWER LEFT HAND CORNER
		IWIDTH = INT(WIDTH)
		IHEIGHT = INT(HEIGHT)
		WRITE (STRING,200) IWIDTH,IHEIGHT
200		FORMAT (' SC0,',I5,',0,',I5,';PA')
                IF (ICOM.EQ.0) THEN
                 WRITE(20,'(A)') STRING(1:21)
                ELSE
             CALL SNDCHR(STRING,21,IER)
             ENDIF
C            PICK UP PEN 1
             string(1:5)=' SP1;'
                IF (ICOM.EQ.0) THEN
                 WRITE(20,'(A)') STRING(1:5)
                ELSE
             call sndchr(string,5,ier)
             ENDIF
C
		RETURN
C
C
	ENDIF
	END
