      SUBROUTINE OFF3PT(X1,Y1,X2,Y2,X3,Y3,STH1,CTH1,DELX,DELY)
C
C   THIS SUBROUTINE CALCULATES (DELX,DELY) OFFSET FROM (X2,Y2), GIVEN
C     3 PTS & THE OFFSET DELTA DISTANCE DOFF (IN PLOT UNITS).
C     ALSO RETURNED ARE STH1 & CTH1, THE SIN & COS OF THE ANGLE LINE
C     SEGMENT 1 MAKES WITH THE PLOT AXES.
C
$INCLUDE:'pxz99.cmn'
C
      DATA TOL/.1/
C***********************************************************************
      DY=Y2-Y1
      DX=X2-X1
      R=SQRT(DX*DX+DY*DY)
      STH1=DY/R
      CTH1=DX/R
      TH1=ATAN2(DY*YRASPI,DX*XRASPI)
      TH2=ATAN2((Y3-Y2)*YRASPI,(X3-X2)*XRASPI)
C***********************************************************************
      TH=0.5*(TH1-TH2)
      CTH=COS(TH)
C
C   NOTE:  TOL MUST BE IN PLOT UNITS.  (E.G. INCHES)
C
      IF(ABS(CTH).GT.TOL) GO TO 10
C
C   HERE COS(TH) = 0.0; LINE RETRACES ITSELF.  CALC PERPENDICULAR.
C
      CALL RTOFF(X1,Y1,X2,Y2,DELX,DELY)
      RETURN
   10 P=DOFF/CTH
      THP=0.5*(TH2+TH1)
      DELY=P*COS(THP)*YRASP
      DELX=-P*SIN(THP)*XRASP
      RETURN
      END

