      SUBROUTINE PXZ02(IER)
C
C  PXZ02 IS THE ERROR MONITOR AND MESSAGE PRINTING
C  ROUTINE.  INPUT IER IS UNIQUE SYSTEM ERROR NUMBER.
C  IERCK IS MESSAGE TABULATION AND CUTOFF ARRAY FOR
C  LIMITING MESSAGES AND CUTTING OF OPERATION IF TOO
C  MANY ARE ENCOUNTERED.  IT IS ASSUMED THAT IER GREATER
C  THAN MAXER WILL CAUSE PROGRAM TERMINATION IN CALLING
C  ROUTINE OR IS MEANT AS A WARNING MESSAGE.
C
$INCLUDE:'pxz99.cmn'
C
C  CHECK TERMINATION  OR WARNING LEVEL..
      IF (IER.GT.MAXER) GO TO 10
      K=3*IER-2
C
C  UPDATE TOTAL ERROR COUNT
      IERCK(K)=IERCK(K)+1
C
C  UPDATE TERMINATION COUNT IF GREATER THAN ZERO..
C  NOTE.. LESS THAN ZERO MEANS NO TERMIANTION.
      IF (IERCK(K+2).GT.0) IERCK(K+2)=IERCK(K+2)-1
C
C  UPDATE PRINTABILITY COUNT.
      IF (IERCK(K+1).LE.0) GO TO 30
      IERCK(K+1)=IERCK(K+1)-1
C
C  PRINT MESSAGE
   10 WRITE(LUERR,20) IER
   20 FORMAT(22H ##PLOT SYS ERROR NO..,I2)
      goto (101,102,103,104,105,106,107,108,109,110,111,112,113,114,
     1115,116,117) ier
  101 print *,' SCALE: NOPTS <1 or >4'
      goto 30
  102 print *,' SCALE: Cannot initialize plotting device'
      goto 30
  103 print *,' SCALE: Data area size (XP(1)*YP(1)) = 0'
      goto 30
  104 print *,' SCALE: Plot margins (XP(3) or YP(3)) < 0'
      goto 30
  105 print *,' SCALE: Plot area size (XP(4)*YP(4)) <= 0'
      goto 30
  106 print *,' SCALE: Plot does not fit on the requested plot device'
      goto 30
  107 print *,' SCALE: No data area (D{X/Y}P(1)=D{X/Y}P(2)'
      goto 30
  108 print *,' SCALE: Non-positive data values in log display'
      goto 30
  109 print *,' SCALE: Data area and margins too big for plot area'
      goto 30
  110 print *,' SCALE: PLTSET called when the plot system was in the'
      print *,'        scaled state, or tried to use the plot system'
      print *,'        when it was in the unscaled state'
      goto 30
  111 print *,' LINE: Number of points passed <= 0'
      goto 30
  112 print *,' VCHAR: Size of characters <=0'
      goto 30
  113 print *,' VCHAR: Number of characters <=0'
      goto 30
  114 print *,' VCHAR: ICODE <0 or >7'
      goto 30
  115 print *,' reserved'
      goto 30
  116 print *,' LINE: Invalid pen number'
      goto 30
  117 goto (151,115,115,115,155,156,30) ier-50
  151 print *,' PLTSET: Plotter requested not available'
      goto 30
  155 print *,' LINE: Bad dashed line control'
      goto 30
  156 print *,' LINE: Pathology in vector determination'
      goto 30
   30 IF (IER.GT.MAXER.OR.IERCK(K+2).NE.0) RETURN
C
C  STOP BECAUSE OF ERROR OVERFLOW.
      WRITE(LUERR,40) IER
   40 FORMAT(36H ##EXCEEDED ERROR CNT FOR ERROR NO..,I3)
      STOP 173
C
      END

