C  PXZ09 CHECKS X-Y AXIS PAPER CONTROL (DZ) AND DATA
C  SCALING (DZP) AND INITIALIZES PARAMETERS...
C    IZLOG,RZMIN,RZMAX,ZSCLE,ZOFFS,ZRSPP
C
C  THE Z IDENTIFIER IS INSERTED TO DENOTE THAT EITHER
C  THE X OR Y AXIS IS INVOLVED.
C
C  ERROR ROUTINE PXZ02(3-9) IS CALLED.
C
      INTEGER FUNCTION PXZ09(DZP,ZP,IZLOG,ZRASP,ZRASX,
     1  RZMIN,RZMAX,ZSCLE,ZOFFS,ZRSPP,NOPTS,FMTL2)
C
      DIMENSION DZP(2),ZP(1)
C
C  SET DATA AREA SIZE.
      DZ=AINT(ZP(1)*ZRASP+.5)
      RZMAX=DZ
      IF (DZ.GT.0.) GO TO 10
      K=3
      GO TO 160
C
   10 IF (NOPTS.LE.2) GO TO 50
      RZMIN=AINT(ZP(3)*ZRASP+.5)
      RZMAX=DZ+RZMIN
      IF (RZMIN.GE.0..AND.ZP(3).GE.0.) GO TO 20
      K=4
      GO TO 160
C
   20 IF (NOPTS.LT.4) GO TO 60
      IF (ZP(4)) 30,60,40
   30 K=5
      GO TO 160
C
   40 ZRSPP=AINT(ZP(4)*ZRASP+.5)
      IF (RZMAX.LE.ZRSPP)  GO TO 70
      K=9
      GO TO 160
C
   50 RZMIN=0.
   60 ZRSPP=RZMAX
   70 IF (ZRSPP.LE.ZRASX)  GO TO 80
      K=6
      GO TO 160
C
C  SET TYPE CONVERSION
   80 IF (NOPTS.LE.2) GO TO 90
      IZLOG=IFIX(ZP(2))
      GO TO 100
   90 IZLOG=0
C
C  CHECK DZP
  100 A=DZP(1)
      B=DZP(2)
      DELZP=B-A
      IF (DELZP.NE.0.) GO TO 110
      K=7
      GO TO 160
C
  110 DZ=DZ*FMTL2
      IF (IZLOG) 130,120,130
C
C  LINEAR
  120 ZSCLE=DZ/(B-A)
      ZOFFS=.5*(RZMIN+RZMAX-ZSCLE*(A+B))
      GO TO 150
C
C  LOGRITHMIC
  130 IF (A.GT.0..AND.B.GT.0.) GO TO 140
      K=8
      GO TO 160
C
  140 ZSCLE=DZ/ALOG(B/A)
      ZOFFS=.5*(RZMIN+RZMAX-ZSCLE*ALOG(A*B))
C
C  SUCCESSFULLY SCALED...
  150 PXZ09=0
      RETURN
C
C  ERROR CONDITION...
  160 CALL PXZ02(K)
      PXZ09=-1
      RETURN
C
      END

