      SUBROUTINE PXZ11(XX,YY,XP,SIZE,FMT,NFMT)
C
C  GENERAL SUPPORT ROUTINE FOR LOGRITHMIC ANNOTATION
C  OF X AND Y AXIS.
C
C	****************************************************
C	NOTE:  THE ORIGNAL WAHL PACKAGE CONTAINED CALLS TO
C	THE USER-DEFINED ROUTINE "CHAR".  THIS CONFLICTS WITH
C	THE VAX VMS FORTRAN INTRINSIC FUNCTION "CHAR".  THEREFORE
C	ALL CALLS TO THE USER-DEFINED ROUTINE HAVE BEEN CHANGED TO
C	"VCHAR."              CINDY COOPER, 23-JUL-81
C	****************************************************
C
      CHARACTER FMT(1),IFMT(20)
      CHARACTER*20 JFMT,AAA
      INTEGER A
      DIMENSION XX(1),YY(1)
      DIMENSION A(5),SP(27),JP(27),SPC(9),
     1 JPC(9),THTA(4),XY(2)
      EQUIVALENCE(AAA,A(1)),(IFMT(1),JFMT)
      LOGICAL NOPS
C
$INCLUDE:'pxz99.cmn'
C
      DATA SP/3*.1,6*.2,.1,2*.2,6*.5,.2,3*.5,5*.0/
      DATA JP/3*9,6*4,9,2*4,6*1,4,3*1,5*0/
      DATA THTA,SPFC/1.570796,4.71239,0.,3.14159,1.5/
C     DATA RLARG/8#376777777777/
      DATA RLARG/16#FFFF7FFF/
C
      IF (SIZE.LE.0) GO TO 290
      DO 5 I=1,20
      IFMT(I)=FMT(I)
      IF(FMT(I).EQ.')') GO TO 7
    5 CONTINUE
    7 IF (XX(1).GT.XX(2)) GO TO 10
      FMIN=XX(1)
      FMAX=XX(2)
      GO TO 20
   10 FMIN=XX(2)
      FMAX=XX(1)
   20 DFCT=EXP(SIZE*SPFC*ALOG(FMAX/FMIN)/XP)
      IF (DFCT.LT.1.1) GO TO 40
      IF (DFCT.LT.1.35) GO TO 50
      IF (DFCT.LT.1.65) GO TO 60
      KF=-1
      DO 30 I=1,9
        JPC(I)=0
   30   CONTINUE
      GO TO 90
   40 KF=0
      GO TO 70
   50 KF=9
      GO TO 70
   60 KF=18
   70 DO 80 I=1,9
        JPC(I)=JP(I+KF)
   80   CONTINUE
   90 IF (NFMT.LE.0) GO TO 100
      XYLL=FMIN*DFCT
      XYULL=FMAX/DFCT
      GO TO 110
  100 XYLL=0
      XYULL=RLARG
C
C  SET UP SECONDARY SIZES AND OFFSETS
  110 SIZA=2.*SIZE
      XOFT=.33333333*SIZA
      XOFC=.5*XOFT
      XOFA=-SIZE
      XOFB=XOFA*5.
      XOF=FLOAT(NFMT)*XOFA
C
C  SET CYCLE
      AA=ALOG10(FMIN)
      B=AINT(AA)
      IF (B.GT.AA) B=B-1.
      ICYC=B
      DLSI=10.**B
C
C  SET IIS AND JJS
      AA=FMIN/DLSI
      B=AINT(AA)
      IIS=IFIX(B)
      AA=AA-B
      IF (JPC(IIS).GT.0) GO TO 130
  120 IIS=IIS+1
      JJS=1
      IF (IIS.LT.9) GO TO 140
      IIS=1
      ICYC=ICYC+1
      DLSI=DLSI*10.
      GO TO 140
  130 JJS=IFIX(AA/SP(KF+IIS))+1
      IF (JJS.GT.JP(IIS)) GO TO 120
C
  140 XY(IYAXC)=YY(1)
      NOPS=.FALSE.
      THT=THTA(IAXTY)
      DLII=DLSI
      XY(IXAXC)=FMIN
      IF (NFMT.EQ.0) GO TO 150
C
C  POST MINIMUM
      WRITE(AAA,JFMT) FMIN
      CALL VCHAR(XY(1),XY(2),A,NFMT,2,SIZE,THT,XOF,0.)
C
C  INITIALIZE
  150 IS=IIS
      JS=JJS
      CALL VCHAR(XY(1),XY(2),IHYPH,1,1,SIZA,THT,XOFT,0.)
      XY(IXAXC)=FLOAT(IS)*DLSI
      IF (KF.LT.0) GO TO 170
      DO 160 I=1,9
        SPC(I)=SP(I+KF)*DLSI
  160   CONTINUE
  170 CONTINUE
C
C  CYCLE LOOP
  180 XNEXT=DLSI*10.
      XYL=AMIN1(XYULL,XNEXT/DFCT)
C
C  MAJOT TICKS AND LABELLING
      DO 250 I=IS,9
        IF (XY(IXAXC).GE.FMAX) GO TO 270
        IF (NFMT.GT.0.AND.XY(IXAXC).LE.FMIN) GO TO 220
        CALL VCHAR(XY(1),XY(2),IHYPH,1,1,SIZA,THT,XOFT,0.)
        IF (NOPS.OR.XY(IXAXC).LT.XYLL.OR.XY(IXAXC).GT.XYL)
     1       GO TO 220
        IF (I.EQ.1) GO TO 190
        CALL VCHAR(XY(1),XY(2),I+IZROT,1,1,SIZE,THT,XOFA,0.)
        GO TO 210
  190   WRITE(AAA,200) ICYC
  200   FORMAT('1E',I3)
        CALL VCHAR(XY(1),XY(2),A,5,2,SIZE,THT,XOFB,0.)
  210   XYLL=XY(IXAXC)*DFCT
C
C  MINOR TICKS
  220   JE=JPC(I)
        IF (JE.LE.0) GO TO 240
        XLST=XY(IXAXC)
        DLSJ=SPC(I)
        IF (JS.GT.1) XY(IXAXC)=XY(IXAXC)+FLOAT(JS-1)*DLSJ
        DO 230 J=JS,JE
          XY(IXAXC)=XY(IXAXC)+DLSJ
          IF (XY(IXAXC).GT.FMAX) GO TO 270
          CALL VCHAR(XY(1),XY(2),IHYPH,1,1,SIZE,THT,XOFC,0.)
  230     CONTINUE
        XY(IXAXC)=XLST
  240   JS=1
        XY(IXAXC)=XY(IXAXC)+DLSI
  250   CONTINUE
      IS=1
      XY(IXAXC)=XNEXT
      DLSI=XNEXT
      ICYC=ICYC+1
      IF (KF.LT.0) GO TO 180
      DO 260 I=1,9
  260 SPC(I)=SPC(I)*10.
      GO TO 180
C
C  END OF AXIS PASS
  270 XY(IXAXC)=FMAX
      CALL VCHAR(XY(1),XY(2),IHYPH,1,1,SIZA,THT,XOFT,0.)
      IF (NOPS) GO TO 290
      IF (NFMT.LE.0) GO TO 280
      WRITE(AAA,JFMT) FMAX
      CALL VCHAR(XY(1),XY(2),A,NFMT,2,SIZE,THT,XOF,0.)
  280 NOPS=.TRUE.
      XY(IYAXC)=YY(2)
      XY(IXAXC)=FMIN
      THT=THTA(IAXTY+1)
      DLSI=DLII
      GO TO 150
C
C  END ROUTINE
  290 RETURN
      END

