      SUBROUTINE RSBNDY(X1,Y1,X2,Y2,INOUT,IPEN2)
C
C   THIS SUBROUTINE HANDLES CONDITIONS WHERE (X1,Y1), (X2,Y2) INTERSECT
C     THE BOUNDARY OF THE DATA AREA.
C       INOUT = 0:  (X1,Y1) WITHIN DATA BOUNDARY.
C            ^= 0:  (X1,Y1) OUTSIDE DATA BOUNDARY.
C       IPEN2 = 0:  PEN DOWN FOR (X2,Y2).
C             = 1:  PEN UP FOR (X2,Y2).
C   ON OUTPUT, INOUT IS SET FOR (X2,Y2), WHICH READIES THIS ROUTINE
C     FOR THE NEXT CALL.  (I.E. WHEN CURRENT (X2,Y2) WILL BE THE NEXT
C     (X1,Y1)).
C
      DIMENSION XCL(2),YCL(2)
C
      I2IN=INOUT
      CALL RSCLIP(X1,Y1,X2,Y2,XCL,YCL,NCL,I2IN)
C
C   CHECK WHETHER (X1,Y1) IN/OUT OF DATA AREA.
C
      IF(INOUT.NE.0) GO TO 20
C
C   (X1,Y1) IS INSIDE DATA AREA.
C
      IF(I2IN.NE.0) GO TO 5
C
C   (X2,Y2) IS WITHIN DATA BOUNDARY.  CALL PXZ07 & RETURN.
C
      CALL PXZ07(X2,Y2,IPEN2)
      INOUT=0
      RETURN
C
C   (X2,Y2) IS OUTSIDE DATA BOUNDARY.
C
    5 IF(IPEN2.EQ.0) CALL PXZ07(XCL(1),YCL(1),IPEN2)
      INOUT=I2IN
      RETURN
C
C   (X1,Y1) IS OUTSIDE THE DATA AREA.
C
   20 IF(I2IN.NE.0) GO TO 25
C
C   (X2,Y2) IS INSIDE DATA AREA.
C
      IF(IPEN2.EQ.0) CALL PXZ07(XCL(1),YCL(1),1)
      CALL PXZ07(X2,Y2,IPEN2)
      INOUT=0
      RETURN
C
C   (X2,Y2) IS OUTSIDE DATA BOUNDARY.
C
   25 IF(IPEN2.NE.0) GO TO 30
C
C   THE PEN IS DOWN.  IF NCL ^= 0 (I.E. = 2), CALL PXZ07 TWICE.
C
      IF(NCL.EQ.0) GO TO 30
      CALL PXZ07(XCL(1),YCL(1),1)
      CALL PXZ07(XCL(2),YCL(2),IPEN2)
   30 INOUT=I2IN
      RETURN
      END
