      SUBROUTINE RSCLIP(X1,Y1,X2,Y2,XCL,YCL,NCL,I2IN)
C
C   THIS ROUTINE CALCULATES THE INTERSECTION OF (X1,Y1) & (X2,Y2) WITH
C     THE DATA AREA BOUNDARY.  (NOTE THAT IF BOTH PTS LIE OUTSIDE THE
C     BOUNDARY, THERE CAN STILL BE A 2 PT INTERSECTION.)  THE NUMBER
C     OF PTS IN THIS INTERSECTION = NCL, WITH (XCL(I),YCL(I),I=1,NCL)
C     THE INTERSECTION VALUES.  ON INPUT, IF I2IN = 0, (X1,Y1) LIES
C     WITHIN THE BOUNDARY; IF ^= 0, IT LIES OUTSIDE.  ON RETURN, IF
C     I2IN = 0, (X2,Y2) LIES WITHIN THE BOUNDARY; IF ^= 0, IT LIES
C     OUTSIDE.
C
      DIMENSION XCL(2),YCL(2)
C
$INCLUDE:'pxz99.cmn'
C
      I1IN=I2IN
      NCL=0
C
C   SET I2IN.
C
      CALL PTPOSN(X2,Y2,I2IN)
      IF(I1IN.GT.0) GO TO 10
C
C   (X1,Y1) LIES WITHIN DATA AREA.
C
      IF(I2IN.EQ.0) RETURN
      K=2
      GO TO 20
   10 K=1
      IF(I2IN.GT.0) GO TO 20
      KE=-2
      GO TO 30
   20 KE=-3
C
C   CHECK IF PTS ON SAME SIDE OF MIN/MAX.
C
   30 IF(IAND(I2IN,I1IN)) 80,40,80
C
C   NO, POSSIBLE CUTS.
C
   40 I12IN=I1IN+I2IN
      DX=X2-X1
      DY=Y2-Y1
C
C   CHECK IF LOWER/UPPER CUTS POSSIBLE.
C
      IF(IAND(I12IN,12)) 60,60,42
   42 RXY=DX/DY
      CXY=X1-RXY*Y1+0.5
C
C   CHECK FOR LOWER CUT.
C
      IF(IAND(I12IN,4)) 50,50,44
   44 BXY=RYMIN
   46 FF=AINT(BXY*RXY+CXY)
      IF(FF.LT.RXMIN.OR.FF.GT.RXMAX) GO TO 50
      NCL=NCL+1
      YCL(NCL)=BXY
      XCL(NCL)=FF
      K=K+1
      IF(K+KE) 50,80,50
C
C   CHECK FOR UPPER CUT.
C
   50 IF(IAND(I12IN,8)) 60,60,52
   52 I12IN=I12IN-8
      BXY=RYMAX
      GO TO 46
C
C   CHECK IF LEFT/RIGHT CUTS POSSIBLE.
C
   60 IF(IAND(I12IN,3)) 70,70,62
   62 RXY=DY/DX
      CXY=Y1-RXY*X1+0.5
C
C   CHECK FOR LEFT CUT.
C
      IF(IAND(I12IN,1)) 70,70,64
   64 BXY=RXMIN
   66 FF=AINT(BXY*RXY+CXY)
      IF(FF.LT.RYMIN.OR.FF.GT.RYMAX) GO TO 70
      NCL=NCL+1
      XCL(NCL)=BXY
      YCL(NCL)=FF
      K=K+1
      IF(K+KE) 70,80,70
C
C   CHECK FOR RIGHT CUT.
C
   70 IF(IAND(I12IN,2)) 80,80,72
   72 I12IN=I12IN-2
      BXY=RXMAX
      GO TO 66
C
C   IF LINE INTERSECTS 2 BOUNDARIES, ORDER THE BOUNDARY INTERSECTION
C     PTS IN DIRECTION OF ORIGINAL LINE.
C
   80 IF(NCL.LT.2) RETURN
      DX1=XCL(1)-X1
      DY1=YCL(1)-Y1
      DX2=XCL(2)-X1
      DY2=YCL(2)-Y1
      R1=DX1*DX1+DY1*DY1
      R2=DX2*DX2+DY2*DY2
      IF(R1.LE.R2) RETURN
      DX1=XCL(1)
      DY1=YCL(1)
      XCL(1)=XCL(2)
      YCL(1)=YCL(2)
      XCL(2)=DX1
      YCL(2)=DY1
      RETURN
      END

