c
c     sf2ascii - standard grid to 80 column ascii
c
      character*50 ingrid,outgrid
      character*56 id,pgm*8
      dimension data(10008)
      print *,'Standard grid to 80 column ascii'
      print *,'Name of input standard grid?'
      read(5,100)ingrid
  100 format(a50)
      print *,'Name of output ascii grid?'
      read(5,100)outgrid
c
      open(10,file=ingrid,form='unformatted',status='old')
      open(11,file=outgrid,form='formatted',status='unknown')
      read(10,err=1301,end=1302)id,pgm,ncol,nrow,nz,xo,dx,yo,dy
      write(6,105)id,pgm,ncol,nrow,nz,xo,dx,yo,dy
  105 format(1x,a56,1x,a8,/,1x,'ncol=',i8,' nrow=',i8,
     1 ' nz=',i3,' xo=',e16.8,' dx=',e16.8,/,1x,'yo=',e16.8,
     2 ' dy=',e16.8)
      if (ncol.gt.10000) go to 1303
      write(11,110)id,pgm,ncol,nrow
  110 format(a56,a8,2i8)
      write(11,120)nz,xo,dx,yo,dy
  120 format(i2,4e18.8)
c
      do 10 irow=1,nrow
      if (inbrow(ncol+1,data).ne.0) go to 1304
      do 20 j=1,ncol+1,5
   20 call outarow(data(j))
   10 continue
      print *,'All done'
      close(10)
      close(11)
      stop
c
c     error exits
c
 1301 print *,'Error reading first line of grid file'
      stop
c
 1302 print *,'End of file encountered in first line of grid'
      stop
c
 1303 print *,'Sorry ncol can''t be greater than 10000'
      stop
c
 1304 print *,'Error reading row',irow
      stop
      end
c
c     INBROW - INput Binary ROW
c
      integer function inbrow(idim,data)
      dimension data(idim)
      inbrow=-1
      read(10,end=98,err=99)data
      inbrow=0
      return
c
   98 inbrow=-1
      return
c
   99 inbrow=1
      return
      end
c
c     OUTAROW - OUTput Ascii ROW
c
      subroutine outarow(data)
      dimension data(5)
      write(11,100)data
  100 format(5e16.9)
      return
      end
