c   XIAM
c
c   computes an equivalent magnetization layer for a gridded magnetic data
c   set measured on topography using the method of Xia and others, 1993
c   (Geophysics, v.58, no.4, p.515).  Use program XIAM_FWD to compute the
c   magnetic field or derivative fields on other surfaces.
c
c   link with SFFTMG and SFOURT
c
c   Jeff Phillips May 1993
c
      dimension a1(2,2048,16),work(4096)
      character*80 ifile1,ifile2,ifile3,ofile1,ofile2
      character*80 filet,fileo,filem
c      character*80 ofilet,ofileo
      character*1 ans,drive
      character*56 id
c
      common/mane/id,pgm(2),dx,dy,nc,nr,nz,xo,yo
      common/other/sincl,sdecl,fincl,fdecl,nstop,errn,mstop,errm,capc
      common/files/drive,filet,fileo,ans,filem
      common/surf/smed,smin,smax,elevel
c
c      data eps/1.e-7/
      data dval/1.e37/
c save the input responses for xia_sav
      open(14,file='xia.rec',status='unknown',form='formatted')
c get initial magnetization, if any
      print'(a\)',' Specify initial magnetization? [n]'
      read(5,1) ans
      if(ans.eq.'y'.or.ans.eq.'Y') then
c input initial magnetization
        print'(a\)',' Standard file containing magnetization: '
        read(5,1)ifile3
        open(12,file=ifile3,status='old',form='unformatted')
        read(12,end=12,err=12,iostat=num)id,pgm,ncol,nrow,nz,xo,dx,yo,
     1    dy,tm,smed0,elevel,nc,nr
        print*,' title = ',id
        if(num.eq.0) go to 14
   12 print'(a\)',' Unfiltered file containing the magnetization: '
      read(5,1) ifile2
      open(11,file=ifile2,form='unformatted',status='old')
        read(11,err=12)id,pgm,ncol,nrow,nz,xo,dx,yo,dy,tm,smed0,elevel,
     1    nc,nr
        print*,' title = ',id
        close(11)
c        read(12)id,pgm,nc,nr,nz,xo,dx,yo,dy
c        read(12) id,pgm,ncol,nrow,nz,xo,dx,yo,dy,tm,smed,elevel,nc,nr
14      nctest=nc
        nrtest=nr
c test for registration with other grids
c        if(nc.ne.nctest.or.nr.ne.nrtest) stop 'grids do not overlay'
c test for dvals
        do 31 j=1,nrow
        call rowio(work,yr,nz,ncol,12,1)
        do 31 i=1,ncol
        if(work(i).ge.dval) stop 'dvals found'
   31   continue
      else
        ans='n'
      endif
c
c get the magnetic anomaly
      print'(a\)',' Standard file containing the observed anomaly: '
      read(5,1) ifile1
      write(14,1) ifile1
    1 format(a)
      open(10,file=ifile1,form='unformatted',status='old')
        read(10)id,pgm,nc,nr,nz,xo,dx,yo,dy
        print*,' title = ',id
      if(ans.eq.'y'.or.ans.eq.'Y') then
        if(nc.ne.nctest.or.nr.ne.nrtest) stop 'grids do not overlay'
      else
        nctest=nc
        nrtest=nr
      endif
c test for dvals, get mean
        tm=0.
        do 20 j=1,nr
        call rowio(work,yr,nz,nc,10,1)
        do 20 i=1,nc
        if(work(i).ge.dval) stop 'dvals found'
        tm=tm+work(i)
   20   continue
        tm=tm/float(nc*nr)
      print'(a\)',' Standard file containing the observation surface: '
      read(5,1) ifile2
      write(14,1) ifile2
        open(11,file=ifile2,status='old',form='unformatted')
        read(11)id,pgm,nc,nr,nz,xo,dx,yo,dy
        print*,' title = ',id
c test for registration with observed anomaly
          if(nc.ne.nctest.or.nr.ne.nrtest) stop 'grids do not overlay'
c get smin,smax and test for dvals
        smin=1.e37
        smax=-1.e37
        do 21 j=1,nr
        call rowio(work,yr,nz,nc,11,1)
        do 21 i=1,nc
        if(work(i).ge.dval) stop 'dvals found'
        if(work(i).lt.smin) smin=work(i)
        if(work(i).gt.smax) smax=work(i)
   21   continue
c get scale factor for observation surface
        print*,'grid dx/dy = ',dx,dy
        print*,'surface min/max = ',smin,smax
        print*,'What single number should these values be multiplied by'
        print*,'  so that they increase vertically down and have the'
        print'(a\)','   same units as dx?:'
        read(5,*) sscale
        write(14,*) sscale
        if(sscale.gt.0.0) then
          smin=smin*sscale
          smax=smax*sscale
        else
          temp=smin
          smin=smax*sscale
          smax=temp*sscale
        endif
        sscale=sscale/dx
        print*,'the bounds of the observation surface are:'
        print*,'        upper = ',smin
        print*,'        lower = ',smax
        smed=(smin+smax)/(2.*dx)
      if(ans.eq.'n'.or.ans.eq.'N') then
        print*,'The equivalent source layer must lie below the'
        print*,'observation surface AND below the continuation'
        print*,'surface.'
   22   print'(a\)',' Elevation of equivalent source layer: '
        read(5,*) elevel
        write(14,*) elevel
        if(elevel.le.smax) then
           print*,'Error: the observation surface extends below'
           print*,'       this elevation.  Try again.'
           go to 22
        endif
        elevel=elevel/dx
c get dimensions of expanded magnetization grid
        call check_dims(nc,nr,ncol,nrow)
      else
        write(14,*) elevel*dx
        write(14,*) ncol,nrow
      endif
c get other parameters
      print*,'sincl,sdecl = incl and decl of source magnetization'
      print*,'fincl,fdecl = incl and decl of regional field'
      print*,'nstop,errn  = max iterations and desired maximum error'
      print *,'             for forward calculations (eg. 32 1)'
      print*,'mstop,errm  = max iterations and desired maximum error'
      print *,'             for inverse calculations (eg. 100000 5)'
      print*,'capc        = convergence factor (usually .1 or .2)'
      print*,
     1'Enter sincl,sdecl,fincl,fdecl,nstop,errn,mstop,errm,capc :'
      read(5,*) sincl,sdecl,fincl,fdecl,nstop,errn,mstop,errm,capc
      if(nstop.gt.32) nstop=32
      capc=capc*1.e-5
      call get_dims(nrow,ncol,nx,ny,nri,id2,nxa)
c get output file and set up calculations
      print'(a\)',' Standard file to receive gridded magnetization:'
      read(5,1) ofile1
      write(14,1) ofile1
      open(13,file=ofile1,form='unformatted',status='unknown')
      pgm='xiam'
      print'(a\)',' Title: '
      read(5,1) id
      write(14,1) id
      close(14)
      write(13) id,pgm,ncol,nrow,nz,xo,dx,yo,dy,tm,smed,elevel,nc,nr
      print'(a\)',' Standard file to receive calculated anomaly:'
      read(5,1) ofile2
      open(15,file=ofile2,form='unformatted',status='unknown')
      pgm='xiam'
      print'(a\)',' Title: '
      read(5,1) id
      write(15) id,pgm,nc,nr,nz,xo,dx,yo,dy
      write(6,275) nri
  275 format(' blocking factor for rows =',i3)
      print'(a\)',' Enter the (RAM) drive letter for temporary files: '
      read(5,1) drive
        filet=drive//':\xia.50'
        call prep(10,filet,1.0,tm,ncol,nrow,a1,work,work(2049))
        print *
        print *,'Extended observed anomaly grid written to ',filet
        fileo=drive//':\xia.51'
        call prep(11,fileo,sscale,smed,ncol,nrow,a1,work,work(2049))
        print *,'Extended observation surface grid written to ',fileo
      if(ans.eq.'y'.or.ans.eq.'Y') then
         filem=drive//':\xia.52'
         call prep(12,filem,1.0,0.0,ncol,nrow,a1,work,work(2049))
         print *,'Extended magnetization grid written to ',filem
      endif
c
      call fmag3d(a1,work,nri,nrow,ncol,id2,tm)
      print *,'Equivalent source magnetization written to ',ofile1
      print *,'Calculated magnetic field written to ',ofile2
c      print *,'A datum of ',tm,' was removed from the input field.'
c
      stop
      end
c **************************************************************
      subroutine rowio(a,y,nz,ncol,ld,key)
      dimension a(nz,ncol)
      go to (1,2),key
1     read(ld) y,a
      go to 90
2     write(ld)y,a
90    return
      end
c **************************************************************
      subroutine check_dims(nc,nr,ncol,nrow)
10      call fftdims(nc,nr)
        print*, 'Enter (new) ncol and nrow:'
        read*, ncol,nrow
c  Check to make sure SFFTMG will accept these.
c  Added 19 June 91.
c        kr=11
c        iw=6
c        ir=5
c        nadd=0
c  note that x & y have been switched from normal (usgs) grid specficati
c  ...convention used is x-north y-east and z-down
        n1=nrow
        n2=ncol
        call get_dims(n1,n2,nx,ny,nri,id2,nxa)
        itest=n1-nx
        if(itest.ne.0) then
          print*,'Select another nrow; SFFTMG cannot handle this one.'
          go to 10
        endif
        if(nc.gt.ncol.or.nr.gt.nrow)then
          print*,'New ncol, nrow are too small.'
          go to 10
        endif
        write(14,*) ncol,nrow
        return
        end
c **************************************************************
      subroutine fftdims(ncol, nrow)
c
c     suggests new dimensions for fourier transform
c
c     Jeff Phillips 1992
c
      dimension nlist(54), ngood(54)
      data nlist / 9, 10, 11, 12, 13, 16
     &, 18, 20, 22, 24, 26, 32
     &, 36, 40, 44, 48, 52, 56, 64
     &, 72, 80, 88, 96, 104, 112, 128
     &, 144, 160, 176, 192, 208, 224, 256
     &, 288, 320, 352, 384, 416, 448, 512
     &, 576, 640, 704, 768, 832, 896, 1024
     &, 1152, 1280, 1408, 1536, 1664, 1792, 2048 /
c
      write(unit=6, fmt=901) ncol, nrow
  901 format(' ncol = ',i5,' nrow = ',i5)
      n = 0
      do 10 i = 1, 54
      if (nlist(i) .lt. ncol) goto 10
      if (nlist(i) .gt. ncol+ncol/2) goto 20
      n = n + 1
      ngood(n) = nlist(i)
   10 continue
   20 write(unit=6, fmt=902)
  902 format(' Suggested new values:')
      write(unit=6, fmt=101) (ngood(i),i = 1, n)
  101 format('  ncol = ',14i5)
      n = 0
      do 30 i = 1, 54
      if (nlist(i) .lt. nrow) goto 30
      if (nlist(i) .gt. nrow+nrow/2) goto 40
      n = n + 1
      ngood(n) = nlist(i)
   30 continue
   40   write(unit=6, fmt=102) (ngood(i),i = 1, n)
  102 format('  nrow = ',14i5)
      return 
      end
c***********************************************************************
      subroutine get_dims(n1,n2,nx,ny,nri,id2,nxa)
      data lnri/16/,iw/6/
c
c  nri = blocking factor for rows (l)
c  nxa = number of rows added (n1-nx)
c  id2 = 2*max(n1,n2)
c
      nx=n1
      ny=n2
      l=lnri+1
      lnri21=lnri/2+1
c  set no. of rows for fft: need m=l*2**k, m.gt. or .eq. nx.
c  m=no. of rows, l=no. from 9-16, k=integer.
  190 l=l-1
      if(l.lt.lnri21) go to 260
      mr=n1/l+0.0000001
      k=1
      idiv=2
  200 iquot=mr/idiv+0.0000001
      if(iquot.lt.idiv) go to 210
      k=k+1
      mr=iquot
      go to 200
  210 k=k+1
      m=l*2**k
  220 mtest=l*2**(k-1)
      if(mtest.lt.n1) go to 230
      k=k-1
      m=mtest
      if(k.eq.0) go to 230
      go to 220
  230 lnxa=m-n1
      if(l.ne.lnri) go to 250
      nxa16=lnxa
  240 nri=l
      nxa=lnxa
      go to 190
  250 if(lnxa.ge.nxa) go to 190
      go to 240
  260 n1=n1+nxa
c  check to see if row block size of 16 will be more efficient
      n116=n1-nxa+nxa16
      ntest=0.9*n116
      if(ntest.gt.n1.or.n116.gt.2048) go to 270
      n1=n1-nxa+nxa16
      nxa=nxa16
      nri=16
  270 continue
      if(n1.gt.2048.or.n2.gt.2048) go to 320
      id2=n1
      if(n2.gt.n1)id2=n2
      id2=2*id2
      return
  320 write(iw,330)nx,ny,n1,n2
  330 format(' #no. of extended rows or columns exceeds 2048:'/
     1' input no. of rows and columns='2i4/
     2' no. of rows and columns required for fft =',2i4,/)
      stop
      end
c **************************************************************
      subroutine prep(iunit,ofile,scale,off,ncol,nrow,g,g1,g2)
c
c  Open grid and cosine taper to reduce FFT wraparound.
c  The new nrow, ncol should be chosen from the list of rich-in-
c  -factors-of-2 numbers that SFFTMG likes.
c
c  Lin Cordell Jan 1990.
c  Revised June 1991.
c  Modified by Jeff Phillips Feb 1992.
c
        character*80 ofile
      dimension g(1),g1(1),g2(1),id(14),pgm(2)
c      index(i,j,nc) = ((j - 1) * nc) + i
        pi=3.1415927
c  Tilt grid.
c      call edge(alpha,beta,gamma,nc,nr,10)
c      close(10)
c        print*, ' alpha = ',alpha,', beta = ',beta,' ,gamma = ',gamma
c        open(10,file=ifile,status='old',form='unformatted')
        rewind(iunit)
        read(iunit)id,pgm,nc,nr,nz,xo,dx,yo,dy
c  Output extended file.
      open(14,file=ofile,status='unknown',form='unformatted')
	pgm(1)='prep'
	pgm(2)='    '
        write(14)id,pgm,ncol,nrow,nz,xo,dx,yo,dy
c      open(14,file='mfilt.6',status='unknown',form='unformatted')
c        write(14)id,pgm,nc,nr,nz,xo,dx,yo,dy
c        write(14)alpha,beta,gamma,ncol,nrow
c  First row (saved).
        j2=1
        call rowio(g,yr,nz,nc,iunit,1)
        y=float(j2)
      do 211 j1=1,nc
        x=float(j1)
c        g(j1)=(g(j1)-alpha*x-beta*y-gamma)*scale
      g(j1)=g(j1)*scale-off
211   g1(j1)=g(j1)
c  Cosine taper right side
        s=0.5*(g(nc)+g(1))
	r=0.5*(g(nc)-g(1))
	lim=ncol-nc
	rlamb=float(lim+1)
	arg=pi/rlamb
	do 201 k=1,lim
	rk=float(k)
	ge=s+r*cos(arg*rk)
	g(nc+k)=ge
201     g1(nc+k)=ge
        call rowio(g,yr,nz,ncol,14,2)
c  Rows down to nr
        do 204 j2=2,nr
        y=float(j2)
        call rowio(g,yr,nz,nc,iunit,1)
	do 202 j1=1,nc
        x=float(j1)
c202     g(j1)=g(j1)-alpha*x-beta*y-gamma
202     g(j1)=g(j1)*scale-off
c  Cosine taper right side.
        s=0.5*(g(nc)+g(1))
	r=0.5*(g(nc)-g(1))
	do 203 k=1,lim
	rk=float(k)
203     g(nc+k)=s+r*cos(arg*rk)
        call rowio(g,yr,nz,ncol,14,2)
204	continue
c  Last row
c  Extend right side
c  Rows nr+1 to nrow.
        do 205 j1=1,ncol
205     g2(j1)=g(j1)
        lim=nrow-nr
	rlamb=float(lim+1)
	arg=pi/rlamb
	do 207 k=1,lim
	yr=float(nr+k-1)*dx+yo
	rk=float(k)
	do 206 j1=1,ncol
	s=0.5*(g2(j1)+g1(j1))
	r=0.5*(g2(j1)-g1(j1))
206     g(j1)=s+r*cos(arg*rk)
        call rowio(g,yr,nz,ncol,14,2)
207	continue
	go to 999
900     print*, "Can't handle it."
        close(iunit)
999     close(14)
        return
        end
c **************************************************************
      subroutine fmag3d(a1,work[huge],nri,nrow,ncol,id2,tm)
      dimension a1(2,ncol,nri),work(id2)
      dimension fact(33)
      real mx,my,mz,maxd,ntot,maxdold
      character*80 filet,fileo,filem
      character*1 drive,ans
c
      common/mane/id(14),pgm(2),dx,dy,nc,nr,nz,xo,yo
      common/other/sincl,sdecl,fincl,fdecl,nstop,errn,mstop,errm,capc
      common/files/drive,filet,fileo,ans,filem
      common/surf/smed,smin,smax,elevel
c
      data twopi / 6.2831853 /
      data conv / .01745329 /
c      data capc/1.e-6/
c      data capc/2.e-6/
      data iunita/22/,iunitb/23/,iunitc/24/,iunitd/25/
      data iunitm/26/
c
      mx = cos(sincl * conv) * cos(sdecl * conv)
      my = cos(sincl * conv) * sin(sdecl * conv)
      mz = sin(sincl * conv)
      fx = cos(fincl * conv) * cos(fdecl * conv)
      fy = cos(fincl * conv) * sin(fdecl * conv)
      fz = sin(fincl * conv)
      write(6,107) mx, my, mz, fx, fy, fz
  107 format(/,45h THE COMPONENTS OF MAGNETIZATION AND REGIONAL
     &13h FIELD ARE...,//,5x,5hmx = ,f6.3,5x,5hmy = ,f6.3,5x,5hmz = 
     &,f6.3,/,5x,5hfx = ,f6.3,5x,5hfy = ,f6.3,5x,5hfz = ,f6.3/)
      aa1 = (mx * fx) - (mz * fz)
      a2 = (my * fy) - (mz * fz)
      a3 = (mx * fy) + (my * fx)
      b1 = (- (mx * fz)) - (mz * fx)
      b2 = (- (my * fz)) - (mz * fy)
c initialize some parameters
      do 22 i=1,nstop+1
      fact(i)=fac(i-1,ierr)
c      print *,i,fact(i)
   22 continue

c   initialize magnetization, rms, and maxd
c   zero out the imaginary part
        do 30 j=1,ncol
   30   a1(2,j,1)=0.0
        nc2=2*ncol
c   open observed anomaly file
        open(10,file=filet,form='unformatted',status='old')
        read(10) id
        if(ans.eq.'y'.or.ans.eq.'Y') then
c   open initial magnetization file
          open(11,file=filem,form='unformatted',status='unknown')
          read(11) id
        endif
c   open topographic change file
      open(12,file=fileo,form='unformatted',status='old')
c   open temporary files
        open(iunita,access='direct',status='unknown',
     1  form='unformatted',file=drive//':\slave1.tmp',recl=nc2*4)
        open(iunitb,access='direct',status='unknown',
     1 form='unformatted',file=drive//':\slave2.tmp',recl=nc2*4)
        open(iunitc,access='direct',status='unknown',
     1  form='unformatted',file=drive//':\slave3.tmp',recl=nc2*4)
        open(iunitd,access='direct',status='unknown',
     1  form='unformatted',file=drive//':\slave4.tmp',recl=ncol*4)
        open(iunitm,access='direct',status='unknown',
c     1  form='unformatted',file=drive//':\slave5.tmp',recl=ncol*4)
     1  form='unformatted',file='slave5.tmp',recl=ncol*4)
c
      ntot=nrow*ncol
      rms=0.0
      maxd=-1.e37
      do 20 j=1,nrow
c   read observed anomaly
      call rowio(work,yr,nz,ncol,10,1)
      if(ans.eq.'y'.or.ans.eq.'Y') then
c   read initial magnetization
        call rowio(work(ncol+1),yr,nz,ncol,11,1)
      endif
      do 10 i=1,ncol
      rms=rms+work(i)**2
      if(abs(work(i)).gt.maxd) maxd=abs(work(i))
c   initialize magnetization
      if(ans.eq.'y'.or.ans.eq.'Y') then
        work(i)=work(ncol+i)
      else
        work(i)=capc*work(i)
      endif
      a1(1,i,1)=work(i)
   10 continue
c      call rowio(work,yr,nz,ncol,11,2)
c   save magnetization
      call swrda(iunitm,j,work,ncol)
      call swrda(iunita,j,a1,nc2)
   20 continue
      write(6,101)
  101 format(/,11x,'FIT TO OBSERVED ANOMALY',10X,
     1'FORWARD CALCULATION'/,
     2/,4x,'M',6x,'RMS_ERROR',6X,'MAX_ERROR',9X,'N',6X,
     3'MAX_CHANGE'/)
      rmsold=sqrt(rms/ntot)
      maxdold=maxd
      m=0
      n=0
      sratio=0.
      write(6,110) m,rmsold,maxdold
  110 format(i5,g19.6,g15.6,/)
      rms=0.
      maxd=0.
c
      rnr=twopi*dx/(float(nrow)*dy)
      rnc=twopi/(float(ncol))
      ncp1=ncol+1
      nnhr=(nrow/2)+1
      nnhc=(ncol/2)+1
  980 m=m+1
c fourier transform the magnetization
      isign=-1
      call sfftmg(iunita,iunitb,ncol,nrow,a1,nri,isign,work)
c do the n=0 term
c   loop to operate on nnhr rows of the fourier transform a1
      do 1010 jr=1,nnhr
      jj=jr-1
      x=float(jj)*rnr
      xsq=x*x
c   read a row of the fourier transform a1
      call srdda(iunita,jr,a1,nc2)
c   loop to operate on ncol elements in the row
      do 1090 i=1,ncol
      ii=i-1
      if(i.gt.nnhc) ii=-(ncp1-i)
      y=float(ii)*rnc
      ysq=y*y
      xy2=xsq+ysq
      if(xy2.eq.0.0) then
        a1(1,i,1)=0.
        a1(2,i,1)=0.
        go to 1090
      endif
      xy=sqrt(xy2)
      arg=xy*(smed-elevel)
      if(arg.lt.-88.028) arg=-88.028
      arg=-exp(arg)
      phir=(aa1*xsq+a2*ysq+a3*x*y)/xy2
      phii=(b1*x+b2*y)/xy
      a1(1,i,1)=a1(1,i,1)*arg
      a1(2,i,1)=a1(2,i,1)*arg
      temp=a1(1,i,1)
      a1(1,i,1)=temp*phir-a1(2,i,1)*phii
      a1(2,i,1)=temp*phii+a1(2,i,1)*phir
 1090 continue
c  save the filtered output to iunita and iunitc
      call swrda(iunita,jr,a1,nc2)
      call swrda(iunitc,jr,a1,nc2)
      if(jr.eq.1) go to 1010
      jmr=nrow-jr+2
      if(jr.eq.jmr) go to 1110
      a1(2,1,1)=-a1(2,1,1)
      iwr=ncp1
      do 1100 i=2,nnhc
      iwr=iwr-1
      x=a1(2,i,1)
      y=a1(1,i,1)
      a1(2,i,1)=-a1(2,iwr,1)
      a1(1,i,1)=a1(1,iwr,1)
      a1(1,iwr,1)=y
      a1(2,iwr,1)=-x
 1100 continue
      call swrda(iunita,jmr,a1,nc2)
      call swrda(iunitc,jmr,a1,nc2)
 1010 continue
 1110 continue
      isign=1
      call sfftmg(iunita,iunitb,ncol,nrow,a1,nri,isign,work)
      area=1.e5*twopi/ntot
      do 1210 jr=1,nrow
      call srdda(iunita,jr,a1,nc2)
      do 1180 i=1,ncol
      work(i)=a1(1,i,1)*area
 1180 continue
      call swrda(iunitd,jr,work,ncol)
 1210 continue
c   done with the n=0 term
      if(nstop.eq.0) go to 5000
c get ready for summation
c      write(6,110) errn
c  110 format(/,25h PERFORMANCE OF SUMMATION,/,17h TRYING TO REACH ,f5.3,
c     &10h OF STOTAL/)
c      write(6,101)
c  101 format(/,4x,1hN,4x,6hSTOTAL,5x,5hSLAST,4x,6hSRATIO/)
c  110 format(/,' PERFORMANCE OF SUMMATION',/,' TRYING TO REACH',
c     &' MAX_CHANGE = ',f5.3/)
c      write(6,101)
c  101 format(/,11x,'N',6x,'MAX_CHANGE',9x,'COL',9X,'ROW'/)
      n=0
 1000 n=n+1
c   loop to operate on nnhr rows of the fourier transform a1
      do 2010 jr=1,nnhr
      jj=jr-1
      x=float(jj)*rnr
      xsq=x*x
c   read a row of the fourier transform of the zero term
      call srdda(iunitc,jr,a1,nc2)
c   loop to operate on ncol elements in the row
      do 2090 i=1,ncol
      ii=i-1
      if(i.gt.nnhc) ii=-(ncp1-i)
      y=float(ii)*rnc
      xy=sqrt(xsq+y*y)
      arg=(xy)**n
      a1(1,i,1)=a1(1,i,1)*arg
      a1(2,i,1)=a1(2,i,1)*arg
 2090 continue
c  save the filtered output to iunita
      call swrda(iunita,jr,a1,nc2)
      if(jr.eq.1) go to 2010
      jmr=nrow-jr+2
      if(jr.eq.jmr) go to 2110
      a1(2,1,1)=-a1(2,1,1)
      iwr=ncp1
      do 2100 i=2,nnhc
      iwr=iwr-1
      x=a1(2,i,1)
      y=a1(1,i,1)
      a1(2,i,1)=-a1(2,iwr,1)
      a1(1,i,1)=a1(1,iwr,1)
      a1(1,iwr,1)=y
      a1(2,iwr,1)=-x
 2100 continue
      call swrda(iunita,jmr,a1,nc2)
 2010 continue
 2110 continue
      isign=1
      call sfftmg(iunita,iunitb,ncol,nrow,a1,nri,isign,work)
      rewind(12)
      read(12) id
c      print*,n+1,ntot,fact(n+1)
      area=1.e5*twopi/(ntot*fact(n+1))
      dum=0.0
c      slast=0.
c      stotal=0.
      sratio=0.
      do 2210 jr=1,nrow
      call srdda(iunita,jr,a1,nc2)
      call rowio(work,yr,nz,ncol,12,1)
      call srdda(iunitd,jr,work(ncol+1),ncol)
      do 2180 i=1,ncol
      a1(1,i,1)=a1(1,i,1)*area*work(i)**n
c      slast=slast+abs(a1(1,i,1))
c      stotal=stotal+abs(work(ncol+i))
      slast=abs(a1(1,i,1))
c      stotal=stotal+slast
      if(slast.gt.sratio) then
        sratio=slast
c        ncs=i
c        nrs=jr
      endif
      work(ncol+i)=work(ncol+i)+a1(1,i,1)
c      work(ncol+i)=a1(1,i,1)
 2180 continue
c   save sum
      call swrda(iunitd,jr,work(ncol+1),ncol)
 2210 continue
c      slast=slast/ntot
c      stotal=stotal/ntot
c      stest=errn*stotal
c      if(stotal.eq.0.0) go to 4999
c      sratio=slast/(stotal+.1e-20)
c      write(6,104) n,stotal,slast,sratio
c      write(6,*) n,sratio,ncs,nrs
c   done with next term in sum
      write(6,111) m,n,sratio
  111 format(1h+,i4,34x,i6,g20.6)
c  104 format(i5,3g10.3)
c 4999 if(n.lt.nstop.and.slast.ge.stest) go to 1000
 4999 if(n.lt.nstop.and.sratio.ge.errn) go to 1000
c   done with sum; get best fit to observed anomaly
 5000 continue
      rewind(10)
      read(10) id
      sumc=0.
      sumc2=0.
      sumt=0.
      sumct=0.
      do 5010 j=1,nrow
      call rowio(work,yr,nz,ncol,10,1)
      call srdda(iunitd,j,work(ncol+1),ncol)
      do 5010 i=1,ncol
      sumc=sumc+work(ncol+i)
      sumc2=sumc2+work(ncol+i)**2
      sumt=sumt+work(i)
      sumct=sumct+work(i)*work(ncol+i)
 5010 continue
      den=ntot*sumc2-sumc*sumc
      a=(ntot*sumct-sumc*sumt)/den
      b=(sumc2*sumt-sumc*sumct)/den
c      print *,a,b
      rms=0.0
      maxd=-1.e37
      rewind(10)
      read(10) id
      do 5120 j=1,nrow
      call rowio(work,yr,nz,ncol,10,1)
      call srdda(iunitd,j,work(ncol+1),ncol)
      do 5110 i=1,ncol
       work(i)=work(i)-a*work(ncol+i)-b
c       work(i)=work(i)-work(ncol+i)
      rms=rms+(work(i))**2
      if(abs(work(i)).gt.maxd) maxd=abs(work(i))
c      work(i)=capc*work(i)
c      work(i)=0.0
c      if(i.eq.70.and.j.eq.70) work(i)=1.
c      a1(1,i,1)=work(i)
 5110 continue
      call swrda(iunitd,j,work,ncol)
c      call rowio(work,yr,nz,ncol,11,2)
c      call swrda(iunitm,j,work,ncol)
c      call swrda(iunita,j,a1,nc2)
 5120 continue
      rms=sqrt(rms/ntot)
      write(6,112) m,rms,maxd,n,sratio
  112 format(1h+,i4,g19.6,g15.6,i6,g20.6,/)
      if(rms.ge.rmsold.or.maxd.ge.maxdold) capc=0.0
      if(maxd.le.errm.or.m.ge.mstop) capc=0.0
      do 5200 i=1,ncol
 5200 a1(2,i,1)=0.0
      do 5220 j=1,nrow
      call srdda(iunitd,j,work(ncol+1),ncol)
      call srdda(iunitm,j,work,ncol)
      do 5210 i=1,ncol
      work(i)=a*work(i)+b*1.e-5+capc*work(ncol+i)
c      work(i)=work(i)+capc*work(ncol+i)
      a1(1,i,1)=work(i)
 5210 continue
      call swrda(iunitm,j,work,ncol)
      call swrda(iunita,j,a1,nc2)
 5220 continue
      if(rms.ge.rmsold.or.maxd.ge.maxdold) go to 6000
      if(maxd.le.errm.or.m.ge.mstop) go to 6000
      rmsold=rms
      maxdold=maxd
      go to 980
 6000 continue
      do 6210 j=1,nrow
      call srdda(iunitm,j,work,ncol)
      write(13) dum,(work(i),i=1,ncol)
 6210 continue
      rewind(10)
      read(10) id
      do 6230 j=1,nr
      call rowio(work,yr,nz,ncol,10,1)
      call srdda(iunitd,j,work(ncol+1),ncol)
      do 6220 i=1,nc
      work(i)=work(i)-work(ncol+i)+tm
 6220 continue
      write(15) dum,(work(i),i=1,nc)
 6230 continue
      close(iunita,status='delete')
      close(iunitb,status='delete')
      close(iunitc,status='delete')
      close(iunitd,status='delete')
      close(iunitm,status='delete')
      return
      end
c***********************************************************************
c  Function fac finds the factorial of n
      function fac(n, ier)
      ier = 0
      if (n .gt. 1) goto 10
      if (n .ge. 0) goto 20
      ier = 1
   20 fac = 1.
      return 
   10 fac = n
      fac2 = fac
   30 fac2 = fac2 - 1.
      if (fac2 .eq. 1.) return 
      fac = fac * fac2
      goto 30
      end
c***********************************************************************
      subroutine srdbin(no,dat[huge],n)
c       subroutine 'srdbin' reads standard grids (binary).
c***********************************************************************
      dimension dat(n)
      read(no)dum,dat
      return
      end
c***********************************************************************
      subroutine swrbin(no,dat[huge],n)
c       subroutine 'swrbin' writes standard grids (binary).
c***********************************************************************
      dimension dat(n)
      data dum/0.0/
      write(no)dum,dat
      return
      end
c***********************************************************************
       subroutine srdda(no,ipos,dat[huge],n)
c       subroutine 'srrda' reads keyed sequential files.
c***********************************************************************
      dimension dat(n)
      read(no,rec=ipos)dat
      return
      end
c***********************************************************************
      subroutine swrda(no,ipos,dat[huge],n)
c       subroutine 'swrda' writes keyed sequential files.
c***********************************************************************
      dimension dat(n)
      write(no,rec=ipos)dat
      return
      end

