c XYZ2GEO - reads a projected xyz file and outputs a geology file for
c           use with PDEPTH.  Use after RAW2GEO.BAT.
      character ifile*80,gsym*5
      print*,'enter input projected binary xyz filename:'
      read(5,100) ifile
  100 format(a)
      open(10,file=ifile,form='unformatted',status='old')
      print*,'enter output geology filename:'
      read(5,100) ifile
      open(11,file=ifile,form='formatted',status='new')
      read(10,end=90) xo,yo,z
      print*,'enter starting geologic unit symbol:'
      read(5,100) gsym
      distold=0.0
      print*,'available contact types are:'
      print*,'  con   - for a non-faulted contact'
      print*,'  fault - for any fault'
      print*,'  thfrt - for a thrust fault dipping to the right'
      print*,'  thflf - for a thrust fault dipping to the left'
      print*,'  coflt - for a concealed fault'
      print*,'  cotrt - for a concealed right-dipping thrust'
      print*,'  cotlf - for a concealed left-dipping thrust'
   10 read(10,end=90) x,y,z
      dist=sqrt((x-xo)**2 + (y-yo)**2)
      write(11,200) gsym,distold,dist
      print*,'enter type of contact at distance ',dist
      read(5,100) gsym
      if(gsym(1:3).ne.'con') write(11,200) gsym,dist,dist
      print*,'enter geologic unit symbol for next segment:'
      read(5,100) gsym
      distold=dist
      go to 10
   90 stop
  200 format(a5,10x,2f10.3)
      end
