/*  100K DLG                                            6/29/93

      This is a program to extract data from the 100K DLG CD-ROM
      to a user specified data storage area (hard disk, floppy disk,
      etc...).  It uses the indicated include files, and various data
      files.

	 100kutil.c.....a collection of functions used in hilo.c
	 font.h.........includes the letter fonts
	 message.h......includes strings that get printed to the screen
	 file.out.......contains quad names and byte sizes for overlays
	 infofile.......contains the title information (format,data,etc.)
	 help.txt.......is an ascii file of information
	 state.reg......registration data, pixels per degree
	 state.ega/vga...graphics data for display
	
	USE EXTRACT.C FOR NORMAL TITLE BLOCKS.
	USE EXTRLONG.C FOR TITLE BLOCKS THAT REQUIRE 2 LINES FOR NAME OF 
		SECTION. MODIFY INFOFILE TO INCLUDE AN EXTRA TERM FOR THE 
		LONGER TITLE.
*/

#include <conio.h>
#include <graph.h>
#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <memory.h>
#include <math.h>
#include <float.h>
#include <malloc.h>
#include <process.h>
#include <direct.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include "font.h"
#include "message.h"
#include "extr_pro.h"

#define GREEN 2                          /* SCREEN TEXT COLORS           */
#define WHITE 15
#define BLUE  5
#define RED 6
#define LTGREEN 1
#define GRAY 11
#define LTBLUE 5 /*12*/
#define MEDGREEN 2 /*8*/

int DisplayCutImage(char *);
int Get_Block(double,double,double,double);
void Mark_Quad1(int,int,int,int,int);

char FF[3]="FF",FS[3]="FS",SF[3]="SF",SS[3]="SS";

struct su                                /* STRUCTURE TO KEEP TRACK      */
{                                        /* OF LAYERS SELECTED           */
int   boolean;                           /* BOOLEAN FOR LAYERS SELECTED  */
char  choicstr[10];
char  choiext[5];
}layer[10];

struct diskfree_t  disk_check_stru;

struct st                                /* STRUCTURE TO CONTAIN THE     */
{                                        /* DATA READ IN FROM FILE.OUT   */
char CutFile[5];
char QuadName[30];
double Lat;
double Lon;
char DirName[10];
char dummy[11];
char hydro[3];
char tran[3];
char rail[3];
char roads[3];
long bytesize[32];
unsigned int Selected[9][6];
} QuadData[285];

struct outputdata                        /* STRUCTURE USED BY THE LINKED */
{                                        /* LIST TO STORE LAYERS AND     */
char dirname[20];                        /* QUADS THAT HAVE BEEN SELECTED*/
char arcfile[20];
char outarcfile[20];
long  bytesaffected;
int xloc;
int yloc;
struct outputdata *fore;
struct outputdata *next;
};

struct outputdata *firstptr, *lastptr, *currentptr, *newptr, *tempptr;

struct   Color 
{       unsigned char  r, g, b;
} DefaultPalette[256];

char ops1[7][20]=                        /* MENU OPTIONS                 */
{
{"HELP  "},
{"SELECT LAYERS    "},
{"SELECT QUADS     "},
{"VIEW QUAD        "},
{"OUTPUT           "},
{"RESET            "},
{"EXIT             "}
};

char ops3[7][20]=
{
{"HELP  "},
{"SELECT LAYERS    "},
{"SELECT QUADS     "},
{"VIEW QUAD        "},
{"OUTPUT           "},
{"RESET            "},
{"EXIT             "}
};

char ops2[6][20]=
{
{"HELP "},
{"SELECT LAYERS    "},
{"SELECT 15' CELLS "},
{"OUTPUT           "},
{"RESET            "},
{"EXIT             "}
};

char ops4[6][20]=
{
{"HELP  "},
{"SELECT LAYERS    "},
{"SELECT 15'CELLS  "},
{"OUTPUT           "},
{"RESET            "},
{"EXIT             "}
};

char layers[6][20]=
{
{"HYDROGRAPHY       "},
{"MISC.TRANS.       "},
{"RAILROADS         "},
{"ROADS             "},
{"ALL LAYERS        "},
{"END SELECTION     "}
};

FILE            *ofile,*rfile,*testfile,*datfile,*cdfile;
union   REGS    inreg, outreg,regs;
struct  SREGS   segregs;
unsigned char   buffer[650];
unsigned char   buffer1[64000];

char TempName1[20],TempName2[20];
char TempName3[20],TempName4[20];
char GRAPHICS,CDDRIVE[3];
char State[30],State_plus[30],Option[20],Format[10],Month[10],Date[10],number[10];
char BreakDown[3];
char InFileName[30];
char OutFileName[30];
char outdir[10],TempLon[20],TempLat[20],TempLonmin[20],TempLatmin[20];
char Return_Char;

double PixelsPerDegreeLong,PixelsPerDegreeLat,oldlat,oldlon,SkipVGA,SkipEGA;
double PPDLat,PPDLong;
double lat,lon;
double x1,x2,yy1,y2;

int Choice=0;                            /* MENU OPTION THE CURSOR IS IN */
int Xvalue,Yvalue;
int CursorY=100,CursorX=100;             /* COORDINATES OF THE + CURSOR  */
int MouseThere,INSTALLED=0;              /* BOOLEAN FOR MOUSE AVAILABLE  */
int ScreenXs=640,ScreenYs;
int BOTTOM;                              /* 480 for VGA, 350 for EGA     */
int DownVGA,DownEGA,Down,Over,Explain,RightESC; /* POSITIONS FOR PUTTING */
int QuadNamePos;                         /*        TEXT ON THE SCREEN    */
int QuadCount,Block;
int BlockCount=0,BlockArray[35]={0};
int LayerCount=0,layerson=0,bytecounton=0,outside_menu=0,Menu=0;
int LayersChosenOn=0, layerselected;
int radix=10;                            /* BASE POWER USED FOR LTOA     */
int Row2=10,Column2=10,Row1,SkipRow,Column1,RRow1;
int BlockSeven[8][4]={                   /* THE NUMBERS OF THE 7.5' QUADS*/
	  {  1,  2,  9, 10 },
	  {  3,  4, 11, 12 },
	  {  5,  6, 13, 14 },
	  {  7,  8, 15, 16 },
	  { 17, 18, 25, 26 },
	  { 19, 20, 27, 28 },
	  { 21, 22, 29, 30 },
	  { 23, 24, 31, 32 },
    };

long            ByteCount=0,LargeByteCount=0,SmallByteCount=0;
unsigned char   Fields,Indexes, dummy;
unsigned char   imd[80];
unsigned char   a,b,c,d;
int             brog, bcog, lrog, lcog;

/************************** MAIN ************************************/
void main(void)
{ 
int             j=0,i=0,n=0,o=0,p=0,q=0,r=0,l=0;
int             m=0; 
int             f;  

/* system("mem.exe");  getch();*/

      firstptr = (struct outputdata *)NULL;
      for(i=0;i<=10;i++)
      {                /* INITIALIZE LAYER ON/OFF      */
	layer[i].boolean = 0;            /* SWITCH TO OFF                */
      }
      sprintf(layer[1].choicstr,"HYDRO");
      sprintf(layer[1].choiext,"HY");
      sprintf(layer[2].choicstr,"MTRAN");
      sprintf(layer[2].choiext,"MT");
      sprintf(layer[3].choicstr,"RAIL");
      sprintf(layer[3].choiext,"RR");
      sprintf(layer[4].choicstr,"ROADS");
      sprintf(layer[4].choiext,"RD");
      sprintf(layer[5].choicstr,"*");
      sprintf(layer[5].choiext,"??");

      printf("LOADING FILES.   PLEASE WAIT...\n");
      Get_ScreenData();                  /* GET TITLE SCREEN DATA        */
      Get_QuadData();                    /* READ IN FILE.OUT: BYTECOUNTS */
      strcat(OutFileName,"state.reg");   /* SET NAME OF REGISTRATION FILE*/
      Check_Video();                     /* SET VGA/EGA MODE TO HARDWARE */
/*      system("c:\\bin1\\monitor\\setmode 18");*/
      DisplayCutImage(InFileName);       /* DISPLAY STATE GRAPHIC FILE   */
      Display_Info();                    /* DISPLAY TITLE ON SCREEN      */
      Display_Menu(1);                   /* PUT INITIAL MENU ON SCREEN   */
      Check_Mouse();                     /* IF MOUSE IS THERE, SET IT UP */

      MakeRoom();                        /* PUT EXPLANATION ON BOTTOM OF */
      WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,50,EXPLAIN8,2,Font);  /* SCREEN */

/***** BEGINNING OF MAIN PROGRAM LOOP * END OF INITIALIZATION CODE *******/
do
{
    if(MouseThere==1)
    {
	inreg.x.ax=0x003;                /* POLL MOUSE CONTINUOSLY       */
	int86 (0x33, &inreg, &outreg);
    }
    else
    {
	Return_Char=pix_val(CursorX,CursorY); /* POLL CURSOR CONTINUOUSLY*/
	outreg.x.dx=100;
    }
    if((outreg.x.dx<25)||(CursorY<25))
    {  /* IF CURSOR IS WITHIN MENU     */
	Display_Explain();
	outside_menu=0;
    }
    else
    {
	if(outside_menu==0)
	{
	   if(Choice>0)
	   {
	      Hide_Mouse();
	      Unhighlight();
	      Unhide_Mouse();
	      Choice=0;
	   }
	   MakeRoom();
	   WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,50,EXPLAIN8,2,Font);
	   outside_menu=1;
	}
    }
    if((outreg.x.bx==1)||(Return_Char=='\r'))
    {  /* IF LEFT OR RETURN IS PRESSED CALCULATE LAT AND LONG VIA CURSOR POSITION*/
	if(MouseThere==1) 
		Column2=outreg.x.cx; 
	else              
		Column2=CursorX;    
	if(MouseThere==1) 
		Row2=outreg.x.dx;
	else              
		Row2=CursorY;
	lat=yy1+(((Row2-Row1))/PixelsPerDegreeLat);
	lon=x1+(((Column2-Column1))/PixelsPerDegreeLong);
	lon=(int)lon;
	if( (lat-(int)lat)>0.5) 
		lat=(int)lat+0.5;
	else
	{
	    y2=(int)lat;
	    lat=y2;
	}
	if(MouseThere!=1) 
		outreg.x.dx=100;  /* AVOID HELP GETTING ACTIVATED */
	if(((outreg.x.dx<25)&&(outreg.x.cx<60))
			||((CursorY<25)&&(CursorX<60)))
		Process_Help(1);

	if(((outreg.x.dx<25)&&(outreg.x.cx>60)&&(outreg.x.cx<180)&&(Menu==1))
			||((CursorY<25)&&(CursorX>60)&&(CursorX<180)&&(Menu==1)))
/*                if(LayersChosenOn==0)*/
			Select_Layers(1);

	if(((outreg.x.dx<25)&&(outreg.x.cx>180)&&(outreg.x.cx<293)&&(Menu==3))
			||((CursorY<25)&&(CursorX>180)&&(CursorX<293)&&(Menu==3)))
		Process_Quads100K();

	if(((outreg.x.dx<25)&&(outreg.x.cx>293)&&(outreg.x.cx<379)&&(Menu==1))
			||((CursorY<25)&&(CursorX>293)&&(CursorX<379)&&(Menu==1)))
	{
		View_Quads();
		CursorY=100;
	}
	if(((outreg.x.dx<25)&&(outreg.x.cx>379)&&(outreg.x.cx<480)&&(Menu==3))
			||((CursorY<25)&&(CursorX>379)&&(CursorX<480)&&(Menu==3)))
	{    f = Output(1);
	     Reset();
	}
	if(((outreg.x.dx<25)&&(outreg.x.cx>480)&&(outreg.x.cx<550))
			||((CursorY<25)&&(CursorX>480)&&(CursorX<550)))
		Reset();

	if(((outreg.x.dx<25)&&(outreg.x.cx>550))
			||((CursorY<25)&&(CursorX>550)))
		i=Exit();
    } /* END IF LEFT BUTTON OR RETURN PRESSED  */
} while(i!=40);                         /*  IF I = 40 EXIT PROGRAM      */
inreg.x.ax=0x0003;                     /*  BIOS check on board memory  */
int86 (0x10, &inreg, &outreg);
}
/*********************** END MAIN PROGRAM ********************************/

/*************************************************************************
**        ZOOM INTO THE 15' QUADS AND CONTINUE PROCESSING
**************************************************************************/
int ProcessQuad(quadnum)
int quadnum;
{
char    filename[30],writetemp[80];
int     i=0,j=27,k=0,m=0,n=0, f;
double  x1,y1,y2,lat,lon,TEMPLAT,TEMPLON;
int     RRow2,CColumn1,CColumn2;
double  showlat,showlatmin;

 LayersChosenOn=0;
 bytecounton=0;                   /* INITIALIZE VARIABLES         */
 for(i=1;i<=10;i++)
 {       layer[i].boolean=0;}
 LayerCount=0;
 /*PPDLong=421.0; */                  /* INITIALIZE PIXELS PER DEGREE */
 CColumn1=103;

 x1=QuadData[quadnum].Lon-1.0;
 y1=QuadData[quadnum].Lat+0.5;
 filename[0]='\0';
 strcat(filename,QuadData[quadnum].CutFile);     /* GET FILENAME  */
 if(GRAPHICS=='V')                               /* ADD EXTENSION */
	strcat(filename,".vga");                     /* .VGA or .EGA  */
 else
	strcat(filename,".ega");
 if(MouseThere==1) 
	Hide_Mouse();
 DisplayCutImage(filename);                      /* DRAW MAP      */
 Display_Menu(4);
 if(MouseThere==1) 
	Unhide_Mouse();
 ClearArea(BOTTOM-QuadNamePos,20,BOTTOM-(QuadNamePos-15),292,GREEN); /* DISPLAY QUADNAME ON SCREEN */
 boxes(20,BOTTOM-QuadNamePos,15,272,15);
 if(((QuadData[quadnum].Lat)-((int)(QuadData[quadnum].Lat)))>=(.5))
 {
	showlat=QuadData[quadnum].Lat-.5;
	showlatmin=30.0;
 }
 else
 {
	showlat=QuadData[quadnum].Lat;
	showlatmin=0.0;
 }
 sprintf(TempLat,"%3.0f",showlat);
 sprintf(TempLatmin,"%2.0f",showlatmin);
 sprintf(TempLon,"%3.0f",-QuadData[quadnum].Lon);
 sprintf(writetemp,"%s",QuadData[quadnum].QuadName);
 WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-2),22,50,writetemp,2,Font);
 WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-2),180,50,TempLat,2,Font);
 WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-2),210,50,TempLatmin,2,Font);
 WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-2),250,50,TempLon,2,Font);

/****   LOOP UNTIL THE USER PRESSES THE RIGHT MOUSE BUTTON OR ENTER ******/

 do
 {
     if(MouseThere==1)
     {
	 outreg.x.bx=0x000;              /* POLL MOUSE CONTINUOSLY       */
	 inreg.x.ax=0x003;
	 int86 (0x33, &inreg, &outreg);
     }
     else
     {
	Return_Char=pix_val(CursorX,CursorY);/* POLL CURSOR CONTINUOUSLY */
	outreg.x.dx=100;
     }
     if((outreg.x.dx<25)||(CursorY<25))
     {                                   /* IF CURSOR IS WITHIN MENU     */
	 Display_Explain2();             /* DISPLAY EXPLANATION AND      */
	 outside_menu=0;                 /* HIGHLIGHT SELECTION          */
     }
     else
     {
	 if(outside_menu==0)
	 {
	   if(Choice>0)
	   {
	      Unhighlight();
	      Choice=0;
	   }
	   MakeRoom();
	   WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,50,EXPLAIN8,2,Font);
	   outside_menu=1;
	 }
     }
     if((outreg.x.bx==1)||(Return_Char=='\r'))
     {                                  /* IF LEFT/RETURN IS PRESSED */
	 if(MouseThere==1) 
		CColumn2=outreg.x.cx;   /* GET CURSOR POSITION  */
	 else              
		CColumn2=CursorX;
	 if(MouseThere==1) 
		RRow2=outreg.x.dx;
	 else              
		RRow2=CursorY;
	 lat=y1+(((double)(RRow2-RRow1))/PPDLat);
	 lon=x1+(((double)(CColumn2-CColumn1))/PPDLong);
	 TEMPLAT=lat;
	 TEMPLON=lon;
	 lon=(int)lon;
	 if( (lat-(int)lat)>0.5)
		lat=(int)lat+0.5;
	 else
	 {
	    y2=(int)lat;
	    lat=y2;
	 }
	 if(MouseThere!=1) 
		outreg.x.dx=100;  /* AVOID ACTIVATING HELP    */

	 if(((outreg.x.dx<25)&&(outreg.x.cx<111))
			||((CursorY<25)&&(CursorX<111)))
	       Process_Help(2);

	 if(((outreg.x.dx<25)&&(outreg.x.cx>111)&&(outreg.x.cx<230)&&(Menu==4))
			||((CursorY<25)&&(CursorX>111)&&(CursorX<230)&&(Menu==4)))
/*               if(LayersChosenOn==0)*/
	       Select_Layers(2);

	 if(((outreg.x.dx<25)&&(outreg.x.cx>230)&&(outreg.x.cx<365)&&(Menu==2))
			||((CursorY<25)&&(CursorX>230)&&(CursorX<365)&&(Menu==2)))
	       if(layerselected == 1)
	       {        Select_Quads2(quadnum);
			layerselected = 0;
			Display_Menu(5);
	       }

	 if(((outreg.x.dx<25)&&(outreg.x.cx>365)&&(outreg.x.cx<449)&&(Menu==2))
			||((CursorY<25)&&(CursorX>365)&&(CursorX<449)&&(Menu==2)))
	 {    f = Output(2);
	      if(f == 0)
	      {       m=40;
		      Choice=0;
		      Return_Char='X';
	      }
	 }
	 if(((outreg.x.dx<25)&&(outreg.x.cx>449)&&(outreg.x.cx<542))
			||((CursorY<25)&&(CursorX>449)&&(CursorX<542)))
	 {     m=40;
	       Choice=0;
	       Return_Char='X';
	 }

	 if(((outreg.x.dx<25)&&(outreg.x.cx>542))
			||((CursorY<25)&&(CursorX>542)))
	 {     m=Exit();
	       Return_Char='X';
	 }

     }  /* END IF LEFT MOUSE OR RETURN BUTTON PRESSED */
 } while(m!=40); /* EXIT LEVEL 2 */
 LayersChosenOn=0;
 for(i=1;i<=10;i++)
 {      layer[i].boolean=0;}
 return(1);
}

/***************** PUT THE VGA/EGA FILE ON THE SCREEN ********************/
int DisplayCutImage(filespec)
char *filespec;
{
FILE    *ifile;
int     columns,rows,i,LineLength;
char    *pntbuff;

	 if((ifile=fopen(filespec,"rb"))==NULL)
	 {
	   system("mode co80");
	   printf("Could not open input file \"%s\"              ", filespec);
	   getch();
	   exit(1);
	 }
	 fread(&columns,sizeof(int),1,ifile);
	 fread(&rows,sizeof(int),1,ifile);
	 fread(&i,sizeof(int),1,ifile);
	 fread(buffer1,sizeof(char),64000,ifile);
	 fclose(ifile);
	 pntbuff=buffer1;
	 for (i = 0; i < rows; i++)
	 {
	     LineLength=*((int *)pntbuff);
	     pntbuff+=2;
	     CUT(pntbuff,buffer);
	     PlotLine(i,0,i,columns-1,buffer);
	     pntbuff+=LineLength;
	 }
	 return(1);
}

/******** DETERMINE THE ACTUAL 15' BLOCK (1-8) THE CURSOR IS IN **********/
int Get_Block(double TLon,double glon,double TLat,double glat)
{
		 for(;;)
		 {
		      if((TLon-glon)>-.25)
		      {
			 if((TLat-glat)<.25)
			   Block=8;
			 else
			   Block=4;
			 break;
		      }
		      if((TLon-glon)>-.5)
		      {
			 if((TLat-glat)<.25)
			   Block=7;
			 else
			   Block=3;
			 break;
		      }
		      if((TLon-glon)>-.750)
		      {
			 if((TLat-glat)<.25)
			   Block=6;
			 else
			   Block=2;
			 break;
		      }
		      if((TLat-glat)<.25)
			Block=5;
		      else
			Block=1;
		      break;
		 } /* END FOR(;;) */
		 return(Block);
}

/********* SELECT  15' QUADS USING THE CURSOR COORDINATES ****************/
int Select_Blocks(quadnumber)
int quadnumber;
{
char    compare[20];
int     i=0,j=0,k=0,l=0,m=0,n=0,o=0,ALL=0;
double  x1,y1,y2,lat,lon,TempLat,TempLong;
int     RRow2=0,CColumn1=0,CColumn2=0,markit;

  ByteCount=0;
  /* PPDLong=421.0;*/
  CColumn1=103;
  x1=QuadData[quadnumber].Lon-1.0;
  y1=QuadData[quadnumber].Lat+0.5;
  do
  {
      if(MouseThere==1)
      {
	  outreg.x.bx=0x000;
	  inreg.x.ax=0x003;           /* POLL MOUSE CONTINUOSLY       */
	  int86 (0x33, &inreg, &outreg);
      }
      else
      {
	  Return_Char=pix_val(CursorX,CursorY);
      }
      if((outreg.x.bx==2)||(Return_Char==27))
      {                          /* RIGHT BUTTON PRESSED         */
	  outreg.x.bx=0x000;
	  k=4000;
      }
      if((outreg.x.bx==1)||(Return_Char=='\r'))
      {                          /* LEFT  PRESSED     */
	  if(MouseThere==1)
	  {                    /* GET CURSOR POSITION */
	      Xvalue=CColumn2=outreg.x.cx;
	      Yvalue=RRow2=outreg.x.dx;
	  }
	  else
	  {
	      Xvalue=CColumn2=CursorX;
	      Yvalue=RRow2=CursorY;
	  }
	  lat=y1+(((double)(RRow2-RRow1))/PPDLat);
	  lon=x1+(((double)(CColumn2-CColumn1))/PPDLong);
	  TempLat=lat;
	  TempLong=lon;
	  lon=(int)lon;
	  if((lat-(int)lat)>0.5)
	  {
	      lat=(int)lat+0.5;
	  }
	  else
	  {
	      y2=(int)lat;
	      lat=y2;
	  }
	 /* DETERMINE THE INDIVIDUAL QUAD THE USER HAS SELECTED */

	  if(MouseThere==1) 
		Mouse_Trap();
	  for(i=0;i<QuadCount;i++)
	  {
	      if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon))
	      {
		  BlockCount=0;
		  Block = Get_Block(TempLong,lon,TempLat,lat);
		  SmallByteCount=0;
	  markit=0;
		  for(m=1;m<=5;m++)
		  {
	    if(layer[m].boolean >= 1)
		    {     /* GET THE BYTE COUNT */
		       if(m==1)
		       {
			 SmallByteCount+=QuadData[i].bytesize[(Block-1)];
			 sprintf(compare,"%s",QuadData[i].hydro);
		       }
		       if(m==2)
		       {
			 SmallByteCount+=QuadData[i].bytesize[(Block+7)];
			 sprintf(compare,"%s",QuadData[i].tran);
		       }
		       if(m==3)
		       {
			 SmallByteCount+=QuadData[i].bytesize[(Block+15)];
			 sprintf(compare,"%s",QuadData[i].rail);
		       }
		       if(m==4)
		       {
			 SmallByteCount+=QuadData[i].bytesize[(Block+23)];
			 sprintf(compare,"%s",QuadData[i].roads);
		       }
		       if(m==5)
		       {
			  SmallByteCount=0;
			  SmallByteCount+=QuadData[i].bytesize[(Block-1)];
			  SmallByteCount+=QuadData[i].bytesize[(Block+7)];
			  SmallByteCount+=QuadData[i].bytesize[(Block+15)];
			  SmallByteCount+=QuadData[i].bytesize[(Block+23)];
			  for(o=1;o<=4;o++)
			  {
			     sprintf(compare,"%s",QuadData[i].hydro);
			     Get_BlockNumbers(compare);
			  }
			  markit=1;
			  Sort_Blocks(i,o,RRow2,CColumn2,markit);
			  break;
		       }  /* END IF M=5 */
		       Get_BlockNumbers(compare);
		       if(layer[5].boolean<=0)
		       {
			   markit++;
			   Sort_Blocks(i,m,RRow2,CColumn2,markit);
		       }
		       SmallByteCount=0;

		    }  /* IF LAYER[m].BOOLEAN >= 1 */
		  }  /* END FOR M = 1 to 5        */
		  break;
	      }  /* END IF LAT AND LON MATCH */
	  }  /* END FOR I < QUADCOUNT */
      } /* END IF LEFT BUTTON OR RETURN PRESSED */
  } while (k!=4000);
  return(1);
}

/**************** ADD 15' QUADS TO THE LINKED LIST ***********************/
void Build_File(i,m,Break)
char Break[];
int i,m;
{
char choicestring[10],choicext[5],archived[15],filename[30],temparray1[5],temparray2[5],directory[20];
int j;
	 choicestring[0]='\0';     /* SET UP DATA TO PUT IN LINKED LIST */
	 sprintf(choicestring,"%s",layer[m].choicstr);
	 sprintf(choicext,"%s",layer[m].choiext);

	 filename[0]='\0';
	 sprintf(directory,"%s",QuadData[i].DirName);
	 strcat(filename,QuadData[i].CutFile);
	 strcat(filename,choicestring);

	 for(j=0;j<BlockCount;j++) 
	 {
	     archived[0]='\0';
	     strcat(archived,QuadData[i].CutFile);
	     strcat(archived,choicext);
	     strcat(archived,Break);
	     if(BlockArray[j]<10)
	     {
		 sprintf(temparray1,"%d",0);
		 strcat(archived,temparray1);
	     }
	     sprintf(temparray2,"%d",BlockArray[j]);
	     strcat(archived,temparray2);
	     newptr=(struct outputdata *) malloc(sizeof(struct outputdata));
	     if(firstptr==(struct outputdata *)NULL)
		  firstptr=currentptr=newptr;
	     else
	     {
		 currentptr=firstptr;
		 while(currentptr->next != (struct outputdata *)NULL)
		    currentptr = currentptr->next;
		 currentptr->next=newptr;
		 currentptr->next->fore = currentptr;
		 currentptr = newptr;
	     }
	     lastptr = newptr;       /* FILL LINKED LIST WITH DATA   */
	     currentptr->bytesaffected=SmallByteCount;
	     sprintf(currentptr->dirname,"%s",directory);
	     sprintf(currentptr->arcfile,"%s",filename);
	     sprintf(currentptr->outarcfile,"%s",archived);
	     currentptr->xloc=Xvalue;
	     currentptr->yloc=Yvalue;
	     currentptr->next = ((struct outputdata *)NULL);
	 }
	 BlockCount = 0;
}

/********** OUTPUT THE DATA TO USER SELECTED DIRECTORY *******************/
int copyout()
{
FILE *testout;
char curpath[60];
char eof=0,ch;
char *pathpnt;
char pathname[80];
char *genbuff;
char longtemp[80];
char command[80],execline[80];
char dummy[3],backslash[3],tempbuffer[81];
char OUTPUTSTR[25],COLON[3],DIRECTORY[25], buf[512];

int result=3,retry;
int numfiles=0;
int cur=0,f,j,choice,p,k,m,r,menu=0;
int TotalBytes=0;
int file_exist;
char command_temp[150];

unsigned  status = 0;
unsigned long TotalBytesonDisk;

void far *pbuf;
struct diskinfo_t info;
pbuf = (void far *) (&buf[0]);
info.buffer = pbuf;
info.drive = 2; /* 0 =drive A, 1 = drive B */
info.head = 0;
info.track = 0;
info.sector = 1;
info.nsectors = 1;

   SaveArea(200,10,300,400,0);
   if((cdfile=fopen("\\cddrive.txt","r"))==NULL) /* GET CD DRIVE   */
	sprintf(command,"%s","\\100K_DLG");
   else
   {    fscanf(cdfile,"%s",CDDRIVE);
	fclose(cdfile);
	sprintf(command,"%c",CDDRIVE[0]);
	strcat(command,":\\100K_DLG");
   }

   if(ByteCount<=0 || (access(command, 0) != 0) )
   {                     /* IF THERE'S NO DATA TO OUTPUT */
       MakeRoom();
       tone(784,20);
       if(ByteCount > 0)
	  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,"Could not find 100K_DLG directory",2,Font);
       else
	  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,ERROR2,2,Font);
       Pause();
   }
   else
   {                                 /* SETUP CHARACTERS FOR OUTPUT  */
       backslash[0]='\0';
       sprintf(backslash,"%s","\\");
       dummy[0] = '\0';
       sprintf(dummy,"%s"," ");
       genbuff=&pathname[1];
       sprintf(DIRECTORY,"%s","\\100K_DLG\\");
       sprintf(OUTPUTSTR,"%s"," > c:\\out.txt ");
       sprintf(COLON,"%s",":");

       do
       {
	  f=1;
	  Clear_Output(BLUE);
	  WriteStringAtxy(WHITE,202,12,50,OUTPUT1,2,Font);
	  WriteStringAtxy(WHITE,222,12,50,OUTPUT10,2,Font);
	  WriteStringAtxy(WHITE,242,12,550,OUTPUT2,2,Font);

	  m=0;                           /* GET OUTPUT DIRECTORY         */
	  for(k=0;(k<80)&&((ch=getch())!='\r');k++)
	  {
	    if( ch == 8 )
	    {
	      m--;
	      k--;
	      tempbuffer[m]='\0';
	    }
	    else
	    {
	      tempbuffer[m]=ch;
	      m++;
	    }
	    tempbuffer[m]='\0';          /* PRINT DIRECTORY ON SCREEN    */
	    ClearArea(241,109,262,350,BLUE);
	    WriteStringAtxy(WHITE,242,110,80,tempbuffer,2,Font);
	  }
	  sprintf(genbuff,"%s",tempbuffer);
	  pathname[0]=' ';
	  pathpnt=curpath;
	  getcwd(pathpnt,55);

/*********** TEST FOR FLOPPY DRIVE READY */

	  _bios_disk(_DISK_RESET, &info);
	  if (( tempbuffer[0] == 'A') || (tempbuffer[0] == 'a'))
	  { info.drive = 0;
	    for (retry = 0; retry < 5; retry++)
	    {
	      if (( status = _bios_disk(_DISK_VERIFY, &info)) != info.nsectors)
	      {
		if ( retry == 2)
		{   WriteStringAtxy(WHITE,280,12,400,"PROBLEM READING DRIVE A-Check And Then Press ENTER",2, Font);
		    getch();
		}
		if ( retry == 4)
		{      Clear_Output(BLUE);
		       WriteStringAtxy(WHITE,280,12,400,"STILL A PROBLEM WITH DRIVE A - returning to menu  ",2, Font);
		       return(0);
		}
	      }
	    }
	  }
	  if (( tempbuffer[0] == 'B') || (tempbuffer[0] == 'b'))
	  { info.drive = 1;
	    for (retry = 0; retry < 5; retry++)
	    {
	      if (( status = _bios_disk(_DISK_VERIFY, &info)) != info.nsectors)
	      {
		if ( retry == 2)
		{   WriteStringAtxy(WHITE,280,12,400,"PROBLEM READING DRIVE B-Check And Then Press ENTER",2, Font);
		    getch();
		}
		if ( retry == 4)
		{       Clear_Output(BLUE);
			WriteStringAtxy(WHITE,280,12,400,"STILL A PROBLEM WITH DRIVE B - returning to menu  ",2, Font);
			return(0);
		}
	      }
	    }
	  }
/************************/

	  p=chdir(&pathname[1]);

	  if(p==-1)
	  {                     /* UNABLE TO LOCATE DIR         */
	     Clear_Output(BLUE);
	     WriteStringAtxy(WHITE,202,12,300,OUTPUT3,2,Font);

	     choice=getch();
	     if(toupper(choice)=='Y')    /* CREATE DIRECTORY?            */
		{
		  p=mkdir(&pathname[1]);
		  if(p==-1)
		     {
		      Clear_Output(BLUE);
		      WriteStringAtxy(WHITE,202,12,300,"UNABLE TO CREATE DIRECTORY - REENTER PATH NAME (Y/N)",2,Font);

		      choice=getch();    /* UNABLE TO CREATE  TRY AGAIN? */
		      if(toupper(choice)=='Y')
			f=0;
		     }
		}
	     else       
		f=0;
	  }
       } while(f==0); /* LOOP WHILE F=0 */
       if(p!=-1)
       {                        /* IF DIRECTORY IS FOUND        */
	 j=chdir(pathpnt);
	 _dos_getdiskfree(((int)(toupper(pathname[1])))-64,&disk_check_stru);
	 TotalBytesonDisk = (long)((long)disk_check_stru.avail_clusters*(long)disk_check_stru.sectors_per_cluster*(long)disk_check_stru.bytes_per_sector);
	 sprintf(longtemp,"%lu",TotalBytesonDisk);
	 Clear_Output(BLUE);
	 WriteStringAtxy(WHITE,202,12,200,OUTPUT4,2,Font);
	 WriteStringAtxy(WHITE,202,300,200,longtemp,2,Font);
	 WriteStringAtxy(WHITE,214,12,200,OUTPUT5,2,Font);
	 ltoa(ByteCount,longtemp,radix);
	 WriteStringAtxy(WHITE,214,300,200,longtemp,2,Font);

	 if(TotalBytesonDisk<ByteCount)
	 { /* TOO MUCH DATA FOR STORAGE AREA */
	    ClearArea(200,10,300,400,RED);
	    boxes(10,200,15,390,100);
	    tone(784,20);
	    WriteStringAtxy(WHITE,202,12,200,OUTPUT4,2,Font);
	    sprintf(longtemp,"%lu",TotalBytesonDisk);
	    WriteStringAtxy(WHITE,202,300,200,longtemp,2,Font);
	    ltoa(ByteCount,longtemp,radix);
	    WriteStringAtxy(WHITE,216,12,200,OUTPUT5,2,Font);
	    WriteStringAtxy(WHITE,216,300,200,longtemp,2,Font);
	    WriteStringAtxy(WHITE,230,12,300,OUTPUT6,2,Font);
	    WriteStringAtxy(WHITE,252,12,300,OUTPUT7,2,Font);
	    WriteStringAtxy(WHITE,270,12,300,PAUSE,2,Font);
	    getch();
	    menu=0;
	    system(" ");
	 }
	 else                            /* NOT TOO MUCH DATA            */
	 {
	    WriteStringAtxy(WHITE,246,12,50,OUTPUT8,2,Font); /* OUTPUT? (Y/N) */
	    choice=getch();
	    if(toupper(choice)=='Y')
	    {
		 Clear_Output(BLUE);
		 WriteStringAtxy(WHITE,214,12,50,OUTPUT9,2,Font);

		 if((cdfile=fopen("\\cddrive.txt","r"))==NULL)  /* NOT INSTALLED */
		     INSTALLED=0;
		 else
		 {
		     fscanf(cdfile,"%s",CDDRIVE);
		     fclose(cdfile);                            /* GET CD DRIVE   */
		     INSTALLED=1;
		 }

 /* testout=fopen("c:\\finalout","wt");*/
/***************** BUILD THE COMMAND LINE AND UNZIP THE DATA ***************/
		 currentptr=firstptr;
		 file_exist = 1;        
		 while( (currentptr)!=((struct outputdata *)NULL) ) 
		 {
		       command[0]='\0';

		       if(INSTALLED==1)
		       {
			   sprintf(command,"%c",CDDRIVE[0]);
			   strcat(command,COLON);
			   strcat(command,DIRECTORY);
		       }
		       else
		       {
			   sprintf(command,"%s","\\100K_DLG\\");
		       }
		       strcat(command,currentptr->dirname);
		       strcpy(command_temp, command);
		       strcat(command,backslash);
		       strcat(command,currentptr->arcfile);
/*                       strcpy(command_temp, command);*/
/*                       strcat(command_temp, ".ZIP");*/
/*strcpy(command_temp, "c:\\100k_dlg\\manteo\\mn1rail.zip");*/
		       
		       if(access(command_temp, 0) == -1)
		       {        file_exist = 0;
				strcpy(OUTPUT12, "Could NOT Find: ");                                
				strcat(OUTPUT12, command_temp);
				system(" ");
		       }
		       else
		       {
				strcat(command,dummy);
				strcat(command,genbuff);
				strcat(command,dummy);
				strcat(command,currentptr->outarcfile);
				sprintf(execline,"%s","PKUNZIP -x -o ");
				strcat(execline,command);
				strcat(execline,OUTPUTSTR);
				system(execline);
		       }
/* fprintf(testout,"%s\n",execline);*/
		       currentptr=currentptr->next;

		 } /* END WHILE LINKED LIST NOT EMPTY */

		 Clear_Output(GREEN);
		 tone(784,20);

		 if(file_exist == 0)
		 {      WriteStringAtxy(WHITE,215,12,70,OUTPUT12,2,Font);
			WriteStringAtxy(WHITE,235,12,50,OUTPUT13,2,Font);
		 }
		 else

			WriteStringAtxy(WHITE,215,12,50,OUTPUT11,2,Font);
		 getch();
		 for(r=0;r<=10;r++){ layer[r].boolean=0;} /* RESET LAYER BOOLEANS */
		 layerson=0;                            /* TO OFF               */
		 bytecounton=0;
		 ByteCount=0;
		 LayerCount=0;
	       /* RestoreArea(26,485,82,620,2); */
	       /* RestoreArea(196,495,252,630,2);  7560 */
		if(Menu == 2 || Menu == 4)
			RestoreArea(30,480,30+56,480+135,2); /* 7560 */
		else        
			RestoreArea(brog,bcog,brog+56,bcog+135,2);
/* fclose(testout);*/
		 menu=1;
	    }   /* END IF TOUPPER CHOICE */
	    else
		system(" ");
	 }   /* END ELSE BYTESIZE < THAN AVAILABLE SPACE */
       } /* END IF P NOT EQUAL -1 */
       RestoreArea(200,10,300,400,0);
   }   /* END ELSE BYTECOUNT > 0 */

/*system("del c:\\out.txt");*/
   return(menu);
}

/********** DISPLAY EXPLANATION LINES AND HIGHLIGHT OPTION ***************/
void Display_Explain(void)
{
int k=1;

 /*help*/      if(((outreg.x.dx<25)&&(outreg.x.cx<60))||((CursorY<25)&&(CursorX<60))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=1)&&(Choice>0))){
		      MakeRoom();
		      if((Choice!=1)&&(Choice>0))   Unhighlight();
		      SaveArea(5,5,25,60,0);
		      ClearArea(5,5,25,60,WHITE);
		      WriteStringAtxy(BLUE,8,20,50,"HELP",2,Font);
		      Choice=1;
		      }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN15,2,Font);
		  Unhide_Mouse();
	       }

 /*layers*/    if(((outreg.x.dx<25)&&(outreg.x.cx>60)&&(outreg.x.cx<180)&&(Menu==1))
	       ||((CursorY<25)&&(CursorX>60)&&(CursorX<180)&&(Menu==1))){
		   Hide_Mouse();
		   if((Choice==0)||((Choice!=2)&&(Choice>0))){
		      MakeRoom();
		      if((Choice!=2)&&(Choice>0)) Unhighlight();
		      SaveArea(5,60,25,180,0);
		      ClearArea(5,60,25,180,WHITE);
		      WriteStringAtxy(BLUE,8,70,50,"SELECT LAYERS",2,Font);
		      Choice=2;
		      }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN2,2,Font);
		  Unhide_Mouse();
	       }

 /*quads*/     if(((outreg.x.dx<25)&&(outreg.x.cx>180)&&(outreg.x.cx<293)&&(Menu==3))
	       ||((CursorY<25)&&(CursorX>180)&&(CursorX<293)&&(Menu==3))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=3)&&(Choice>0))){
		      MakeRoom();
		      if((Choice!=3)&&(Choice>0))  Unhighlight();
		      SaveArea(5,180,25,293,0);
		      ClearArea(5,180,25,293,WHITE);
		      WriteStringAtxy(12,8,190,50,"SELECT QUADS",2,Font);
		      Choice=3;
		      }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN3,2,Font);
		  Unhide_Mouse();
	       }

 /*zoom in*/   if(((outreg.x.dx<25)&&(outreg.x.cx>293)&&(outreg.x.cx<379)&&(Menu==1))
	       ||((CursorY<25)&&(CursorX>293)&&(CursorX<379))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=4)&&(Choice>0))){
		     MakeRoom();
		     if((Choice!=4)&&(Choice>0)) Unhighlight();
		     SaveArea(5,293,25,379,0);
		     ClearArea(5,293,25,379,WHITE);
		     WriteStringAtxy(12,8,303,50,"VIEW QUAD",2,Font);
		     Choice=4;
		     }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN4,2,Font);
		  Unhide_Mouse();
	       }

 /*output*/    if(((outreg.x.dx<25)&&(outreg.x.cx>379)&&(outreg.x.cx<480)&&(Menu==3))
	       ||((CursorY<25)&&(CursorX>379)&&(CursorX<480)&&(Menu==3))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=5)&&(Choice>0))){
		     MakeRoom();
		     if((Choice!=5)&&(Choice>0))   Unhighlight();
		     SaveArea(5,379,25,480,0);
		     ClearArea(5,379,25,480,WHITE);
		     WriteStringAtxy(12,8,389,50,"OUTPUT",2,Font);
		     Choice=5;
		     }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN5,2,Font);
		  Unhide_Mouse();
	       }

 /*reset*/     if(((outreg.x.dx<25)&&(outreg.x.cx>480)&&(outreg.x.cx<550))
	       ||((CursorY<25)&&(CursorX>480)&&(CursorX<550))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=6)&&(Choice>0))){
		     MakeRoom();
		     if((Choice!=6)&&(Choice>0))   Unhighlight();
		     SaveArea(5,480,25,550,0);
		     ClearArea(5,480,25,550,WHITE);
		     WriteStringAtxy(BLUE,8,490,17,"RESET",2,Font);
		     Choice=6;
		     }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN7,2,Font);
		  Unhide_Mouse();
	       }

 /*exit*/      if(((outreg.x.dx<25)&&(outreg.x.cx>550))||((CursorY<25)&&(CursorX>550))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=7)&&(Choice>0))){
		    MakeRoom();
		    if((Choice!=7)&&(Choice>0))  Unhighlight();
		    SaveArea(5,550,25,635,0);
		    ClearArea(5,550,25,635,WHITE);
		    WriteStringAtxy(12,8,560,50,"EXIT",2,Font);
		    Choice=7;
		  }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN6,2,Font);
		  Unhide_Mouse();
	       }

	       /* THIS LOOP AVOIDS REHIGHLIGHTING THE OPTIONS */
	       while(k==1){
		if(MouseThere){
		  inreg.x.ax=0x00B;          /* CHECK FOR MOUSE MOVEMENT */
		  int86 (0x33,&inreg, &outreg);
		  if((outreg.x.cx!=0)||(outreg.x.dx!=0))  k=2;
		  inreg.x.ax=0x003;          /* CHECK FOR BUTTONS PUSHED */
		  int86 (0x33,&inreg,&outreg);
		  if((outreg.x.bx==1)||(outreg.x.bx==2))  k=2;
		  }
		else{
		  k=2;
		  }
	       }
}

/********** HIGHLIGHT AND DISPLAY LINES ON BOTTOM OF SCREEN **************/
void Display_Explain2(void)   /* THIS FUNCTION WORKS FOR LEVEL 2 (DIFFERENT MENU) */
{
int k=1;
 /*help*/      if(((outreg.x.dx<25)&&(outreg.x.cx<111))||((CursorY<25)&&(CursorX<111))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=8)&&(Choice>0))){
		     MakeRoom();
		     if((Choice!=8)&&(Choice>0))   Unhighlight();
		     SaveArea(5,5,25,111,0);
		     ClearArea(5,5,25,111,WHITE);
		     WriteStringAtxy(12,8,20,50,"HELP",2,Font);
		     Choice=8;
		     }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN15,2,Font);
		  Unhide_Mouse();
	       }

 /*layers*/    if(((outreg.x.dx<25)&&(outreg.x.cx>111)&&(outreg.x.cx<230)&&(Menu==4))
	       ||((CursorY<25)&&(CursorX>111)&&(CursorX<230)&&(Menu==4))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=9)&&(Choice>0))){
		    MakeRoom();
		    if((Choice!=9)&&(Choice>0))   Unhighlight();
		    SaveArea(5,111,25,230,0);
		    ClearArea(5,111,25,230,WHITE);
		    WriteStringAtxy(12,8,121,50,"SELECT LAYERS",2,Font);
		    Choice=9;
		  }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN2,2,Font);
		  Unhide_Mouse();
	       }

 /*quads*/     if(((outreg.x.dx<25)&&(outreg.x.cx>230)&&(outreg.x.cx<365)&&(Menu==2))
	       ||((CursorY<25)&&(CursorX>230)&&(CursorX<365)&&(Menu==2)))
		 if(layerselected == 1)
	       {
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=10)&&(Choice>0))){
		      MakeRoom();
		      if((Choice!=10)&&(Choice>0))   Unhighlight();
		      SaveArea(5,230,25,365,0);
		      ClearArea(5,230,25,365,WHITE);
		      WriteStringAtxy(12,8,240,50,"SELECT 15' CELLS",2,Font);
		      Choice=10;
		      }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN20,2,Font);
		  Unhide_Mouse();
	       }

 /*output*/    if(((outreg.x.dx<25)&&(outreg.x.cx>365)&&(outreg.x.cx<449)&&(Menu==2))
	       ||((CursorY<25)&&(CursorX>365)&&(CursorX<449)&&(Menu==2))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=11)&&(Choice>0))){
		    MakeRoom();
		    if((Choice!=11)&&(Choice>0))  Unhighlight();
		    SaveArea(5,365,25,449,0);
		    ClearArea(5,365,25,449,WHITE);
		    WriteStringAtxy(12,8,375,50,"OUTPUT",2,Font);
		    Choice=11;
		  }
		  WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN5,2,Font);
		  Unhide_Mouse();
	       }

 /*reset*/     if(((outreg.x.dx<25)&&(outreg.x.cx>449)&&(outreg.x.cx<542))
	       ||((CursorY<25)&&(CursorX>449)&&(CursorX<542))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=12)&&(Choice>0))){
		    MakeRoom();
		    if((Choice!=12)&&(Choice>0))  Unhighlight();
		    SaveArea(5,449,25,542,0);
		    ClearArea(5,449,25,542,WHITE);
		    WriteStringAtxy(12,8,459,50,"RESET",2,Font);
		    Choice=12;
		  }
		  WriteStringAtxy(15,BOTTOM-(Explain-5),12,200,EXPLAIN7,2,Font);
		  Unhide_Mouse();
	       }


 /*exit*/      if(((outreg.x.dx<25)&&(outreg.x.cx>542))
	       ||((CursorY<25)&&(CursorX>542))){
		  Hide_Mouse();
		  if((Choice==0)||((Choice!=13)&&(Choice>0))){
		     MakeRoom();
		     if((Choice!=13)&&(Choice>0))   Unhighlight();
		     SaveArea(5,542,25,635,0);
		     ClearArea(5,542,25,635,WHITE);
		     WriteStringAtxy(12,8,552,50,"EXIT",2,Font);
		     Choice=13;
		     }
		  WriteStringAtxy(15,BOTTOM-(Explain-5),12,200,EXPLAIN9,2,Font);
		  Unhide_Mouse();
	       }

	       /* THIS LOOP AVOIDS REHIGHLIGHTING THE OPTIONS */
	       while(k==1){
		 if(MouseThere==1){
		   inreg.x.ax=0x00B;         /* CHECK FOR MOUSE MOVEMENT */
		   int86 (0x33,&inreg, &outreg);
		   if((outreg.x.cx!=0)||(outreg.x.dx!=0))  k=2;
		   inreg.x.ax=0x003;         /* CHECK FOR BUTTONS PUSHED */
		   int86 (0x33,&inreg,&outreg);
		   if((outreg.x.bx==1)||(outreg.x.bx==2))  k=2;
		   }
		 else{
		     k=2;
		 }
	       }
}

/************** CLEAR THE AREA ON THE BOTTOM OF SCREEN FOR INFO **********/
void MakeRoom(void)
{
		ClearArea(BOTTOM-Explain,10,BOTTOM-(Explain-20),300,BLUE);
		boxes(10,BOTTOM-Explain,WHITE,290,20);
}

/************* DERIVE BLOCK NUMBERS USING FF FS SS ETC.. *****************/
void Get_BlockNumbers(compare)
char compare[];
{
int l;
      /*FF*/        if(l=(strcmp(compare,FF))==0){
			 BlockArray[BlockCount++]=Block;
			 sprintf(BreakDown,"%s","F");
		    }
      /*FS*/        if(l=(strcmp(compare,FS))==0){
			  if((Block==1)||(Block==2)||(Block==5)||(Block==6)){
			     BlockArray[BlockCount++]=Block;
			     sprintf(BreakDown,"%s","F");
			  }
			  else{
			     sprintf(BreakDown,"%s","S");
			     if(Block==3){
				BlockArray[BlockCount++]=5;
				BlockArray[BlockCount++]=6;
				BlockArray[BlockCount++]=13;
				BlockArray[BlockCount++]=14;
			       }
			     if(Block==4){
				BlockArray[BlockCount++]=7;
				BlockArray[BlockCount++]=8;
				BlockArray[BlockCount++]=15;
				BlockArray[BlockCount++]=16;
			       }
			     if(Block==7){
				BlockArray[BlockCount++]=21;
				BlockArray[BlockCount++]=22;
				BlockArray[BlockCount++]=29;
				BlockArray[BlockCount++]=30;
			       }
			     if(Block==8){
				BlockArray[BlockCount++]=23;
				BlockArray[BlockCount++]=24;
				BlockArray[BlockCount++]=31;
				BlockArray[BlockCount++]=32;
			       }
			   }  /* END ELSE */
		    }   /* END IF FS */

      /*SF*/        if(l=(strcmp(compare,SF))==0){
		       if((Block==3)||(Block==4)||(Block==7)||(Block==8)){
			      BlockArray[BlockCount++] = Block;
			      sprintf(BreakDown,"%s","F");
			 }
		       else
			 {
			     sprintf(BreakDown,"%s","S");
			     if(Block==1){
				BlockArray[BlockCount++]=1;
				BlockArray[BlockCount++]=2;
				BlockArray[BlockCount++]=9;
				BlockArray[BlockCount++]=10;
			       }
			     if(Block==2){
				BlockArray[BlockCount++]=3;
				BlockArray[BlockCount++]=4;
				BlockArray[BlockCount++]=11;
				BlockArray[BlockCount++]=12;
			       }
			     if(Block==5){
				BlockArray[BlockCount++]=17;
				BlockArray[BlockCount++]=18;
				BlockArray[BlockCount++]=25;
				BlockArray[BlockCount++]=26;
			       }
			     if(Block==6){
				BlockArray[BlockCount++]=19;
				BlockArray[BlockCount++]=20;
				BlockArray[BlockCount++]=27;
				BlockArray[BlockCount++]=28;
			       }
			}  /* END ELSE */
		      } /*   END IF SF   */
      /*SS*/        if(l=(strcmp(compare,SS))==0){
			   sprintf(BreakDown,"%s","S");
			   if(Block==1){
			      BlockArray[BlockCount++]=1;
			      BlockArray[BlockCount++]=2;
			      BlockArray[BlockCount++]=9;
			      BlockArray[BlockCount++]=10;
			     }
			   if(Block==2){
			      BlockArray[BlockCount++]=3;
			      BlockArray[BlockCount++]=4;
			      BlockArray[BlockCount++]=11;
			      BlockArray[BlockCount++]=12;
			     }
			   if(Block==3){
			      BlockArray[BlockCount++]=5;
			      BlockArray[BlockCount++]=6;
			      BlockArray[BlockCount++]=13;
			      BlockArray[BlockCount++]=14;
			     }
			   if(Block==4){
			      BlockArray[BlockCount++]=7;
			      BlockArray[BlockCount++]=8;
			      BlockArray[BlockCount++]=15;
			      BlockArray[BlockCount++]=16;
			     }
			   if(Block==5){
			      BlockArray[BlockCount++]=17;
			      BlockArray[BlockCount++]=18;
			      BlockArray[BlockCount++]=25;
			      BlockArray[BlockCount++]=26;
			     }
			   if(Block==6){
			      BlockArray[BlockCount++]=19;
			      BlockArray[BlockCount++]=20;
			      BlockArray[BlockCount++]=27;
			      BlockArray[BlockCount++]=28;
			     }
			   if(Block==7){
			      BlockArray[BlockCount++]=21;
			      BlockArray[BlockCount++]=22;
			      BlockArray[BlockCount++]=29;
			      BlockArray[BlockCount++]=30;
			     }
			   if(Block==8){
			      BlockArray[BlockCount++]=23;
			      BlockArray[BlockCount++]=24;
			      BlockArray[BlockCount++]=31;
			      BlockArray[BlockCount++]=32;
			     }
		     }   /* END IF SS               */
}

/******************* ADD QUAD TO THE LINKED LIST *************************/
void Build_File100K(quadnumber)
int quadnumber;
{
int j,q;
char asterisk[3],directory[20],choicestring[20],filename[20],archived[5];

       sprintf(asterisk,"%s","*");       /* SET UP DATA FOR LINKED LIST  */

       for(j=1;j<=4;j++){
	  if((layer[j].boolean>=1)&&(layer[5].boolean!=1)){
	      LargeByteCount=0;
	      switch(j){

		 case 1: for(q=0;q<8;q++) {LargeByteCount+=QuadData[quadnumber].bytesize[q];}
			 ByteCount+=LargeByteCount;
			 break;
		 case 2: for(q=8;q<16;q++) {LargeByteCount+=QuadData[quadnumber].bytesize[q];}
			 ByteCount+=LargeByteCount;
			 break;
		 case 3: for(q=16;q<24;q++) {LargeByteCount+=QuadData[quadnumber].bytesize[q];}
			 ByteCount+=LargeByteCount;
			 break;
		 case 4: for(q=24;q<32;q++) {LargeByteCount+=QuadData[quadnumber].bytesize[q];}
			 ByteCount+=LargeByteCount;
			 break;
		 default: break;
	      }

	      directory[0]='\0';
	      sprintf(directory,"%s",QuadData[quadnumber].DirName);

	      choicestring[0]='\0';
	      sprintf(choicestring,"%s",layer[j].choicstr);
	      filename[0]='\0';
	      strcat(filename,QuadData[quadnumber].CutFile);
	      strcat(filename,choicestring);
       /*       strcat(filename,asterisk);   */

	      archived[0]='\0';
	      sprintf(archived,"%s","*");

	      newptr=(struct outputdata *) malloc(sizeof(struct outputdata));
	      newptr->next=((struct outputdata *)NULL);

	      if(firstptr==(struct outputdata *)NULL)
		  firstptr=currentptr=newptr;
	      else{
		  currentptr=firstptr;
		  while(currentptr->next != (struct outputdata *)NULL)
		       currentptr = currentptr->next;
		  currentptr->next=newptr;
		  currentptr->next->fore = currentptr;
		  currentptr = currentptr->next;
		  currentptr->next = (struct outputdata *)NULL;
	      }
	      lastptr = newptr;          /* STORE DATA IN LINKED LIST    */
	      currentptr->bytesaffected=LargeByteCount;
	      sprintf(currentptr->dirname,"%s",directory);
	      sprintf(currentptr->arcfile,"%s",filename);
	      sprintf(currentptr->outarcfile,"%s",archived);
	      currentptr->xloc=Xvalue;
	      currentptr->yloc=Yvalue;
	      currentptr->next = ((struct outputdata *)NULL);
	 }  /* END IF LAYER[J].BOOLEAN == 1 */
       } /* END FOR J = 1 to 4 */

       if(layer[5].boolean>=1){
	      LargeByteCount=0;
	      for(q=0;q<32;q++) {LargeByteCount+=QuadData[quadnumber].bytesize[q];}
	      ByteCount+=LargeByteCount;

	      directory[0]='\0';
	      sprintf(directory,"%s",QuadData[quadnumber].DirName);
	      filename[0]='\0';
	      strcat(filename,QuadData[quadnumber].CutFile);
	      strcat(filename,asterisk);
	      archived[0]='\0';
	      sprintf(archived,"%s","*");

	      newptr=(struct outputdata *) malloc(sizeof(struct outputdata));

	      if(firstptr==(struct outputdata *)NULL)
		   firstptr=currentptr=newptr;
	      else{
		   currentptr=firstptr;
		   while(currentptr->next != (struct outputdata *)NULL)
		       currentptr = currentptr->next;
		   currentptr->next=newptr;
		   currentptr->next->fore = currentptr;
		   currentptr = currentptr->next;
		   currentptr->next = (struct outputdata *)NULL;
	      }
	      lastptr = newptr;

	      currentptr->bytesaffected=LargeByteCount;
	      sprintf(currentptr->dirname,"%s",directory);
	      sprintf(currentptr->arcfile,"%s",filename);
	      sprintf(currentptr->outarcfile,"%s",archived);
	      currentptr->xloc=Xvalue;
	      currentptr->yloc=Yvalue;
	      currentptr->next = ((struct outputdata *)NULL);
       }
       /* ByteCount+=LargeByteCount; */
}

/***************** DISPLAY THE VARIOUS MENUS *****************************/
void Display_Menu(WhichMenu)
int WhichMenu;
{
      ClearArea(5,5,25,635,BLUE);
      boxes(5,5,WHITE,630,20);
      if(MouseThere) 
	Hide_Mouse();
      switch(WhichMenu)
      {
	case 1:   WriteStringAtxy(WHITE,8,20,17,&ops1[0][0],2,Font);
		  WriteStringAtxy(WHITE,8,70,17,&ops1[1][0],2,Font);
		  WriteStringAtxy(GRAY,8,190,17,&ops1[2][0],2,Font);
		  WriteStringAtxy(WHITE,8,303,17,&ops1[3][0],2,Font);
		  WriteStringAtxy(GRAY,8,389,17,&ops1[4][0],2,Font);
		  WriteStringAtxy(WHITE,8,490,17,&ops1[5][0],2,Font);
		  WriteStringAtxy(WHITE,8,560,17,&ops1[6][0],2,Font);
		  Menu=1;
		  break;
	case 3:   WriteStringAtxy(WHITE,8,20,17,&ops3[0][0],2,Font);
		  WriteStringAtxy(GRAY,8,70,17,&ops3[1][0],2,Font);
		  WriteStringAtxy(WHITE,8,190,17,&ops3[2][0],2,Font);
		  WriteStringAtxy(GRAY,8,303,17,&ops3[3][0],2,Font);
		  WriteStringAtxy(WHITE,8,389,17,&ops3[4][0],2,Font);
		  WriteStringAtxy(WHITE,8,490,17,&ops3[5][0],2,Font);
		  WriteStringAtxy(WHITE,8,560,17,&ops3[6][0],2,Font);
		  Menu=3;
		  break;
	case 2:   WriteStringAtxy(WHITE,8,20,17,&ops2[0][0],2,Font);
		  WriteStringAtxy(GRAY,8,121,17,&ops2[1][0],2,Font);
		  WriteStringAtxy(WHITE,8,240,17,&ops2[2][0],2,Font);
		  WriteStringAtxy(WHITE,8,375,17,&ops2[3][0],2,Font);
		  WriteStringAtxy(WHITE,8,459,17,&ops2[4][0],2,Font);
		  WriteStringAtxy(WHITE,8,552,17,&ops2[5][0],2,Font);
		  Menu=2;
		  break;
	case 4:   WriteStringAtxy(WHITE,8,20,17,&ops4[0][0],2,Font);
		  WriteStringAtxy(WHITE,8,121,17,&ops4[1][0],2,Font);
		  WriteStringAtxy(GRAY,8,240,17,&ops4[2][0],2,Font);
		  WriteStringAtxy(GRAY,8,375,17,&ops4[3][0],2,Font);
		  WriteStringAtxy(WHITE,8,459,17,&ops4[4][0],2,Font);
		  WriteStringAtxy(WHITE,8,552,17,&ops4[5][0],2,Font);
		  Menu=4;
		  break;
	case 5:   WriteStringAtxy(WHITE,8,20,17,&ops2[0][0],2,Font);
		  WriteStringAtxy(GRAY,8,121,17,&ops2[1][0],2,Font);
		  WriteStringAtxy(GRAY,8,240,17,&ops2[2][0],2,Font);
		  WriteStringAtxy(WHITE,8,375,17,&ops2[3][0],2,Font);
		  WriteStringAtxy(WHITE,8,459,17,&ops2[4][0],2,Font);
		  WriteStringAtxy(WHITE,8,552,17,&ops2[5][0],2,Font);
		  Menu=2;
		  break;
      }  /* END SWITCH */
      if(MouseThere) 
	Unhide_Mouse();
}

/*************** DISPLAY AND PAGE THROUGH THE HELP FILE ******************/
void Process_Help(level)
int level;
{
FILE *helpfile;
char helpbuffer[41];
int i=0,j=0,k=0;
char userinpt,ch;
    Hide_Mouse();
    Unhighlight();
    Choice=0;
    if(level==1)
	helpfile=fopen("help.srn","r");
    else
	helpfile=fopen("help2.srn","r");
    /*SaveArea(100,50,300,340,0);  100,50,324,340,0 */
    SaveArea(100,50,260,310,0);
    do
    {
     ClearArea(100,50,260,310,BLUE);
	 /*boxes(50,100,WHITE,290,200);*/
     boxes(50,100,WHITE,260,160);
	 k=102;
	 for(j=0;j<8;j++)
	 {              /* DISPLAY 9 LINES OF HELP.TXT */
	     ch=fgetc(helpfile);
	     for(i=0;(i<40)&&((feof(helpfile))==0)&&(ch!='\n');i++){
		  helpbuffer[i] = ch;
		  ch=fgetc(helpfile);
	     }
	     helpbuffer[i]='\0';
	     WriteStringAtxy(WHITE,(k),51,50,helpbuffer,2,Font);
	     k+=17; /* 20 */
	 }
	/* WriteStringAtxy(WHITE,286,72,50,RETURNESC,2,Font);  314, 72 */
	 WriteStringAtxy(WHITE,246,72,50,RETURNESC,2,Font); 
    } while((userinpt=getch())!=27);      /* UNTIL ESC PRESSED            */
    fclose(helpfile);
    /*RestoreArea(100,50,300,340,0);       100,50,324,340,0 */
    RestoreArea(100,50,260,310,0);
    Unhide_Mouse();
}

/*************** HIGHLIGHT OR UNHIGHLIGHT LAYERS AS CHOSEN ***************/
void Process_Layers(SIZE)
int SIZE;
{
int j=0,k=0;

     do{
       if(MouseThere==1){
	 outreg.x.bx=0x000;
	 inreg.x.ax=0x003;            /* POLL MOUSE CONTINUOSLY          */
	 int86 (0x33, &inreg, &outreg);
	 }
       else{
	 Return_Char=pix_val(CursorX,CursorY);/* POLL ARROW KEYS CONTINUOUSLY*/
	 }

       if((outreg.x.bx==1)||(Return_Char=='\r')) /* IF LEFT BUTTON IS PRESSED       */
	  {
	    if(MouseThere==1) Mouse_Trap();

	      /* IF HYDROGRAPHY IS SELECTED FROM MENU */
	     if(((outreg.x.dx>25)&&(outreg.x.dx<42)&&(outreg.x.cx>5)&&(outreg.x.cx<100))
	       ||((CursorY>25)&&(CursorY<42)&&(CursorX>5)&&(CursorX<100))){
	       Hide_Mouse();
	       if(layer[1].boolean>=1){
		 layer[1].boolean=0;
		 LayerCount--;
		 if(LayerCount==0){
		    RestoreArea(25,5,150,100,1);    /* 11875 */
		    UnMark_Blocks(SIZE);
		    if(MouseThere==1) Unhide_Mouse();
		    layerson=0;
		    j=4000;
		    }
		 else{
		    ClearArea(26,6,44,99,BLUE);       /* 12 */
		    WriteStringAtxy(15,27,10,50,&layers[0][0],2,Font);
		    }
		 Deselect_Layers(1);
		 }
	       else{
		layer[1].boolean=1;
		LayerCount++;
		ClearArea(26,6,44,99,WHITE);
		WriteStringAtxy(12,27,10,50,&layers[0][0],2,Font);
		}
	      } /* END IF HYDROGRAPHY SELECTED */

	      /* IF MISC TRAN IS SELECTED FROM MENU */
	     if(((outreg.x.dx>42)&&(outreg.x.dx<53)&&(outreg.x.cx>5)&&(outreg.x.cx<100))
	     ||((CursorY>42)&&(CursorY<53)&&(CursorX>5)&&(CursorX<100))){
	      Hide_Mouse();
	      if(layer[2].boolean==1){
		layer[2].boolean=0;
		LayerCount--;
		if(LayerCount==0){
		    RestoreArea(25,5,150,100,1);/* 11875 */
		    UnMark_Blocks(SIZE);
		    if(MouseThere==1) Unhide_Mouse();
		    layerson=0;
		    j=4000;
		    }
		 else{
		    ClearArea(46,6,64,99,BLUE);       /*12*/
		    WriteStringAtxy(15,47,11,50,&layers[1][0],2,Font);
		    }
		Deselect_Layers(2);
		}
	      else{
		layer[2].boolean=1;
		LayerCount++;
		ClearArea(46,6,64,99,WHITE);
		WriteStringAtxy(12,47,11,50,&layers[1][0],2,Font);
		}
	      } /* END IF MISC TRAN SELECTED */

	      /* IF RAILROADS IS SELECTED FROM MENU */
	     if(((outreg.x.dx>53)&&(outreg.x.dx<75)&&(outreg.x.cx>5)&&(outreg.x.cx<100))
	       ||((CursorY>53)&&(CursorY<75)&&(CursorX>5)&&(CursorX<100))){
	      Hide_Mouse();
	      if(layer[3].boolean==1){
		layer[3].boolean=0;
		LayerCount--;
		if(LayerCount==0){
		    RestoreArea(25,5,150,100,1);
		    UnMark_Blocks(SIZE);
		    if(MouseThere==1) Unhide_Mouse();
		    layerson=0;
		    j=4000;
		    }
		 else{
		    ClearArea(66,6,84,99,BLUE);       /*12*/
		    WriteStringAtxy(15,67,11,50,&layers[2][0],2,Font);
		    }
		Deselect_Layers(3);
		}
	      else{
		layer[3].boolean=1;
		LayerCount++;
		ClearArea(66,6,84,99,WHITE);
		WriteStringAtxy(12,67,11,50,&layers[2][0],2,Font);
		}
	      } /* END IF RAILROADS TRAN SELECTED */

	      /* IF ROADS IS SELECTED FROM MENU */
	     if(((outreg.x.dx>75)&&(outreg.x.dx<100)&&(outreg.x.cx>5)&&(outreg.x.cx<100))
	     ||((CursorY>75)&&(CursorY<100)&&(CursorX>5)&&(CursorX<100))){
	      if(MouseThere==1) Hide_Mouse();
	      if(layer[4].boolean==1){
		layer[4].boolean=0;
		LayerCount--;
		if(LayerCount==0){
		    RestoreArea(25,5,150,100,1);
		    UnMark_Blocks(SIZE);
		    if(MouseThere==1) Unhide_Mouse();
		    layerson=0;
		    j=4000;
		    }
		 else{
		    ClearArea(86,6,104,99,BLUE);
		    WriteStringAtxy(15,87,11,50,&layers[3][0],2,Font);
		    }
		Deselect_Layers(4);
		}
	      else{
		layer[4].boolean=1;
		LayerCount++;
		ClearArea(86,6,104,99,WHITE);
		WriteStringAtxy(12,87,11,50,&layers[3][0],2,Font);
		}
	      }

	      /* IF ALL IS SELECTED FROM MENU */
	     if(((outreg.x.dx>100)&&(outreg.x.dx<120)&&(outreg.x.cx>5)&&(outreg.x.cx<100))
	     ||((CursorY>100)&&(CursorY<120)&&(CursorX>5)&&(CursorX<100))){
	      if(MouseThere==1) Hide_Mouse();
	      if(layer[5].boolean==1){
		layer[5].boolean=0;
		LayerCount--;
		if(LayerCount==0){
		    RestoreArea(25,5,150,100,1);
		    UnMark_Blocks(SIZE);
		    if(MouseThere==1) Unhide_Mouse();
		    layerson=0;
		    j=4000;
		    }
		 else{
		    ClearArea(106,6,124,99,BLUE);
		    WriteStringAtxy(15,107,11,50,&layers[4][0],2,Font);
		    }
		Deselect_Layers(5);
		}
	      else{
		layer[5].boolean=1;
		LayerCount++;
		ClearArea(106,6,124,99,WHITE);
		WriteStringAtxy(12,107,11,50,&layers[4][0],2,Font);
		}
	      }

	      /* IF QUIT IS SELECTED FROM MENU */
	     if(((outreg.x.dx>120)&&(outreg.x.dx<150)&&(outreg.x.cx>5)&&(outreg.x.cx<100))
	     ||((CursorY>120)&&(CursorY<150)&&(CursorX>5)&&(CursorX<100))){
		if(MouseThere==1) Hide_Mouse();
		RestoreArea(25,5,150,100,1);
		if(MouseThere==1) Unhide_Mouse();
		layerson=0;
		j=4000;
	      }
	    if(MouseThere==1) Unhide_Mouse();

	} /* END IF RIGHT BUTTON PRESSED */
    }while(j!=4000);
}

/************* UNHIGHLIGHT MENU CHOICES **********************************/
void Unhighlight(void)
{
     switch(Choice){
	  case 1:  RestoreArea(5,5,25,60,0);
		   break;
	  case 2:  RestoreArea(5,60,25,180,0);
		   break;
	  case 3:  RestoreArea(5,180,25,293,0);
		   break;
	  case 4:  RestoreArea(5,293,25,379,0);
		   break;
	  case 5:  RestoreArea(5,379,25,480,0);
		   break;
	  case 6:  RestoreArea(5,480,25,550,0);
		   break;
	  case 7:  RestoreArea(5,550,25,635,0);
		   break;
		   /********   LEVEL TWO   **********/
	  case 8:  RestoreArea(5,5,25,111,0);
		   break;
	  case 9:  RestoreArea(5,111,25,230,0);
		   break;
	  case 10: RestoreArea(5,230,25,365,0);
		   break;
	  case 11: RestoreArea(5,365,25,449,0);
		   break;
	  case 12: RestoreArea(5,449,25,542,0);
		   break;
	  case 13: RestoreArea(5,542,25,635,0);
		   break;
	  default: break;
     }
}

/**************** HIDE MOUSE BEFOR DOING SOMETHING ***********************/
void Hide_Mouse(void)
{
       inreg.x.ax=0x002;
       int86 (0x33, &inreg, &outreg);    /* HIDE BEFORE DRAWING          */
}

/***************** PUT MOUSE BACK ON SCREEN ******************************/
void Unhide_Mouse(void)
{
       inreg.x.ax=0x001;
       int86 (0x33, &inreg, &outreg);    /* MAKE MOUSE VISIBLE           */
}

/************ DISPLAY LAYERS IN WINDOW *****************/
void Display_Layers(void)
{
       ClearArea(25,5,150,100,BLUE);
       boxes(5,25,WHITE,95,125);

       if(layer[1].boolean>=1){
	  ClearArea(26,6,44,99,WHITE);
	  WriteStringAtxy(BLUE,27,10,50,&layers[0][0],2,Font);
	  }
       else
	  WriteStringAtxy(WHITE,27,10,50,&layers[0][0],2,Font);

       if(layer[2].boolean>=1){
	  ClearArea(46,6,64,99,WHITE);
	  WriteStringAtxy(BLUE,47,10,50,&layers[1][0],2,Font);
	  }
       else
	  WriteStringAtxy(WHITE,47,10,50,&layers[1][0],2,Font);

       if(layer[3].boolean>=1){
	  ClearArea(66,6,84,99,WHITE);
	  WriteStringAtxy(BLUE,67,10,50,&layers[2][0],2,Font);
	  }
       else
	  WriteStringAtxy(WHITE,67,10,50,&layers[2][0],2,Font);

       if(layer[4].boolean>=1){
	  ClearArea(86,6,104,99,WHITE);
	  WriteStringAtxy(BLUE,87,10,50,&layers[3][0],2,Font);
	  }
       else
	  WriteStringAtxy(WHITE,87,10,50,&layers[3][0],2,Font);

       if(layer[5].boolean>=1){
	  ClearArea(106,6,124,99,WHITE);
	  WriteStringAtxy(BLUE,107,10,50,&layers[4][0],2,Font);
	  }
       else
	  WriteStringAtxy(WHITE,107,10,50,&layers[4][0],2,Font);

       WriteStringAtxy(RED,127,9,50,&layers[5][0],2,Font);
}

/*********** DISPLAY THE BYTECOUNT IN WINDOW **********/
void Display_Bytecount(void)
{
char tempbytecount[30];

	 if(Menu == 2 || Menu == 4)
	 {
		if(bytecounton==0)
		{
			/* SaveArea(196,495,252,630,2); 7560 */
			SaveArea(30,480,30+56,480+135,2); /* 7560 */
			ClearArea(30,480,30+56,480+135,BLUE);
			boxes(480,30,WHITE,135,56);

			WriteStringAtxy(WHITE,30+20,480+2,50,BYTECOUNT1,2,Font);
			WriteStringAtxy(WHITE,30+38,480+2,50,BYTECOUNT2,2,Font);
			bytecounton=1;
		}
		ClearArea(30+1,480+3,30+13,480+130,BLUE);
		ltoa(ByteCount,tempbytecount,radix);
		WriteStringAtxy(WHITE,30+3,480+4,50,tempbytecount,2,Font);
	 }
	 else
	 {
		if(bytecounton==0)
		{
			/* SaveArea(196,495,252,630,2);  7560 */
			SaveArea(brog,bcog,brog+56,bcog+135,2);
			ClearArea(brog,bcog,brog+56,bcog+135,BLUE);
			boxes(bcog,brog,WHITE,135,56);

			WriteStringAtxy(WHITE,brog+20,bcog+2,50,BYTECOUNT1,2,Font);
			WriteStringAtxy(WHITE,brog+38,bcog+2,50,BYTECOUNT2,2,Font);
			bytecounton=1;
		}
		ClearArea(brog+1,bcog+3,brog+13,bcog+130,BLUE);
		ltoa(ByteCount,tempbytecount,radix);
		WriteStringAtxy(WHITE,brog+3,bcog+4,50,tempbytecount,2,Font);
	 }
}

/**************** DISPLAY TITLE ON MAIN SCREEN ***************************/
void Display_Info(void)
{
	WriteStringAtxy(WHITE,Down+20,Over,100,State,2,Font);
	WriteStringAtxy(WHITE,Down+35,Over,100,State_plus,2,Font);
	WriteStringAtxy(WHITE,Down+52,Over,100,TITLE,2,Font);
	WriteStringAtxy(WHITE,Down+52,Over+60,100,Option,2,Font);
	WriteStringAtxy(WHITE,Down+52,Over+120,50,Format,2,Font);
	WriteStringAtxy(WHITE,Down+70,Over,50,Month,2,Font);
	WriteStringAtxy(WHITE,Down+70,Over+70,100,Date,2,Font);
}

/************ WAIT FOR USER TO PRESS ANY KEY *****************************/
void Pause(void)
{
	 SaveArea(BOTTOM-RightESC,350,BOTTOM-(RightESC-20),600,0);
	 ClearArea(BOTTOM-RightESC,350,BOTTOM-(RightESC-20),600,BLUE);
	 boxes(350,BOTTOM-RightESC,WHITE,250,20);
	 WriteStringAtxy(WHITE,BOTTOM-(RightESC-4),352,200,PAUSE,2,Font);
	 getch();
	 RestoreArea(BOTTOM-RightESC,350,BOTTOM-(RightESC-20),600,0);
}

/********** HIGHLIGHT EACH QUAD CHOSEN ***********************************/
void Mark_Quad(latitude,longitude,COLOR,SIZE,QUAD)
int latitude,longitude,COLOR,SIZE,QUAD;
{
int lat=0,lon=0;
double LATINCREMENT,PPDLON;
static int i=0;
char image[300], image0[300];

      if(MouseThere) Hide_Mouse();
      if(SIZE==1)
      {                       /* 100K QUADS                   */
	latitude += 5;
	longitude +=30;
	LATINCREMENT= (-PixelsPerDegreeLat)/2;
  /*      PPDLON= 58.5; */
	lat=((int)(latitude/LATINCREMENT))*LATINCREMENT;
	lon=(((int)(longitude/PixelsPerDegreeLong))*PixelsPerDegreeLong);
 /*     boxes(lon,lat,COLOR,48,((int)LATINCREMENT)-1);  DRAW BOX     */
/*        WriteStringAtxy(COLOR,lat+5,lon-2,200,MARKIT,1,Font);*/
	
	_setcolor(5);
	_getimage(0, 0, 12, 12, image0);
	_rectangle(_GFILLINTERIOR, 0, 0, 10, 10);
	_getimage(0, 0, 10, 10, image);
	_putimage(0, 0, image0, _GPSET);
	_putimage(lon-8, lat+5, image, _GXOR);

      }                                                /* AROUND QUAD  */
      else
      {                              /* 15 MINUTE QUADS              */
	LATINCREMENT=RRow1;
	PPDLON=PPDLong/4;  /*=103.0; */
	lat=(((int)(latitude/LATINCREMENT))*LATINCREMENT);
	lon=(((int)(longitude/PPDLON))*PPDLON);
/*        boxes(lon+5,lat,COLOR,((int)(PPDLON))-1,(RRow1)-1);*/
	/*WriteStringAtxy(COLOR,lat+50,lon+50,200,MARKIT,1,Font);*/
	
	_setcolor(5);
	_getimage(0, 0, 18, 18, image0);
	_rectangle(_GFILLINTERIOR, 0, 0, 16, 16);
	_getimage(0, 0, 16, 16, image);
	_putimage(0, 0, image0, _GPSET);
	_putimage(lon+50, lat+40, image, _GXOR);
      }
      if(MouseThere) Unhide_Mouse();
}

/********** HIGHLIGHT EACH QUAD CHOSEN ***********************************/
void Mark_Quad1(latitude,longitude,COLOR,SIZE,QUAD)
int latitude,longitude,COLOR,SIZE,QUAD;
{
int lat1=0,lon1=0;
double LATINCREMENT,PPDLON;
static int i=0;
char image[300], image0[300];
float   Lat_Mark_Deg;
float   Lon_Mark_Deg;
float   Lat_Mark_Pix;
float   Lon_Mark_Pix;

      if(MouseThere) Hide_Mouse();
      if(SIZE==1)
      {                       /* 100K QUADS                   */
/* latitude in degrees = yy1 + (((Row2-Row1))/PixelsPerDegreeLat) */
	Lat_Mark_Deg = lat + 0.25;
	Lon_Mark_Deg = lon - 0.5;
	Lat_Mark_Pix = ((Lat_Mark_Deg-yy1)*PixelsPerDegreeLat) + Row1;
	Lon_Mark_Pix = ((Lon_Mark_Deg-x1)*PixelsPerDegreeLong) + Column1;

	_setcolor(5);
	_getimage(0, 0, 12, 12, image0);
	_rectangle(_GFILLINTERIOR, 0, 0, 10, 10);
	_getimage(0, 0, 10, 10, image);
	_putimage(0, 0, image0, _GPSET);
	_putimage(Lon_Mark_Pix-4, Lat_Mark_Pix-4, image, _GXOR);

      }                                                /* AROUND QUAD  */
      else
      {                              /* 15 MINUTE QUADS              */
	LATINCREMENT=RRow1;
	PPDLON=PPDLong/4;  /*=103.0; */
	lat1=(((int)(latitude/LATINCREMENT))*LATINCREMENT);
	lon1=(((int)(longitude/PPDLON))*PPDLON);
	
	_setcolor(5);
	_getimage(0, 0, 18, 18, image0);
	_rectangle(_GFILLINTERIOR, 0, 0, 16, 16);
	_getimage(0, 0, 16, 16, image);
	_putimage(0, 0, image0, _GPSET);
	_putimage(lon1+50, lat1+40, image, _GXOR);
      }
      if(MouseThere) Unhide_Mouse();
}

/************** CLEAR THE AREA ON THE SCREEN FOR OUTPUT TEXT *************/
void Clear_Output(Color)
int Color;
{
	  ClearArea(200,10,300,400,Color);
	  boxes(10,200,WHITE,390,100);
}

/****************** DESELECT 100K QUADS **********************************/
void Deselect100K(quadnumber)
int quadnumber;
{
int hit=0;
char string1[20],string2[20];
    
      currentptr=firstptr;
				      /* IF ONLY ONE QUAD DELETE IT      */
      if(firstptr->next==((struct outputdata *)NULL)){
	 ByteCount-=currentptr->bytesaffected;
	 firstptr=((struct outputdata *)NULL);
	 lastptr=((struct outputdata *)NULL);
	 }
      else{                          /* LOOP THROUGH LIST DELETING QUADS */
	 while((currentptr !=(struct outputdata *)NULL)){
	   sprintf(string1,"%s",currentptr->dirname);
	   sprintf(string2,"%s",QuadData[quadnumber].DirName);
	   if(strncmp(string1,string2,strlen(string1))==0){
		hit=1;
		ByteCount-=currentptr->bytesaffected;
		tempptr=currentptr;
		if((currentptr!=firstptr)&&(currentptr!=lastptr)){
		     currentptr->fore->next=currentptr->next;
		     currentptr->next->fore=currentptr->fore;
		     currentptr=currentptr->next;
		     free(tempptr);
		     }
		else{
		  if(currentptr==firstptr){
		    if(firstptr->next==((struct outputdata *)NULL)){
		       currentptr=((struct outputdata *)NULL);
		       free(firstptr);
		       free(lastptr);
		       firstptr=(struct outputdata *)NULL;
		       }
		    else{
		       currentptr=currentptr->next;
		       firstptr=firstptr->next;
		       free(tempptr);
		       }
		  }
		  else{
		    lastptr=currentptr->fore;
		    currentptr->fore->next=((struct outputdata *)NULL);
		    currentptr=((struct outputdata *)NULL);
		    free(tempptr);
		    }
		}
	  }   /*  END IF HIT */
	  else
	      currentptr=currentptr->next;

      }   /* WHILE */
  } /* ELSE */
}

/****************** DESELECT 15M QUADS ***********************************/
void Deselect15M(quadnumber,m,Break)
char Break[];
int quadnumber,m;
{
char choicext[5],archived[10],temparray1[3],temparray[5];
int j;
int hit=0;

      sprintf(choicext,"%s",layer[m].choiext);

      for(j=0;j<BlockCount;j++){
	 archived[0]='\0';           /* MAKE ARCHIVED LOOK LIKE: WP4MTF05 */
	 strcat(archived,QuadData[quadnumber].CutFile);
	 strcat(archived,choicext);
	 strcat(archived,Break);
	 sprintf(temparray,"%d",BlockArray[j]);
	 if(BlockArray[j]<10){
	    sprintf(temparray1,"%d",0);
	    strcat(archived,temparray1);
	 }
	 strcat(archived,temparray);

	 currentptr=firstptr;

	 if(firstptr->next==((struct outputdata *)NULL)){
	    firstptr=((struct outputdata *)NULL);
	    lastptr=((struct outputdata *)NULL);
	    free(firstptr);          /* IF ONLY ONE QUAD DELETE IT       */
	    }

	 else{                       /* LOOP THROUGH LIST DELETING QUADS */

	   while((currentptr /* ->next */  !=(struct outputdata *)NULL)){
	     if ( (strcmp(currentptr->dirname,QuadData[quadnumber].DirName)==0)&&(strcmp(archived,currentptr->outarcfile)==0) ) {
		hit=1;
		tempptr=currentptr;
		if((currentptr!=firstptr)&&(currentptr!=lastptr)){
		     currentptr->fore->next=currentptr->next;
		     currentptr->next->fore=currentptr->fore;
		     currentptr=currentptr->next;
		     free(tempptr);
		     }
		else{
		    if(currentptr==firstptr){
			if(firstptr->next==((struct outputdata *)NULL)){
			     currentptr=((struct outputdata *)NULL);
			     free(firstptr);
			     free(lastptr);
			     firstptr=((struct outputdata *)NULL);
			     }
			else{
			    currentptr=currentptr->next;
			    firstptr=firstptr->next;
			    free(tempptr);
			    }
			}
		    else{
			lastptr=currentptr->fore;
			currentptr->fore->next=((struct outputdata *)NULL);
			currentptr=((struct outputdata *)NULL);
			free(tempptr);
		    }
		}
	    }
	    else{    /*if(hit!=1){*/
	       currentptr=currentptr->next;
	       hit=0;
	    }
	  }   /* WHILE */
	}   /* ELSE */
      }   /* END FOR J < BLOCKCOUNT */
}

/****************** DESELECT LAYERS, DROP FROM LINKED LIST****************/
void Deselect_Layers(currentlayer)
int currentlayer;
{
int hit=0;
int SIZE;

   if((Menu==1)||(Menu==3)) SIZE=1;

   if(ByteCount>0){
      currentptr=firstptr;           /* IF ONLY ONE QUAD DELETE IT       */
      if(firstptr->next==((struct outputdata *)NULL)){
	 ByteCount-=currentptr->bytesaffected;
	 firstptr=((struct outputdata *)NULL);
	 }
      else{                          /* LOOP THROUGH LIST DELETING QUADS */
	 while((currentptr !=(struct outputdata *)NULL)){
	   if(strstr(currentptr->arcfile,layer[currentlayer].choicstr)!=NULL){
		hit=1;
		ByteCount-=currentptr->bytesaffected;
		tempptr=currentptr;
		if((currentptr!=firstptr)&&(currentptr!=lastptr)){
		     currentptr->fore->next=currentptr->next;
		     currentptr->next->fore=currentptr->fore;
		     currentptr=currentptr->next;
		     free(tempptr);
		     }
		else{
		  if(currentptr==firstptr){
		    if(firstptr->next==((struct outputdata *)NULL)){
		       currentptr=((struct outputdata *)NULL);
		       free(firstptr);
		       firstptr=(struct outputdata *)NULL;
		       }
		    else{
		       currentptr=currentptr->next;
		       firstptr=firstptr->next;
		       free(tempptr);
		       }
		  }
		  else{
		    lastptr=currentptr->fore;
		    currentptr->fore->next=((struct outputdata *)NULL);
		    currentptr=((struct outputdata *)NULL);
		    free(tempptr);
		    }
		}
	   }
	   else
	     currentptr=currentptr->next;

      }   /* WHILE */
      Display_Bytecount();
  } /* ELSE */
 } /* IF BYTECOUNT > 0 */
 if(ByteCount<=0)
     firstptr=((struct outputdata *)NULL);
}

/***************** DO YOU REALLY WANT TO EXIT ****************************/
int Affirm_Exit(void)
{
char choice;
int i;
	 SaveArea(200,140,270,425,0);
	 tone(784,20);
	 ClearArea(200,140,270,425,RED);
	 boxes(140,200,WHITE,285,70);
	 WriteStringAtxy(15,220,145,50,EXPLAIN13,2,Font);
	 WriteStringAtxy(15,250,175,50,EXPLAIN14,2,Font);

	 choice=getch();
	 if(toupper(choice)=='Y'){       /* IF YES EXIT                  */
	     firstptr=((struct outputdata *)NULL);
	     i=40;
	     }
	 else{                           /* IF NO RETURN INTACT          */
	     i=0;
	     }
	 RestoreArea(200,140,270,425,0);
	 return(i);
}

/******************* WAIT FOR BUTTON RELEASE *****************************/
void Mouse_Trap(void)
{
	 outreg.x.bx=0x000;              /* DOS INTERRUPT TO DETECT      */
	 outreg.x.ax=0x000;              /* BUTTON RELEASE               */
	 inreg.x.ax=0x006;
	 inreg.x.bx=0x000;
	 int86 (0x33, &inreg, &outreg);

	 while(outreg.x.ax!=0x000){
	   outreg.x.bx=0x000;
	   outreg.x.ax=0x000;
	   inreg.x.ax=0x006;
	   inreg.x.bx=0x000;
	   int86 (0x33, &inreg, &outreg);
	 }
}

/****************** DISPLAY CHOSEN LAYERS ON SCREEN **********************/
void Display_Picked_Layers(void)
{
int j, k, l=0;
      
      k = 20;
      Hide_Mouse();
      if(layer[5].boolean>=1)
      {
	  l=4;
      }
      else
      {
	  for(j=0;j<=4;j++) 
		if(layer[j].boolean>=1) 
			l++;
      }
      if(Menu == 2 || Menu == 4)
      {
	if(l>0)
	{
		SaveArea(30,10,140,100,1);  /* 9900 */
		ClearArea(30,10,30+((l+1)*19),10+90,BLUE);
		boxes(10,30,WHITE,90,(l+1)*19);
		WriteStringAtxy(WHITE,30+2,10+8,50,"LAYER(S):",2,Font);
		for(j=0;j<=3;j++)
		{
			if((layer[j+1].boolean>=1)||(layer[5].boolean>=1))
			{
				WriteStringAtxy(WHITE,30+k,10+4,50,&layers[j][0],2,Font);
				k+=19;
			}
		}
		LayersChosenOn=1;
	 }  /* END IF l>0 */
      }
      else
      {
	if(l>0)
	{
		/* SaveArea(30,10,140,100,1);  9900 */
		SaveArea(lrog,lcog,lrog+110,lcog+90,1);  /* 9900 */
		ClearArea(lrog,lcog,lrog+((l+1)*19),lcog+90,BLUE);
		boxes(lcog,lrog,WHITE,90,(l+1)*19);
		WriteStringAtxy(WHITE,lrog+2,lcog+8,50,"LAYER(S):",2,Font);
		for(j=0;j<=3;j++)
		{
			if((layer[j+1].boolean>=1)||(layer[5].boolean>=1))
			{
				WriteStringAtxy(WHITE,lrog+k,lcog+4,50,&layers[j][0],2,Font);
				k+=19;
			}
		}
		LayersChosenOn=1;
	 }  /* END IF l>0 */
      }
      Unhide_Mouse();
}

/***************** SELECT DESIRED 100k QUADS AND HIGHLIGHT ***************/
void Process_Quads100K(void)
{
int n,i,k=0,l,QuadNameOn=0;
double showlat,showlon,showlatmin,showlonmin;
char LastName[30],TempName[30];

       sprintf(LastName,"%s","BLANK");
       if(MouseThere==1) 
		Hide_Mouse();
       Unhighlight();
       Choice=0;
       if(LayerCount<=0)
       {
	    MakeRoom();
	    tone(784,20);
	    WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,ERROR1,2,Font);
	    Pause();
	    MakeRoom();
	    if(MouseThere==1) 
		Unhide_Mouse();
       }
       else
       {
	    MakeRoom();
	    if(MouseThere==1) 
		WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN12,2,Font);
	    else 
		WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN16,2,Font);
	    outreg.x.bx = 0x000;
	    SaveArea(BOTTOM-RightESC,10,BOTTOM-(RightESC-20),300,0);
	    ClearArea(BOTTOM-RightESC,10,BOTTOM-(RightESC-20),300,BLUE);
	    boxes(10,BOTTOM-RightESC,WHITE,290,20);
	    if(MouseThere==1) 
		WriteStringAtxy(WHITE,BOTTOM-(RightESC-4),12,50,EXPLAIN10,2,Font);
	    else 
		WriteStringAtxy(WHITE,BOTTOM-(RightESC-4),12,50,EXPLAIN17,2,Font);
/*          SaveQuadNameArea(BOTTOM-QuadNamePos,20,BOTTOM-(QuadNamePos-15),300,0);*/
	    SaveQuadNameArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,0);

	    do
	    {               /* LOOP UNTIL USER PRESSES RIGHT BUTTON */
	       if(MouseThere==1)
	       {
		   Unhide_Mouse();
		   inreg.x.ax=0x003;            /* POLL MOUSE CONTINUOSLY */
		   int86 (0x33, &inreg, &outreg);
	       }
	       else
	       {
		   Return_Char=pix_val(CursorX,CursorY);
	       }
	       if(MouseThere==1)     
			Xvalue=Column2=outreg.x.cx;
	       else                  
			Xvalue=Column2=CursorX;
	       if(MouseThere==1)     
			Yvalue=Row2=outreg.x.dx;
	       else                  
			Yvalue=Row2=CursorY-7;
	       showlat=lat=yy1+((Row2-Row1)/(PixelsPerDegreeLat));
	       showlon=lon=x1+((Column2-Column1)/PixelsPerDegreeLong);
	       showlon=-showlon;
	       showlatmin=(showlat-((int)(showlat)))*60;
	       showlonmin=(showlon-((int)(showlon)))*60;
	       lon=(int)lon;
	       if((lat-(int)lat)>0.5)
	       {
		   lat=(int)lat+0.5;
	       }
	       else
	       {
		   y2=(int)lat;
		   lat=y2;
	       }
	       QuadNameOn=0;
	       for(i=0;i<QuadCount;i++)
	       {
		   if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon)&&(l=(strcmp(QuadData[i].QuadName,LastName)!=0)))
		   {
			ClearArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,MEDGREEN); /*8*/
			boxes(350,BOTTOM-(QuadNamePos-25),15,270,20);
			sprintf(LastName,"%s",QuadData[i].QuadName);
			sprintf(TempName,"%s",QuadData[i].QuadName);
			if(((QuadData[i].Lat)-((int)(QuadData[i].Lat)))>=(.5))
			{
			       showlat=QuadData[i].Lat-.5;
			       showlatmin=30.0;
			}
			else
			{
			       showlat=QuadData[i].Lat;
			       showlatmin=0.0;
			}
			sprintf(TempLat,"%3.0f",showlat);
			sprintf(TempLatmin,"%2.0f",showlatmin);
			sprintf(TempLon,"%3.0f",-QuadData[i].Lon);
			WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),362,50,TempName,2,Font);
			WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),520,50,TempLat,2,Font);
			WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),550,50,TempLatmin,2,Font);
			WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),590,50,TempLon,2,Font);
			QuadNameOn=1;
			break;
		   }
		   if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon)&&(l=(strcmp(QuadData[i].QuadName,LastName)==0)))
			QuadNameOn=1;
	       }  /* END FOR */
	       if(QuadNameOn==0)
	       {
/*                 RestoreQuadNameArea(BOTTOM-QuadNamePos,20,BOTTOM-(QuadNamePos-15),300,0);*/
		   RestoreQuadNameArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,0);

		   sprintf(LastName,"%s","BLANK");
	       }
	       if((outreg.x.bx==1)||(Return_Char=='\r'))
	       { /* IF LEFT BUTTON IS PRESSED */
		   if(MouseThere==1) 
			Mouse_Trap();
		   for(i=0;i<QuadCount;i++)
		   {
		       if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon))
		       {
			   if(QuadData[i].Selected[0][0]==1)
			   {
			       Deselect100K(i);
			       Mark_Quad1(((int)(Row2)),((int)(Column2)),GRAY,1,i);
			       QuadData[i].Selected[0][0]=0;
			   }
			   else
			   {
			       QuadData[i].Selected[0][0]=1;
			       Build_File100K(i);
			       Mark_Quad1(((int)(Row2)),((int)(Column2)),GRAY,1,i);
			   }
			   Display_Bytecount();
		       }
		   } /* END FOR */
	       }  /* END IF LEFT BUTTON PRESSED */
	       if((outreg.x.bx==2)||(Return_Char==27))
	       {  /* RIGHT BUTTON PRESSED */
		   if(MouseThere==1) 
			Mouse_Trap();
		   outreg.x.bx=0x000;
		   n=4000;
	       }
	    } while(n!=4000);
	    n=0;
	    Hide_Mouse();
/*          RestoreQuadNameArea(BOTTOM-QuadNamePos,20,BOTTOM-(QuadNamePos-15),300,0);*/
	    RestoreQuadNameArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,0);
	    RestoreArea(BOTTOM-RightESC,10,BOTTOM-(RightESC-20),300,0);
	    Unhide_Mouse();
       } /* END IF LAYERS HAVE BEEN SELECTED */
}

/*********************** RESET BACK TO ENTRY SCREEN **********************/
void Reset(void)
{
int x=0,i=0,j=0,k=0,l=0;

	if(MouseThere==1) 
		Hide_Mouse();
	Unhighlight();
	Choice=0;
	DisplayCutImage(InFileName);
	Display_Menu(1);
	Display_Info();
	LayersChosenOn=0;
	layerson=0;
	bytecounton=0;
	ByteCount=0;                            /* RESET VARIABLES       */
	LayerCount=0;
	firstptr=((struct outputdata *)NULL);

	if(MouseThere==1) 
		Unhide_Mouse();
	for(i=0;i<=QuadCount;i++)
	{
	    QuadData[i].Selected[0][0]=0;
	    for(j=0;j<=8;j++)
	    {
		for(k=0;k<=5;k++)
		{
		    QuadData[i].Selected[j][k]=0;
		}
	    }
	}
	for(l=0;l<=10;l++)
	{
	    layer[l].boolean=0;
	}
}

/**************** EXIT PROGRAM OR EXIT LEVEL TWO *************************/
int Exit(void)
{
int m;
	  if(MouseThere) Hide_Mouse();
	  Unhighlight();
	  Choice=0;
	  if(ByteCount>0)
	       m=Affirm_Exit();
	  else
	       m=40;
	  if(MouseThere) Unhide_Mouse();
	  return(m);
}

/************** GOTO COPYOUT AND DISPLAY APPROPRIATE MENU ****************/
int Output(LEVEL)
int LEVEL;
{
int n,i,k,j,l;
	if(LayersChosenOn)
	{
/*              RestoreArea(200,10,300,100,1); */
		if(Menu == 2 || Menu == 4)
			RestoreArea(30,10,140,100,1); /* 9900 */
		else
			RestoreArea(lrog,lcog,lrog+110,lcog+90,1);  /* 9900 */
		LayersChosenOn=0;
	}
	if(MouseThere==1) 
		Hide_Mouse();
	Unhighlight();
	Choice=0;

	if( (n = copyout()) == 1)
	{          /* SUCCESSFUL COPY OUT          */
	   if(LEVEL==2)
	   {
	      Display_Menu(4);
	      UnMark_Blocks(2);
	      n = 0;
	   }
	   else
	   {
	      Display_Menu(1);
	      UnMark_Blocks(1);
	   }
	   firstptr=((struct outputdata *)NULL);
	   for(i=0;i<=QuadCount;i++)
	   {
		QuadData[i].Selected[0][0]=0;
		for(j=0;j<=8;j++)
		{       for(k=0;k<=5;k++)
			{       QuadData[i].Selected[j][k] =0;
			}
		}
	    }

	   for(l=0;l<=10;l++)
	   {    layer[l].boolean=0;
	   }
	}
	else
	{                            /* UNSUCCESSFUL COPY OUT        */
	   if(LEVEL==2)
	   {
	       Display_Menu(2);
	       Display_Picked_Layers();
	   }
	   else
	   {
	       Display_Menu(3);
	       Display_Picked_Layers();
	   }
	}
	if(MouseThere==1) 
		Unhide_Mouse();
	return(n);
}

/************************** CHOOSE LAYERS *******************************/
void Select_Layers(LEVEL)
int LEVEL;
{          if(MouseThere==1) Hide_Mouse();
	   Unhighlight();
	   Choice=0;
/*           if(LayersChosenOn==1) RestoreArea(200,10,300,100,1); */
	   if(LayersChosenOn==1)
	   {
		if(Menu == 2 || Menu == 4)
			RestoreArea(30,10,140,100,1); /* 9900 */
		else
			RestoreArea(lrog,lcog,lrog+110,lcog+90,1);  /* 9900 */
	   }                
	   LayersChosenOn=0;
	   SaveArea(25,5,150,100,1); /* 11875 */
	   Display_Layers();
	   if(ByteCount>0)
	   {
	       /* tone(); */
	       ClearArea(BOTTOM-Explain,10,BOTTOM-(Explain-20),300,RED);
	       boxes(10,BOTTOM-Explain,15,290,20);
	       WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN19,2,Font);
	   }
	   else
	   {
	       MakeRoom();
	       WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN2,2,Font);
	   }
	   layerson=1;
	   if(MouseThere==1) 
		Unhide_Mouse();
	   if(LEVEL==2)  
		Display_Menu(2);
	   else          
		Display_Menu(3);
	   if(MouseThere==1) 
		Unhide_Mouse();
	   Process_Layers(LEVEL);
	   if(LayerCount<=0)
	   {
	       ByteCount=0;
	       if(LEVEL==1)
		 Display_Menu(1);
	       else
		 Display_Menu(4);
	   }
	   Display_Picked_Layers();
	   layerselected = 1;
}

/****************** SELECT QUADS IN LEVEL TWO ****************************/
void Select_Quads2(quadnum)
int quadnum;
{
      Hide_Mouse();
      Unhighlight();
      Choice=0;
      if(LayerCount<=0)
      {
	 if(MouseThere==1) 
		Unhide_Mouse();
	 MakeRoom();
	 tone(784,20);
	 WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,ERROR1,2,Font);
	 Pause();
	 MakeRoom();
      }
      else
      {
	 MakeRoom();
	 if(MouseThere==1) 
		Unhide_Mouse();
	 if(MouseThere==1) 
		WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN11,2,Font);
	 else 
		WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN18,2,Font);
	 SaveArea(BOTTOM-Explain,350,BOTTOM-(Explain-20),600,0);
	 ClearArea(BOTTOM-Explain,350,BOTTOM-(Explain-20),600,LTBLUE);  /*12*/
	 boxes(350,BOTTOM-Explain,15,250,20);
	 if(MouseThere==1) 
		WriteStringAtxy(WHITE,BOTTOM-(Explain-5),352,200,EXPLAIN10,2,Font);
	 else 
		WriteStringAtxy(WHITE,BOTTOM-(Explain-5),352,200,EXPLAIN17,2,Font);
	 Select_Blocks(quadnum);
	 if(MouseThere==1) 
		Hide_Mouse();
	 RestoreArea(BOTTOM-Explain,350,BOTTOM-(Explain-20),600,0);
	 if(MouseThere==1) 
		Unhide_Mouse();
      }
}

/************************ ZOOM INTO A QUAD *******************************/
void View_Quads(void)
{
int i,m,l,r,QuadNameOn=0,j,k;
char LastName[30],TempName[30];
double showlat,showlatmin;

/*   SaveQuadNameArea(BOTTOM-QuadNamePos,20,BOTTOM-(QuadNamePos-15),300,0);*/
     SaveQuadNameArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,0);

     if(MouseThere==1) Hide_Mouse();
     Unhighlight();
     Choice=0;
     MakeRoom();
     if(MouseThere==1) WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN12,2,Font);
     else WriteStringAtxy(WHITE,BOTTOM-(Explain-5),12,200,EXPLAIN16,2,Font);
     outreg.x.bx = 0x000;
     m=0;
     SaveArea(200,200,220,340,1); /* 2800 */
     do
     {
	 if(MouseThere==1)
	 {
	     Unhide_Mouse();
	     inreg.x.ax=0x003;           /* POLL MOUSE CONTINUOSLY       */
	     int86 (0x33, &inreg, &outreg);
	 }
	 else
	 {
	     Return_Char=pix_val(CursorX,CursorY); /* POLL CURSOR        */
	 }

	 if(MouseThere==1) 
		Column2=outreg.x.cx;   /* GET MOUSE OR       */
	  else              
		Column2=CursorX;       /* CURSOR POSITION    */
	  if(MouseThere==1) 
		Row2=outreg.x.dx;
	  else              
		Row2=CursorY-7;
	  lat=yy1+(((Row2-Row1))/PixelsPerDegreeLat);
	  lon=x1+(((Column2-Column1))/PixelsPerDegreeLong);
	  lon=(int)lon;
	  if((lat-(int)lat)>0.5)
	  {        /* GET SOUTHEAST CORNER OF THE  */
	      lat=(int)lat+0.5;          /* QUAD THE CURSOR IS IN        */
	  }
	  else
	  {
	      y2=(int)lat;
	      lat=y2;
	  }
	  QuadNameOn=0;                  /* COMPARE CURSOR COORDINATES   */
	  for(i=0;i<QuadCount;i++)
	  {      /* WITH COORDS OF DATA READ IN  */
	      if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon)&&(l=(strcmp(QuadData[i].QuadName,LastName)!=0)))
	      {
/*
		  ClearArea(BOTTOM-QuadNamePos,20,BOTTOM-(QuadNamePos-15),300,8);
		  boxes(20,BOTTOM-QuadNamePos,15,280,15);
		  ClearArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,8);
*/
		  ClearArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,MEDGREEN); /*8*/
		  boxes(350,BOTTOM-(QuadNamePos-25),15,270,20);
		  sprintf(LastName,"%s",QuadData[i].QuadName);
		  sprintf(TempName,"%s",QuadData[i].QuadName);
		  if(((QuadData[i].Lat)-((int)(QuadData[i].Lat)))>=(.5))
		  {
		      showlat=QuadData[i].Lat-.5;
		      showlatmin=30.0;
		  }
		  else
		  {
		      showlat=QuadData[i].Lat;
		      showlatmin=0.0;
		  }
		  sprintf(TempLat,"%3.0f",showlat);
		  sprintf(TempLatmin,"%2.0f",showlatmin);
		  sprintf(TempLon,"%3.0f",-QuadData[i].Lon);
		  WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),362,50,TempName,2,Font);
		  WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),520,50,TempLat,2,Font);
		  WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),550,50,TempLatmin,2,Font);
		  WriteStringAtxy(WHITE,BOTTOM-(QuadNamePos-30),590,50,TempLon,2,Font);
	      }
	      if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon)&&(l=(strcmp(QuadData[i].QuadName,LastName)==0)))
		   QuadNameOn=1;
	  }  /*  END FOR */
	  if(QuadNameOn==0)
	  {
	      RestoreQuadNameArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,0);
	      sprintf(LastName,"%s","BLANK");
	  }
	  if((outreg.x.bx==1)||(Return_Char=='\r'))
	  { /* IF LEFT/RETURN PRESSED */
	      if(MouseThere==1) 
		Mouse_Trap();
		for(i=0;i<QuadCount;i++)
		{
		   if((lat==QuadData[i].Lat)&&(lon==QuadData[i].Lon))
		   {
			ByteCount=0;
			ProcessQuad(i);  /* A VALID QUAD IS SELECTED SO DRAW */
			Hide_Mouse();    /* AND PROCESS IT               */
			DisplayCutImage(InFileName);
			Display_Menu(1);

			firstptr=((struct outputdata *)NULL);

			for(i=0;i<=QuadCount;i++)
			{
			    QuadData[i].Selected[0][0]=0;
			    for(j=0;j<=8;j++)
			    {
			       for(k=0;k<=5;k++)
			       {
				    QuadData[i].Selected[j][k] =0;
			       }
			    }
			}
			for(l=0;l<=9;l++)
			{
			    layer[l].boolean=0;
			}
			if(MouseThere==1) 
				Unhide_Mouse();
			outreg.x.bx=0;
			m=4000;
			break;
		   } /* END IF */
		} /* END FOR I < QUADCOUNT */
	  }  /* END IF LEFT OR RETURN PRESSED */

     } while(m!=4000);
     for(r=0;r<10;r++)
     {   layer[r].boolean=0;
     } /* RESET VARIABLES THEN RETURN*/
     layerson=0;
     bytecounton=0;
     ByteCount=0;
     LayerCount=0;
     Display_Info();
     RestoreQuadNameArea(BOTTOM-(QuadNamePos-25),350,BOTTOM-(QuadNamePos-45),620,0);
}

/************* DECIPHER WETHER TO TURN QUAD ON OR OFF (15M)***************/
void Sort_Blocks(i,m,RRow2,CColumn2,markit)
int i,m,RRow2,CColumn2,markit;
{
       if(QuadData[i].Selected[Block][m]==1){/* QUAD IS ON SO TURN IT OFF*/
	    Deselect15M(i,m,BreakDown);
	    if(markit==1)
		Mark_Quad(RRow2,CColumn2,GRAY,2,i);
	    ByteCount= (ByteCount-SmallByteCount);
	    QuadData[i].Selected[Block][m]=0;
	    }
       else{
	   QuadData[i].Selected[Block][m]=1; /* QUAD IS OFF SO TURN IT ON*/
	   Build_File(i,m,BreakDown);
	   if (markit==1)
		Mark_Quad(RRow2,CColumn2,LTGREEN,2,i);
	   ByteCount=(ByteCount+SmallByteCount);
	   }
       Display_Bytecount();
}

/*************** ERASE HIGHLIGHTED QUADS **************/
void UnMark_Blocks(SIZE)
int SIZE;
{       int y2;

    currentptr=firstptr;                 /* LOOP THROUGH LINKED LIST     */
    while((currentptr !=(struct outputdata *)NULL))
    {    lat=yy1+(((currentptr->yloc-Row1))/PixelsPerDegreeLat);
	 lon=x1+(((currentptr->xloc-Column1))/PixelsPerDegreeLong);
	 lon=(int)lon;
	 if( (lat-(int)lat)>0.5) 
		lat=(int)lat+0.5;
	 else
	 {
	    y2=(int)lat;
	    lat=y2;
	 }
	 Mark_Quad1(currentptr->yloc,currentptr->xloc,GRAY,SIZE,1);
	 currentptr=currentptr->next;
    }
}

/********  FIND OUT IF THERE IS A MOUSE AND PROCESS ACCORDINGLY  *********/
void Check_Mouse(void)
{
unsigned char MouseType,IRQused;
    
	inreg.x.ax=0x000;                
	int86 (0x33, &inreg, &outreg);   /* INITIALIZE MOUSE             */

	if(outreg.x.ax==-1){             /* MOUSE IS THERE               */
	    inreg.x.ax=0x001;
	    int86 (0x33,&inreg,&outreg); /* MAKE MOUSE VISIBLE ON SCREEN */
	    MouseThere=1;

	    inreg.x.ax=0x0024;           /* GET MOUSE STATISTICS         */
	    int86 (0x33,&inreg,&outreg);
	    MouseType=outreg.h.ch;
	    IRQused=outreg.h.cl;

	    }
	else{                            /* NO MOUSE                     */
	    MouseThere = 0;
	    outreg.x.dx=100;
	}
}

/******************** GET VIDEO MODE EGA or VGA **************************/
void Check_Video(void)
{
int o,i;

      if(o=(_setvideomode(_VRES16COLOR))==0)
      {  /* IF VGA WORKS USE THAT  */
	if(o=(_setvideomode(_ERESCOLOR))==0)
	{  /* IF NOT USE EGA         */
	    printf("NEITHER EGA NOR VGA ARE SUPPORTED"); /* IF NEITHER   */
	    exit(1);
	}
	else
	{ 
	    GRAPHICS='E';
	    BOTTOM=350;
	    ScreenYs=350;
	    Down=DownEGA;
	    strcat(InFileName,"state.ega");
	}
      }
      else
      {
	GRAPHICS='V';
	BOTTOM=480;
	ScreenYs=480;
	Down=DownVGA;
	strcat(InFileName,"state.vga");
/*        _setvideomode(_DEFAULTMODE);*/
	_setvideomode(_VRES16COLOR);
      }

      if((rfile=fopen(OutFileName,"rt"))==NULL)
      {    /* READ IN STATE.REG */
	  system("mode co80");
	  printf("Could not register file \"%s\"  ", OutFileName); /* TO GET PERTINENT DATA */
	  getch();
	  exit(1);
      }
      else
      {
	  if(GRAPHICS=='V')  fscanf(rfile,"%lf %lf %lf %d %d %lf %lf\n",&x1,&PixelsPerDegreeLong,&SkipEGA,&Column1,&SkipEGA,&PPDLong,&SkipEGA);
	  else               fscanf(rfile,"%lf %lf %lf %d %d %lf %lf\n",&x1,&SkipVGA,&PixelsPerDegreeLong,&SkipVGA,&Column1,&SkipVGA,&PPDLong);
	  if(GRAPHICS=='V')  fscanf(rfile,"%lf %lf %lf %d %d %d %d %lf %lf\n",&yy1,&PixelsPerDegreeLat,&SkipEGA,&Row1,&SkipRow,&RRow1,&SkipRow,&PPDLat,&SkipEGA);
	  else               fscanf(rfile,"%lf %lf %lf %d %d %d %d %lf %lf\n",&yy1,&SkipVGA,&PixelsPerDegreeLat,&SkipRow,&Row1,&SkipRow,&RRow1,&SkipVGA,&PPDLat);
	  fclose(rfile);
      }  /* END ELSE */

      if((ofile=fopen("dlg.pal","rt"))==NULL)
      {
/*            system("mode co80");*/
	    printf("Could not open pallette file %s - using default colors\n", "dlg.pal");
	    getch();
	    if(GRAPHICS=='V') 
		SetVideoMode(0x12);    /* SET TO VGA       */
	    else 
		SetVideoMode(0x10);    /* SET TO EGA       */
      }
      else
      {
	  for (i = 0; i <= 15; i++)
	  {
	     fscanf(ofile,"%d %d %d %d",&a,&b,&c,&d);
	     DefaultPalette[i].r = b;
	     DefaultPalette[i].g = c;
	     DefaultPalette[i].b = d;
	  }
	  DefaultPalette[7].r = 60;
	  DefaultPalette[7].g = 60;
	  DefaultPalette[7].b = 60;

	  fclose(ofile);

	  if(GRAPHICS=='V') 
		SetVideoMode(0x12);   /*   SET TO VGA       */
	  else 
		SetVideoMode(0x10);   /*   SET TO EGA       */
	  WritePalette(DefaultPalette);
      }   /*  END ELSE */
}

/******************** GET QUAD DATA **************************************/
void Get_QuadData(void)
{
int i,result,j,p;

      if((ofile=fopen("file.out","rt"))==NULL)
      {
	 system("mode co80");
	 printf("Could not open disk content file \"%s\" ", "file.out");
	 getch();
	 exit(1);
      }
      else
      {
	i=0;                             /* READ DATA FROM FILE.OUT      */
	do
	{
	    result=fscanf(ofile," %[^~] %c %lf %lf %s %s %s %s %s %s",
	    QuadData[i].QuadName,&a,&QuadData[i].Lat,&QuadData[i].Lon,
	    QuadData[i].CutFile,QuadData[i].DirName,
	    QuadData[i].hydro,QuadData[i].tran,QuadData[i].rail,QuadData[i].roads);
	    for(j=0;j<=32;j++)
		fscanf(ofile,"%lu ",&QuadData[i].bytesize[j]);
	    for(j=0;j<=9;j++) 
	    {
	       for(p=0;p<=6;p++)
		  QuadData[i].Selected[j][p]=0;
	    }
	    i++;
	} while(result==10);
	QuadCount=i;
	fclose(ofile);
      }   /* END ELSE */
}

/********************** GET SCREEN AND PLACEMENT DATA ********************/
void Get_ScreenData(void)
{
FILE *datfile;
int rogVGA, cogVGA, rogEGA, cogEGA;

      if((datfile=fopen("infofile","r"))==NULL)
      {     /* GET TITLE DATA   */
	   system("mode co80");
	   printf("Could not open entry screen data file \"%s\" ", "infofile");
	   getch();
	   exit(1);
      }
      else
      {    /* TITLE POSTION & TEXT */
	   fscanf(datfile,"%d %s %s %s %s %s %s %d %d \n",&Over,State,State_plus,Option,Format,Month,Date,&DownVGA,&DownEGA);
	   /* MESSAGE STRIP INFO AREA 1, INFO AREA 2, QUAD NAME POSITION  */
	   fscanf(datfile,"%d %d %d \n",&Explain,&RightESC,&QuadNamePos);
	   fscanf(datfile,"%d %d %d %d \n", &rogVGA, &cogVGA, &rogEGA, &cogEGA);
	   if(_setvideomode(_VRES16COLOR))   /* BYTE COUNT AREA */
	   {    brog = rogVGA;
		bcog = cogVGA;
		Down = DownVGA;
		BOTTOM = 480;
	   }
	   else
	   {    brog = rogEGA;
		bcog = cogEGA;
		Down = DownEGA;
		BOTTOM = 350;
	   }
	   fscanf(datfile,"%d %d %d %d \n", &rogVGA, &cogVGA, &rogEGA, &cogEGA);
	   if(_setvideomode(_VRES16COLOR))      /* LAYERS AREA  */
	   {    lrog = rogVGA;
		lcog = cogVGA;
	   }
	   else
	   {    lrog = rogEGA;
		lcog = cogEGA;
	   }
	   fclose(datfile);
      }
}

/*sprintf(TempName1,"%d",CursorX);
sprintf(TempName2,"%d",CursorY);
ClearArea(99,99,140,140,RED);
WriteStringAtxy(LTGREEN,100,100,50,TempName1,2,Font);
WriteStringAtxy(LTGREEN,120,100,50,TempName2,2,Font);*/

